import 'package:flutter/material.dart';
import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/ebookdetailmodel.dart';
import 'package:prakah/model/reviewmodel.dart' as review;
import 'package:prakah/model/reviewmodel.dart';
import 'package:prakah/model/relatedbookmodel.dart' as relatedbook;
import 'package:prakah/model/relatedbookmodel.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webservice/apiservice.dart';

class EbookDetailProvider extends ChangeNotifier {
  EbookDetailModel ebookDetailModel = EbookDetailModel();
  /* Add Review Field */
  SuccessModel successModel = SuccessModel();
  // Buybookmodel buybookmodel = Buybookmodel();
  bool loading = false;
  int ebookType = 0;

  /* Related Book Field */
  RelatedBookModel relatedBookModel = RelatedBookModel();
  List<relatedbook.Result>? relatedBookList = [];
  bool relatedBookLoading = false, relatedBookloadMore = false;
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;

  /* Get Book Review List Field */
  ReviewModel getCourseReviewModel = ReviewModel();
  List<review.Result>? reviewList = [];
  int? reviewtotalRows, reviewtotalPage, reviewcurrentPage;
  bool? reviewisMorePage;
  bool reviewloading = false, reviewloadmore = false;

  void setLoading(bool isLoading) {
    loading = isLoading;
    relatedBookLoading = isLoading;
    reviewloading = isLoading;
    notifyListeners();
  }

  Future<void> getEbooksDetail(String bookId) async {
    loading = true;
    ebookDetailModel = await ApiService().bookDetail(bookId);
    loading = false;
    notifyListeners();
  }

  bool isReviewLoding = false;

  Future<void> addReview(String type, contentId, comment, rating) async {
    setAddReviewLoding(true);
    successModel =
        await ApiService().addContentReview(type, contentId, comment, rating);
    setAddReviewLoding(false);
  }

  void setAddReviewLoding(bool isLoding) {
    isReviewLoding = isLoding;
    notifyListeners();
  }

  void ebookTab(int type) {
    ebookType = type;
    notifyListeners();
  }

  /* Add Like Dislike */

  /* Product Like Dislike */
  void addRemoveWishlist(String type, contentId) {
    if ((ebookDetailModel.result?[0].isWishlist ?? 0) == 0) {
      ebookDetailModel.result?[0].isWishlist = 1;
    } else {
      ebookDetailModel.result?[0].isWishlist = 0;
    }
    notifyListeners();
    addremoveWishList(type, contentId);
  }

  Future<void> addremoveWishList(String type, contentId) async {
    successModel = await ApiService().addRemoveWishlist(type, contentId);
  }

/* Related Book With Pagination Start */

  Future<void> getRelatedBooks(String bookId, pageNo) async {
    relatedBookLoading = true;
    relatedBookModel = await ApiService().relatedBooks(bookId, pageNo);
    if (relatedBookModel.status == 200) {
      setPaginationData(relatedBookModel.totalRows, relatedBookModel.totalPage,
          relatedBookModel.currentPage, relatedBookModel.morePage);
      if (relatedBookModel.result != null &&
          (relatedBookModel.result?.length ?? 0) > 0) {
        for (var i = 0; i < (relatedBookModel.result?.length ?? 0); i++) {
          relatedBookList
              ?.add(relatedBookModel.result?[i] ?? relatedbook.Result());
        }
        final Map<int, relatedbook.Result> postMap = {};
        relatedBookList?.forEach((item) {
          postMap[item.id ?? 0] = item;
        });
        relatedBookList = postMap.values.toList();
        setLoadMore(false);
      }
    }
    relatedBookLoading = false;
    notifyListeners();
  }

  void setPaginationData(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }

  void setLoadMore(bool relatedBookloadMore) {
    this.relatedBookloadMore = relatedBookloadMore;
    notifyListeners();
  }

/* Review List */

/* Course Review List */

  Future<void> getReviewByBook(String type, contentId, pageNo) async {
    reviewloading = true;
    getCourseReviewModel =
        await ApiService().courseReviewList(type, contentId, pageNo);
    if (getCourseReviewModel.status == 200) {
      setReviewPaginationData(
          getCourseReviewModel.totalRows,
          getCourseReviewModel.totalPage,
          getCourseReviewModel.currentPage,
          getCourseReviewModel.morePage);
      if (getCourseReviewModel.result != null &&
          (getCourseReviewModel.result?.length ?? 0) > 0) {
        printLog(
            "reviewList length :==> ${(getCourseReviewModel.result?.length ?? 0)}");
        if (getCourseReviewModel.result != null &&
            (getCourseReviewModel.result?.length ?? 0) > 0) {
          printLog(
              "reviewList length :==> ${(getCourseReviewModel.result?.length ?? 0)}");
          for (var i = 0; i < (getCourseReviewModel.result?.length ?? 0); i++) {
            reviewList?.add(getCourseReviewModel.result?[i] ?? review.Result());
          }
          final Map<int, review.Result> postMap = {};
          reviewList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          reviewList = postMap.values.toList();
          printLog("reviewList length :==> ${(reviewList?.length ?? 0)}");
          setReviewLoadMore(false);
        }
      }
    }
    reviewloading = false;
    notifyListeners();
  }

  void setReviewPaginationData(int? reviewtotalRows, int? reviewtotalPage,
      int? reviewcurrentPage, bool? reviewisMorePage) {
    this.reviewcurrentPage = reviewcurrentPage;
    this.reviewtotalRows = reviewtotalRows;
    this.reviewtotalPage = reviewtotalPage;
    reviewisMorePage = reviewisMorePage;
    notifyListeners();
  }

  void setReviewLoadMore(bool reviewloadmore) {
    this.reviewloadmore = reviewloadmore;
    notifyListeners();
  }

  void clearProvider() {
    ebookDetailModel = EbookDetailModel();
    successModel = SuccessModel();
    loading = false;
    ebookType = 0;
    relatedBookModel = RelatedBookModel();
    relatedBookList = [];
    relatedBookList?.clear();
    relatedBookLoading = false;
    relatedBookloadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
    isReviewLoding = false;
  }
}
