import 'package:prakah/model/applycouponmodel.dart';
import 'package:prakah/model/promocodemodel.dart' as promocode;
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class CouponProvider extends ChangeNotifier {
  promocode.PromocodeModel promocodeModel = promocode.PromocodeModel();
  ApplyCouponModel applyCouponModel = ApplyCouponModel();
  bool loading = false;
  List<promocode.Result>? cartList = [];
  /* Post Pagination */
  bool loadMore = false;
  int? totalRows, totalPage, currentPage;
  bool? isMorePage;
  void setLoading(bool isLoading) {
    loading = isLoading;
    notifyListeners();
  }

  Future<void> getUseMeeting(int pageNo) async {
    loading = true;
    promocodeModel = await ApiService().promocodeResponse(pageNo);
    if (promocodeModel.status == 200) {
      setPagination(promocodeModel.totalRows, promocodeModel.totalPage,
          promocodeModel.currentPage, promocodeModel.morePage);
      if (promocodeModel.result != null &&
          (promocodeModel.result?.length ?? 0) > 0) {
        for (var i = 0; i < (promocodeModel.result?.length ?? 0); i++) {
          cartList?.add(promocodeModel.result?[i] ?? promocode.Result());
        }
        final Map<int, promocode.Result> postMap = {};
        cartList?.forEach((item) {
          postMap[item.id ?? 0] = item;
        });
        cartList = postMap.values.toList();
        setLoadMore(false);
      }
    }
    loading = false;
    notifyListeners();
  }

  void setLoadMore(bool loadMore) {
    this.loadMore = loadMore;
    notifyListeners();
  }

  void setPagination(
      int? totalRows, int? totalPage, int? currentPage, bool? morePage) {
    this.currentPage = currentPage;
    this.totalRows = totalRows;
    this.totalPage = totalPage;
    isMorePage = morePage;
    notifyListeners();
  }

  bool applyLoded = false;
  int? index;
  Future<void> getApplyCoupon(int postion, promocodeId, totalPrice) async {
    index = postion;
    setApplyLoding(true);

    applyCouponModel =
        await ApiService().applyCouponResponse(promocodeId, totalPrice);

    setApplyLoding(false);
  }

  void setApplyLoding(bool isLoding) {
    applyLoded = isLoding;
    notifyListeners();
  }

  int? itemSelect;
  String? addressIds;

  void setIds({required int index, required String ids}) {
    itemSelect = index;
    addressIds = ids;
    notifyListeners();

    // For debugging purposes
    printLog("Selected Index: $index");
    printLog("Selected ID: $addressIds");
  }

  void clearProvider() {
    promocodeModel = promocode.PromocodeModel();
    loading = false;
    applyLoded = false;
    cartList = [];
    cartList?.clear();
    itemSelect = 0;
    addressIds;
    index;
    /* Pagination */
    loadMore = false;
    totalRows;
    totalPage;
    currentPage;
    isMorePage;
  }
}
