import 'package:prakah/model/applycouponmodel.dart';
import 'package:prakah/model/cartmodel.dart' as cart;
import 'package:prakah/model/successModel.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:flutter/material.dart';

class CartProvider extends ChangeNotifier {
  cart.CartModel cartModel = cart.CartModel();
  SuccessModel successModel = SuccessModel();
  ApplyCouponModel applyCouponModel = ApplyCouponModel();

  bool loading = false;
  bool removeLoading = false;

  void setLoading(bool isLoading) {
    loading = isLoading;
    notifyListeners();
  }

  Future<void> getUseMeeting() async {
    loading = true;
    cartModel = await ApiService().cartListResponse();
    addPrice();
    loading = false;
    notifyListeners();
  }

  /* Remove cart api */
  Future<void> getRemoveCart(int index, courseId) async {
    successModel = await ApiService().removeToCartCourse(courseId);
    getUseMeeting();
    cartModel.result?.removeAt(index);
    notifyListeners();
  }

  Future<void> getRemoveCoupone(String totalPrice) async {
    setRemoveLoading(true);
    applyCouponModel = await ApiService().removeCouponResponse(totalPrice);
    setRemoveLoading(false);
  }

  void setRemoveLoading(bool isLoading) {
    removeLoading = isLoading;
    notifyListeners();
  }

  void providerNoti() {
    notifyListeners();
  }

/* Total Price Cart */
  int priceItem = 0; // Initial price

  void addPrice() {
    priceItem = 0; // Reset the total price to 0

    for (var i = 0; i < (cartModel.result?.length ?? 0); i++) {
      priceItem += int.parse(cartModel.result?[i].price.toString() ?? "0.0");
    }

    printLog("My Price total count is $priceItem");
    notifyListeners(); // Notify listeners about the change
  }

/* WEB */
  String? discountPrice, promocodeName = "", promocodeId, totalPrice;
  void setPrice({dynamic value, disPri, proId, proName, totPrice}) {
    priceItem = value;
    discountPrice = disPri;
    promocodeId = proId;
    promocodeName = proName;
    totalPrice = totPrice;
    notifyListeners();
  }

  void clearProvider() {
    cartModel = cart.CartModel();
    successModel = SuccessModel();
    applyCouponModel = ApplyCouponModel();
    loading = false;
    removeLoading = false;
    discountPrice = "";
    promocodeName = "";
    promocodeId = "";

    priceItem = 0; // Initial price
  }
}
