import 'package:prakah/model/successModel.dart';
import 'package:prakah/model/relatedblogmodel.dart';
import 'package:prakah/model/relatedblogmodel.dart' as related;
import 'package:prakah/utils/utils.dart';
import 'package:flutter/material.dart';
import 'package:prakah/model/blogdetailmodel.dart';
import 'package:prakah/webservice/apiservice.dart';

class BlogDetailProvider extends ChangeNotifier {
  BlogDetailModel blogDetailModel = BlogDetailModel();
  RelatedBlogModel relatedBookModel = RelatedBlogModel();
  bool loading = false;
  /* Add Review Field */
  SuccessModel successModel = SuccessModel();

  List<related.Result>? relatedCourseList = [];
  int? relatedCoursetotalRows, relatedCoursetotalPage, relatedCoursecurrentPage;
  bool? relatedCourseisMorePage;
  bool relatedCourseloading = false, relatedCourseloadmore = false;

  void setLoading(bool isLoading) {
    loading = isLoading;
    relatedCourseloading = isLoading;
    notifyListeners();
  }

  Future<void> getBlogDetail(String blogid) async {
    loading = true;
    blogDetailModel = await ApiService().blogDetail(blogid);
    loading = false;
    notifyListeners();
  }

/* Related Course */

  Future<void> getRelatedCourse(String blogId, pageNo) async {
    relatedCourseloading = true;
    relatedBookModel = await ApiService().relatedBlogResponse(blogId, pageNo);
    if (relatedBookModel.status == 200) {
      setRelatedCoursePaginationData(
          relatedBookModel.totalRows,
          relatedBookModel.totalPage,
          relatedBookModel.currentPage,
          relatedBookModel.morePage);
      if (relatedBookModel.result != null &&
          (relatedBookModel.result?.length ?? 0) > 0) {
        printLog(
            "relatedCourseList length :==> ${(relatedBookModel.result?.length ?? 0)}");
        if (relatedBookModel.result != null &&
            (relatedBookModel.result?.length ?? 0) > 0) {
          printLog(
              "relatedCourseList length :==> ${(relatedBookModel.result?.length ?? 0)}");
          for (var i = 0; i < (relatedBookModel.result?.length ?? 0); i++) {
            relatedCourseList
                ?.add(relatedBookModel.result?[i] ?? related.Result());
          }
          final Map<int, related.Result> postMap = {};
          relatedCourseList?.forEach((item) {
            postMap[item.id ?? 0] = item;
          });
          relatedCourseList = postMap.values.toList();
          printLog(
              "relatedCourseList length :==> ${(relatedCourseList?.length ?? 0)}");
          setRelatedCourseLoadMore(false);
        }
      }
    }
    relatedCourseloading = false;
    notifyListeners();
  }

  void setRelatedCoursePaginationData(
      int? relatedCoursetotalRows,
      int? relatedCoursetotalPage,
      int? relatedCoursecurrentPage,
      bool? relatedCourseisMorePage) {
    this.relatedCoursecurrentPage = relatedCoursecurrentPage;
    this.relatedCoursetotalRows = relatedCoursetotalRows;
    this.relatedCoursetotalPage = relatedCoursetotalPage;
    relatedCourseisMorePage = relatedCourseisMorePage;
    notifyListeners();
  }

  void setRelatedCourseLoadMore(bool relatedCourseloadmore) {
    this.relatedCourseloadmore = relatedCourseloadmore;
    notifyListeners();
  }

  /* Product Like Dislike */
  Future<void> addRemoveWishlist(String type, contentId) async {
    if ((blogDetailModel.result?[0].isWishlist ?? 0) == 0) {
      blogDetailModel.result?[0].isWishlist = 1;
    } else {
      blogDetailModel.result?[0].isWishlist = 0;
    }
    notifyListeners();
    addremoveWishList(type, contentId);
  }

  Future<void> addremoveWishList(String type, contentId) async {
    successModel = await ApiService().addRemoveWishlist(type, contentId);
  }

  void clearProvider() {
    /* Course Detail Field */
    blogDetailModel = BlogDetailModel();
    relatedBookModel = RelatedBlogModel();
    loading = false;
    /* Get Review By Course Field */

    relatedCourseList = [];
    relatedCourseList?.clear();
    relatedCoursetotalRows;
    relatedCoursetotalPage;
    relatedCoursecurrentPage;
    relatedCourseisMorePage;
    relatedCourseloading = false;
    relatedCourseloadmore = false;
    /* Add Review Field */
    successModel = SuccessModel();
  }
}
