import 'package:prakah/model/coursenamemodel.dart';
import 'package:prakah/model/selectedtimeslotemodel.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webservice/apiservice.dart';
import 'package:file_picker/file_picker.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

class AppoinmentBookingProvider extends ChangeNotifier {
  SelectedTimeSloteModel selectedTimeSloteModel = SelectedTimeSloteModel();

  DateTime selectedValue = DateTime.now();
  void setLoding(bool isLoading) {
    courseNameLoading = isLoading;
    loading = isLoading;
    notifyListeners();
  }

  void setDate(DateTime date) {
    selectedValue = date;
    notifyListeners();
  }

  CourseNameModel courseNameModel = CourseNameModel();
  bool courseNameLoading = false, loading = false;
  String? courseId;

  String? weekDayName = "";

  void setWeekDay(String name) {
    weekDayName = name;

    printLog("My Week day name $weekDayName");
    notifyListeners();
  }

/* File Picked Code  */

  String? fileName = "", filePath = "";

  Future<void> filePickedCode() async {
    FilePickerResult? result = await FilePicker.platform.pickFiles();

    if (result != null) {
      PlatformFile file = result.files.first;

      fileName = file.name;
      filePath = file.path ?? "";
      printLog('File name: ${file.name}');
      printLog('File path: ${file.path}');
      printLog('File size: ${file.size}');
    } else {
      printLog("User canceled the picker");
    }
    notifyListeners();
  }

/* End */

  Future<void> getCourseName() async {
    courseNameLoading = true;
    courseNameModel = await ApiService().courseNameResponse();
    courseNameLoading = false;
    notifyListeners();
  }

  Future<void> getBlogDetail(String meetinId, date) async {
    loading = true;
    selectedTimeSloteModel =
        await ApiService().timeSlotSelectResponse(meetinId, date);
    if ((selectedTimeSloteModel.result ?? []).isNotEmpty) {
      setMeetingId(
          id: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].id
                  .toString() ??
              "",
          start: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].startTime
                  .toString() ??
              "",
          end: selectedTimeSloteModel
                  .result?[0].timeSlotes?[0].timeSchedul?[0].endTime
                  .toString() ??
              "");
      // Get weekday name (e.g., Monday)
      final weekDayName = DateFormat('EEEE').format(selectedValue);
      setWeekDay(weekDayName);
    }

    loading = false;
    notifyListeners();
  }

  void setCourseId(String ids) {
    courseId = ids;
    notifyListeners();
  }

/* Time Slot id get */

  String? meetingScheduledId;
  String? meetingScheduledStartTime;
  String? meetingScheduledEndTime;

  void setMeetingId({String? id, start, end}) {
    meetingScheduledId = id;
    meetingScheduledStartTime = start;
    meetingScheduledEndTime = end;
    printLog(
        "My Selected Starte and END TIme $meetingScheduledStartTime - $meetingScheduledEndTime");
    notifyListeners();
  }

  void clearContent() {
    selectedTimeSloteModel = SelectedTimeSloteModel();
    meetingScheduledId = "";
    loading = false;
  }

  void clearProvider() {
    selectedValue = DateTime.now();
    courseNameModel = CourseNameModel();
    courseNameLoading = false;
    selectedTimeSloteModel = SelectedTimeSloteModel();
    loading = false;

    courseId = "";
    meetingScheduledId = "";
    fileName = "";
    filePath = "";
    meetingScheduledStartTime = "";
    meetingScheduledEndTime = "";
    weekDayName = "";
    selectedValue = DateTime.now();
  }
}
