import 'package:prakah/provider/coursedetailsprovider.dart';
import 'package:prakah/provider/playerprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:provider/provider.dart';
import 'package:youtube_player_iframe/youtube_player_iframe.dart';

class PlayerYoutube extends StatefulWidget {
  final String? videoUrl, vUploadType, videoThumb;
  final int? videoId, courseId, chepterId, viewApiType;
  const PlayerYoutube(this.videoId, this.videoUrl, this.vUploadType,
      this.videoThumb, this.courseId, this.chepterId, this.viewApiType,
      {super.key});

  @override
  State<PlayerYoutube> createState() => PlayerYoutubeState();
}

class PlayerYoutubeState extends State<PlayerYoutube> {
  late PlayerProvider playerProvider;
  YoutubePlayerController? controller;
  bool fullScreen = false;
  int? playerCPosition, videoDuration;

  @override
  void initState() {
    super.initState();
    playerProvider = Provider.of<PlayerProvider>(context, listen: false);
    if (!kIsWeb) {
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.manual, overlays: []);
      SystemChrome.setPreferredOrientations([DeviceOrientation.portraitUp]);
    }
    _initPlayer();
    controller?.listen((event) {
      if (event.playerState == PlayerState.paused) {
        controller?.currentTime.then((value) {
          videoDuration = (value * 1000).toInt();
          printLog("Paused at (ms): $videoDuration");
        });
      }
    });
  }

  Future<void> _initPlayer() async {
    printLog("Enter Youtube :===>");
    printLog("videoUrl :===> ${widget.videoUrl}");
    var videoId = YoutubePlayerController.convertUrlToId(widget.videoUrl ?? "");
    printLog("videoId :====> $videoId");
    controller = YoutubePlayerController.fromVideoId(
      videoId: videoId ?? '',
      autoPlay: true,
      params: const YoutubePlayerParams(
        showControls: true,
        mute: false,
        showFullscreenButton: true,
        loop: false,
      ),
    );

    // Api Call CourseView
    if (Constant.userID != null || widget.viewApiType == 1) {
      await playerProvider.addVideoView(
        "3",
        widget.courseId,
        widget.videoId,
      );
    }
    Future.delayed(Duration.zero).then((value) {
      if (mounted) {
        setState(() {});
      }
    });
  }

  @override
  void dispose() {
    controller?.close();
    if (!(kIsWeb)) {
      SystemChrome.setPreferredOrientations([DeviceOrientation.portraitUp]);
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.manual,
          overlays: SystemUiOverlay.values);
    }
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    SystemChrome.setEnabledSystemUIMode(SystemUiMode.manual, overlays: []);
    return PopScope(
      onPopInvokedWithResult: (didPop, result) => onBackPressed,
      child: Scaffold(
        backgroundColor: white,
        body: Stack(
          children: [
            _buildPlayer(),
          ],
        ),
      ),
    );
  }

  Widget _buildPlayer() {
    if (controller == null) {
      return Utils.pageLoader();
    } else {
      if (kIsWeb) {
        return Column(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            InkWell(
              onTap: () async {
                final detailProvider =
                    Provider.of<CourseDetailsProvider>(context, listen: false);
                if (Constant.userID != null && widget.viewApiType == 1) {
                  Utils().showProgress(context, "Please Wait...");
                  await playerProvider.addVideoRead(widget.courseId.toString(),
                      widget.videoId, widget.chepterId, videoDuration);
                  if (!playerProvider.loading) {
                    if (playerProvider.successVideoReadModel.status == 200) {
                      await detailProvider
                          .getCourseDetails(widget.courseId.toString());
                      await detailProvider.getVideoByChapter(
                          widget.courseId.toString(),
                          widget.chepterId.toString(),
                          0,
                          false);
                      if (!mounted) return;
                      Utils().hideProgress(context);
                      Navigator.pop(context);
                    } else {
                      if (!mounted) return;
                      Utils().hideProgress(context);
                      Utils.showSnackbar(
                          context,
                          "fail",
                          playerProvider.successVideoReadModel.message ?? "",
                          false);
                    }
                  }
                }
              },
              child: Container(
                padding: const EdgeInsets.all(8),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(50),
                  color: colorPrimary,
                ),
                child: MyText(
                    color: white,
                    fontsizeNormal: Dimens.textMedium,
                    maxline: 2,
                    multilanguage: true,
                    fontwaight: FontWeight.w500,
                    text: "markcomplite",
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
            Expanded(
              child: YoutubePlayerScaffold(
                backgroundColor: black,
                controller: controller!,
                autoFullScreen: true,
                defaultOrientations: const [
                  DeviceOrientation.landscapeLeft,
                  DeviceOrientation.landscapeRight,
                ],
                builder: (context, player) {
                  return Scaffold(
                    backgroundColor: black,
                    body: Center(
                      child: LayoutBuilder(
                        builder: (context, constraints) {
                          return player;
                        },
                      ),
                    ),
                  );
                },
              ),
            ),
          ],
        );
      } else {
        return YoutubePlayerScaffold(
          backgroundColor: white,
          controller: controller!,
          autoFullScreen: true,
          defaultOrientations: const [
            DeviceOrientation.portraitDown,
            DeviceOrientation.portraitUp,
          ],
          builder: (context, player) {
            return Scaffold(
              backgroundColor: white,
              appBar: kIsWeb
                  ? null
                  : AppBar(
                      backgroundColor: colorPrimaryDark,
                      elevation: 0,
                      surfaceTintColor: transparent,
                      systemOverlayStyle: SystemUiOverlayStyle(
                          statusBarColor: transparent,
                          systemNavigationBarColor: transparent,
                          systemNavigationBarDividerColor: transparent),
                      centerTitle: false,
                      titleSpacing: 0,
                      leading: InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () {
                          onBackPressed();
                        },
                        child: Icon(
                          Icons.arrow_back_outlined,
                          size: 20,
                          color: white,
                        ),
                      ),
                    ),
              body: Center(
                child: LayoutBuilder(
                  builder: (context, constraints) {
                    return player;
                  },
                ),
              ),
            );
          },
        );
      }
    }
  }

  Future<bool> onBackPressed() async {
    if (!mounted) return Future.value(false);
    if (!kIsWeb) {
      SystemChrome.setPreferredOrientations([DeviceOrientation.portraitUp]);
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.manual,
          overlays: SystemUiOverlay.values);
    }
    Navigator.pop(context, false);
    printLog("onBackPressed playerCPosition :===> $playerCPosition");
    printLog("onBackPressed videoDuration :===> $videoDuration");
/* API Call */
    final detailProvider =
        Provider.of<CourseDetailsProvider>(context, listen: false);
    if (Constant.userID != null || widget.viewApiType == 1) {
      await playerProvider.addVideoRead(
          widget.courseId.toString(),
          widget.videoId.toString(),
          widget.chepterId.toString(),
          videoDuration);
      await detailProvider.getCourseDetails(widget.courseId.toString());
      await detailProvider.getVideoByChapter(
          widget.courseId.toString(), widget.chepterId.toString(), 0, false);
    }

    return Future.value(true);
  }
}
