import 'dart:io';
import 'dart:isolate';
import 'package:chewie/chewie.dart';
import 'package:prakah/provider/coursedetailsprovider.dart';
import 'package:prakah/provider/playerprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:provider/provider.dart';
import 'package:video_player/video_player.dart';

class PlayerVideo extends StatefulWidget {
  final String? videoUrl, vUploadType, videoThumb, type, secreateKey;
  final int? videoId, courseId, chepterId, viewApiType;
  const PlayerVideo(
      this.videoId,
      this.videoUrl,
      this.vUploadType,
      this.chepterId,
      this.videoThumb,
      this.courseId,
      this.type,
      this.secreateKey,
      this.viewApiType,
      {super.key});

  @override
  State<PlayerVideo> createState() => _PlayerVideoState();
}

class _PlayerVideoState extends State<PlayerVideo> {
  late PlayerProvider playerProvider;
  int? playerCPosition, videoDuration;
  ChewieController? _chewieController;
  VideoPlayerController? _videoPlayerController;

  @override
  void initState() {
    super.initState();
    playerProvider = Provider.of<PlayerProvider>(context, listen: false);
    WidgetsBinding.instance.addPostFrameCallback((_) {
      _playerInit();
    });
    getCurrentVideoTime();
  }

  Future<void> _playerInit() async {
    if (widget.type == "video") {
      try {
        _videoPlayerController = VideoPlayerController.networkUrl(
          Uri.parse(widget.videoUrl ?? ""),
        );
        await Future.wait([_videoPlayerController!.initialize()]);
        await waitForDuration(); // Ensure duration is available before proceeding
      } catch (e) {
        printLog("Error ===> ${e.toString()}");
      }
    } else {
      if (!kIsWeb && widget.type == "download") {
        // File? tempFile;
        /* Decrypt Without Freez START ******************** */
        final receivePort = ReceivePort();
        dynamic tempFile;
        tempFile = await decryptFile([
          File(widget.videoUrl ?? ""),
          widget.secreateKey ?? "",
          receivePort.sendPort,
          context,
        ]);
        if (tempFile == null) return;
        _videoPlayerController =
            VideoPlayerController.file(File(tempFile?.path ?? ""));
        /* ********************** Decrypt Without Freez END */
      }
    }

    /* Chewie Controller */

    _setupController();

    if (widget.type != "download" || widget.viewApiType == 1) {
      await playerProvider.addVideoView(
          "3", (widget.courseId ?? 0), widget.videoId);
    }

    Future.delayed(Duration.zero).then((value) {
      if (!mounted) return;
      setState(() {});
    });
  }

/* Video Duartion get code */
  Future<void> waitForDuration() async {
    while (_videoPlayerController?.value.duration.inMilliseconds == 0) {
      await Future.delayed(const Duration(milliseconds: 200));
    }
    videoDuration = _videoPlayerController?.value.duration.inMilliseconds;
    printLog("I am Find the video duartion$videoDuration");
  }

  Future<void> _setupController() async {
    _chewieController = ChewieController(
      videoPlayerController: _videoPlayerController!,
      startAt: Duration.zero,
      autoPlay: true,
      autoInitialize: true,
      looping: false,
      fullScreenByDefault: false,
      allowFullScreen: true,
      hideControlsTimer: const Duration(seconds: 1),
      showControls: true,
      allowedScreenSleep: false,
      deviceOrientationsOnEnterFullScreen: [
        DeviceOrientation.landscapeLeft,
        DeviceOrientation.landscapeRight,
      ],
      deviceOrientationsAfterFullScreen: [
        DeviceOrientation.portraitUp,
        DeviceOrientation.portraitDown,
      ],
      cupertinoProgressColors: ChewieProgressColors(
        playedColor: colorPrimary,
        handleColor: colorPrimary,
        backgroundColor: gray,
        bufferedColor: colorAccent,
      ),
      materialProgressColors: ChewieProgressColors(
        playedColor: colorPrimary,
        handleColor: colorPrimary,
        backgroundColor: gray,
        bufferedColor: colorAccent,
      ),
      errorBuilder: (context, errorMessage) {
        return Center(
          child: MyText(
            color: white,
            text: errorMessage,
            textalign: TextAlign.center,
            fontsizeNormal: 14,
            fontwaight: FontWeight.w600,
            fontsizeWeb: 16,
            multilanguage: false,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            fontstyle: FontStyle.normal,
          ),
        );
      },
    );
    _chewieController?.addListener(() {
      playerCPosition =
          (_chewieController?.videoPlayerController.value.position)
                  ?.inMilliseconds ??
              0;
    });
  }

  void getCurrentVideoTime() {
    final currentPosition = _videoPlayerController?.value.position;
    videoDuration = currentPosition?.inMilliseconds;
  }

  @override
  void dispose() {
    if (_chewieController != null) {
      _chewieController?.removeListener(() {});
      _chewieController?.videoPlayerController.dispose();
    }
    if (!(kIsWeb)) {
      SystemChrome.setPreferredOrientations([DeviceOrientation.portraitUp]);
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.manual,
          overlays: SystemUiOverlay.values);
    }
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return PopScope(
      canPop: true,
      onPopInvokedWithResult: (didPop, result) {
        onBackPressed(didPop);
      },
      child: Scaffold(
        backgroundColor: white,
        appBar: kIsWeb
            ? null
            : AppBar(
                backgroundColor: colorPrimaryDark,
                elevation: 0,
                surfaceTintColor: transparent,
                systemOverlayStyle: SystemUiOverlayStyle(
                    statusBarColor: transparent,
                    systemNavigationBarColor: transparent,
                    systemNavigationBarDividerColor: transparent),
                centerTitle: false,
                titleSpacing: 0,
                leading: InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  onTap: () {
                    onBackPressed(false);
                  },
                  child: Icon(
                    Icons.arrow_back_outlined,
                    size: 20,
                    color: white,
                  ),
                ),
              ),
        body: SafeArea(
          child: Stack(
            children: [
              Center(
                child: _buildPage(),
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget _buildPage() {
    if (_chewieController != null &&
        _chewieController?.videoPlayerController.value != null &&
        _chewieController!.videoPlayerController.value.isInitialized) {
      return _buildPlayer();
    } else {
      return Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          SizedBox(
            height: 70,
            width: 70,
            child: Utils.pageLoader(),
          ),
          const SizedBox(height: 20),
          MyText(
            color: colorPrimaryDark,
            text: "Loading...",
            textalign: TextAlign.center,
            fontsizeNormal: 14,
            fontwaight: FontWeight.w600,
            fontsizeWeb: 16,
            multilanguage: false,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            fontstyle: FontStyle.normal,
          ),
        ],
      );
    }
  }

  Widget _buildPlayer() {
    return Stack(
      children: [
        AspectRatio(
          aspectRatio: _chewieController?.aspectRatio ??
              (_chewieController?.videoPlayerController.value.aspectRatio ??
                  16 / 9),
          child: Chewie(
            controller: _chewieController!,
          ),
        ),
        kIsWeb
            ? Positioned.fill(
                top: 15,
                left: 15,
                bottom: 50,
                child: Align(
                  alignment: Alignment.topCenter,
                  child: InkWell(
                    onTap: () async {
                      final detailProvider = Provider.of<CourseDetailsProvider>(
                          context,
                          listen: false);
                      if (Constant.userID != null && widget.viewApiType == 1) {
                        Utils().showProgress(context, "Please Wait...");
                        await playerProvider.addVideoRead(
                            widget.courseId.toString(),
                            widget.videoId.toString(),
                            widget.chepterId.toString(),
                            videoDuration);

                        if (!playerProvider.loading) {
                          if (playerProvider.successVideoReadModel.status ==
                              200) {
                            await detailProvider
                                .getCourseDetails(widget.courseId.toString());
                            await detailProvider.getVideoByChapter(
                                widget.courseId.toString(),
                                widget.chepterId.toString(),
                                0,
                                false);
                            if (!mounted) return;
                            Utils().hideProgress(context);
                            Navigator.pop(context);
                          } else {
                            if (!mounted) return;
                            Utils().hideProgress(context);
                            Utils.showSnackbar(
                                context,
                                "fail",
                                playerProvider.successVideoReadModel.message ??
                                    "",
                                false);
                          }
                        }
                      }
                    },
                    child: Container(
                      padding: const EdgeInsets.all(8),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(50),
                        color: colorPrimary,
                      ),
                      child: MyText(
                          color: white,
                          fontsizeNormal: Dimens.textMedium,
                          maxline: 2,
                          multilanguage: true,
                          fontwaight: FontWeight.w500,
                          text: "markcomplite",
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ),
                  ),
                ),
              )
            : const SizedBox.shrink(),
      ],
    );
  }

  Future<void> onBackPressed(bool didPop) async {
    if (didPop) return;

    if (!kIsWeb) {
      SystemChrome.setPreferredOrientations([DeviceOrientation.portraitUp]);

      SystemChrome.setEnabledSystemUIMode(SystemUiMode.manual,
          overlays: SystemUiOverlay.values);
    }

    printLog("onBackPressed playerCPosition :===> $playerCPosition");
    printLog("onBackPressed videoDuration :===> $videoDuration");

    // Defer Navigator.pop to avoid calling during a locked navigator state
    Future.microtask(() {
      if (!mounted) return;
      if (Navigator.canPop(context)) {
        Navigator.pop(context, false);
      }
    });
    if (widget.type == "video") {
      // API Call
      final detailProvider =
          Provider.of<CourseDetailsProvider>(context, listen: false);
      if (Constant.userID != null && widget.viewApiType == 1) {
        await playerProvider.addVideoRead(
            widget.courseId.toString(),
            widget.videoId.toString(),
            widget.chepterId.toString(),
            videoDuration);

        await detailProvider.getCourseDetails(widget.courseId.toString());
        await detailProvider.getVideoByChapter(
            widget.courseId.toString(), widget.chepterId.toString(), 0, false);
      }
    }
  }
}
