import 'package:prakah/pages/blogdetail.dart';
import 'package:prakah/pages/detail.dart';
import 'package:prakah/pages/ebookdetails.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/wishlistprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class WishList extends StatefulWidget {
  const WishList({super.key});

  @override
  State<WishList> createState() => WishListState();
}

class WishListState extends State<WishList> {
  late WishlistProvider wishlistProvider;
  late ScrollController _scrollController;
  double? width;
  double? height;

  @override
  void initState() {
    super.initState();
    wishlistProvider = Provider.of<WishlistProvider>(context, listen: false);
    _scrollController = ScrollController();
    _scrollController.addListener(_scrollListener);
    /* Course List Api */

    _fetchData("3", 0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (wishlistProvider.currentPage ?? 0) <
            (wishlistProvider.totalPage ?? 0)) {
      printLog("load more====>");
      wishlistProvider.setLoadMore(true);
      if (wishlistProvider.layoutType == Constant.courseType) {
        _fetchData("3", wishlistProvider.currentPage ?? 0);
      } else if (wishlistProvider.layoutType == Constant.bookType) {
        _fetchData("2", wishlistProvider.currentPage ?? 0);
      } else {
        _fetchData("1", wishlistProvider.currentPage ?? 0);
      }
    }
  }

  Future<void> _fetchData(String type, int? nextPage) async {
    await wishlistProvider.getWishList(type, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();

    wishlistProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "wishlist",
          multilanguage: true),
      body: Consumer<WishlistProvider>(
          builder: (context, wishlistprovider, child) {
        return Stack(
          children: [
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 20,
              children: [
                tabButton(),
                Expanded(child: setLayout()),
              ],
            ),
            /* AdMob Banner */
            Utils.showBannerAd(context),
          ],
        );
      }),
    );
  }

  Widget tabButton() {
    return Container(
      width: MediaQuery.of(context).size.width,
      alignment: Alignment.centerRight,
      margin: const EdgeInsets.fromLTRB(20, 20, 20, 0),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(14),
        color: colorPrimary.withValues(alpha: 0.18),
      ),
      child: Row(
        spacing: 15,
        children: [
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () async {
                wishlistProvider.selectLayout(Constant.courseType);
                wishlistProvider.clearWishList();
                _fetchData("3", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: wishlistProvider.layoutType == Constant.courseType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: wishlistProvider.layoutType == Constant.courseType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "course",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () async {
                wishlistProvider.selectLayout(Constant.bookType);
                wishlistProvider.clearWishList();
                _fetchData("2", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: wishlistProvider.layoutType == Constant.bookType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: wishlistProvider.layoutType == Constant.bookType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "book",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () async {
                wishlistProvider.selectLayout(Constant.blogType);
                wishlistProvider.clearWishList();
                _fetchData("1", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: wishlistProvider.layoutType == Constant.blogType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: wishlistProvider.layoutType == Constant.blogType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "blog",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget setLayout() {
    if (wishlistProvider.loading && !wishlistProvider.loadMore) {
      return Padding(
        padding: const EdgeInsets.fromLTRB(15, 10, 15, 15),
        child: (wishlistProvider.layoutType == Constant.courseType)
            ? courseShimmer()
            : (wishlistProvider.layoutType == Constant.bookType)
                ? bookShimmer()
                : blogShimmer(),
      );
    } else {
      if (wishlistProvider.wishList != null &&
          (wishlistProvider.wishList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          padding: const EdgeInsets.fromLTRB(15, 10, 15, 80),
          scrollDirection: Axis.vertical,
          controller: _scrollController,
          physics: const AlwaysScrollableScrollPhysics(),
          child: (wishlistProvider.layoutType == Constant.courseType)
              ? buildCourse()
              : (wishlistProvider.layoutType == Constant.bookType)
                  ? buildBook()
                  : buildBlog(),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget buildCourse() {
    return Column(
      children: [
        courseItem(),
        if (wishlistProvider.loadMore)
          Container(
            height: 50,
            margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
            child: Utils.pageLoader(),
          )
        else
          const SizedBox.shrink(),
      ],
    );
  }

  Widget courseItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 2,
          maxItemsPerRow: 2,
          horizontalGridSpacing: 5,
          verticalGridSpacing: 5,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
          ),
          children:
              List.generate(wishlistProvider.wishList?.length ?? 0, (index) {
            return InkWell(
              onTap: () {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      transitionDuration: const Duration(milliseconds: 200),
                      pageBuilder: (BuildContext context,
                          Animation<double> animation,
                          Animation<double> secondaryAnimation) {
                        return Detail(
                            courseId: wishlistProvider.wishList?[index].id
                                    .toString() ??
                                "");
                      },
                      transitionsBuilder: (BuildContext context,
                          Animation<double> animation,
                          Animation<double> secondaryAnimation,
                          Widget child) {
                        return Align(
                          child: FadeTransition(
                            opacity: animation,
                            child: child,
                          ),
                        );
                      },
                    ),
                  );
                });
              },
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          imgWidth: MediaQuery.sizeOf(context).width,
                          imgHeight: 110,
                          fit: BoxFit.fill,
                          radius: 10,
                          islandscap: true,
                          imageUrl: wishlistProvider
                                  .wishList?[index].thumbnailImg
                                  .toString() ??
                              ""),
                      Positioned.fill(
                        top: 5,
                        left: 10,
                        right: 10,
                        child: Align(
                          alignment: Alignment.topRight,
                          child: (wishlistProvider.position == index &&
                                  wishlistProvider.deleteWishlistloading)
                              ? const SizedBox(
                                  height: 20,
                                  width: 20,
                                  child: CircularProgressIndicator(
                                    color: white,
                                    strokeWidth: 1,
                                  ),
                                )
                              : InkWell(
                                  onTap: () async {
                                    await wishlistProvider.addremoveWatchLater(
                                      "3",
                                      index,
                                      wishlistProvider.wishList?[index].id
                                              .toString() ??
                                          "",
                                    );
                                  },
                                  child: const Icon(
                                    Icons.favorite,
                                    color: red,
                                  ),
                                ),
                        ),
                      ),
                    ],
                  ),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text:
                          wishlistProvider.wishList?[index].title.toString() ??
                              "",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(wishlistProvider
                                  .wishList?[index].totalView
                                  .toString() ??
                              "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  Row(
                    children: [
                      MyRating(
                        size: 15,
                        rating: double.parse(wishlistProvider
                                .wishList?[index].avgRating
                                .toString() ??
                            ""),
                        spacing: 2,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(wishlistProvider.wishList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (wishlistProvider.wishList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${wishlistProvider.wishList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            );
          })),
    );
  }

  Widget buildBook() {
    return Column(
      children: [
        buildBookItem(),
        if (wishlistProvider.loadMore)
          Container(
            height: 50,
            margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
            child: Utils.pageLoader(),
          )
        else
          const SizedBox.shrink(),
      ],
    );
  }

  Widget buildBookItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: 3,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children:
            List.generate(wishlistProvider.wishList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        EbookDetails(
                      ebookId:
                          wishlistProvider.wishList?[index].id.toString() ?? "",
                      ebookName:
                          wishlistProvider.wishList?[index].title.toString() ??
                              "",
                    ),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            },
            child: SizedBox(
              width: 150,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          radius: 5,
                          imgWidth: width,
                          imgHeight: 155,
                          imageUrl: wishlistProvider
                                  .wishList?[index].thumbnailImg
                                  .toString() ??
                              "",
                          fit: BoxFit.cover),
                      Positioned.fill(
                        top: 5,
                        left: 10,
                        right: 10,
                        child: Align(
                          alignment: Alignment.topRight,
                          child: (wishlistProvider.position == index &&
                                  wishlistProvider.deleteWishlistloading)
                              ? const SizedBox(
                                  height: 20,
                                  width: 20,
                                  child: CircularProgressIndicator(
                                    color: colorPrimary,
                                    strokeWidth: 1,
                                  ),
                                )
                              : InkWell(
                                  onTap: () async {
                                    await wishlistProvider.addremoveWatchLater(
                                      "2",
                                      index,
                                      wishlistProvider.wishList?[index].id
                                              .toString() ??
                                          "",
                                    );
                                  },
                                  child: const Icon(
                                    Icons.favorite,
                                    color: red,
                                  ),
                                ),
                        ),
                      ),
                    ],
                  ),
                  const SizedBox(height: 10),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text:
                          wishlistProvider.wishList?[index].title.toString() ??
                              "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  MyText(
                      color: gray,
                      text: wishlistProvider.wishList?[index].tutorName
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(
                          wishlistProvider.wishList?[index].avgRating
                                  .toString() ??
                              "",
                        ),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text: "${double.parse(
                            wishlistProvider.wishList?[index].avgRating
                                    .toString() ??
                                "",
                          )}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (wishlistProvider.wishList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${wishlistProvider.wishList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          );
        }),
      ),
    );
  }

/* Blog Data */
  Widget buildBlog() {
    return Column(
      children: [
        buildBlogItem(),
        if (wishlistProvider.loadMore)
          Container(
            height: 50,
            margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
            child: Utils.pageLoader(),
          )
        else
          const SizedBox.shrink(),
      ],
    );
  }

  Widget buildBlogItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children:
            List.generate(wishlistProvider.wishList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        BlogDetail(
                      blogId:
                          wishlistProvider.wishList?[index].id.toString() ?? "",
                    ),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            },
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                Stack(
                  children: [
                    MyNetworkImage(
                        radius: 5,
                        imgWidth: width,
                        imgHeight: 155,
                        imageUrl: wishlistProvider.wishList?[index].image
                                .toString() ??
                            "",
                        fit: BoxFit.cover),
                    Positioned.fill(
                      top: 5,
                      left: 10,
                      right: 10,
                      child: Align(
                        alignment: Alignment.topRight,
                        child: (wishlistProvider.position == index &&
                                wishlistProvider.deleteWishlistloading)
                            ? const SizedBox(
                                height: 20,
                                width: 20,
                                child: CircularProgressIndicator(
                                  color: colorPrimary,
                                  strokeWidth: 1,
                                ),
                              )
                            : InkWell(
                                onTap: () async {
                                  await wishlistProvider.addremoveWatchLater(
                                    "1",
                                    index,
                                    wishlistProvider.wishList?[index].id
                                            .toString() ??
                                        "",
                                  );
                                },
                                child: const Icon(
                                  Icons.favorite,
                                  color: red,
                                ),
                              ),
                      ),
                    ),
                  ],
                ),
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: wishlistProvider.wishList?[index].title.toString() ??
                        "",
                    fontsizeNormal: Dimens.textBig,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                MyText(
                    color: gray,
                    text: wishlistProvider.wishList?[index].tutorName
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget courseShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 2,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(
          10,
          (index) {
            return Container(
              width: 200,
              margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.rectangular(
                    width: MediaQuery.sizeOf(context).width,
                    height: 110,
                  ),
                  const SizedBox(height: 8),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  Widget bookShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: 3,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return SizedBox(
            width: 140,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                CustomWidget.roundrectborder(
                  width: width ?? 0,
                  height: 155,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget blogShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 4,
            children: [
              Stack(
                children: [
                  CustomWidget.roundcorner(width: width ?? 0, height: 155),
                  Positioned.fill(
                    top: 5,
                    left: 10,
                    right: 10,
                    child: Align(
                      alignment: Alignment.topRight,
                      child: CustomWidget.circular(width: 30, height: 30),
                    ),
                  ),
                ],
              ),
              CustomWidget.roundcorner(width: width ?? 0.0, height: 16),
              CustomWidget.roundcorner(width: (width ?? 0.0) * 0.5, height: 14),
            ],
          );
        }),
      ),
    );
  }
}
