import 'package:prakah/pages/nodata.dart';
import 'package:prakah/pages/tutorprofilepage.dart';
import 'package:prakah/provider/viewseriesprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';
import 'package:readmore/readmore.dart';

class ViewSeriesPage extends StatefulWidget {
  final String liveClassId, title, detailsType;
  const ViewSeriesPage(
      {super.key,
      required this.liveClassId,
      required this.title,
      required this.detailsType});

  @override
  State<ViewSeriesPage> createState() => _ViewSeriesPageState();
}

class _ViewSeriesPageState extends State<ViewSeriesPage> {
  ViewSeriesProvider viewSeriesProvider = ViewSeriesProvider();
  @override
  initState() {
    super.initState();
    viewSeriesProvider =
        Provider.of<ViewSeriesProvider>(context, listen: false);

    _fetchData();
  }

  Future<void> _fetchData() async {
    if (widget.detailsType == "series") {
      await viewSeriesProvider.getEbooks(widget.liveClassId);
    } else {
      await viewSeriesProvider.getHistroyDetails(widget.liveClassId);
    }
  }

  @override
  void dispose() {
    viewSeriesProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: widget.title,
          multilanguage: false),
      body: Consumer<ViewSeriesProvider>(
          builder: (context, viewSeriesProvider, child) {
        if (viewSeriesProvider.loading) {
          return shimmerDetails();
        } else {
          if (widget.detailsType == "series") {
            if (viewSeriesProvider.viewSeriesModel.status == 200 &&
                (viewSeriesProvider.viewSeriesModel.result?.length ?? 0) > 0) {
              return _buildCommanData();
            } else {
              return NoData();
            }
          } else {
            if (viewSeriesProvider.classHistoryDetailsModel.status == 200 &&
                viewSeriesProvider
                        .classHistoryDetailsModel.result?[0].liveClass !=
                    null) {
              return _buildHistoryData();
            } else {
              return NoData();
            }
          }
        }
      }),
    );
  }

  Widget _buildCommanData() {
    final commanDetilsList = viewSeriesProvider.viewSeriesModel.result?[0];
    return SingleChildScrollView(
      padding: EdgeInsets.fromLTRB(15, 0, 15, 0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 14,
        children: [
          Stack(
            children: [
              MyNetworkImage(
                imageUrl: commanDetilsList?.courseLandscapeImg ?? "",
                fit: BoxFit.fill,
                imgHeight: 250,
                imgWidth: MediaQuery.sizeOf(context).width,
                radius: 10,
              ),
              Positioned(
                top: 10,
                left: 5,
                child: Row(
                  spacing: 4,
                  children: [
                    (commanDetilsList?.status.toString() ?? "") == "2"
                        ? MyNetworkImage(
                            imageUrl:
                                "https://i.fbcd.co/products/resized/resized-750-500/2419-9ff351c8d3c2dcbe30da81041c911438a6559890b83490e3a1fd55f8e3b4fc06.jpg",
                            radius: 0,
                            imgHeight: 20,
                            imgWidth: 20,
                            fit: BoxFit.cover)
                        : SizedBox.shrink(),
                    (commanDetilsList?.status.toString() ?? "") == "2"
                        ? Container(
                            padding: EdgeInsets.symmetric(
                                horizontal: 6, vertical: 4),
                            decoration: BoxDecoration(
                                gradient: LinearGradient(
                                    colors: [
                                      red.withValues(alpha: 0.5),
                                      red.withValues(alpha: 0.6)
                                    ],
                                    tileMode: TileMode.mirror,
                                    begin: Alignment.topCenter,
                                    end: Alignment.bottomCenter),
                                borderRadius: BorderRadius.circular(7)),
                            child: MyText(
                              text: "live_now",
                              multilanguage: true,
                              color: white,
                              fontsizeNormal: Dimens.textSmall,
                              fontsizeWeb: Dimens.textSmall,
                              fontwaight: FontWeight.w400,
                            ),
                          )
                        : SizedBox.shrink(),
                  ],
                ),
              )
            ],
          ),
          ReadMoreText(
            commanDetilsList?.description.toString() ?? "",
            trimLines: 5,
            textAlign: TextAlign.left,
            style: GoogleFonts.montserrat(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w500,
                color: gray),
            trimCollapsedText: 'Read More',
            colorClickableText: black,
            trimMode: TrimMode.Line,
            trimExpandedText: 'Read less',
            lessStyle: GoogleFonts.montserrat(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w600,
                color: black),
            moreStyle: GoogleFonts.montserrat(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w600,
                color: black),
          ),
          Row(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            spacing: 20,
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 6,
                children: [
                  Icon(
                    Icons.date_range,
                    size: 20,
                    color: black,
                  ),
                  MyText(
                    text: DateFormat("dd MMMM, yyyy").format(
                        commanDetilsList?.startedDate ?? DateTime.now()),
                    multilanguage: false,
                    color: black,
                    fontsizeNormal: Dimens.textSmall,
                    fontsizeWeb: Dimens.textSmall,
                    fontwaight: FontWeight.w400,
                  ),
                ],
              ),
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 6,
                children: [
                  Icon(
                    Icons.watch_later_outlined,
                    size: 20,
                    color: black,
                  ),
                  MyText(
                    text: Utils.formateTime(
                        staTime: commanDetilsList?.startTime ?? "",
                        enTime: commanDetilsList?.endTime ?? ""),
                    multilanguage: false,
                    color: black,
                    fontsizeNormal: Dimens.textSmall,
                    fontsizeWeb: Dimens.textSmall,
                    fontwaight: FontWeight.w400,
                  ),
                ],
              )
            ],
          ),
          InkWell(
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        TutorProfilePage(
                            tutorid: commanDetilsList?.typeId.toString() ?? ""),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            },
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              spacing: 14,
              children: [
                MyNetworkImage(
                  imageUrl: commanDetilsList?.lecturerImage ?? "",
                  fit: BoxFit.fill,
                  imgHeight: 50,
                  imgWidth: 50,
                  radius: 50,
                ),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 2,
                    children: [
                      MyText(
                        text: commanDetilsList?.lecturerName.toString() ?? "",
                        multilanguage: false,
                        color: black,
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textSmall,
                        fontwaight: FontWeight.w400,
                      ),
                      MyText(
                        text:
                            commanDetilsList?.lecturerUserName.toString() ?? "",
                        multilanguage: false,
                        color: black,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textSmall,
                        fontwaight: FontWeight.w400,
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
          SizedBox(height: 20),
          Row(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              (commanDetilsList?.status.toString() ?? "") == "1"
                  ? Expanded(
                      child: btnWidget(
                      text: "remind_me",
                      color: colorPrimaryDark,
                      textColor: white,
                      borderColor: colorPrimaryDark,
                    ))
                  : SizedBox.shrink(),
              (commanDetilsList?.status.toString() ?? "") == "1"
                  ? SizedBox(width: 20)
                  : SizedBox.shrink(),
              Expanded(
                  child: btnWidget(
                onTap: () {
                  if ((commanDetilsList?.status.toString() ?? "") == "1") {
                  } else {
                    Utils.lanchUrl(
                        commanDetilsList?.meetingLink.toString() ?? "");
                  }
                },
                text: "jion_this_class",
                color: white,
                textColor: colorPrimaryDark,
                borderColor: colorPrimaryDark,
              ))
            ],
          )
        ],
      ),
    );
  }

/* History List Data Started */
  Widget _buildHistoryData() {
    final commanDetilsList =
        viewSeriesProvider.classHistoryDetailsModel.result?[0].liveClass;
    return SingleChildScrollView(
      padding: EdgeInsets.fromLTRB(15, 10, 15, 0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 14,
        children: [
          MyNetworkImage(
            imageUrl: commanDetilsList?.courseLandscapeImg ?? "",
            fit: BoxFit.fill,
            imgHeight: 250,
            imgWidth: MediaQuery.sizeOf(context).width,
            radius: 10,
          ),
          ReadMoreText(
            commanDetilsList?.description.toString() ?? "",
            trimLines: 5,
            textAlign: TextAlign.left,
            style: GoogleFonts.montserrat(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w500,
                color: gray),
            trimCollapsedText: 'Read More',
            colorClickableText: black,
            trimMode: TrimMode.Line,
            trimExpandedText: 'Read less',
            lessStyle: GoogleFonts.montserrat(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w600,
                color: black),
            moreStyle: GoogleFonts.montserrat(
                fontSize: Dimens.textSmall,
                fontWeight: FontWeight.w600,
                color: black),
          ),
          Row(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            spacing: 20,
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 6,
                children: [
                  Icon(
                    Icons.date_range,
                    size: 20,
                    color: black,
                  ),
                  MyText(
                    text: Utils.dateConvert(
                        commanDetilsList?.startedDate.toString() ?? "",
                        "dd MMMM, yyyy"),
                    multilanguage: false,
                    color: black,
                    fontsizeNormal: Dimens.textSmall,
                    fontsizeWeb: Dimens.textSmall,
                    fontwaight: FontWeight.w400,
                  ),
                ],
              ),
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 6,
                children: [
                  Icon(
                    Icons.watch_later_outlined,
                    size: 20,
                    color: black,
                  ),
                  MyText(
                    text: Utils.formateTime(
                        staTime: commanDetilsList?.startTime ?? "",
                        enTime: commanDetilsList?.endTime ?? ""),
                    multilanguage: false,
                    color: black,
                    fontsizeNormal: Dimens.textSmall,
                    fontsizeWeb: Dimens.textSmall,
                    fontwaight: FontWeight.w400,
                  ),
                ],
              )
            ],
          ),
          InkWell(
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        TutorProfilePage(
                            tutorid: commanDetilsList?.typeId.toString() ?? ""),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            },
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              spacing: 14,
              children: [
                MyNetworkImage(
                  imageUrl: commanDetilsList?.lecturerImage ?? "",
                  fit: BoxFit.fill,
                  imgHeight: 50,
                  imgWidth: 50,
                  radius: 50,
                ),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 2,
                    children: [
                      MyText(
                        text: commanDetilsList?.lecturerName.toString() ?? "",
                        multilanguage: false,
                        color: black,
                        fontsizeNormal: Dimens.textMedium,
                        fontsizeWeb: Dimens.textSmall,
                        fontwaight: FontWeight.w400,
                      ),
                      MyText(
                        text:
                            commanDetilsList?.lecturerUserName.toString() ?? "",
                        multilanguage: false,
                        color: black,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textSmall,
                        fontwaight: FontWeight.w400,
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }

  Widget btnWidget({String? text, color, textColor, borderColor, onTap}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: 6, vertical: 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
            color: color,
            borderRadius: BorderRadius.circular(8),
            border: Border.all(
                width: 1, color: borderColor, style: BorderStyle.solid)),
        child: MyText(
          text: text ?? "",
          color: textColor,
          multilanguage: true,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textTitle,
          fontwaight: FontWeight.w600,
        ),
      ),
    );
  }

  /* Shimmer */

  Widget shimmerDetails() {
    return SingleChildScrollView(
      padding: EdgeInsets.fromLTRB(15, 0, 15, 0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 14,
        children: [
          CustomWidget.roundrectborder(
              height: 250, width: MediaQuery.sizeOf(context).width),
          CustomWidget.roundrectborder(
              height: 14, width: MediaQuery.sizeOf(context).width),
          CustomWidget.roundrectborder(
              height: 14, width: MediaQuery.sizeOf(context).width),
          CustomWidget.roundrectborder(
              height: 14, width: MediaQuery.sizeOf(context).width),
          CustomWidget.roundrectborder(
              height: 14, width: MediaQuery.sizeOf(context).width),
          CustomWidget.roundrectborder(height: 14, width: 200),
          Row(
            spacing: 20,
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                  child: CustomWidget.roundrectborder(height: 14, width: 200)),
              Expanded(
                  child: CustomWidget.roundrectborder(height: 14, width: 200)),
            ],
          ),
          Row(
            spacing: 10,
            children: [
              CustomWidget.circular(height: 50, width: 50),
              Expanded(
                  child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.roundrectborder(height: 14, width: 200),
                  CustomWidget.roundrectborder(height: 14, width: 150),
                ],
              )),
            ],
          ),
          Row(
            spacing: 20,
            children: [
              Expanded(
                  child: CustomWidget.roundrectborder(height: 25, width: 200)),
              Expanded(
                  child: CustomWidget.roundrectborder(height: 25, width: 200)),
            ],
          ),
        ],
      ),
    );
  }
}
