import 'package:prakah/pages/blogdetail.dart';
import 'package:prakah/pages/detail.dart';
import 'package:prakah/pages/ebookdetails.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/pages/search.dart';
import 'package:prakah/pages/tutorprofilepage.dart';
import 'package:prakah/pages/videobyidviewall.dart';
import 'package:prakah/provider/viewallprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import '../model/sectiondetailmodel.dart';

class ViewAll extends StatefulWidget {
  final String? contentId, title, viewAllType, screenLayout;
  const ViewAll(
      {super.key,
      this.contentId,
      this.viewAllType,
      this.title,
      this.screenLayout});

  @override
  State<ViewAll> createState() => ViewAllState();
}

class ViewAllState extends State<ViewAll> {
  late ViewAllProvider viewAllProvider;
  PageController pageController = PageController();
  late ScrollController _scrollController;
  double? width;
  double? height;

  @override
  void initState() {
    super.initState();
    viewAllProvider = Provider.of<ViewAllProvider>(context, listen: false);
    _scrollController = ScrollController();
    _scrollController.addListener(_scrollListener);
    _fetchSectionDetail(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (viewAllProvider.currentPage ?? 0) < (viewAllProvider.totalPage ?? 0)) {
      viewAllProvider.setLoadMore(true);
      _fetchSectionDetail(viewAllProvider.currentPage ?? 0);
    }
  }

  Future<void> _fetchSectionDetail(int? nextPage) async {
    await viewAllProvider.getSeactionDetail(
        widget.contentId.toString(), (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();

    viewAllProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return Stack(
      children: [
        Scaffold(
          appBar: AppBar(
            backgroundColor: colorPrimaryDark,
            elevation: 0,
            surfaceTintColor: transparent,
            systemOverlayStyle: SystemUiOverlayStyle(
                statusBarColor: transparent,
                systemNavigationBarColor: transparent,
                systemNavigationBarDividerColor: transparent),
            centerTitle: false,
            titleSpacing: 0,
            leading: Utils.backButton(context),
            title: MyText(
              text: widget.title ?? "",
              multilanguage: false,
              fontsizeNormal: Dimens.textTitle,
              fontsizeWeb: Dimens.textTitle,
              fontstyle: FontStyle.normal,
              fontwaight: FontWeight.bold,
              textalign: TextAlign.center,
              color: white,
            ),
            actions: [
              IconButton(
                autofocus: true,
                focusColor: white.withValues(alpha: 0.5),
                onPressed: () {
                  AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                      () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        transitionDuration: const Duration(milliseconds: 200),
                        pageBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation) {
                          return const Search();
                        },
                        transitionsBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation,
                            Widget child) {
                          return Align(
                            child: FadeTransition(
                              opacity: animation,
                              child: child,
                            ),
                          );
                        },
                      ),
                    );
                  });
                },
                icon: Icon(Icons.search, size: 20, color: white),
              ),
            ],
          ),
          body: Consumer<ViewAllProvider>(
              builder: (context, viewAllProvider, child) {
            return RefreshIndicator(
              backgroundColor: white,
              color: colorPrimary,
              displacement: 40,
              edgeOffset: 1.0,
              triggerMode: RefreshIndicatorTriggerMode.anywhere,
              strokeWidth: 3,
              onRefresh: () async {
                viewAllProvider.clearProvider();
                viewAllProvider.setLoadMore(false);
                await _fetchSectionDetail(0);
              },
              child: SingleChildScrollView(
                controller: _scrollController,
                padding: const EdgeInsets.only(bottom: 80),
                physics: const AlwaysScrollableScrollPhysics(),
                child: Column(
                  children: [
                    selectLayout(),
                    buildSection(),
                  ],
                ),
              ),
            );
          }),
        ),
        /* AdMob Banner */
        Utils.showBannerAd(context),
      ],
    );
  }

  Widget selectLayout() {
    if (widget.viewAllType == "section" &&
        widget.screenLayout != "blog" &&
        widget.screenLayout != "tutor" &&
        widget.screenLayout != "category" &&
        widget.screenLayout != "language" &&
        widget.screenLayout != "book") {
      return Container(
        width: MediaQuery.of(context).size.width,
        height: 45,
        alignment: Alignment.centerRight,
        padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
        decoration: BoxDecoration(
          color: colorPrimary.withValues(alpha: 0.18),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.end,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            InkWell(
              onTap: () async {
                await viewAllProvider.selectLayout(Constant.grid);
              },
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_grid.png",
                  color: viewAllProvider.layoutType == Constant.grid
                      ? colorPrimary
                      : gray,
                ),
              ),
            ),
            const SizedBox(width: 8),
            InkWell(
              onTap: () async {
                await viewAllProvider.selectLayout(Constant.square);
              },
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_square.png",
                  color: viewAllProvider.layoutType == Constant.square
                      ? colorPrimary
                      : gray,
                ),
              ),
            ),
            const SizedBox(width: 8),
            InkWell(
              onTap: () async {
                await viewAllProvider.selectLayout(Constant.list);
              },
              child: Padding(
                padding: const EdgeInsets.all(8),
                child: MyImage(
                  width: 20,
                  height: 20,
                  imagePath: "ic_list.png",
                  color: viewAllProvider.layoutType == Constant.list
                      ? colorPrimary
                      : gray,
                ),
              ),
            ),
          ],
        ),
      );
    } else {
      return const SizedBox.shrink();
    }
  }

  Widget buildSection() {
    if (widget.screenLayout == "blog") {
      return buildBlog();
    } else if (widget.screenLayout == "book") {
      return buildBook();
    } else if (widget.screenLayout == "category" ||
        widget.screenLayout == "language") {
      return buildCategoryAndLanguage();
    } else if (widget.screenLayout == "tutor") {
      return buildTutor();
    } else {
      return buildSectionItem();
    }
  }

  Widget buildSectionItem() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Padding(
            padding: const EdgeInsets.all(15),
            child: Column(
              children: [
                MediaQuery.removePadding(
                  context: context,
                  removeTop: true,
                  child: ResponsiveGridList(
                    minItemWidth: 120,
                    minItemsPerRow: itemCount(),
                    maxItemsPerRow: itemCount(),
                    horizontalGridSpacing: 5,
                    verticalGridSpacing: 10,
                    listViewBuilderOptions: ListViewBuilderOptions(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      physics: const BouncingScrollPhysics(),
                    ),
                    children: List.generate(
                        viewAllProvider.sectionDetailList?.length ?? 0,
                        (index) {
                      return buildSectionLayout(index);
                    }),
                  ),
                ),
                if (viewAllProvider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  /* Section Layout's Start */

  Widget buildSectionLayout(int index) {
    if (viewAllProvider.layoutType == Constant.grid) {
      return bigPortrait(
          index: index, courseList: viewAllProvider.sectionDetailList ?? []);
    } else if (viewAllProvider.layoutType == Constant.square) {
      return square(
          index: index, courseList: viewAllProvider.sectionDetailList ?? []);
    } else {
      return listView(
          index: index, courseList: viewAllProvider.sectionDetailList ?? []);
    }
  }

  /* Listview  */
  Widget listView({required int index, required List<Result>? courseList}) {
    return InkWell(
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return Detail(courseId: courseList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        });
      },
      child: Container(
        width: MediaQuery.sizeOf(context).width,
        margin: EdgeInsets.only(bottom: 15),
        decoration: BoxDecoration(
            border: Border.all(
                width: 1,
                color: gray.withValues(alpha: .4),
                style: BorderStyle.solid),
            boxShadow: [
              BoxShadow(
                  blurRadius: 4,
                  blurStyle: BlurStyle.outer,
                  color: transparent.withValues(alpha: .3),
                  offset: Offset(0, 0),
                  spreadRadius: 0)
            ],
            color: white,
            borderRadius: BorderRadius.circular(5)),
        child: Row(
          children: [
            Container(
              width: 115,
              height: 100,
              decoration: BoxDecoration(
                  image: DecorationImage(
                      image: NetworkImage(
                          courseList?[index].landscapeImg.toString() ?? ""),
                      fit: BoxFit.fill),
                  border: Border(
                    right: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .4),
                        style: BorderStyle.solid),
                  ),
                  boxShadow: [
                    BoxShadow(
                        blurRadius: 4,
                        blurStyle: BlurStyle.outer,
                        color: transparent.withValues(alpha: .2),
                        offset: Offset(0, 0),
                        spreadRadius: 0)
                  ],
                  borderRadius: const BorderRadius.only(
                      bottomLeft: Radius.circular(5),
                      topLeft: Radius.circular(5))),
            ),
            const SizedBox(width: 10),
            Expanded(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: courseList?[index].title.toString() ?? "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(
                              courseList?[index].totalView.toString() ?? "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(
                            courseList?[index].avgRating.toString() ?? ""),
                        spacing: 2,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(courseList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (courseList?[index].isFree.toString() ?? "") == "0"
                          ? "${Constant.currencyCode} ${courseList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      multilanguage: false,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  /* Square */
  Widget square({required int index, required List<Result>? courseList}) {
    return InkWell(
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return Detail(courseId: courseList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        });
      },
      child: Container(
        width: 200,
        margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
        child: Column(
          spacing: 4,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            MyNetworkImage(
                imgWidth: MediaQuery.sizeOf(context).width,
                imgHeight: 170,
                fit: BoxFit.fill,
                islandscap: true,
                radius: 20,
                imageUrl: courseList?[index].thumbnailImg.toString() ?? ""),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: courseList?[index].title.toString() ?? "",
                fontsizeNormal: Dimens.textBigSmall,
                fontwaight: FontWeight.w600,
                maxline: 2,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            MyText(
                color: gray,
                text:
                    "${Utils.kmbGenerator(int.parse(courseList?[index].totalView.toString() ?? ""))} ${Locales.string(context, "students")}",
                fontsizeNormal: Dimens.textSmall,
                fontwaight: FontWeight.w500,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            Row(
              children: [
                MyRating(
                  size: 13,
                  rating: double.parse(
                      courseList?[index].avgRating.toString() ?? ""),
                  spacing: 2,
                ),
                const SizedBox(width: 5),
                MyText(
                    color: colorAccent,
                    text:
                        "${double.parse(courseList?[index].avgRating.toString() ?? "")}",
                    fontsizeNormal: Dimens.textBigSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            MyText(
                color: black,
                text: (courseList?[index].isFree.toString() ?? "") == "0"
                    ? "${Constant.currencyCode} ${courseList?[index].price.toString() ?? ""}"
                    : Locales.string(context, "free"),
                fontsizeNormal: Dimens.textSmall,
                fontwaight: FontWeight.w500,
                maxline: 1,
                multilanguage: false,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ],
        ),
      ),
    );
  }

  /* Big Portrait */
  Widget bigPortrait({required int index, required List<Result>? courseList}) {
    return InkWell(
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return Detail(courseId: courseList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        });
      },
      child: Container(
        width: 200,
        margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 4,
          children: [
            MyNetworkImage(
                imgWidth: MediaQuery.sizeOf(context).width,
                imgHeight: 110,
                fit: BoxFit.fill,
                radius: 20,
                islandscap: true,
                imageUrl: courseList?[index].thumbnailImg.toString() ?? ""),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: courseList?[index].title.toString() ?? "",
                fontsizeNormal: Dimens.textBigSmall,
                fontwaight: FontWeight.w600,
                maxline: 2,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            MyText(
                color: gray,
                text:
                    "${Utils.kmbGenerator(int.parse(courseList?[index].totalView.toString() ?? ""))} ${Locales.string(context, "students")}",
                fontsizeNormal: Dimens.textSmall,
                fontwaight: FontWeight.w500,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            Row(
              children: [
                MyRating(
                  size: 13,
                  rating: double.parse(
                      courseList?[index].avgRating.toString() ?? ""),
                  spacing: 2,
                ),
                const SizedBox(width: 5),
                MyText(
                    color: colorAccent,
                    text:
                        "${double.parse(courseList?[index].avgRating.toString() ?? "")}",
                    fontsizeNormal: Dimens.textBigSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            MyText(
                color: black,
                text: (courseList?[index].isFree.toString() ?? "") == "0"
                    ? "${Constant.currencyCode} ${courseList?[index].price.toString() ?? ""}"
                    : Locales.string(context, "free"),
                fontsizeNormal: Dimens.textSmall,
                fontwaight: FontWeight.w500,
                maxline: 1,
                multilanguage: false,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
          ],
        ),
      ),
    );
  }

  /* Section Layout's End */

/* Blog Item  */

  Widget buildBlog() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Padding(
            padding: const EdgeInsets.all(15),
            child: Column(
              children: [
                MediaQuery.removePadding(
                  context: context,
                  removeTop: true,
                  child: ResponsiveGridList(
                    minItemWidth: 120,
                    minItemsPerRow: 2,
                    maxItemsPerRow: 2,
                    horizontalGridSpacing: 5,
                    verticalGridSpacing: 10,
                    listViewBuilderOptions: ListViewBuilderOptions(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      physics: const BouncingScrollPhysics(),
                    ),
                    children: List.generate(
                        viewAllProvider.sectionDetailList?.length ?? 0,
                        (index) {
                      return buildBlogItem(
                          index: index,
                          blogList: viewAllProvider.sectionDetailList ?? []);
                    }),
                  ),
                ),
                if (viewAllProvider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  Widget buildBlogItem({required int index, required List<Result>? blogList}) {
    return InkWell(
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return BlogDetail(blogId: blogList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        });
      },
      child: Container(
        width: 200,
        margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
        child: Column(
          children: [
            MyNetworkImage(
                radius: 10,
                imgWidth: MediaQuery.sizeOf(context).width,
                imgHeight: 110,
                fit: BoxFit.fill,
                islandscap: true,
                imageUrl: blogList?[index].image.toString() ?? ""),
            const SizedBox(height: 8),
            Expanded(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: blogList?[index].title.toString() ?? "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  const SizedBox(height: 5),
                  MyText(
                      color: gray,
                      text: Utils.timeAgoCustom(
                        DateTime.parse(
                            blogList?[index].createdAt.toString() ?? ""),
                      ),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w600,
                      maxline: 3,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

/* Book Item */

  Widget buildBook() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Padding(
            padding: const EdgeInsets.all(15),
            child: Column(
              children: [
                MediaQuery.removePadding(
                  context: context,
                  removeTop: true,
                  child: ResponsiveGridList(
                    minItemWidth: 120,
                    minItemsPerRow: 3,
                    maxItemsPerRow: 3,
                    horizontalGridSpacing: 10,
                    verticalGridSpacing: 10,
                    listViewBuilderOptions: ListViewBuilderOptions(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      physics: const BouncingScrollPhysics(),
                    ),
                    children: List.generate(
                        viewAllProvider.sectionDetailList?.length ?? 0,
                        (index) {
                      return buildBookItem(
                          index: index,
                          bookList: viewAllProvider.sectionDetailList ?? []);
                    }),
                  ),
                ),
                if (viewAllProvider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  Widget buildBookItem({required int index, required List<Result>? bookList}) {
    return InkWell(
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              pageBuilder: (context, animation, secondaryAnimation) =>
                  EbookDetails(
                ebookId: bookList?[index].id.toString() ?? "",
                ebookName: bookList?[index].title.toString() ?? "",
              ),
              transitionsBuilder:
                  (context, animation, secondaryAnimation, child) {
                const begin = Offset(1.0, 0.0);
                const end = Offset.zero;
                const curve = Curves.ease;

                var tween = Tween(begin: begin, end: end)
                    .chain(CurveTween(curve: curve));

                return SlideTransition(
                  position: animation.drive(tween),
                  child: child,
                );
              },
            ),
          );
        });
      },
      child: SizedBox(
        width: 140,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            MyNetworkImage(
                imgWidth: width,
                radius: 20,
                imgHeight: 155,
                imageUrl: bookList?[index].thumbnailImg.toString() ?? "",
                fit: BoxFit.cover),
            const SizedBox(height: 10),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: bookList?[index].title.toString() ?? "",
                fontsizeNormal: Dimens.textSmall,
                fontsizeWeb: Dimens.textSmall,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontwaight: FontWeight.w600,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            const SizedBox(height: 5),
            MyText(
                color: gray,
                text: bookList?[index].tutorName.toString() ?? "",
                fontsizeNormal: Dimens.textSmall,
                fontsizeWeb: Dimens.textSmall,
                maxline: 2,
                overflow: TextOverflow.ellipsis,
                fontwaight: FontWeight.w600,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            const SizedBox(height: 5),
            Row(
              children: [
                MyRating(
                  size: 13,
                  rating: double.parse(
                      (bookList?[index].avgRating.toString() ?? "")),
                  spacing: 3,
                ),
                const SizedBox(width: 5),
                MyText(
                    color: colorAccent,
                    text:
                        "${double.parse(bookList?[index].avgRating.toString() ?? "")}",
                    fontsizeNormal: Dimens.textBigSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          ],
        ),
      ),
    );
  }

/* Category And Language Layout Item */

  Widget buildCategoryAndLanguage() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildCategoryAndLanguageShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Padding(
            padding: const EdgeInsets.all(15),
            child: Column(
              children: [
                MediaQuery.removePadding(
                  context: context,
                  removeTop: true,
                  child: ResponsiveGridList(
                    minItemWidth: 120,
                    minItemsPerRow: 4,
                    maxItemsPerRow: 8,
                    horizontalGridSpacing: 0,
                    verticalGridSpacing: 0,
                    listViewBuilderOptions: ListViewBuilderOptions(
                      scrollDirection: Axis.vertical,
                      shrinkWrap: true,
                      padding: EdgeInsets.zero,
                      physics: const BouncingScrollPhysics(),
                    ),
                    children: List.generate(
                        viewAllProvider.sectionDetailList?.length ?? 0,
                        (index) {
                      return buildCategoryAndLangageItem(
                          index: index,
                          categoryList:
                              viewAllProvider.sectionDetailList ?? []);
                    }),
                  ),
                ),
                if (viewAllProvider.loadmore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  Widget buildCategoryAndLangageItem(
      {required int index, required List<Result>? categoryList}) {
    return InkWell(
        splashColor: transparent,
        focusColor: transparent,
        hoverColor: transparent,
        highlightColor: transparent,
        onTap: () {
          AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
            Navigator.of(context).push(
              PageRouteBuilder(
                pageBuilder: (context, animation, secondaryAnimation) =>
                    VideoByIdViewAll(
                  apiType: widget.screenLayout,
                  title: categoryList?[index].name.toString() ?? "",
                  contentId: categoryList?[index].id.toString() ?? "",
                ),
                transitionsBuilder:
                    (context, animation, secondaryAnimation, child) {
                  const begin = Offset(1.0, 0.0);
                  const end = Offset.zero;
                  const curve = Curves.ease;

                  var tween = Tween(begin: begin, end: end)
                      .chain(CurveTween(curve: curve));

                  return SlideTransition(
                    position: animation.drive(tween),
                    child: child,
                  );
                },
              ),
            );
          });
        },
        child: Column(
          children: [
            Container(
              height: 76,
              width: 87,
              padding: const EdgeInsets.fromLTRB(10, 5, 10, 5),
              alignment: Alignment.center,
              decoration: BoxDecoration(
                  color: white,
                  borderRadius: const BorderRadius.all(Radius.circular(25)),
                  border: Border.all(
                      width: 0.8, color: colorPrimary.withValues(alpha: 0.2))),
              margin: const EdgeInsets.all(5),
              child: MyNetworkImage(
                  imgHeight: 50,
                  imgWidth: 60,
                  radius: 10,
                  imageUrl: categoryList?[index].image.toString() ?? "",
                  fit: BoxFit.cover),
            ),
            MyText(
                color: gray,
                text: categoryList?[index].name.toString() ?? "",
                fontsizeNormal: Dimens.textMedium,
                overflow: TextOverflow.ellipsis,
                maxline: 2,
                fontwaight: FontWeight.w600,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal),
          ],
        ));
  }

  Widget buildCategoryAndLanguageShimmer() {
    return Padding(
      padding: const EdgeInsets.all(15),
      child: MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 4,
          maxItemsPerRow: 4,
          horizontalGridSpacing: 2,
          verticalGridSpacing: 2,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(40, (index) {
            return Column(
              children: [
                const CustomWidget.roundcorner(
                  height: 60,
                  width: 50,
                ),
                const CustomWidget.circleborder(
                  height: 18,
                  width: 120,
                ),
              ],
            );
          }),
        ),
      ),
    );
  }

/* Tutor Item */

  Widget buildTutor() {
    if (viewAllProvider.loading && !viewAllProvider.loadmore) {
      return buildTutorShimmer();
    } else {
      if (viewAllProvider.sectionDetailModel.status == 200 &&
          viewAllProvider.sectionDetailList != null) {
        if ((viewAllProvider.sectionDetailList?.length ?? 0) > 0) {
          return Column(
            children: [
              ResponsiveGridList(
                minItemWidth: 120,
                minItemsPerRow: 1,
                maxItemsPerRow: 1,
                horizontalGridSpacing: 10,
                horizontalGridMargin: 14,
                verticalGridSpacing: 10,
                verticalGridMargin: 20,
                listViewBuilderOptions: ListViewBuilderOptions(
                  scrollDirection: Axis.vertical,
                  shrinkWrap: true,
                  physics: const NeverScrollableScrollPhysics(),
                ),
                children: List.generate(
                    viewAllProvider.sectionDetailList?.length ?? 0, (index) {
                  return buildTutorItem(
                      index: index,
                      tutorList: viewAllProvider.sectionDetailList ?? []);
                }),
              ),
              if (viewAllProvider.loadmore)
                Container(
                  height: 50,
                  margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                  child: Utils.pageLoader(),
                )
              else
                const SizedBox.shrink(),
            ],
          );
        } else {
          return const NoData();
        }
      } else {
        return const NoData();
      }
    }
  }

  Widget buildTutorItem(
      {required int index, required List<Result>? tutorList}) {
    return Container(
      padding: const EdgeInsets.fromLTRB(20, 20, 20, 15),
      decoration: BoxDecoration(
          color: Theme.of(context).secondaryHeaderColor,
          borderRadius: BorderRadius.circular(6)),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              MyNetworkImage(
                  imgWidth: 60,
                  imgHeight: 60,
                  radius: 200,
                  fit: BoxFit.cover,
                  imageUrl: tutorList?[index].image.toString() ?? ""),
              const SizedBox(width: 10),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: tutorList?[index].fullName == ""
                            ? "Guest User"
                            : tutorList?[index].fullName.toString() ?? "",
                        fontsizeNormal: Dimens.textDesc,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 5),
                    MyText(
                        color: gray,
                        text: tutorList?[index].email.toString() ?? "",
                        fontsizeNormal: Dimens.textBigSmall,
                        fontwaight: FontWeight.w400,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
              ),
            ],
          ),
          const SizedBox(height: 8),
          MyText(
              color: colorPrimaryDark,
              text:
                  "${Utils.kmbGenerator(tutorList?[index].totalView ?? 0)} Students",
              fontsizeNormal: Dimens.textSmall,
              fontwaight: FontWeight.w500,
              maxline: 2,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          const SizedBox(height: 8),
          MyText(
              color: gray,
              text: tutorList?[index].description.toString() ?? "",
              fontsizeNormal: Dimens.textSmall,
              fontwaight: FontWeight.w400,
              maxline: 3,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          const SizedBox(height: 8),
          Align(
            alignment: Alignment.center,
            child: InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              highlightColor: transparent,
              onTap: () {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          TutorProfilePage(
                        tutorid: tutorList?[index].id.toString() ?? "",
                      ),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                  );
                });
              },
              child: Container(
                padding: const EdgeInsets.fromLTRB(18, 8, 18, 8),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(50),
                  border: Border.all(width: 0.8, color: colorPrimaryDark),
                ),
                child: MyText(
                    color: colorPrimaryDark,
                    text: "View Profile",
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w500,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget buildTutorShimmer() {
    return Padding(
      padding: const EdgeInsets.all(15),
      child: ResponsiveGridList(
        minItemWidth: 200,
        minItemsPerRow: 1,
        maxItemsPerRow: 1,
        horizontalGridSpacing: 10,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const BouncingScrollPhysics(),
        ),
        children: List.generate(40, (index) {
          return Container(
            width: 260,
            padding: const EdgeInsets.fromLTRB(20, 20, 20, 15),
            color: Theme.of(context).secondaryHeaderColor,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  children: [
                    const CustomWidget.circular(width: 60, height: 60),
                    Expanded(
                        child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        CustomWidget.roundrectborder(
                            width: MediaQuery.of(context).size.width,
                            height: 10),
                        CustomWidget.roundrectborder(width: 200, height: 10),
                      ],
                    ))
                  ],
                ),
                const SizedBox(height: 10),
                CustomWidget.roundrectborder(
                  width: MediaQuery.of(context).size.width,
                  height: 10,
                ),
                const SizedBox(height: 10),
                CustomWidget.roundrectborder(
                    width: MediaQuery.of(context).size.width, height: 10),
                CustomWidget.roundrectborder(width: 200, height: 10),
                Align(
                    alignment: Alignment.topCenter,
                    child: CustomWidget.circleborder(width: 200, height: 35))
              ],
            ),
          );
        }),
      ),
    );
  }

/* Shimmer Widget */
  Widget buildShimmer() {
    return Padding(
      padding: const EdgeInsets.all(15),
      child: Column(
        children: [
          MediaQuery.removePadding(
            context: context,
            removeTop: true,
            child: ResponsiveGridList(
              minItemWidth: 120,
              minItemsPerRow: itemCount(),
              maxItemsPerRow: itemCount(),
              horizontalGridSpacing: 5,
              verticalGridSpacing: 10,
              listViewBuilderOptions: ListViewBuilderOptions(
                scrollDirection: Axis.vertical,
                shrinkWrap: true,
                physics: const BouncingScrollPhysics(),
              ),
              children: List.generate(10, (index) {
                return Container(
                  width: 200,
                  margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
                  child: Column(
                    children: [
                      CustomWidget.roundcorner(
                        width: MediaQuery.sizeOf(context).width,
                        height: 150,
                      ),
                      const SizedBox(height: 8),
                      Expanded(
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            CustomWidget.rectangular(
                              width: MediaQuery.sizeOf(context).width,
                              height: 5,
                            ),
                            CustomWidget.rectangular(
                              width: MediaQuery.sizeOf(context).width,
                              height: 5,
                            ),
                            CustomWidget.rectangular(
                              width: MediaQuery.sizeOf(context).width,
                              height: 5,
                            ),
                            CustomWidget.rectangular(
                              width: MediaQuery.sizeOf(context).width,
                              height: 5,
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                );
              }),
            ),
          ),
        ],
      ),
    );
  }

  /* Item Count */
  int itemCount() {
    if (viewAllProvider.layoutType == Constant.grid) {
      return 2;
    } else if (viewAllProvider.layoutType == Constant.square) {
      return 1;
    } else {
      return 1;
    }
  }
}
