import 'package:prakah/pages/detail.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/pages/search.dart';
import 'package:prakah/provider/videobyidviewallprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import 'package:prakah/model/coursemodel.dart' as videobyid;

class VideoByIdViewAll extends StatefulWidget {
  final String? contentId, title, apiType;
  const VideoByIdViewAll({
    super.key,
    this.contentId,
    this.apiType,
    this.title,
  });

  @override
  State<VideoByIdViewAll> createState() => ViewAllState();
}

class ViewAllState extends State<VideoByIdViewAll> {
  late VideoByIdViewAllProvider videoByIdViewAllProvider;
  PageController pageController = PageController();
  late ScrollController _scrollController;
  double? width;
  double? height;

  @override
  void initState() {
    super.initState();
    videoByIdViewAllProvider =
        Provider.of<VideoByIdViewAllProvider>(context, listen: false);
    _scrollController = ScrollController();
    _scrollController.addListener(_scrollListener);
    _fetchData(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (videoByIdViewAllProvider.currentPage ?? 0) <
            (videoByIdViewAllProvider.totalPage ?? 0)) {
      videoByIdViewAllProvider.setLoadMore(true);
      _fetchData(videoByIdViewAllProvider.currentPage ?? 0);
    }
  }

  Future<void> _fetchData(int? nextPage) async {
    await videoByIdViewAllProvider.getVideoById(
        widget.contentId.toString(), widget.apiType, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();

    videoByIdViewAllProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return Stack(
      children: [
        Scaffold(
          appBar: AppBar(
            backgroundColor: colorPrimaryDark,
            elevation: 0,
            surfaceTintColor: transparent,
            systemOverlayStyle: SystemUiOverlayStyle(
                statusBarColor: transparent,
                systemNavigationBarColor: transparent,
                systemNavigationBarDividerColor: transparent),
            centerTitle: false,
            titleSpacing: 0,
            leading: Utils.backButton(context),
            title: MyText(
              text: widget.title ?? "",
              multilanguage: false,
              fontsizeNormal: Dimens.textTitle,
              fontsizeWeb: Dimens.textTitle,
              fontstyle: FontStyle.normal,
              fontwaight: FontWeight.bold,
              textalign: TextAlign.center,
              color: white,
            ),
            actions: [
              IconButton(
                autofocus: true,
                focusColor: white.withValues(alpha: 0.5),
                onPressed: () {
                  AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                      () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        transitionDuration: const Duration(milliseconds: 200),
                        pageBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation) {
                          return const Search();
                        },
                        transitionsBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation,
                            Widget child) {
                          return Align(
                            child: FadeTransition(
                              opacity: animation,
                              child: child,
                            ),
                          );
                        },
                      ),
                    );
                  });
                },
                icon: Icon(Icons.search, size: 20, color: white),
              ),
            ],
          ),
          body: Consumer<VideoByIdViewAllProvider>(
              builder: (context, videoByIdViewAllProvider, child) {
            return RefreshIndicator(
              backgroundColor: white,
              color: colorPrimary,
              displacement: 40,
              edgeOffset: 1.0,
              triggerMode: RefreshIndicatorTriggerMode.anywhere,
              strokeWidth: 3,
              onRefresh: () async {},
              child: Column(
                children: [
                  selectLayout(),
                  Expanded(child: buildVideoById()),
                  if (videoByIdViewAllProvider.loadmore)
                    Container(
                      height: 50,
                      margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                      child: Utils.pageLoader(),
                    )
                  else
                    const SizedBox.shrink(),
                  SizedBox(height: 50)
                ],
              ),
            );
          }),
        ),
        /* AdMob Banner */
        Utils.showBannerAd(context),
      ],
    );
  }

  Widget selectLayout() {
    return Container(
      width: MediaQuery.of(context).size.width,
      height: 45,
      alignment: Alignment.centerRight,
      padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
      decoration: BoxDecoration(
        color: colorPrimary.withValues(alpha: 0.18),
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.end,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          InkWell(
            onTap: () {
              videoByIdViewAllProvider.selectLayout(Constant.grid);
            },
            child: Padding(
              padding: const EdgeInsets.all(8),
              child: MyImage(
                width: 20,
                height: 20,
                imagePath: "ic_grid.png",
                color: videoByIdViewAllProvider.layoutType == Constant.grid
                    ? colorPrimary
                    : gray,
              ),
            ),
          ),
          const SizedBox(width: 8),
          InkWell(
            onTap: () {
              videoByIdViewAllProvider.selectLayout(Constant.square);
            },
            child: Padding(
              padding: const EdgeInsets.all(8),
              child: MyImage(
                width: 20,
                height: 20,
                imagePath: "ic_square.png",
                color: videoByIdViewAllProvider.layoutType == Constant.square
                    ? colorPrimary
                    : gray,
              ),
            ),
          ),
          const SizedBox(width: 8),
          InkWell(
            onTap: () {
              videoByIdViewAllProvider.selectLayout(Constant.list);
            },
            child: Padding(
              padding: const EdgeInsets.all(8),
              child: MyImage(
                width: 20,
                height: 20,
                imagePath: "ic_list.png",
                color: videoByIdViewAllProvider.layoutType == Constant.list
                    ? colorPrimary
                    : gray,
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget buildVideoById() {
    if (videoByIdViewAllProvider.loading &&
        !videoByIdViewAllProvider.loadmore) {
      return buildShimmer();
    } else {
      if (videoByIdViewAllProvider.getCourseList != null &&
          (videoByIdViewAllProvider.getCourseList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          controller: _scrollController,
          physics: const AlwaysScrollableScrollPhysics(),
          child: MediaQuery.removePadding(
            context: context,
            removeTop: true,
            child: ResponsiveGridList(
              minItemWidth: 120,
              minItemsPerRow: itemCount(),
              maxItemsPerRow: itemCount(),
              horizontalGridSpacing: 5,
              verticalGridSpacing: 10,
              verticalGridMargin: 10,
              horizontalGridMargin: 15,
              listViewBuilderOptions: ListViewBuilderOptions(
                scrollDirection: Axis.vertical,
                shrinkWrap: true,
                physics: const NeverScrollableScrollPhysics(),
              ),
              children: List.generate(
                  videoByIdViewAllProvider.getCourseList?.length ?? 0, (index) {
                return buildVideoByIdLayout(index);
              }),
            ),
          ),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget buildVideoByIdLayout(int index) {
    if (videoByIdViewAllProvider.layoutType == Constant.grid) {
      return bigPortraitVideoById(
          index: index,
          courseList: videoByIdViewAllProvider.getCourseList ?? []);
    } else if (videoByIdViewAllProvider.layoutType == Constant.square) {
      return squareVideoById(
          index: index,
          courseList: videoByIdViewAllProvider.getCourseList ?? []);
    } else {
      return listViewVideoById(
          index: index,
          courseList: videoByIdViewAllProvider.getCourseList ?? []);
    }
  }

/* Category And Language Layouts Start */

  /* ListView */
  Widget listViewVideoById(
      {required int index, required List<videobyid.Result>? courseList}) {
    return InkWell(
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return Detail(courseId: courseList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        });
      },
      child: Container(
        width: MediaQuery.sizeOf(context).width,
        margin: EdgeInsets.only(bottom: 15),
        decoration: BoxDecoration(
            border: Border.all(
                width: 1,
                color: gray.withValues(alpha: .4),
                style: BorderStyle.solid),
            boxShadow: [
              BoxShadow(
                  blurRadius: 4,
                  blurStyle: BlurStyle.solid,
                  color: transparent.withValues(alpha: .3),
                  offset: Offset(0, 0),
                  spreadRadius: 0)
            ],
            color: white,
            borderRadius: BorderRadius.circular(5)),
        child: Row(
          children: [
            Container(
              width: 115,
              height: 100,
              decoration: BoxDecoration(
                  image: DecorationImage(
                      image: NetworkImage(
                          courseList?[index].landscapeImg.toString() ?? ""),
                      fit: BoxFit.fill),
                  border: Border(
                    right: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .4),
                        style: BorderStyle.solid),
                  ),
                  boxShadow: [
                    BoxShadow(
                        blurRadius: 4,
                        blurStyle: BlurStyle.solid,
                        color: transparent.withValues(alpha: .2),
                        offset: Offset(0, 0),
                        spreadRadius: 0)
                  ],
                  borderRadius: const BorderRadius.only(
                      bottomLeft: Radius.circular(5),
                      topLeft: Radius.circular(5))),
            ),
            const SizedBox(width: 10),
            Expanded(
              child: Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: courseList?[index].title.toString() ?? "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(
                              courseList?[index].totalView.toString() ?? "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(
                            courseList?[index].avgRating.toString() ?? ""),
                        spacing: 2,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(courseList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (courseList?[index].isFree.toString() ?? "") == "0"
                          ? "${Constant.currencyCode} ${courseList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w500,
                      maxline: 1,
                      multilanguage: false,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }

  /* Square */
  Widget squareVideoById(
      {required int index, required List<videobyid.Result>? courseList}) {
    return InkWell(
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return Detail(courseId: courseList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        });
      },
      child: Column(
        spacing: 4,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          MyNetworkImage(
              imgWidth: MediaQuery.sizeOf(context).width,
              imgHeight: 170,
              radius: 20,
              fit: BoxFit.fill,
              islandscap: true,
              imageUrl: courseList?[index].thumbnailImg.toString() ?? ""),
          MyText(
              color: Theme.of(context).colorScheme.surface,
              text: courseList?[index].title.toString() ?? "",
              fontsizeNormal: Dimens.textBigSmall,
              fontwaight: FontWeight.w600,
              maxline: 2,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          MyText(
              color: gray,
              text:
                  "${Utils.kmbGenerator(int.parse(courseList?[index].totalView.toString() ?? ""))} ${Locales.string(context, "students")}",
              fontsizeNormal: Dimens.textSmall,
              fontwaight: FontWeight.w500,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          Row(
            children: [
              MyRating(
                size: 13,
                rating:
                    double.parse(courseList?[index].avgRating.toString() ?? ""),
                spacing: 2,
              ),
              const SizedBox(width: 5),
              MyText(
                  color: colorAccent,
                  text:
                      "${double.parse(courseList?[index].avgRating.toString() ?? "")}",
                  fontsizeNormal: Dimens.textBigSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 2,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ],
          ),
          MyText(
              color: black,
              text: (courseList?[index].isFree.toString() ?? "") == "0"
                  ? "${Constant.currencyCode} ${courseList?[index].price.toString() ?? ""}"
                  : Locales.string(context, "free"),
              fontsizeNormal: Dimens.textSmall,
              fontwaight: FontWeight.w500,
              maxline: 1,
              multilanguage: false,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
        ],
      ),
    );
  }

  /* Big Portrait */
  Widget bigPortraitVideoById(
      {required int index, required List<videobyid.Result>? courseList}) {
    return InkWell(
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return Detail(courseId: courseList?[index].id.toString() ?? "");
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        });
      },
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 4,
        children: [
          MyNetworkImage(
              imgWidth: MediaQuery.sizeOf(context).width,
              imgHeight: 110,
              radius: 20,
              fit: BoxFit.fill,
              islandscap: true,
              imageUrl: courseList?[index].thumbnailImg.toString() ?? ""),
          MyText(
              color: Theme.of(context).colorScheme.surface,
              text: courseList?[index].title.toString() ?? "",
              fontsizeNormal: Dimens.textBigSmall,
              fontwaight: FontWeight.w600,
              maxline: 2,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          MyText(
              color: gray,
              text:
                  "${Utils.kmbGenerator(int.parse(courseList?[index].totalView.toString() ?? ""))} ${Locales.string(context, "students")}",
              fontsizeNormal: Dimens.textSmall,
              fontwaight: FontWeight.w500,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
          Row(
            children: [
              MyRating(
                size: 13,
                rating:
                    double.parse(courseList?[index].avgRating.toString() ?? ""),
                spacing: 2,
              ),
              const SizedBox(width: 5),
              MyText(
                  color: colorAccent,
                  text:
                      "${double.parse(courseList?[index].avgRating.toString() ?? "")}",
                  fontsizeNormal: Dimens.textBigSmall,
                  fontwaight: FontWeight.w600,
                  maxline: 2,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ],
          ),
          MyText(
              color: black,
              text: (courseList?[index].isFree.toString() ?? "") == "0"
                  ? "${Constant.currencyCode} ${courseList?[index].price.toString() ?? ""}"
                  : Locales.string(context, "free"),
              fontsizeNormal: Dimens.textSmall,
              fontwaight: FontWeight.w500,
              maxline: 1,
              multilanguage: false,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
        ],
      ),
    );
  }

/* Category And Language Layouts End */

/* Shimmer Widget */
  Widget buildShimmer() {
    return Padding(
      padding: const EdgeInsets.all(15),
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: itemCount(),
        maxItemsPerRow: itemCount(),
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return Container(
            width: 200,
            margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
            child: Column(
              children: [
                CustomWidget.rectangular(
                  width: MediaQuery.sizeOf(context).width,
                  height: 110,
                ),
                const SizedBox(height: 8),
                Expanded(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CustomWidget.rectangular(
                        width: MediaQuery.sizeOf(context).width,
                        height: 5,
                      ),
                      CustomWidget.rectangular(
                        width: MediaQuery.sizeOf(context).width,
                        height: 5,
                      ),
                      CustomWidget.rectangular(
                        width: MediaQuery.sizeOf(context).width,
                        height: 5,
                      ),
                      CustomWidget.rectangular(
                        width: MediaQuery.sizeOf(context).width,
                        height: 5,
                      ),
                    ],
                  ),
                ),
              ],
            ),
          );
        }),
      ),
    );
  }

  /* Item Count */
  int itemCount() {
    if (videoByIdViewAllProvider.layoutType == Constant.grid) {
      return 2;
    } else if (videoByIdViewAllProvider.layoutType == Constant.square) {
      return 1;
    } else {
      return 1;
    }
  }
}
