import 'dart:async';
import 'dart:io';
import 'package:cloud_firestore/cloud_firestore.dart';
import 'package:prakah/pages/bottombar.dart';
import 'package:prakah/pages/editprofile.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/firebaseconstant.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:firebase_auth/firebase_auth.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:pinput/pinput.dart';
import 'package:provider/provider.dart';

class VerifyOtp extends StatefulWidget {
  final String fullnumber, number, countrycode, countryName;
  const VerifyOtp({
    super.key,
    required this.fullnumber,
    required this.number,
    required this.countrycode,
    required this.countryName,
  });

  @override
  State<VerifyOtp> createState() => _VerifyOtpState();
}

class _VerifyOtpState extends State<VerifyOtp> {
  late GeneralProvider generalProvider;
  final FirebaseAuth _auth = FirebaseAuth.instance;
  final otpController = TextEditingController();

  int? forceResendingToken;
  String? verificationId;
  String? strDeviceType, strDeviceToken;
  Timer? _resendTimer;
  int secondsRemaining = 30;
  bool canResend = false;

  @override
  void initState() {
    super.initState();
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    _getDeviceToken();
    codeSend();
    _startTimer();
  }

  void _startTimer() {
    _resendTimer?.cancel();
    secondsRemaining = 30;
    canResend = false;

    _resendTimer = Timer.periodic(const Duration(seconds: 1), (timer) {
      if (secondsRemaining == 0) {
        timer.cancel();
        setState(() {
          canResend = true;
        });
      } else {
        setState(() {
          secondsRemaining--;
        });
      }
    });
  }

  String formatTime(int seconds) {
    int minutes = seconds ~/ 60; // Calculate minutes
    int remainingSeconds = seconds % 60; // Calculate remaining seconds
    return '$minutes:${remainingSeconds.toString().padLeft(2, '0')}'; // Format as MM:SS
  }

  Future<void> _getDeviceToken() async {
    try {
      if (Platform.isAndroid) {
        strDeviceType = "1";
      } else {
        strDeviceType = "2";
      }
      strDeviceToken = await FirebaseMessaging.instance.getToken();
    } catch (e) {
      printLog("_getDeviceToken Exception ===> $e");
    }
  }

  @override
  void dispose() {
    _resendTimer?.cancel(); // Clean up the timer when the widget is disposed
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          image: DecorationImage(
              image: AssetImage("assets/images/login_bg.png"),
              fit: BoxFit.fill)),
      child: Scaffold(
        backgroundColor: transparent,
        appBar: AppBar(
          backgroundColor: transparent,
          systemOverlayStyle: SystemUiOverlayStyle(
            statusBarColor: transparent,
            systemNavigationBarColor: transparent,
          ),
          leading: InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              Navigator.of(context).pop();
            },
            child: const Icon(
              Icons.arrow_back_outlined,
              size: 20,
              color: white,
            ),
          ),
        ),
        body: Container(
          height: MediaQuery.sizeOf(context).height,
          width: MediaQuery.sizeOf(context).width,
          margin: EdgeInsets.only(top: 120),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(30), topRight: Radius.circular(30))),
          child: SingleChildScrollView(
            scrollDirection: Axis.vertical,
            physics: const BouncingScrollPhysics(),
            padding: EdgeInsets.fromLTRB(15, 40, 15, 30),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                    color: colorPrimaryDark,
                    text: "otpverification",
                    fontsizeNormal: Dimens.textExtraBig,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    multilanguage: true,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 6),
                MyText(
                    color: colorPrimaryDark,
                    text: "enterotpcodetosenttomobilenumber",
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w400,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal,
                    multilanguage: true),
                const SizedBox(height: 30),
                otpTextField(),
                const SizedBox(height: 20),
                resendotp(),
                const SizedBox(height: 15),
                verifyotp(),
                const SizedBox(height: 40),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget otpTextField() {
    return Padding(
      padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
      child: Pinput(
        length: 6,
        keyboardType: TextInputType.number,
        controller: otpController,
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        followingPinTheme: PinTheme(
            width: 50,
            height: 50,
            decoration: BoxDecoration(
              border: Border.all(color: colorPrimaryDark, width: 1),
              shape: BoxShape.rectangle,
              color: transparent,
              borderRadius: BorderRadius.circular(5),
            )),
        defaultPinTheme: PinTheme(
          width: 50,
          height: 50,
          decoration: BoxDecoration(
            shape: BoxShape.rectangle,
            border: Border.all(width: 1, color: colorPrimaryDark),
            borderRadius: BorderRadius.circular(5),
          ),
          textStyle: GoogleFonts.inter(
            color: black,
            fontSize: Dimens.textlargeBig,
            fontStyle: FontStyle.normal,
            fontWeight: FontWeight.w500,
          ),
        ),
      ),
    );
  }

  Widget resendotp() {
    return Align(
      alignment: Alignment.center,
      child: InkWell(
        borderRadius: BorderRadius.circular(50),
        onTap: canResend
            ? () {
                codeSend(); // Resend OTP
                _startTimer(); // Restart timer
              }
            : null, // Disable tap when waiting
        child: Padding(
          padding: const EdgeInsets.all(20),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.center,
            spacing: 10,
            children: [
              MyText(
                  color: colorAccent,
                  text: "resend",
                  fontsizeNormal: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal,
                  multilanguage: true),
              MyText(
                color: colorAccent,
                text: formatTime(secondsRemaining),
                maxline: 1,
                fontsizeNormal: Dimens.textTitle,
                fontwaight: FontWeight.w700,
                fontstyle: FontStyle.normal,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
              )
            ],
          ),
        ),
      ),
    );
  }

  Widget verifyotp() {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      return InkWell(
        onTap: () {
          if (otpController.text.toString().isEmpty) {
            Utils.showSnackbar(context, "info", "enterreceivedotp", true);
          } else {
            if (verificationId == null || verificationId == "") {
              Utils.showSnackbar(context, "info", "otp_not_working", true);
              return;
            }
            generalProvider.setLoading(true);
            _checkOTPAndLogin();
          }
        },
        child: AnimatedContainer(
          duration: const Duration(milliseconds: 80),
          clipBehavior: Clip.antiAliasWithSaveLayer,
          curve: Curves.bounceInOut,
          width: generalProvider.isProgressLoading
              ? 100
              : MediaQuery.of(context).size.width,
          height: 45,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            color: colorPrimaryDark,
            borderRadius: BorderRadius.circular(10),
          ),
          child: generalProvider.isProgressLoading
              ? const SizedBox(
                  width: 25,
                  height: 25,
                  child: CircularProgressIndicator(
                    color: white,
                    strokeWidth: 2,
                  ),
                )
              : MyText(
                  color: white,
                  text: "verifyandproceed",
                  fontsizeNormal: 16,
                  fontwaight: FontWeight.w600,
                  maxline: 1,
                  multilanguage: true,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.center,
                  fontstyle: FontStyle.normal,
                ),
        ),
      );
    });
  }

/* ====================== Send OTP Start ========================== */
  Future<void> codeSend() async {
    await phoneSignIn(phoneNumber: widget.fullnumber);
  }

  Future<void> phoneSignIn({required String phoneNumber}) async {
    await _auth.verifyPhoneNumber(
      phoneNumber: phoneNumber,
      verificationCompleted: _onVerificationCompleted,
      verificationFailed: _onVerificationFailed,
      codeSent: _onCodeSent,
      codeAutoRetrievalTimeout: _onCodeTimeout,
      forceResendingToken: forceResendingToken, // ✅ pass for resend
    );
  }

  Future<void> _onVerificationCompleted(
      PhoneAuthCredential authCredential) async {
    User? user = FirebaseAuth.instance.currentUser;
    setState(() {
      otpController.text = authCredential.smsCode!;
    });
    if (authCredential.smsCode != null) {
      try {
        UserCredential? credential =
            await user?.linkWithCredential(authCredential);
        printLog(
            "_onVerificationCompleted credential =====> ${credential?.user?.phoneNumber ?? ""}");
      } on FirebaseAuthException catch (e) {
        if (e.code == 'provider-already-linked') {
          await _auth.signInWithCredential(authCredential);
        }
      }
    }
  }

  void _onVerificationFailed(FirebaseAuthException exception) {
    if (exception.code == 'invalid-phone-number') {
      Utils.showSnackbar(context, "fail", "invalidphonenumber", true);
    }
  }

  void _onCodeSent(String verificationId, int? forceResendingToken) {
    this.verificationId = verificationId;
    this.forceResendingToken = forceResendingToken;

    _startTimer(); // ✅ start timer here

    if (!mounted) return;
    setState(() {});
  }

  dynamic _onCodeTimeout(String verificationId) {
    this.verificationId = verificationId;
    generalProvider.setLoading(false);
    return null;
  }

/* ====================== Send OTP End ========================== */

  Future<void> _checkOTPAndLogin() async {
    bool error = false;
    UserCredential? userCredential;

    printLog("_checkOTPAndLogin verificationId =====> $verificationId");
    // Create a PhoneAuthCredential with the code
    PhoneAuthCredential? phoneAuthCredential = PhoneAuthProvider.credential(
      verificationId: verificationId ?? "",
      smsCode: otpController.text.toString(),
    );
    try {
      userCredential = await _auth.signInWithCredential(phoneAuthCredential);
    } on FirebaseAuthException catch (e) {
      generalProvider.setLoading(false);
      if (e.code == 'invalid-verification-code' ||
          e.code == 'invalid-verification-id') {
        if (!mounted) return;
        Utils.showSnackbar(context, "", "otp_invalid", true);
        return;
      } else if (e.code == 'session-expired') {
        if (!mounted) return;
        Utils.showSnackbar(context, "", "otp_session_expired", false);
        return;
      } else {
        error = true;
      }
    }
    if (!error && userCredential != null) {
      loginApi(widget.number.toString(), "1",
          userCredential.user?.uid.toString() ?? "");
    } else {
      if (!mounted) return;
      Utils().hideProgress(context);
      Utils.showSnackbar(context, "", "otp_login_fail", true);
    }
  }

  Future<void> loginApi(String number, String type, firebaseId) async {
    generalProvider.setLoading(true);
    try {
      await generalProvider.getOtpLogin(
        type,
        widget.countrycode,
        number,
        widget.countryName,
        strDeviceType ?? "",
        strDeviceToken ?? "",
      );

      if (generalProvider.loginmodel.status == 200) {
        Utils.saveUserCreds(
          userID: generalProvider.loginmodel.result?[0].id.toString(),
          userName:
              generalProvider.loginmodel.result?[0].userName.toString() ?? "",
          fullName:
              generalProvider.loginmodel.result?[0].fullName.toString() ?? "",
          email: generalProvider.loginmodel.result?[0].email.toString() ?? "",
          mobileNumber:
              generalProvider.loginmodel.result?[0].mobileNumber.toString() ??
                  "",
          image: generalProvider.loginmodel.result?[0].image.toString() ?? "",
          deviceType:
              generalProvider.loginmodel.result?[0].deviceType.toString() ?? "",
          deviceToken:
              generalProvider.loginmodel.result?[0].deviceToken.toString() ??
                  "",
          userIsBuy:
              generalProvider.loginmodel.result?[0].isBuy.toString() ?? "",
          type: generalProvider.loginmodel.result?[0].type.toString() ?? "",
        );
        generalProvider.setLoading(false);

        /* Initialize Hive */
        await Utils.initializeHiveBoxes();

        /* email and mobile and name is empty open the edit profie */
        if (type == "4") {
          await SharedPre().save("edit", "1");
          if (!mounted) return;
          Utils.navigatePage(context, Bottombar(), '');
        } else if (generalProvider.loginmodel.result?[0].fullName.toString() ==
                "" ||
            generalProvider.loginmodel.result?[0].email.toString() == "" ||
            generalProvider.loginmodel.result?[0].mobileNumber.toString() ==
                "") {
          await SharedPre().save("edit", "0");
          if (!mounted) return;
          Utils.navigatePage(context, EditProfile(editType: "2"), '');
        } else {
          await SharedPre().save("edit", "1");
          if (!mounted) return;
          Utils.navigatePage(context, Bottombar(), '');
        }
      } else {
        generalProvider.setLoading(false);
        if (!mounted) return;
        Utils.showSnackbar(
            context, "fail", generalProvider.loginmodel.message ?? "", false);
      }
    } catch (e) {
      generalProvider.setLoading(false);
      printLog(e.toString());
      if (!mounted) return;
      Utils.showSnackbar(
          context, "fail", generalProvider.loginmodel.message ?? "", false);
    }
  }

  void updateDataInFirestore({required String firebasedid}) {
    printLog('strDeviceToken ....==>> $strDeviceToken');
    printLog('firebasedid ....==>> $firebasedid');
    // Update data to Firestore
    FirebaseFirestore.instance
        .collection(FirestoreConstants.pathUserCollection)
        .doc(firebasedid)
        .update({FirestoreConstants.deviceToken: strDeviceToken})
        .then((value) => printLog("User Updated"))
        .onError((error, stackTrace) {
          printLog("updateDataFirestore error ===> ${error.toString()}");
          printLog(
              "updateDataFirestore stackTrace ===> ${stackTrace.toString()}");
        });
  }
}
