import 'package:prakah/pages/blogdetail.dart';
import 'package:prakah/pages/detail.dart';
import 'package:prakah/pages/ebookdetails.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/tutorprofileprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class TutorProfilePage extends StatefulWidget {
  final String tutorid;
  const TutorProfilePage({super.key, required this.tutorid});

  @override
  State<TutorProfilePage> createState() => TutorProfilePageState();
}

class TutorProfilePageState extends State<TutorProfilePage> {
  late TutorProfileProvider tutorProvider;
  late ScrollController _scrollController;
  double? height;
  double? width;

  @override
  void initState() {
    super.initState();
    tutorProvider = Provider.of<TutorProfileProvider>(context, listen: false);
    _scrollController = ScrollController();
    _scrollController.addListener(_scrollListener);

    getApi();
  }

  Future<void> getApi() async {
    await Future.wait([
      tutorProvider.getTutorprofile(widget.tutorid),
      _fetchData("1", 0),
    ]);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (tutorProvider.currentPage ?? 0) < (tutorProvider.totalPage ?? 0)) {
      tutorProvider.setLoadMore(true);
      if (tutorProvider.layoutType == Constant.blogType) {
        _fetchData("1", tutorProvider.currentPage ?? 0);
      } else if (tutorProvider.layoutType == Constant.bookType) {
        _fetchData("2", tutorProvider.currentPage ?? 0);
      } else {
        _fetchData("3", tutorProvider.currentPage ?? 0);
      }
    }
  }

  Future<void> _fetchData(String type, int? nextPage) async {
    await tutorProvider.getContentByTutor(
        type, widget.tutorid, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();

    tutorProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    height = MediaQuery.of(context).size.height;
    width = MediaQuery.of(context).size.width;
    return Stack(
      children: [
        Scaffold(
          appBar: Utils.myAppBarWithBack(
              editType: "1",
              context: context,
              appBarTitle: "tutorprofile",
              multilanguage: true),
          body: Consumer<TutorProfileProvider>(
              builder: (context, tutorProvider, child) {
            return Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 10,
              children: [
                tutorAbout(),
                tabButton(),
                Expanded(child: setLayout()),
              ],
            );
          }),
        ),
        /* AdMob Banner */
        Utils.showBannerAd(context),
      ],
    );
  }

  Widget tutorAbout() {
    if (tutorProvider.loading) {
      return tutorAboutShimmer();
    } else {
      if (tutorProvider.tutorprofilemodel.status == 200 &&
          (tutorProvider.tutorprofilemodel.result?.length ?? 0) > 0) {
        return Container(
          width: MediaQuery.of(context).size.width,
          color: colorPrimaryDark,
          padding: const EdgeInsets.fromLTRB(20, 15, 20, 15),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Container(
                    padding: EdgeInsets.all(4),
                    decoration: BoxDecoration(
                      border: Border.all(
                          color: colorAccent,
                          width: 2,
                          style: BorderStyle.solid),
                      borderRadius: BorderRadius.circular(50),
                    ),
                    child: MyNetworkImage(
                        radius: 50,
                        imageUrl: tutorProvider
                                .tutorprofilemodel.result?[0].image
                                .toString() ??
                            "",
                        fit: BoxFit.cover,
                        imgHeight: 80,
                        imgWidth: 80),
                  ),
                  const SizedBox(width: 15),
                  Expanded(
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        tutorAllCountsItem(
                          title: "Blog",
                          count: Utils.kmbGenerator(tutorProvider
                                  .tutorprofilemodel.result?[0].totalBlog ??
                              0),
                        ),
                        tutorAllCountsItem(
                          title: "Book",
                          count: Utils.kmbGenerator(tutorProvider
                                  .tutorprofilemodel.result?[0].totalBook ??
                              0),
                        ),
                        tutorAllCountsItem(
                          title: "Course",
                          count: Utils.kmbGenerator(tutorProvider
                                  .tutorprofilemodel.result?[0].totalCourse ??
                              0),
                        ),
                      ],
                    ),
                  ),
                ],
              ),
              const SizedBox(height: 15),
              MyText(
                  color: white,
                  text: tutorProvider.tutorprofilemodel.result?[0].fullName
                          .toString() ??
                      "",
                  maxline: 2,
                  fontwaight: FontWeight.w700,
                  fontsizeNormal: Dimens.textTitle,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
              const SizedBox(height: 5),
              MyText(
                  color: white,
                  text: tutorProvider.tutorprofilemodel.result?[0].email
                          .toString() ??
                      "",
                  maxline: 2,
                  fontwaight: FontWeight.w500,
                  fontsizeNormal: Dimens.textMedium,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ],
          ),
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget tutorAboutShimmer() {
    return Container(
      width: MediaQuery.of(context).size.width,
      color: colorPrimary,
      padding: const EdgeInsets.fromLTRB(20, 15, 20, 15),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              Container(
                padding: EdgeInsets.all(4),
                decoration: BoxDecoration(
                  border: Border.all(
                      color: colorAccent, width: 2, style: BorderStyle.solid),
                  borderRadius: BorderRadius.circular(50),
                ),
                child: CustomWidget.circular(height: 80, width: 80),
              ),
              const SizedBox(width: 15),
              Expanded(
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    CustomWidget.roundcorner(height: 20, width: 50),
                    CustomWidget.roundcorner(height: 20, width: 50),
                    CustomWidget.roundcorner(height: 20, width: 50),
                  ],
                ),
              ),
            ],
          ),
          const SizedBox(height: 15),
          CustomWidget.roundcorner(height: 14, width: 250),
          SizedBox(height: 5),
          CustomWidget.roundcorner(height: 14, width: 200)
        ],
      ),
    );
  }

  Widget tabButton() {
    return Container(
      width: MediaQuery.of(context).size.width,
      alignment: Alignment.centerRight,
      margin: const EdgeInsets.fromLTRB(20, 0, 20, 0),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(14),
        color: colorPrimary.withValues(alpha: 0.18),
      ),
      child: Row(
        spacing: 15,
        children: [
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () {
                tutorProvider.selectLayout(Constant.blogType);
                tutorProvider.clearContent();
                tutorProvider.setLoading(false);
                _fetchData("1", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: tutorProvider.layoutType == Constant.blogType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: tutorProvider.layoutType == Constant.blogType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "blog",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () {
                tutorProvider.selectLayout(Constant.bookType);
                tutorProvider.clearContent();
                _fetchData("2", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: tutorProvider.layoutType == Constant.bookType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: tutorProvider.layoutType == Constant.bookType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "book",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () {
                tutorProvider.selectLayout(Constant.courseType);
                tutorProvider.clearContent();
                _fetchData("3", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: tutorProvider.layoutType == Constant.courseType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: tutorProvider.layoutType == Constant.courseType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "course",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget setLayout() {
    if (tutorProvider.tutorContentLoading && !tutorProvider.loadMore) {
      return Padding(
        padding: EdgeInsets.fromLTRB(15, 0, 15, 10),
        child: (tutorProvider.layoutType == Constant.blogType)
            ? blogShimmer()
            : (tutorProvider.layoutType == Constant.bookType)
                ? bookShimmer()
                : courseShimmer(),
      );
    } else {
      if (tutorProvider.courseList != null &&
          (tutorProvider.courseList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          scrollDirection: Axis.vertical,
          controller: _scrollController,
          padding: EdgeInsets.fromLTRB(15, 0, 15, 60),
          physics: const AlwaysScrollableScrollPhysics(),
          child: (tutorProvider.layoutType == Constant.blogType)
              ? buildBlogItem()
              : (tutorProvider.layoutType == Constant.bookType)
                  ? buildBookItem()
                  : courseItem(),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget courseItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 2,
          maxItemsPerRow: 2,
          horizontalGridSpacing: 5,
          verticalGridSpacing: 5,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
          ),
          children:
              List.generate(tutorProvider.courseList?.length ?? 0, (index) {
            return InkWell(
              onTap: () {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      transitionDuration: const Duration(milliseconds: 200),
                      pageBuilder: (BuildContext context,
                          Animation<double> animation,
                          Animation<double> secondaryAnimation) {
                        return Detail(
                            courseId: tutorProvider.courseList?[index].id
                                    .toString() ??
                                "");
                      },
                      transitionsBuilder: (BuildContext context,
                          Animation<double> animation,
                          Animation<double> secondaryAnimation,
                          Widget child) {
                        return Align(
                          child: FadeTransition(
                            opacity: animation,
                            child: child,
                          ),
                        );
                      },
                    ),
                  );
                });
              },
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          imgWidth: MediaQuery.sizeOf(context).width,
                          imgHeight: 110,
                          fit: BoxFit.fill,
                          radius: 10,
                          islandscap: true,
                          imageUrl: tutorProvider
                                  .courseList?[index].thumbnailImg
                                  .toString() ??
                              ""),
                      Positioned(
                        top: 5,
                        right: 10,
                        child: Container(
                          padding: EdgeInsets.all(5),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: black.withValues(alpha: 0.4)),
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () async {
                              if (Utils.checkLoginUser(context)) {
                                await tutorProvider.addRemoveWishlist(
                                  index,
                                  "3",
                                  tutorProvider.courseList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Icon(
                              tutorProvider.courseList?[index].isWishlist == 1
                                  ? Icons.favorite
                                  : Icons.favorite_border,
                              color:
                                  tutorProvider.courseList?[index].isWishlist ==
                                          1
                                      ? red
                                      : white,
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: tutorProvider.courseList?[index].title.toString() ??
                          "",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(tutorProvider
                                  .courseList?[index].totalView
                                  .toString() ??
                              "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  Row(
                    children: [
                      MyRating(
                        size: 15,
                        rating: double.parse(tutorProvider
                                .courseList?[index].avgRating
                                .toString() ??
                            ""),
                        spacing: 2,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(tutorProvider.courseList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (tutorProvider.courseList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${tutorProvider.courseList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            );
          })),
    );
  }

  Widget buildBookItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: 3,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(tutorProvider.courseList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        EbookDetails(
                      ebookId:
                          tutorProvider.courseList?[index].id.toString() ?? "",
                      ebookName:
                          tutorProvider.courseList?[index].title.toString() ??
                              "",
                    ),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            },
            child: SizedBox(
              width: 150,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          radius: 5,
                          imgWidth: width,
                          imgHeight: 155,
                          imageUrl: tutorProvider
                                  .courseList?[index].thumbnailImg
                                  .toString() ??
                              "",
                          fit: BoxFit.cover),
                      Positioned(
                        top: 10,
                        right: 10,
                        child: Container(
                          padding: EdgeInsets.all(5),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: black.withValues(alpha: 0.4)),
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () async {
                              if (Utils.checkLoginUser(context)) {
                                await tutorProvider.addRemoveWishlist(
                                  index,
                                  "2",
                                  tutorProvider.courseList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Icon(
                              tutorProvider.courseList?[index].isWishlist == 1
                                  ? Icons.favorite
                                  : Icons.favorite_border,
                              color:
                                  tutorProvider.courseList?[index].isWishlist ==
                                          1
                                      ? red
                                      : white,
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  const SizedBox(height: 10),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: tutorProvider.courseList?[index].title.toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  MyText(
                      color: gray,
                      text: tutorProvider.courseList?[index].tutorName
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(
                          tutorProvider.courseList?[index].avgRating
                                  .toString() ??
                              "",
                        ),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text: "${double.parse(
                            tutorProvider.courseList?[index].avgRating
                                    .toString() ??
                                "",
                          )}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (tutorProvider.courseList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${tutorProvider.courseList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          );
        }),
      ),
    );
  }

/* Blog Data */

  Widget buildBlogItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(tutorProvider.courseList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        BlogDetail(
                      blogId:
                          tutorProvider.courseList?[index].id.toString() ?? "",
                    ),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            },
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                Stack(
                  children: [
                    MyNetworkImage(
                        radius: 10,
                        imgWidth: width,
                        imgHeight: 170,
                        imageUrl:
                            tutorProvider.courseList?[index].image.toString() ??
                                "",
                        fit: BoxFit.fill),
                    Positioned(
                      top: 10,
                      right: 10,
                      child: Container(
                        padding: EdgeInsets.all(5),
                        decoration: BoxDecoration(
                            shape: BoxShape.circle,
                            color: black.withValues(alpha: 0.4)),
                        child: InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          onTap: () async {
                            if (Utils.checkLoginUser(context)) {
                              await tutorProvider.addRemoveWishlist(
                                index,
                                "1",
                                tutorProvider.courseList?[index].id
                                        .toString() ??
                                    "",
                              );
                            }
                          },
                          child: Icon(
                            tutorProvider.courseList?[index].isWishlist == 1
                                ? Icons.favorite
                                : Icons.favorite_border,
                            color:
                                tutorProvider.courseList?[index].isWishlist == 1
                                    ? red
                                    : white,
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text:
                        tutorProvider.courseList?[index].title.toString() ?? "",
                    fontsizeNormal: Dimens.textBig,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                MyText(
                    color: gray,
                    text:
                        tutorProvider.courseList?[index].tutorName.toString() ??
                            "",
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget courseShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 2,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(
          10,
          (index) {
            return Container(
              width: 200,
              margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.rectangular(
                    width: MediaQuery.sizeOf(context).width,
                    height: 110,
                  ),
                  const SizedBox(height: 8),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  Widget bookShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: 3,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return SizedBox(
            width: 140,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                CustomWidget.roundrectborder(
                  width: width ?? 0,
                  height: 155,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget blogShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 4,
            children: [
              Stack(
                children: [
                  CustomWidget.roundcorner(width: width ?? 0, height: 155),
                  Positioned.fill(
                    top: 5,
                    left: 10,
                    right: 10,
                    child: Align(
                      alignment: Alignment.topRight,
                      child: CustomWidget.circular(width: 30, height: 30),
                    ),
                  ),
                ],
              ),
              CustomWidget.roundcorner(width: width ?? 0.0, height: 16),
              CustomWidget.roundcorner(width: (width ?? 0.0) * 0.5, height: 14),
            ],
          );
        }),
      ),
    );
  }

  Widget tutorAllCountsItem({required dynamic count, required title}) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        MyText(
            color: white,
            text: Utils.kmbGenerator(int.parse(count.toString())),
            maxline: 2,
            fontwaight: FontWeight.w600,
            fontsizeNormal: Dimens.textTitle,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
        MyText(
            color: white,
            text: title,
            maxline: 2,
            multilanguage: false,
            fontwaight: FontWeight.w500,
            fontsizeNormal: Dimens.textMedium,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
      ],
    );
  }
}
