import 'package:prakah/model/transcationlistmodel.dart' as payment;
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/transcationlistprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class TranscationList extends StatefulWidget {
  const TranscationList({super.key});

  @override
  State<TranscationList> createState() => _TranscationListState();
}

class _TranscationListState extends State<TranscationList> {
  TransactionListProvider transactionListProvider = TransactionListProvider();
  ScrollController scrollController = ScrollController();
  @override
  void initState() {
    super.initState();
    transactionListProvider =
        Provider.of<TransactionListProvider>(context, listen: false);

    scrollController.addListener(_scrollListener);

    getApiData("1", 0);
  }

  void _scrollListener() {
    if (!scrollController.hasClients) return;
    if (scrollController.offset >= scrollController.position.maxScrollExtent &&
        !scrollController.position.outOfRange &&
        (transactionListProvider.currentPage ?? 0) <
            (transactionListProvider.totalPage ?? 0)) {
      printLog("-----?? api call page 2 ");
      transactionListProvider.setLoadMore(true);

      getApiData(transactionListProvider.selectType ?? "",
          transactionListProvider.currentPage ?? 0);
    }
  }

  Future<void> getApiData(String type, pageno) async {
    await transactionListProvider.getSectionList(type, (pageno ?? 0) + 1);
  }

  @override
  void dispose() {
    scrollController.dispose();
    transactionListProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "my_transactions",
          multilanguage: true),
      body: Consumer<TransactionListProvider>(
          builder: (context, transactionListProvider, child) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 20,
          children: [
            tabButton(),
            Expanded(child: _buildMain()),
          ],
        );
      }),
    );
  }

  Widget tabButton() {
    return Container(
      width: MediaQuery.of(context).size.width,
      alignment: Alignment.centerRight,
      margin: const EdgeInsets.fromLTRB(14, 10, 14, 0),
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(14),
        color: colorPrimary.withValues(alpha: 0.18),
      ),
      child: SingleChildScrollView(
        scrollDirection: Axis.horizontal,
        child: Row(
          spacing: 15,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            _buildTab(
              title: "package",
              count: "1",
              onTap: () {
                transactionListProvider.setType("1");
                transactionListProvider.clearContent();
                getApiData(transactionListProvider.selectType ?? "", 0);
              },
            ),
            _buildTab(
              title: "wallet",
              count: "2",
              onTap: () {
                transactionListProvider.setType("2");
                transactionListProvider.clearContent();
                getApiData(transactionListProvider.selectType ?? "", 0);
              },
            ),
            _buildTab(
              title: "live_classes",
              count: "3",
              onTap: () {
                transactionListProvider.setType("3");
                transactionListProvider.clearContent();
                getApiData(transactionListProvider.selectType ?? "", 0);
              },
            ),
            _buildTab(
              title: "books",
              count: "4",
              onTap: () {
                transactionListProvider.setType("4");
                transactionListProvider.clearContent();
                getApiData(transactionListProvider.selectType ?? "", 0);
              },
            ),
            _buildTab(
              title: "course",
              count: "5",
              onTap: () {
                transactionListProvider.setType("5");
                transactionListProvider.clearContent();
                getApiData(transactionListProvider.selectType ?? "", 0);
              },
            ),
            _buildTab(
              title: "meetings",
              count: "6",
              onTap: () {
                transactionListProvider.setType("6");
                transactionListProvider.clearContent();
                getApiData(transactionListProvider.selectType ?? "", 0);
              },
            ),
          ],
        ),
      ),
    );
  }

  Widget _buildTab({String? title, onTap, count}) {
    return InkWell(
      borderRadius: BorderRadius.circular(10),
      focusColor: transparent,
      highlightColor: transparent,
      hoverColor: transparent,
      splashColor: transparent,
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.all(10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: transactionListProvider.selectType == count
              ? colorPrimary
              : transparent,
        ),
        child: MyText(
            color: transactionListProvider.selectType == count
                ? white
                : Theme.of(context).colorScheme.surface,
            text: title ?? "",
            multilanguage: true,
            fontsizeNormal: Dimens.textSmall,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
      ),
    );
  }

/* Tab Data END */

  Widget _buildMain() {
    if (transactionListProvider.loading && !transactionListProvider.loadMore) {
      return shimmer();
    } else {
      if (transactionListProvider.histroyList != null &&
          (transactionListProvider.histroyList?.length ?? 0) > 0) {
        return SingleChildScrollView(
            controller: scrollController,
            padding: EdgeInsets.fromLTRB(14, 0, 14, 0),
            physics: const AlwaysScrollableScrollPhysics(),
            clipBehavior: Clip.antiAlias,
            child: Column(
              children: [
                transactionListProvider.selectType == "6"
                    ? _buildMeetingTr()
                    : transactionListProvider.selectType == "5"
                        ? _buildCourseTr()
                        : transactionListProvider.selectType == "4"
                            ? _buildBookTr()
                            : transactionListProvider.selectType == "3"
                                ? _buildLiveClassTr()
                                : _buildData(),
                const SizedBox(height: 10),
                if (transactionListProvider.loadMore)
                  Utils.pageLoader()
                else
                  const SizedBox.shrink(),
                const SizedBox(height: 30),
              ],
            ));
      } else {
        return const NoData();
      }
    }
  }

  Widget _buildData() {
    final transactions = transactionListProvider.histroyList ?? [];
    final groupedTransactions = _groupTransactionsByMonth(transactions);

    return ResponsiveGridList(
        minItemWidth: 400,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        verticalGridMargin: 0,
        horizontalGridMargin: 10,
        verticalGridSpacing: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          groupedTransactions.keys.length,
          (index) {
            final monthYear = groupedTransactions.keys.toList()[index];
            final transactionsInMonth = groupedTransactions[monthYear] ?? [];

            return Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                // Month Header
                Padding(
                  padding: const EdgeInsets.all(8.0),
                  child: MyText(
                    text: monthYear, // Display month and year
                    multilanguage: false,
                    fontsizeNormal: Dimens.textBig,
                    fontwaight: FontWeight.w600,
                    color: black,
                  ),
                ),
                // Transactions for the Month
                ...transactionsInMonth.map((trans) {
                  return Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      ListTile(
                        leading: MyText(
                          text: trans.id.toString(),
                          multilanguage: false,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          fontsizeNormal: Dimens.textMedium,
                          color: black,
                          fontwaight: FontWeight.w400,
                        ),
                        title: MyText(
                          text: "Trans_Id : ${trans.transactionId}",
                          multilanguage: false,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          fontsizeNormal: Dimens.textSmall,
                          color: gray,
                          fontwaight: FontWeight.w400,
                        ),
                        trailing: MyText(
                          text:
                              "${Constant.currencyCode} ${trans.price.toString()}",
                          multilanguage: false,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          fontsizeNormal: Dimens.textTitle,
                          color: black,
                          fontwaight: FontWeight.w400,
                        ),
                      ),
                      MyText(
                        text: DateFormat('d MMM yyyy, h:mm a')
                            .format(DateTime.parse(trans.updatedAt ?? "")),
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontsizeNormal: Dimens.textSmall,
                        color: gray,
                        fontwaight: FontWeight.w400,
                      ),
                    ],
                  );
                }),
              ],
            );
          },
        ));
  }

/* Live class Data */
  Widget _buildLiveClassTr() {
    final transactions = transactionListProvider.histroyList ?? [];
    final groupedTransactions = _groupTransactionsByMonth(transactions);

    return ResponsiveGridList(
        minItemWidth: 400,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        verticalGridMargin: 0,
        horizontalGridMargin: 10,
        verticalGridSpacing: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          groupedTransactions.keys.length,
          (index) {
            final monthYear = groupedTransactions.keys.toList()[index];
            final transactionsInMonth = groupedTransactions[monthYear] ?? [];

            return Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 10,
              children: [
                // Month Header
                MyText(
                  text: monthYear, // Display month and year
                  multilanguage: false,
                  fontsizeNormal: Dimens.textBig,
                  fontwaight: FontWeight.w600,
                  color: black,
                ),
                // Transactions for the Month
                ...transactionsInMonth.map((trans) {
                  return Column(
                    spacing: 10,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        spacing: 20,
                        children: [
                          MyText(
                            text: trans.id.toString(),
                            multilanguage: false,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            fontsizeNormal: Dimens.textBig,
                            color: black,
                            fontwaight: FontWeight.w400,
                          ),
                          Expanded(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                MyText(
                                  text: trans.liveClassTitle ?? "",
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textMedium,
                                  color: black,
                                  fontwaight: FontWeight.w400,
                                ),
                                MyText(
                                  text:
                                      "Tran Id :  ${trans.transactionId ?? ""}",
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textSmall,
                                  color: gray,
                                  fontwaight: FontWeight.w400,
                                ),
                              ],
                            ),
                          ),
                          MyText(
                            text:
                                "${Constant.currencyCode} ${trans.price.toString()}",
                            multilanguage: false,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            fontsizeNormal: Dimens.textBig,
                            color: black,
                            fontwaight: FontWeight.w600,
                          ),
                        ],
                      ),
                      MyText(
                        text: DateFormat('d MMM yyyy, h:mm a')
                            .format(DateTime.parse(trans.updatedAt ?? "")),
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontsizeNormal: Dimens.textSmall,
                        color: gray,
                        fontwaight: FontWeight.w400,
                      ),
                    ],
                  );
                }),
              ],
            );
          },
        ));
  }

/* Book Transaction Data Started */
  Widget _buildBookTr() {
    final transactions = transactionListProvider.histroyList ?? [];
    final groupedTransactions = _groupTransactionsByMonth(transactions);

    return ResponsiveGridList(
        minItemWidth: 400,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        verticalGridMargin: 0,
        horizontalGridMargin: 10,
        verticalGridSpacing: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          groupedTransactions.keys.length,
          (index) {
            final monthYear = groupedTransactions.keys.toList()[index];
            final transactionsInMonth = groupedTransactions[monthYear] ?? [];

            return Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 10,
              children: [
                // Month Header
                MyText(
                  text: monthYear, // Display month and year
                  multilanguage: false,
                  fontsizeNormal: Dimens.textBig,
                  fontwaight: FontWeight.w600,
                  color: black,
                ),
                // Transactions for the Month
                ...transactionsInMonth.map((trans) {
                  return Column(
                    spacing: 10,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        spacing: 20,
                        children: [
                          MyNetworkImage(
                              imgHeight: 50,
                              imgWidth: 50,
                              radius: 200,
                              imageUrl: trans.bookImage ?? "",
                              fit: BoxFit.cover),
                          Expanded(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                MyText(
                                  text: trans.bookName ?? "",
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textMedium,
                                  color: black,
                                  fontwaight: FontWeight.w400,
                                ),
                                MyText(
                                  text:
                                      "Tran Id :  ${trans.transactionId ?? ""}",
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textSmall,
                                  color: gray,
                                  fontwaight: FontWeight.w400,
                                ),
                              ],
                            ),
                          ),
                          MyText(
                            text:
                                "${Constant.currencyCode} ${trans.bookPrice.toString()}",
                            multilanguage: false,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            fontsizeNormal: Dimens.textBig,
                            color: black,
                            fontwaight: FontWeight.w600,
                          ),
                        ],
                      ),
                      MyText(
                        text: DateFormat('d MMM yyyy, h:mm a')
                            .format(DateTime.parse(trans.updatedAt ?? "")),
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontsizeNormal: Dimens.textSmall,
                        color: gray,
                        fontwaight: FontWeight.w400,
                      ),
                    ],
                  );
                }),
              ],
            );
          },
        ));
  }

/* Course transaction Data started */
  Widget _buildCourseTr() {
    final transactions = transactionListProvider.histroyList ?? [];
    final groupedTransactions = _groupTransactionsByMonth(transactions);

    return ResponsiveGridList(
        minItemWidth: 400,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        verticalGridMargin: 0,
        horizontalGridMargin: 10,
        verticalGridSpacing: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          groupedTransactions.keys.length,
          (index) {
            final monthYear = groupedTransactions.keys.toList()[index];
            final transactionsInMonth = groupedTransactions[monthYear] ?? [];

            return Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 10,
              children: [
                // Month Header
                MyText(
                  text: monthYear, // Display month and year
                  multilanguage: false,
                  fontsizeNormal: Dimens.textBig,
                  fontwaight: FontWeight.w600,
                  color: black,
                ),
                // Transactions for the Month
                ...transactionsInMonth.map((trans) {
                  return Column(
                    spacing: 10,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        spacing: 20,
                        children: [
                          MyNetworkImage(
                              imgHeight: 50,
                              imgWidth: 50,
                              radius: 200,
                              imageUrl: trans.courseImage ?? "",
                              fit: BoxFit.cover),
                          Expanded(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                MyText(
                                  text: trans.courseTitle ?? "",
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textMedium,
                                  color: black,
                                  fontwaight: FontWeight.w400,
                                ),
                                MyText(
                                  text: "Purch Id :  ${trans.purchaseId ?? ""}",
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textSmall,
                                  color: gray,
                                  fontwaight: FontWeight.w400,
                                ),
                              ],
                            ),
                          ),
                          MyText(
                            text:
                                "${Constant.currencyCode} ${trans.coursePrice.toString()}",
                            multilanguage: false,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            fontsizeNormal: Dimens.textBig,
                            color: black,
                            fontwaight: FontWeight.w600,
                          ),
                        ],
                      ),
                      MyText(
                        text: DateFormat('d MMM yyyy, h:mm a')
                            .format(DateTime.parse(trans.updatedAt ?? "")),
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontsizeNormal: Dimens.textSmall,
                        color: gray,
                        fontwaight: FontWeight.w400,
                      ),
                    ],
                  );
                }),
              ],
            );
          },
        ));
  }

/* metting transaction data Started */

  Widget _buildMeetingTr() {
    final transactions = transactionListProvider.histroyList ?? [];
    final groupedTransactions = _groupTransactionsByMonth(transactions);

    return ResponsiveGridList(
        minItemWidth: 400,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        verticalGridMargin: 0,
        horizontalGridMargin: 10,
        verticalGridSpacing: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          groupedTransactions.keys.length,
          (index) {
            final monthYear = groupedTransactions.keys.toList()[index];
            final transactionsInMonth = groupedTransactions[monthYear] ?? [];

            return Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 10,
              children: [
                // Month Header
                MyText(
                  text: monthYear, // Display month and year
                  multilanguage: false,
                  fontsizeNormal: Dimens.textBig,
                  fontwaight: FontWeight.w600,
                  color: black,
                ),
                // Transactions for the Month
                ...transactionsInMonth.map((trans) {
                  return Column(
                    spacing: 10,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        spacing: 20,
                        children: [
                          buildAttachmentWidget(trans.attachment.toString()),
                          Expanded(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                MyText(
                                  text:
                                      "Trans_Id : ${trans.transactionId ?? ""}",
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textMedium,
                                  color: black,
                                  fontwaight: FontWeight.w400,
                                ),
                                MyText(
                                  text: trans.details ?? "",
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textSmall,
                                  color: gray,
                                  fontwaight: FontWeight.w400,
                                ),
                              ],
                            ),
                          ),
                          MyText(
                            text:
                                "${Constant.currencyCode} ${trans.totalPrice.toString()}",
                            multilanguage: false,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            fontsizeNormal: Dimens.textBig,
                            color: black,
                            fontwaight: FontWeight.w600,
                          ),
                        ],
                      ),
                      MyText(
                        text: DateFormat('d MMM yyyy, h:mm a')
                            .format(DateTime.parse(trans.updatedAt ?? "")),
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontsizeNormal: Dimens.textSmall,
                        color: gray,
                        fontwaight: FontWeight.w400,
                      ),
                    ],
                  );
                }),
              ],
            );
          },
        ));
  }

  bool isImage(String url) {
    return url.endsWith('.png') ||
        url.endsWith('.jpg') ||
        url.endsWith('.jpeg') ||
        url.endsWith('.gif');
  }

  bool isPdf(String url) {
    return url.endsWith('.pdf');
  }

  bool isVideo(String url) {
    return url.endsWith('.mp4') ||
        url.endsWith('.mov') ||
        url.endsWith('.avi') ||
        url.endsWith('.webm');
  }

  Widget buildAttachmentWidget(String url) {
    if (isImage(url)) {
      return MyNetworkImage(
          imgHeight: 50,
          imgWidth: 50,
          radius: 200,
          imageUrl: url,
          fit: BoxFit.cover);
    } else if (isPdf(url)) {
      return Icon(Icons.picture_as_pdf, size: 40, color: Colors.red);
    } else if (isVideo(url)) {
      return Icon(Icons.videocam, size: 40, color: Colors.blue);
    } else {
      return Icon(Icons.insert_drive_file, size: 40, color: Colors.grey);
    }
  }

// Helper method to group transactions by month and year
  Map<String, List<payment.Result>> _groupTransactionsByMonth(
      List<payment.Result> transactions) {
    final Map<String, List<payment.Result>> groupedTransactions = {};

    for (int i = 0; i < (transactions.length); i++) {
      final date = DateTime.parse(transactions[i].updatedAt ?? "");
      final monthYear = DateFormat('MMMM yyyy').format(date);

      if (groupedTransactions.containsKey(monthYear)) {
        groupedTransactions[monthYear]!.add(transactions[i]);
      } else {
        groupedTransactions[monthYear] = [transactions[i]];
      }
    }

    return groupedTransactions;
  } /* Shimmer Data */

  Widget shimmer() {
    return ResponsiveGridList(
        minItemWidth: 400,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        verticalGridMargin: 0,
        horizontalGridMargin: 20,
        verticalGridSpacing: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Column(
              children: [
                Row(
                  children: [
                    CustomWidget.circular(
                      height: 30,
                      width: 30,
                    ),
                    Expanded(
                      child: CustomWidget.roundcorner(
                        height: 20,
                        width: MediaQuery.sizeOf(context).width,
                      ),
                    ),
                    const CustomWidget.roundcorner(
                      height: 20,
                      width: 60,
                    ),
                  ],
                ),
                const SizedBox(height: 8),
                Row(
                  children: [
                    Expanded(
                      child: CustomWidget.roundcorner(
                        height: 20,
                        width: MediaQuery.sizeOf(context).width,
                      ),
                    ),
                    const SizedBox(width: 50),
                    Expanded(
                      child: CustomWidget.roundcorner(
                        height: 20,
                        width: MediaQuery.sizeOf(context).width,
                      ),
                    ),
                  ],
                )
              ],
            );
          },
        ));
  }
}
