import 'package:prakah/pages/bottombar.dart';
import 'package:prakah/pages/editprofile.dart';
import 'package:prakah/pages/intro.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

class Splash extends StatefulWidget {
  const Splash({super.key});

  @override
  State<Splash> createState() => SplashState();
}

class SplashState extends State<Splash> {
  SharedPre sharedPre = SharedPre();
  late GeneralProvider generalProvider;

  @override
  void initState() {
    super.initState();
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
  }

  @override
  Widget build(BuildContext context) {
    checkFirstSeen();
    return Scaffold(
      backgroundColor: colorPrimaryDark,
      body: MyImage(
        fit: BoxFit.fill,
        width: MediaQuery.of(context).size.width,
        height: MediaQuery.of(context).size.height,
        imagePath: "splash.png",
      ),
    );
  }

  Future<void> checkFirstSeen() async {
    await generalProvider.getGeneralsetting(context);
    String? seen = await sharedPre.read('seen') ?? "";
    String? edit = await sharedPre.read("edit") ?? "";
    printLog("Edit is : ===== $edit");

    if (!mounted) return;
    if (seen == "1") {
      if (Constant.userID != null && (Constant.userID ?? "").isNotEmpty) {
        if (edit == "0") {
          Utils.navigatePage(context, const EditProfile(editType: "2"), "1");
        } else {
          Utils.navigatePage(context, const Bottombar(), "1");
        }
      } else {
        Utils.navigatePage(context, const Bottombar(), "1");
      }
    } else {
      if ((generalProvider.introScreenModel.status == 200) &&
          (generalProvider.introScreenModel.result?.length ?? 0) > 0) {
        Utils.navigatePage(
            context,
            Intro(introList: generalProvider.introScreenModel.result ?? []),
            "1");
      } else {
        Utils.navigatePage(context, const Bottombar(), "1");
      }
    }
  }
}
