import 'package:prakah/pages/blogdetail.dart';
import 'package:prakah/pages/detail.dart';
import 'package:prakah/pages/ebookdetails.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class Search extends StatefulWidget {
  const Search({super.key});

  @override
  State<Search> createState() => _SearchState();
}

class _SearchState extends State<Search> {
  final searchController = TextEditingController();
  SearchProvider searchProvider = SearchProvider();
  final ScrollController _scrollController = ScrollController();
  double? width;
  double? height;
  @override
  void initState() {
    super.initState();
    searchProvider = Provider.of<SearchProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (searchProvider.currentPage ?? 0) < (searchProvider.totalPage ?? 0)) {
      printLog("load more====>");
      searchProvider.setLoadMore(true);
      if (searchProvider.layoutType == Constant.courseType) {
        _fetchData("3", searchProvider.currentPage ?? 0);
      } else if (searchProvider.layoutType == Constant.bookType) {
        _fetchData("2", searchProvider.currentPage ?? 0);
      } else {
        _fetchData("1", searchProvider.currentPage ?? 0);
      }
    }
  }

  Future<void> _fetchData(String type, int? nextPage) async {
    await searchProvider.getSearch(
        searchController.text, type, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();

    searchProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return Scaffold(
      appBar: appBar(),
      body: Consumer<SearchProvider>(builder: (context, searchprovider, child) {
        return Padding(
          padding: const EdgeInsets.fromLTRB(20, 10, 20, 80),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 10,
            children: [
              tabButton(),
              Expanded(child: setLayout()),
              if (searchProvider.loadMore)
                Utils.pageLoader()
              else
                const SizedBox.shrink(),
            ],
          ),
        );
      }),
    );
  }

  AppBar appBar() {
    return AppBar(
      systemOverlayStyle: const SystemUiOverlayStyle(
        statusBarIconBrightness: Brightness.light,
        statusBarBrightness: Brightness.light,
      ),
      elevation: 0,
      titleSpacing: 0,
      backgroundColor: colorPrimaryDark,
      surfaceTintColor: transparent,
      leading: Utils.backButton(context),
      toolbarHeight: 80,
      centerTitle: false,
      title:
          Consumer<SearchProvider>(builder: (context, searchprovider, child) {
        return Padding(
          padding: const EdgeInsets.only(right: 10),
          child: TextFormField(
            obscureText: false,
            keyboardType: TextInputType.text,
            controller: searchController,
            textInputAction: TextInputAction.done,
            cursorColor: Theme.of(context).colorScheme.surface,
            style: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: Theme.of(context).colorScheme.surface,
                fontWeight: FontWeight.w500),
            decoration: InputDecoration(
              filled: true,
              fillColor: textFiledColor,
              contentPadding: const EdgeInsets.fromLTRB(15, 15, 15, 15),
              focusedBorder: const OutlineInputBorder(
                borderRadius: BorderRadius.all(Radius.circular(10)),
                borderSide: BorderSide.none,
              ),
              disabledBorder: const OutlineInputBorder(
                borderRadius: BorderRadius.all(Radius.circular(10)),
                borderSide: BorderSide.none,
              ),
              enabledBorder: const OutlineInputBorder(
                borderRadius: BorderRadius.all(Radius.circular(10)),
                borderSide: BorderSide.none,
              ),
              border: const OutlineInputBorder(
                borderRadius: BorderRadius.all(Radius.circular(10)),
                borderSide: BorderSide.none,
              ),
              hintText: Locales.string(context, "searchbarhint"),
              hintStyle: GoogleFonts.inter(
                  fontSize: Dimens.textMedium,
                  fontStyle: FontStyle.normal,
                  color: Theme.of(context).colorScheme.surface,
                  fontWeight: FontWeight.w500),
            ),
            onChanged: (value) async {
              if (value.isNotEmpty) {
                searchProvider.clearWishList();
                searchProvider.searchList?.clear();
                if (searchProvider.layoutType == Constant.courseType) {
                  await _fetchData("3", 0);
                } else if (searchProvider.layoutType == Constant.bookType) {
                  await _fetchData("2", 0);
                } else {
                  await _fetchData("1", 0);
                }
              }
            },
          ),
        );
      }),
      actions: [
        Consumer<SearchProvider>(builder: (context, searchprovider, child) {
          return searchController.text.isEmpty
              ? SizedBox.shrink()
              : IconButton(
                  onPressed: () {
                    searchController.clear();
                    searchProvider.clearProvider();
                    searchProvider.searchList?.clear();
                    if (searchProvider.layoutType == Constant.courseType) {
                      _fetchData("3", 0);
                    } else if (searchProvider.layoutType == Constant.bookType) {
                      _fetchData("2", 0);
                    } else {
                      _fetchData("1", 0);
                    }
                    FocusManager.instance.primaryFocus?.unfocus();
                  },
                  icon: Icon(
                    Icons.close,
                    size: 22,
                    color: white,
                  ),
                );
        }),
      ],
    );
  }

  Widget tabButton() {
    return Container(
      width: MediaQuery.of(context).size.width,
      alignment: Alignment.centerRight,
      padding: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(14),
        color: colorPrimary.withValues(alpha: 0.18),
      ),
      child: Row(
        spacing: 15,
        children: [
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () {
                searchProvider.selectLayout(Constant.courseType);
                searchProvider.clearWishList();
                _fetchData("3", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: searchProvider.layoutType == Constant.courseType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: searchProvider.layoutType == Constant.courseType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "course",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () {
                searchProvider.selectLayout(Constant.bookType);
                searchProvider.clearWishList();
                _fetchData("2", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: searchProvider.layoutType == Constant.bookType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: searchProvider.layoutType == Constant.bookType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "book",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
          Expanded(
            child: InkWell(
              borderRadius: BorderRadius.circular(10),
              focusColor: transparent,
              highlightColor: transparent,
              hoverColor: transparent,
              splashColor: transparent,
              onTap: () {
                searchProvider.selectLayout(Constant.blogType);
                searchProvider.clearWishList();
                _fetchData("1", 0);
              },
              child: Container(
                padding: const EdgeInsets.all(10),
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: searchProvider.layoutType == Constant.blogType
                      ? colorPrimary
                      : transparent,
                ),
                child: MyText(
                    color: searchProvider.layoutType == Constant.blogType
                        ? white
                        : Theme.of(context).colorScheme.surface,
                    text: "blog",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w600,
                    maxline: 3,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget setLayout() {
    if (searchProvider.loading && !searchProvider.loadMore) {
      return (searchProvider.layoutType == Constant.courseType)
          ? courseShimmer()
          : (searchProvider.layoutType == Constant.bookType)
              ? bookShimmer()
              : blogShimmer();
    } else {
      if (searchProvider.searchList != null &&
          (searchProvider.searchList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          scrollDirection: Axis.vertical,
          controller: _scrollController,
          physics: const AlwaysScrollableScrollPhysics(),
          child: (searchProvider.layoutType == Constant.courseType)
              ? courseItem()
              : (searchProvider.layoutType == Constant.bookType)
                  ? buildBookItem()
                  : buildBlogItem(),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget courseItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 2,
          maxItemsPerRow: 2,
          horizontalGridSpacing: 5,
          verticalGridSpacing: 5,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
          ),
          children:
              List.generate(searchProvider.searchList?.length ?? 0, (index) {
            return InkWell(
              onTap: () {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      transitionDuration: const Duration(milliseconds: 200),
                      pageBuilder: (BuildContext context,
                          Animation<double> animation,
                          Animation<double> secondaryAnimation) {
                        return Detail(
                            courseId: searchProvider.searchList?[index].id
                                    .toString() ??
                                "");
                      },
                      transitionsBuilder: (BuildContext context,
                          Animation<double> animation,
                          Animation<double> secondaryAnimation,
                          Widget child) {
                        return Align(
                          child: FadeTransition(
                            opacity: animation,
                            child: child,
                          ),
                        );
                      },
                    ),
                  );
                });
              },
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          imgWidth: MediaQuery.sizeOf(context).width,
                          imgHeight: 110,
                          fit: BoxFit.fill,
                          radius: 10,
                          islandscap: true,
                          imageUrl: searchProvider
                                  .searchList?[index].thumbnailImg
                                  .toString() ??
                              ""),
                      Positioned.fill(
                        top: 5,
                        left: 10,
                        right: 10,
                        child: Align(
                          alignment: Alignment.topRight,
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () {
                              if (Utils.checkLoginUser(context)) {
                                searchProvider.addRemoveWishlist(
                                  index,
                                  "3",
                                  searchProvider.searchList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Icon(
                              searchProvider.searchList?[index].isWishlist == 1
                                  ? Icons.favorite
                                  : Icons.favorite_border,
                              color: searchProvider
                                          .searchList?[index].isWishlist ==
                                      1
                                  ? red
                                  : white,
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text:
                          searchProvider.searchList?[index].title.toString() ??
                              "",
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.start,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: gray,
                          text: Utils.kmbGenerator(int.parse(searchProvider
                                  .searchList?[index].totalView
                                  .toString() ??
                              "")),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      const SizedBox(width: 5),
                      MyText(
                          color: gray,
                          text: "students",
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: true,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  Row(
                    children: [
                      MyRating(
                        size: 15,
                        rating: double.parse(searchProvider
                                .searchList?[index].avgRating
                                .toString() ??
                            ""),
                        spacing: 2,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text:
                              "${double.parse(searchProvider.searchList?[index].avgRating.toString() ?? "")}",
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (searchProvider.searchList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${searchProvider.searchList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            );
          })),
    );
  }

  Widget buildBookItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: 3,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children:
            List.generate(searchProvider.searchList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        EbookDetails(
                      ebookId:
                          searchProvider.searchList?[index].id.toString() ?? "",
                      ebookName:
                          searchProvider.searchList?[index].title.toString() ??
                              "",
                    ),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            },
            child: SizedBox(
              width: 150,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 4,
                children: [
                  Stack(
                    children: [
                      MyNetworkImage(
                          radius: 5,
                          imgWidth: width,
                          imgHeight: 155,
                          imageUrl: searchProvider
                                  .searchList?[index].thumbnailImg
                                  .toString() ??
                              "",
                          fit: BoxFit.cover),
                      Positioned.fill(
                        top: 5,
                        left: 10,
                        right: 10,
                        child: Align(
                          alignment: Alignment.topRight,
                          child: InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            onTap: () {
                              if (Utils.checkLoginUser(context)) {
                                searchProvider.addRemoveWishlist(
                                  index,
                                  "2",
                                  searchProvider.searchList?[index].id
                                          .toString() ??
                                      "",
                                );
                              }
                            },
                            child: Icon(
                              searchProvider.searchList?[index].isWishlist == 1
                                  ? Icons.favorite
                                  : Icons.favorite_border,
                              color: searchProvider
                                          .searchList?[index].isWishlist ==
                                      1
                                  ? red
                                  : white,
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  const SizedBox(height: 10),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text:
                          searchProvider.searchList?[index].title.toString() ??
                              "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  MyText(
                      color: gray,
                      text: searchProvider.searchList?[index].tutorName
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textSmall,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  Row(
                    children: [
                      MyRating(
                        size: 13,
                        rating: double.parse(
                          searchProvider.searchList?[index].avgRating
                                  .toString() ??
                              "",
                        ),
                        spacing: 3,
                      ),
                      const SizedBox(width: 5),
                      MyText(
                          color: colorAccent,
                          text: "${double.parse(
                            searchProvider.searchList?[index].avgRating
                                    .toString() ??
                                "",
                          )}",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                  MyText(
                      color: black,
                      text: (searchProvider.searchList?[index].isFree
                                      .toString() ??
                                  "") ==
                              "0"
                          ? "${Constant.currencyCode} ${searchProvider.searchList?[index].price.toString() ?? ""}"
                          : Locales.string(context, "free"),
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 2,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          );
        }),
      ),
    );
  }

/* Blog Data */

  Widget buildBlogItem() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children:
            List.generate(searchProvider.searchList?.length ?? 0, (index) {
          return InkWell(
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        BlogDetail(
                      blogId:
                          searchProvider.searchList?[index].id.toString() ?? "",
                    ),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            },
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                Stack(
                  children: [
                    MyNetworkImage(
                        radius: 10,
                        imgWidth: width,
                        imgHeight: 155,
                        imageUrl: searchProvider.searchList?[index].image
                                .toString() ??
                            "",
                        fit: BoxFit.cover),
                    Positioned.fill(
                      top: 5,
                      left: 10,
                      right: 10,
                      child: Align(
                        alignment: Alignment.topRight,
                        child: InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          onTap: () {
                            if (Utils.checkLoginUser(context)) {
                              searchProvider.addRemoveWishlist(
                                index,
                                "1",
                                searchProvider.searchList?[index].id
                                        .toString() ??
                                    "",
                              );
                            }
                          },
                          child: Icon(
                            searchProvider.searchList?[index].isWishlist == 1
                                ? Icons.favorite
                                : Icons.favorite_border,
                            color:
                                searchProvider.searchList?[index].isWishlist ==
                                        1
                                    ? red
                                    : white,
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: searchProvider.searchList?[index].title.toString() ??
                        "",
                    fontsizeNormal: Dimens.textBig,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                MyText(
                    color: gray,
                    text: searchProvider.searchList?[index].tutorName
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textMedium,
                    fontsizeWeb: Dimens.textSmall,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontwaight: FontWeight.w600,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget courseShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 2,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(
          10,
          (index) {
            return Container(
              width: 200,
              margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.rectangular(
                    width: MediaQuery.sizeOf(context).width,
                    height: 110,
                  ),
                  const SizedBox(height: 8),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                  CustomWidget.roundrectborder(
                    width: MediaQuery.sizeOf(context).width,
                    height: 5,
                  ),
                ],
              ),
            );
          },
        ),
      ),
    );
  }

  Widget bookShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 3,
        maxItemsPerRow: 3,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return SizedBox(
            width: 140,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                CustomWidget.roundrectborder(
                  width: width ?? 0,
                  height: 155,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
                CustomWidget.roundrectborder(
                  width: MediaQuery.sizeOf(context).width,
                  height: 5,
                ),
              ],
            ),
          );
        }),
      ),
    );
  }

  Widget blogShimmer() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(10, (index) {
          return Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 4,
            children: [
              Stack(
                children: [
                  CustomWidget.roundcorner(width: width ?? 0, height: 155),
                  Positioned.fill(
                    top: 5,
                    left: 10,
                    right: 10,
                    child: Align(
                      alignment: Alignment.topRight,
                      child: CustomWidget.circular(width: 30, height: 30),
                    ),
                  ),
                ],
              ),
              CustomWidget.roundcorner(width: width ?? 0.0, height: 16),
              CustomWidget.roundcorner(width: (width ?? 0.0) * 0.5, height: 14),
            ],
          );
        }),
      ),
    );
  }
}
