import 'dart:io';

import 'package:prakah/pages/bottombar.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/services.dart';
import 'package:intl_phone_field/country_picker_dialog.dart';
import 'package:intl_phone_field/intl_phone_field.dart';
import 'package:prakah/pages/login.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';

class Register extends StatefulWidget {
  const Register({super.key});

  @override
  State<Register> createState() => _RegisterState();
}

class _RegisterState extends State<Register> {
  late GeneralProvider generalProvider;
  TextEditingController fullnameController = TextEditingController();
  TextEditingController emailController = TextEditingController();
  TextEditingController passwordController = TextEditingController();
  TextEditingController numberController = TextEditingController();
  TextEditingController confPasswordController = TextEditingController();

  bool obscureTextPassword = true;
  bool obscureTextPassword1 = true;

  String mobilenumber = "", countrycode = "", countryname = "";
  String? strDeviceType, strDeviceToken;

  @override
  initState() {
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    super.initState();
    _getDeviceToken();
  }

  Future<void> _getDeviceToken() async {
    try {
      if (Platform.isAndroid) {
        strDeviceType = "1";
      } else {
        strDeviceType = "2";
      }
      strDeviceToken = await FirebaseMessaging.instance.getToken();
    } catch (e) {
      printLog("_getDeviceToken Exception ===> $e");
    }
    printLog("===>strDeviceToken $strDeviceToken");
    printLog("===>strDeviceType $strDeviceType");
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          image: DecorationImage(
              image: AssetImage("assets/images/login_bg.png"),
              fit: BoxFit.fill)),
      child: Scaffold(
        backgroundColor: transparent,
        appBar: AppBar(
          backgroundColor: transparent,
          systemOverlayStyle: SystemUiOverlayStyle(
            statusBarColor: transparent,
            systemNavigationBarColor: transparent,
          ),
          leading: InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              Navigator.of(context).pop();
            },
            child: const Icon(
              Icons.arrow_back_outlined,
              size: 20,
              color: white,
            ),
          ),
        ),
        body: Container(
          height: MediaQuery.sizeOf(context).height,
          width: MediaQuery.sizeOf(context).width,
          margin: EdgeInsets.only(top: 120),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(30), topRight: Radius.circular(30))),
          child: SingleChildScrollView(
            scrollDirection: Axis.vertical,
            physics: const BouncingScrollPhysics(),
            padding: EdgeInsets.fromLTRB(15, 30, 15, 30),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                    color: colorPrimaryDark,
                    text: "signup",
                    fontsizeNormal: Dimens.textExtraBig,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    multilanguage: true,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 20),
                registerField(),
                const SizedBox(height: 30),
                signUpBtn(),
                const SizedBox(height: 10),
                loginText(),
                const SizedBox(height: 60),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget registerField() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 10,
      children: [
        MyText(
            color: black,
            text: "full_name",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: false,
          keyboardType: TextInputType.text,
          controller: fullnameController,
          textInputAction: TextInputAction.next,
          cursorColor: black,
          style: GoogleFonts.inter(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              letterSpacing: 1.0,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            hintText: "Enter the full name",
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                letterSpacing: 1.0,
                color: gray,
                fontWeight: FontWeight.w600),
          ),
        ),
        MyText(
            color: black,
            text: "email_address",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: false,
          keyboardType: TextInputType.emailAddress,
          controller: emailController,
          textInputAction: TextInputAction.next,
          cursorColor: black,
          style: GoogleFonts.inter(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              letterSpacing: 1.0,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            hintText: "Enter the Email",
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                letterSpacing: 1.0,
                color: gray,
                fontWeight: FontWeight.w600),
          ),
        ),
        MyText(
            color: black,
            text: "mobile_number",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        IntlPhoneField(
          disableLengthCheck: true,
          textAlignVertical: TextAlignVertical.center,
          cursorColor: black,
          autovalidateMode: AutovalidateMode.disabled,
          controller: numberController,
          pickerDialogStyle: PickerDialogStyle(backgroundColor: white),
          style: GoogleFonts.inter(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: black,
              letterSpacing: 1.0,
              fontWeight: FontWeight.w600),
          showCountryFlag: true,
          showDropdownIcon: false,
          initialCountryCode: Constant.initialCountryCode,
          dropdownTextStyle: GoogleFonts.inter(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              letterSpacing: 1.0,
              color: gray,
              fontWeight: FontWeight.w400),
          keyboardType: TextInputType.number,
          textInputAction: TextInputAction.next,
          decoration: InputDecoration(
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            hintText: "Enter the Phone number",
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                letterSpacing: 1.0,
                color: gray,
                fontWeight: FontWeight.w600),
          ),
          onChanged: (phone) {
            mobilenumber = phone.completeNumber;
            countryname = phone.countryISOCode;
            countrycode = phone.countryCode;
          },
          onCountryChanged: (country) {
            countryname = country.code.replaceAll('+', '');
            countrycode = "+${country.dialCode.toString()}";
          },
        ),
        MyText(
            color: black,
            text: "password",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: obscureTextPassword,
          keyboardType: TextInputType.text,
          controller: passwordController,
          textInputAction: TextInputAction.next,
          cursorColor: black,
          style: GoogleFonts.inter(
              fontSize: Dimens.textTitle,
              fontStyle: FontStyle.normal,
              color: black,
              letterSpacing: 5.0,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            suffixIcon: Container(
              width: 5,
              height: 5,
              alignment: Alignment.center,
              child: InkWell(
                onTap: () {
                  setState(() {
                    obscureTextPassword = !obscureTextPassword;
                  });
                },
                child: Container(
                  width: 25,
                  height: 25,
                  alignment: Alignment.center,
                  child: Icon(
                    obscureTextPassword
                        ? Icons.visibility
                        : Icons.visibility_off,
                    color: gray,
                  ),
                ),
              ),
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            hintText: "Enter the Password",
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                letterSpacing: 1.0,
                color: gray,
                fontWeight: FontWeight.w600),
          ),
          onChanged: (value) {},
        ),
        MyText(
            color: black,
            text: "conf_password",
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            multilanguage: true,
            fontstyle: FontStyle.normal),
        TextFormField(
          obscureText: obscureTextPassword1,
          keyboardType: TextInputType.text,
          controller: confPasswordController,
          textInputAction: TextInputAction.next,
          cursorColor: black,
          style: GoogleFonts.inter(
              fontSize: Dimens.textTitle,
              fontStyle: FontStyle.normal,
              color: black,
              letterSpacing: 5.0,
              fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            suffixIcon: Container(
              width: 5,
              height: 5,
              alignment: Alignment.center,
              child: InkWell(
                onTap: () {
                  setState(() {
                    obscureTextPassword1 = !obscureTextPassword1;
                  });
                },
                child: Container(
                  width: 25,
                  height: 25,
                  alignment: Alignment.center,
                  child: Icon(
                    obscureTextPassword1
                        ? Icons.visibility
                        : Icons.visibility_off,
                    color: gray,
                  ),
                ),
              ),
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            disabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            border: OutlineInputBorder(
              borderRadius: const BorderRadius.all(Radius.circular(7)),
              borderSide:
                  BorderSide(width: 1, color: gray, style: BorderStyle.solid),
            ),
            hintText: "Enter the Confirm Password",
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                letterSpacing: 1.0,
                color: gray,
                fontWeight: FontWeight.w600),
          ),
          onChanged: (value) {},
        ),
      ],
    );
  }

  Widget signUpBtn() {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      if (generalprovider.isProgressLoading) {
        return Container(
          width: MediaQuery.of(context).size.width,
          height: 45,
          alignment: Alignment.center,
          decoration: BoxDecoration(
            color: colorPrimary,
            borderRadius: BorderRadius.circular(12),
          ),
          child: const SizedBox(
            width: 20,
            height: 20,
            child: CircularProgressIndicator(
              color: colorAccent,
              strokeWidth: 2,
            ),
          ),
        );
      } else {
        return InkWell(
          onTap: () async {
            if (fullnameController.text.isEmpty) {
              Utils.showSnackbar(context, "fail", "pleasenterfullname", true);
            } else if (emailController.text.isEmpty) {
              Utils.showSnackbar(context, "fail", "pleasenteremail", true);
            } else if (numberController.text.isEmpty) {
              Utils.showSnackbar(
                  context, "fail", "pleaseenteryourmobile", true);
            } else if (passwordController.text.isEmpty) {
              Utils.showSnackbar(
                  context, "fail", "pleaseenteryourpassword", true);
            } else if (passwordController.text.length < 6) {
              Utils.showSnackbar(
                  context, "fail", "pleaseenterpasswordonlysixdigit", true);
            } else if (confPasswordController.text != passwordController.text) {
              Utils.showSnackbar(context, "fail", "confirm_message_pass", true);
            } else {
              generalProvider.setLoading(true);
              await generalProvider.getRegister(
                fullnameController.text,
                emailController.text,
                numberController.text,
                passwordController.text,
                countrycode,
                countryname,
                strDeviceType,
                strDeviceToken,
              );

              if (generalProvider.loginmodel.status == 200) {
                if (!mounted) return;
                generalprovider.setLoading(false);

                Utils.saveUserCreds(
                  userID: generalProvider.loginmodel.result?[0].id.toString(),
                  userName: generalProvider.loginmodel.result?[0].userName
                          .toString() ??
                      "",
                  fullName: generalProvider.loginmodel.result?[0].fullName
                          .toString() ??
                      "",
                  email:
                      generalProvider.loginmodel.result?[0].email.toString() ??
                          "",
                  mobileNumber: generalProvider
                          .loginmodel.result?[0].mobileNumber
                          .toString() ??
                      "",
                  image:
                      generalProvider.loginmodel.result?[0].image.toString() ??
                          "",
                  deviceType: generalProvider.loginmodel.result?[0].deviceType
                          .toString() ??
                      "",
                  deviceToken: generalProvider.loginmodel.result?[0].deviceToken
                          .toString() ??
                      "",
                  userIsBuy:
                      generalProvider.loginmodel.result?[0].isBuy.toString() ??
                          "",
                  type: generalProvider.loginmodel.result?[0].type.toString() ??
                      "",
                );
                await SharedPre().save("edit", "1");
                if (!context.mounted) return;
                Utils.navigatePage(context, Bottombar(), '');
              } else {
                generalprovider.setLoading(false);
                if (!context.mounted) return;
                Utils.showSnackbar(context, "fail",
                    generalProvider.loginmodel.message ?? "", false);
              }
            }
          },
          child: Container(
            width: MediaQuery.of(context).size.width,
            height: 45,
            alignment: Alignment.center,
            decoration: BoxDecoration(
              color: colorPrimary,
              borderRadius: BorderRadius.circular(12),
            ),
            child: MyText(
              color: white,
              text: "signup",
              fontsizeNormal: Dimens.textTitle,
              fontwaight: FontWeight.w600,
              maxline: 1,
              multilanguage: true,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
            ),
          ),
        );
      }
    });
  }

  Widget loginText() {
    return InkWell(
      onTap: () {
        Navigator.of(context).pushReplacement(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return const Login();
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          MyText(
              color: gray,
              text: "alreadyhaveanaccount",
              fontsizeNormal: Dimens.textMedium,
              fontwaight: FontWeight.w500,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
          const SizedBox(width: 5),
          MyText(
              color: colorPrimary,
              text: "login",
              fontsizeNormal: Dimens.textTitle,
              fontwaight: FontWeight.w600,
              maxline: 1,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
        ],
      ),
    );
  }
}
