import 'package:prakah/utils/dimens.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:provider/provider.dart';
import 'package:syncfusion_flutter_pdfviewer/pdfviewer.dart';
import 'package:prakah/provider/readbookprovider.dart';
import 'package:prakah/utils/color.dart';

class ReadBook extends StatefulWidget {
  final String pdfURL, bookName, bookId;
  const ReadBook({
    super.key,
    required this.pdfURL,
    required this.bookName,
    required this.bookId,
  });

  @override
  State<ReadBook> createState() => _ReadBookState();
}

class _ReadBookState extends State<ReadBook> {
  ReadBookProvider readBookProvider = ReadBookProvider();
  final GlobalKey<SfPdfViewerState> _pdfViewerKey = GlobalKey();
  final PdfViewerController _pdfViewerController = PdfViewerController();

  @override
  void initState() {
    super.initState();
    readBookProvider = Provider.of<ReadBookProvider>(context, listen: false);
    getApi();
  }

  Future<void> getApi() async {
    await readBookProvider.addVideoView("2", widget.bookId, "");
  }

  @override
  void dispose() {
    _pdfViewerController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: white,
      appBar: kIsWeb
          ? null
          : AppBar(
              backgroundColor: colorPrimaryDark,
              elevation: 0,
              surfaceTintColor: transparent,
              systemOverlayStyle: SystemUiOverlayStyle(
                  statusBarColor: transparent,
                  systemNavigationBarColor: transparent,
                  systemNavigationBarDividerColor: transparent),
              centerTitle: false,
              titleSpacing: 0,
              leading: InkWell(
                splashColor: transparent,
                focusColor: transparent,
                hoverColor: transparent,
                onTap: () {
                  Navigator.of(context).pop();
                },
                child: Icon(
                  Icons.arrow_back_outlined,
                  size: 20,
                  color: white,
                ),
              ),
              title: MyText(
                text: widget.bookName,
                multilanguage: false,
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: Dimens.textTitle,
                fontstyle: FontStyle.normal,
                fontwaight: FontWeight.bold,
                textalign: TextAlign.center,
                color: white,
              ),
              actions: [
                Padding(
                  padding: const EdgeInsets.all(8.0),
                  child: InkWell(
                      onTap: () {
                        _pdfViewerKey.currentState?.openBookmarkView();
                      },
                      child: Icon(Icons.bookmark, size: 20, color: white)),
                )
              ],
            ),
      body: SfPdfViewer.network(
        widget.pdfURL,
        key: _pdfViewerKey,
        controller: _pdfViewerController,
        canShowHyperlinkDialog: true,
        currentSearchTextHighlightColor: colorPrimary,
        enableTextSelection: true,
        canShowPageLoadingIndicator: true,
        scrollDirection: PdfScrollDirection.vertical,
        pageLayoutMode: PdfPageLayoutMode.single,
        enableDoubleTapZooming: true,
        interactionMode: PdfInteractionMode.selection,
        initialScrollOffset: Offset.zero,
        canShowScrollStatus: true,
        canShowScrollHead: true,
        canShowPaginationDialog: true,
      ),
    );
  }
}
