import 'package:prakah/pages/transcationlist.dart';
import 'package:prakah/provider/mywalletprovider.dart';
import 'package:prakah/subscription/subscription.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';

class MyWallet extends StatefulWidget {
  const MyWallet({super.key});

  @override
  State<MyWallet> createState() => _MyWalletState();
}

class _MyWalletState extends State<MyWallet> {
  MyWalletProvider myWalletProvider = MyWalletProvider();
  final TextEditingController walletController = TextEditingController();

  @override
  void initState() {
    super.initState();
    myWalletProvider = Provider.of<MyWalletProvider>(context, listen: false);
    getAPi();
  }

  Future<void> getAPi() async {
    await myWalletProvider.getprofile();
  }

  @override
  void dispose() {
    myWalletProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "my_wallet",
          multilanguage: true),
      body: Consumer<MyWalletProvider>(
          builder: (context, myWalletProvider, child) {
        return SingleChildScrollView(
          padding: EdgeInsets.fromLTRB(20, 10, 20, 10),
          physics: BouncingScrollPhysics(),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.start,
            spacing: 20,
            children: [
              Container(
                decoration: BoxDecoration(
                    color: white,
                    borderRadius: BorderRadius.circular(10),
                    border: Border.all(
                        width: 1,
                        color: textFiledColor,
                        style: BorderStyle.solid),
                    boxShadow: [
                      BoxShadow(
                        blurRadius: 11,
                        blurStyle: BlurStyle.solid,
                        color: transparent.withValues(alpha: 0.08),
                        spreadRadius: 0,
                        offset: Offset(0, 3),
                      )
                    ]),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Padding(
                      padding: const EdgeInsets.fromLTRB(30, 10, 30, 10),
                      child: myWalletProvider.loading
                          ? CustomWidget.roundcorner(height: 14, width: 80)
                          : Column(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              spacing: 10,
                              children: [
                                MyText(
                                  color: colorPrimaryDark,
                                  text: myWalletProvider.profileModel.status ==
                                              200 &&
                                          (myWalletProvider.profileModel.result
                                                      ?.length ??
                                                  0) >
                                              0
                                      ? (myWalletProvider.profileModel
                                              .result?[0].walletAmount
                                              .toString() ??
                                          "0")
                                      : "0",
                                  multilanguage: true,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textExtraBig,
                                  fontwaight: FontWeight.w500,
                                ),
                                MyText(
                                  color: black,
                                  text: "your_wallet_balance",
                                  multilanguage: true,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textTitle,
                                  fontwaight: FontWeight.w500,
                                ),
                              ],
                            ),
                    ),
                    Divider(
                      thickness: 1,
                      color: gray,
                      height: 20,
                    ),
                    Padding(
                      padding: const EdgeInsets.fromLTRB(30, 20, 30, 20),
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        spacing: 20,
                        children: [
                          Expanded(
                            child: InkWell(
                              splashColor: transparent,
                              focusColor: transparent,
                              highlightColor: transparent,
                              hoverColor: transparent,
                              onTap: () {
                                showAddMoneyDialog();
                              },
                              child: Container(
                                padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
                                decoration: BoxDecoration(
                                    color: white,
                                    borderRadius: BorderRadius.circular(10),
                                    border: Border.all(
                                        width: 1,
                                        color: textFiledColor,
                                        style: BorderStyle.solid),
                                    boxShadow: [
                                      BoxShadow(
                                        blurRadius: 11,
                                        blurStyle: BlurStyle.solid,
                                        color:
                                            transparent.withValues(alpha: 0.08),
                                        spreadRadius: 0,
                                        offset: Offset(0, 3),
                                      )
                                    ]),
                                child: Column(
                                  spacing: 10,
                                  children: [
                                    Icon(Icons.add,
                                        size: 20, color: colorPrimaryDark),
                                    MyText(
                                      color: black,
                                      text: "add_money",
                                      multilanguage: true,
                                      maxline: 1,
                                      overflow: TextOverflow.ellipsis,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w500,
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          Expanded(
                            child: InkWell(
                              splashColor: transparent,
                              focusColor: transparent,
                              highlightColor: transparent,
                              hoverColor: transparent,
                              onTap: () {
                                if (Utils.checkLoginUser(context)) {
                                  Navigator.of(context).push(
                                    PageRouteBuilder(
                                      pageBuilder: (context, animation,
                                              secondaryAnimation) =>
                                          const TranscationList(),
                                      transitionsBuilder: (context, animation,
                                          secondaryAnimation, child) {
                                        const begin = Offset(1.0, 0.0);
                                        const end = Offset.zero;
                                        const curve = Curves.ease;

                                        var tween = Tween(
                                                begin: begin, end: end)
                                            .chain(CurveTween(curve: curve));

                                        return SlideTransition(
                                          position: animation.drive(tween),
                                          child: child,
                                        );
                                      },
                                    ),
                                  );
                                }
                              },
                              child: Container(
                                padding: EdgeInsets.fromLTRB(20, 16, 20, 16),
                                decoration: BoxDecoration(
                                    color: white,
                                    borderRadius: BorderRadius.circular(10),
                                    border: Border.all(
                                        width: 1,
                                        color: textFiledColor,
                                        style: BorderStyle.solid),
                                    boxShadow: [
                                      BoxShadow(
                                        blurRadius: 11,
                                        blurStyle: BlurStyle.solid,
                                        color:
                                            transparent.withValues(alpha: 0.08),
                                        spreadRadius: 0,
                                        offset: Offset(0, 3),
                                      )
                                    ]),
                                child: Column(
                                  spacing: 10,
                                  children: [
                                    Icon(Icons.history,
                                        size: 20, color: colorPrimaryDark),
                                    MyText(
                                      color: black,
                                      text: "transaction_history",
                                      multilanguage: true,
                                      maxline: 1,
                                      overflow: TextOverflow.ellipsis,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w500,
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          )
                        ],
                      ),
                    )
                  ],
                ),
              ),
/* Upgrade plne details */
              _upGradePlane(),
            ],
          ),
        );
      }),
    );
  }
  /* Add Money dialog Data */

  Future showAddMoneyDialog() {
    return showDialog(
      context: context,
      builder: (context) {
        return Consumer<MyWalletProvider>(
            builder: (context, myWalletProvider, child) {
          return AlertDialog(
            backgroundColor: white,
            elevation: 10,
            title: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 6,
              children: [
                InkWell(
                    splashColor: transparent,
                    highlightColor: transparent,
                    hoverColor: transparent,
                    focusColor: transparent,
                    onTap: () {
                      if (Navigator.canPop(context)) {
                        Navigator.of(context).pop();
                      }
                    },
                    child: Icon(Icons.close, size: 20, color: black)),
                MyText(
                    color: black,
                    text: "add_money",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                MyText(
                    color: black,
                    text:
                        "${Locales.string(context, "available_balance")} ${Constant.currencyCode} ${myWalletProvider.profileModel.result?[0].walletAmount.toString() ?? ""}",
                    multilanguage: false,
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            content: TextFormField(
              keyboardType: TextInputType.number,
              controller: walletController,
              textInputAction: TextInputAction.next,
              cursorColor: black,
              style: GoogleFonts.lato(
                  fontSize: Dimens.textMedium,
                  fontStyle: FontStyle.normal,
                  color: black,
                  fontWeight: FontWeight.w600),
              decoration: InputDecoration(
                prefixIcon: Icon(Icons.wallet, size: 20, color: gray),
                focusedBorder: OutlineInputBorder(
                  borderRadius: const BorderRadius.all(Radius.circular(10)),
                  borderSide: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                ),
                disabledBorder: OutlineInputBorder(
                  borderRadius: const BorderRadius.all(Radius.circular(10)),
                  borderSide: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                ),
                enabledBorder: OutlineInputBorder(
                  borderRadius: const BorderRadius.all(Radius.circular(10)),
                  borderSide: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                ),
                border: OutlineInputBorder(
                  borderRadius: const BorderRadius.all(Radius.circular(10)),
                  borderSide: BorderSide(
                      width: 1, color: webTextFiled, style: BorderStyle.solid),
                ),
                hintText: "Enter the amount",
                hintStyle: GoogleFonts.lato(
                    fontSize: Dimens.textMedium,
                    fontStyle: FontStyle.normal,
                    color: gray,
                    fontWeight: FontWeight.w400),
              ),
            ),
            actions: [
              Align(
                alignment: Alignment.center,
                child: InkWell(
                    borderRadius: BorderRadius.circular(10),
                    focusColor: transparent,
                    highlightColor: transparent,
                    hoverColor: transparent,
                    splashColor: transparent,
                    onTap: () async {
                      /* trabsaction id */
                      String? transactionId = Utils.generateRandomOrderID();
                      if (walletController.text.isEmpty) {
                        Utils.showSnackbar(
                            context, "fail", "pleaseenteramount", true);
                      } else {
                        myWalletProvider.setWallet(true);

                        await myWalletProvider.getAddWallet(
                            walletController.text, transactionId);

                        if (myWalletProvider.successModel.status == 200) {
                          myWalletProvider.setWallet(false);
                          if (!context.mounted) return;
                          if (Navigator.canPop(context)) {
                            Navigator.of(context).pop();
                          }
                          /* APi Call */
                          getAPi();
                          walletController.clear();
                          FocusManager.instance.primaryFocus?.unfocus();
                        } else {
                          myWalletProvider.setWallet(false);
                          if (!context.mounted) return;
                          Utils.showSnackbar(
                              context,
                              "fail",
                              myWalletProvider.successModel.message ?? "",
                              false);
                        }
                      }
                    },
                    child: AnimatedContainer(
                      duration: Duration(milliseconds: 120),
                      padding: const EdgeInsets.all(10),
                      alignment: Alignment.center,
                      width: myWalletProvider.walletLoading
                          ? 60
                          : MediaQuery.sizeOf(context).width,
                      decoration: BoxDecoration(
                          color: colorPrimaryDark,
                          borderRadius: BorderRadius.circular(4),
                          boxShadow: [
                            BoxShadow(
                                blurRadius: 11,
                                color: transparent.withValues(alpha: 0.08),
                                blurStyle: BlurStyle.outer,
                                offset: Offset(0, 3),
                                spreadRadius: 0)
                          ]),
                      child: myWalletProvider.walletLoading
                          ? SizedBox(
                              height: 20,
                              width: 20,
                              child: CircularProgressIndicator(
                                color: white,
                              ),
                            )
                          : MyText(
                              color: white,
                              text: "proceed_add_money",
                              multilanguage: true,
                              fontsizeNormal: Dimens.textMedium,
                              fontwaight: FontWeight.w600,
                              maxline: 1,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                    )),
              )
            ],
          );
        });
      },
    );
  }

  Widget _upGradePlane() {
    if (Constant.isBuy == "1" ||
        (myWalletProvider.profileModel.result?[0].isBuy.toString() ?? "") ==
            "1") {
      return Container(
        padding: EdgeInsets.fromLTRB(20, 25, 20, 25),
        decoration: BoxDecoration(
            color: white,
            borderRadius: BorderRadius.circular(10),
            boxShadow: [
              BoxShadow(
                  blurRadius: 11,
                  color: transparent.withValues(alpha: 0.08),
                  blurStyle: BlurStyle.outer,
                  offset: Offset(0, 3),
                  spreadRadius: 0)
            ]),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 30,
          children: [
            Expanded(
                child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              spacing: 10,
              children: [
                MyText(
                    color: black,
                    text: "current_plan",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                myWalletProvider.loading
                    ? CustomWidget.roundcorner(height: 10, width: 80)
                    : MyText(
                        color: black,
                        text: ((myWalletProvider.profileModel.status == 200 &&
                                (myWalletProvider.profileModel.result?.length ??
                                        0) >
                                    0))
                            ? (myWalletProvider
                                    .profileModel.result?[0].packageName
                                    .toString() ??
                                "")
                            : "0",
                        multilanguage: false,
                        fontsizeNormal: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                InkWell(
                    borderRadius: BorderRadius.circular(10),
                    focusColor: transparent,
                    highlightColor: transparent,
                    hoverColor: transparent,
                    splashColor: transparent,
                    onTap: () {
                      Navigator.of(context).pushReplacement(
                        PageRouteBuilder(
                          pageBuilder:
                              (context, animation, secondaryAnimation) =>
                                  Subscription(),
                          transitionsBuilder:
                              (context, animation, secondaryAnimation, child) {
                            const begin = Offset(1.0, 0.0);
                            const end = Offset.zero;
                            const curve = Curves.ease;

                            var tween = Tween(begin: begin, end: end)
                                .chain(CurveTween(curve: curve));

                            return SlideTransition(
                              position: animation.drive(tween),
                              child: child,
                            );
                          },
                        ),
                      );
                    },
                    child: Container(
                      width: 110,
                      padding: const EdgeInsets.fromLTRB(10, 4, 10, 4),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        color: colorPrimaryDark,
                        borderRadius: BorderRadius.circular(4),
                      ),
                      child: MyText(
                          color: white,
                          text: "upgrade_now",
                          multilanguage: true,
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ))
              ],
            )),
            MyImage(
              width: 100,
              height: 111,
              imagePath: "tr_image.png",
              fit: BoxFit.fill,
            )
          ],
        ),
      );
    } else {
      return SizedBox.shrink();
    }
  }
}
