import 'package:prakah/pages/nodata.dart';
import 'package:prakah/pages/readbook.dart';
import 'package:prakah/provider/transcationlistprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class MyPurchasesBook extends StatefulWidget {
  const MyPurchasesBook({super.key});

  @override
  State<MyPurchasesBook> createState() => _MyPurchasesBookState();
}

class _MyPurchasesBookState extends State<MyPurchasesBook> {
  TransactionListProvider transactionListProvider = TransactionListProvider();
  ScrollController scrollController = ScrollController();
  @override
  void initState() {
    super.initState();
    transactionListProvider =
        Provider.of<TransactionListProvider>(context, listen: false);

    scrollController.addListener(_scrollListener);

    getApiData(0);
  }

  void _scrollListener() {
    if (!scrollController.hasClients) return;
    if (scrollController.offset >= scrollController.position.maxScrollExtent &&
        !scrollController.position.outOfRange &&
        (transactionListProvider.currentPage ?? 0) <
            (transactionListProvider.totalPage ?? 0)) {
      printLog("-----?? api call page 2 ");
      transactionListProvider.setLoadMore(true);

      getApiData(transactionListProvider.currentPage ?? 0);
    }
  }

  Future<void> getApiData(int? pageno) async {
    await transactionListProvider.getSectionList("4", (pageno ?? 0) + 1);
  }

  @override
  void dispose() {
    scrollController.dispose();
    transactionListProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          context: context,
          appBarTitle: "my_purchases",
          multilanguage: true,
          editType: "1"),
      body: _buildMain(),
    );
  }

  Widget _buildMain() {
    return Consumer<TransactionListProvider>(
      builder: (context, transactionListProvider, child) {
        if (transactionListProvider.loading &&
            !transactionListProvider.loadMore) {
          return shimmer();
        } else {
          if (transactionListProvider.histroyList != null &&
              (transactionListProvider.histroyList?.length ?? 0) > 0) {
            return SingleChildScrollView(
                controller: scrollController,
                padding: EdgeInsets.fromLTRB(14, 0, 14, 0),
                physics: const AlwaysScrollableScrollPhysics(),
                clipBehavior: Clip.antiAlias,
                child: Column(
                  children: [
                    _buildBookTr(),
                    const SizedBox(height: 10),
                    if (transactionListProvider.loadMore)
                      Utils.pageLoader()
                    else
                      const SizedBox.shrink(),
                    const SizedBox(height: 30),
                  ],
                ));
          } else {
            return const NoData();
          }
        }
      },
    );
  }

  Widget _buildBookTr() {
    return ResponsiveGridList(
        minItemWidth: 120,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        verticalGridMargin: 20,
        horizontalGridMargin: 10,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          transactionListProvider.histroyList?.length ?? 0,
          (index) {
            final trans = transactionListProvider.histroyList?[index];

            return InkWell(
              onTap: () {
                if (Utils.checkLoginUser(context)) {
                  AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                      () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            ReadBook(
                          bookId: trans?.contentId.toString() ?? "",
                          bookName: trans?.bookName.toString() ?? "",
                          pdfURL: trans?.bookUrl.toString() ?? "",
                        ),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  });
                }
              },
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 10,
                children: [
                  MyNetworkImage(
                      imgHeight: 200,
                      imgWidth: MediaQuery.sizeOf(context).width,
                      radius: 10,
                      imageUrl: trans?.bookImage ?? "",
                      fit: BoxFit.cover),
                  MyText(
                    text: trans?.bookName ?? "",
                    multilanguage: false,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    fontsizeNormal: Dimens.textMedium,
                    color: black,
                    fontwaight: FontWeight.w600,
                  ),
                ],
              ),
            );
          },
        ));
  }

  Widget shimmer() {
    return ResponsiveGridList(
        minItemWidth: 120,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        verticalGridMargin: 20,
        horizontalGridMargin: 10,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
            padding: EdgeInsets.zero,
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 4,
              children: [
                CustomWidget.roundcorner(
                  height: 200,
                  width: MediaQuery.sizeOf(context).width,
                ),
                CustomWidget.roundcorner(
                    height: 14, width: MediaQuery.sizeOf(context).width),
                CustomWidget.roundcorner(
                    height: 14, width: MediaQuery.sizeOf(context).width),
              ],
            );
          },
        ));
  }
}
