import 'package:prakah/pages/coupon.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/cartprovider.dart';
import 'package:prakah/provider/coursedetailsprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:flutter_slidable/flutter_slidable.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class MyCart extends StatefulWidget {
  const MyCart({super.key});

  @override
  State<MyCart> createState() => _MyCartState();
}

class _MyCartState extends State<MyCart> {
  CartProvider cartProvider = CartProvider();

  String? discountPrice, price, promocodeId, promocodeName = "";
  @override
  void initState() {
    super.initState();
    cartProvider = Provider.of<CartProvider>(context, listen: false);

    getApi();
  }

  Future<void> getApi() async {
    await cartProvider.getUseMeeting();
  }

  @override
  void dispose() {
    cartProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "my_cart",
          multilanguage: true),
      body: Consumer<CartProvider>(builder: (context, cartProvider, child) {
        if (cartProvider.loading) {
          return _myCartShimmer();
        } else {
          if (cartProvider.cartModel.status == 200 &&
              (cartProvider.cartModel.result?.length ?? 0) > 0) {
            return SafeArea(
              child: Padding(
                padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                child: Column(
                  children: [
                    Expanded(
                      child: SingleChildScrollView(
                        physics: const AlwaysScrollableScrollPhysics(),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          spacing: 20,
                          children: [
                            _buildMain(),
                            _couponeShowdata(),
                            MyText(
                              text: 'payment_summary',
                              multilanguage: true,
                              maxline: 1,
                              overflow: TextOverflow.ellipsis,
                              fontsizeNormal: Dimens.textBig,
                              color: black,
                              fontwaight: FontWeight.w500,
                            ),
                            paymentSummaryData(),
                          ],
                        ),
                      ),
                    ),
                    _buildButton()
                  ],
                ),
              ),
            );
          } else {
            return NoData();
          }
        }
      }),
    );
  }

  Widget _buildMain() {
    return _buildData();
  }

  Widget _buildData() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        horizontalGridMargin: 0,
        verticalGridMargin: 0,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            physics: BouncingScrollPhysics(),
            padding: EdgeInsets.zero),
        children: List.generate(
          cartProvider.cartModel.result?.length ?? 0,
          (index) {
            final cartListData = cartProvider.cartModel.result?[index];
            return Slidable(
              endActionPane: ActionPane(
                dragDismissible: true,
                motion: ScrollMotion(),
                children: [
                  SlidableAction(
                    borderRadius: BorderRadius.only(
                        bottomRight: Radius.circular(10),
                        topRight: Radius.circular(10)),
                    onPressed: (context) async {
                      await cartProvider.getRemoveCart(
                          index, cartListData?.courseId.toString() ?? "");

                      /* APi call */
                      if (!context.mounted) return;
                      final detailsProvider =
                          Provider.of<CourseDetailsProvider>(context,
                              listen: false);

                      detailsProvider.getAddToCart(
                          cartListData?.courseId.toString() ?? "");
                    },
                    backgroundColor: red,
                    foregroundColor: white,
                    icon: Icons.delete,
                    label: Locales.string(context, 'remove'),
                  ),
                ],
              ),
              child: Container(
                padding:
                    const EdgeInsets.symmetric(horizontal: 10, vertical: 12),
                decoration: BoxDecoration(
                    boxShadow: [
                      BoxShadow(
                          blurRadius: 3,
                          color: colorPrimaryDark.withValues(alpha: .3))
                    ],
                    border: Border.all(
                        width: 1,
                        color: colorPrimaryDark.withValues(alpha: .3),
                        style: BorderStyle.solid),
                    color: white,
                    borderRadius: BorderRadius.only(
                        bottomLeft: Radius.circular(10),
                        topLeft: Radius.circular(10))),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    MyNetworkImage(
                      imgWidth: 120,
                      imgHeight: 100,
                      imageUrl: cartListData?.courseImage ?? "",
                      fit: BoxFit.cover,
                      radius: 10,
                    ),
                    const SizedBox(width: 15),
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          MyText(
                            text: cartListData?.courseTitle ?? "",
                            multilanguage: false,
                            maxline: 2,
                            overflow: TextOverflow.ellipsis,
                            fontsizeNormal: Dimens.textMedium,
                            color: black,
                            fontwaight: FontWeight.w600,
                          ),
                          const SizedBox(height: 5),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            spacing: 4,
                            children: [
                              MyRating(
                                  rating: double.parse(
                                      cartListData?.courseAvgRating ?? ""),
                                  spacing: 5,
                                  size: 15),
                              MyText(
                                  color: colorAccent,
                                  text: cartListData?.courseAvgRating
                                          .toString() ??
                                      "",
                                  fontsizeNormal: Dimens.textMedium,
                                  fontwaight: FontWeight.w600,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                            ],
                          ),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              ((cartListData?.totalVideoDuration.toString() ??
                                          "") ==
                                      "0")
                                  ? SizedBox.shrink()
                                  : Flexible(
                                      fit: FlexFit.loose,
                                      child: MyText(
                                        text: Utils.formatDuration(double.parse(
                                            cartListData?.totalVideoDuration
                                                    .toString() ??
                                                "")),
                                        multilanguage: false,
                                        maxline: 1,
                                        overflow: TextOverflow.ellipsis,
                                        fontsizeNormal: Dimens.textSmall,
                                        color: gray,
                                        fontwaight: FontWeight.w500,
                                      ),
                                    ),
                              ((cartListData?.totalVideoDuration.toString() ??
                                          "") ==
                                      "0")
                                  ? SizedBox.shrink()
                                  : SizedBox(width: 10),
                              ((cartListData?.totalVideoDuration.toString() ??
                                          "") ==
                                      "0")
                                  ? SizedBox.shrink()
                                  : Container(
                                      height: 5,
                                      width: 5,
                                      decoration: const BoxDecoration(
                                          color: gray, shape: BoxShape.circle),
                                    ),
                              ((cartListData?.totalVideoDuration.toString() ??
                                          "") ==
                                      "0")
                                  ? SizedBox.shrink()
                                  : SizedBox(width: 4),
                              Flexible(
                                fit: FlexFit.loose,
                                child: MyText(
                                  text:
                                      '${Utils.kmbGenerator(cartListData?.totalChapter ?? 0)} lectures.',
                                  multilanguage: false,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  fontsizeNormal: Dimens.textSmall,
                                  color: gray,
                                  fontwaight: FontWeight.w500,
                                ),
                              ),
                            ],
                          ),
                          MyText(
                            text:
                                '${Constant.currencyCode} ${cartListData?.price.toString() ?? ""}',
                            multilanguage: false,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            fontsizeNormal: Dimens.textTitle,
                            color: colorPrimaryDark,
                            fontwaight: FontWeight.w500,
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            );
          },
        ));
  }

  Widget _myCartShimmer() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        horizontalGridMargin: 15,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            physics: BouncingScrollPhysics(),
            padding: EdgeInsets.zero),
        children: List.generate(
          5,
          (index) {
            return Container(
              padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 12),
              decoration: BoxDecoration(
                  boxShadow: [
                    BoxShadow(
                        blurRadius: 3,
                        color: colorPrimaryDark.withValues(alpha: .3))
                  ],
                  border: Border.all(
                      width: 1,
                      color: colorPrimaryDark.withValues(alpha: .3),
                      style: BorderStyle.solid),
                  color: white,
                  borderRadius: BorderRadius.only(
                      bottomLeft: Radius.circular(10),
                      topLeft: Radius.circular(10))),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  CustomWidget.roundcorner(height: 100, width: 120),
                  const SizedBox(width: 15),
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        CustomWidget.roundcorner(height: 16, width: 120),
                        const SizedBox(height: 5),
                        CustomWidget.roundcorner(height: 14, width: 120),
                        Row(
                          spacing: 4,
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            Expanded(
                              child: CustomWidget.roundcorner(
                                  height: 16, width: 120),
                            ),
                            Container(
                              height: 5,
                              width: 5,
                              decoration: const BoxDecoration(
                                  color: gray, shape: BoxShape.circle),
                            ),
                            Expanded(
                              child: CustomWidget.roundcorner(
                                  height: 16, width: 120),
                            ),
                          ],
                        ),
                        CustomWidget.roundcorner(height: 16, width: 60),
                      ],
                    ),
                  ),
                ],
              ),
            );
          },
        ));
  }

/* coupone apply code ui show or not */
  Widget _couponeShowdata() {
    if ((promocodeName ?? "").isEmpty) {
      return SizedBox.shrink();
    } else {
      return Container(
        padding: EdgeInsets.fromLTRB(15, 10, 15, 10),
        decoration: BoxDecoration(
            color: white,
            borderRadius: BorderRadius.circular(16),
            boxShadow: [
              BoxShadow(
                  blurRadius: 4,
                  blurStyle: BlurStyle.outer,
                  offset: Offset(0, 4),
                  spreadRadius: 0,
                  color: transparent.withValues(alpha: 0.25))
            ]),
        child: Row(
          spacing: 10,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            Icon(Icons.discount, size: 20, color: colorPrimary),
            Expanded(
              child: MyText(
                text: promocodeName ?? "",
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textBig,
                color: colorPrimary,
                fontwaight: FontWeight.w500,
              ),
            ),
            InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              highlightColor: transparent,
              onTap: () async {
                await cartProvider
                    .getRemoveCoupone(cartProvider.priceItem.toString());

                if (cartProvider.applyCouponModel.status == 200) {
                  discountPrice = cartProvider
                      .applyCouponModel.result?[0].discountAmount
                      .toString();
                  price =
                      cartProvider.applyCouponModel.result?[0].price.toString();

                  promocodeName = "";
                  promocodeId = "0";
                } else {
                  if (!mounted) return;

                  Utils.showSnackbar(context, "fail",
                      cartProvider.applyCouponModel.message ?? "", false);
                }
              },
              child: Container(
                height: 24,
                width: 24,
                alignment: Alignment.center,
                decoration: BoxDecoration(
                    color: colorPrimary.withValues(alpha: 0.3),
                    shape: BoxShape.circle),
                child: Icon(
                  Icons.remove,
                  size: 20,
                  color: colorPrimaryDark,
                ),
              ),
            )
          ],
        ),
      );
    }
  }

  /* PaymentSummary Data */

  Widget paymentSummaryData() {
    return Container(
      width: MediaQuery.sizeOf(context).width,
      padding: const EdgeInsets.fromLTRB(15, 15, 25, 15),
      decoration: BoxDecoration(
        color: white,
        border: Border.all(
            width: 1,
            color: colorPrimary.withValues(alpha: 0.4),
            style: BorderStyle.solid),
        borderRadius: BorderRadius.circular(10),
      ),
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'item_total',
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text: '${Constant.currencyCode} ${cartProvider.priceItem}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: colorPrimaryDark,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          const SizedBox(height: 10),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'taxes_fee',
                decoration: TextDecoration.underline,
                decorationStyle: TextDecorationStyle.dotted,
                decorationColor: black,
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text: '${Constant.currencyCode} ${discountPrice ?? "0"}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: colorPrimaryDark,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          Divider(
            thickness: 1,
            height: 20,
            color: gray.withValues(alpha: .8),
          ),
          const SizedBox(height: 10),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'total_price',
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text:
                    '${Constant.currencyCode} ${price ?? "${cartProvider.priceItem}"}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: colorPrimaryDark,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
        ],
      ),
    );
  }

/* Btn show */
  Widget _buildButton() {
    return Row(
      spacing: 20,
      children: [
        Expanded(
          child: _btnWidget(
              color: colorPrimaryDark,
              textColor: white,
              borderColor: colorPrimaryDark,
              onTap: () {
                String? newPrice, newDiscount;
                if (Utils.checkLoginUser(context)) {
                  if (price == null || price!.isEmpty) {
                    newPrice = cartProvider.priceItem.toString();
                  } else {
                    newPrice = price;
                  }
                  if (discountPrice == null || discountPrice!.isEmpty) {
                    newDiscount = discountPrice?.toString() ?? "0";
                  } else {
                    newDiscount = discountPrice;
                  }
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          AllPayment(
                        payType: "cart",
                        cartType: "1",
                        price: newPrice,
                        discountPrice: newDiscount ?? "0",
                        promoCodeId: promocodeId ?? "0",
                      ),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                  );
                }
              },
              title: "check_out"),
        ),
        Expanded(
          child: _btnWidget(
              color: white,
              borderColor: colorPrimaryDark,
              textColor: colorPrimaryDark,
              onTap: () async {
                if (Utils.checkLoginUser(context)) {
                  var result = await Navigator.of(context).push(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          Coupon(
                        price: cartProvider.priceItem,
                      ),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                  );
                  if (result != null) {
                    discountPrice = result['discount_price'];
                    price = result["price"];
                    promocodeName = result['promocodeName'];
                    promocodeId = result["promocodeId"];
                    printLog(
                        "$discountPrice, $price, $promocodeId, $promocodeName");
                  }
                  cartProvider.providerNoti();
                }
              },
              title: "add_coupon"),
        )
      ],
    );
  }

  Widget _btnWidget({String? title, textColor, color, borderColor, onTap}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.fromLTRB(20, 12, 20, 12),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: borderColor, style: BorderStyle.solid),
            color: color,
            borderRadius: BorderRadius.circular(36)),
        child: MyText(
          text: title ?? "",
          multilanguage: true,
          color: textColor,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textMedium,
          fontwaight: FontWeight.w600,
        ),
      ),
    );
  }
}
