import 'package:prakah/pages/verifyotp.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:intl_phone_field/country_picker_dialog.dart';
import 'package:intl_phone_field/intl_phone_field.dart';

class MobileLogin extends StatefulWidget {
  const MobileLogin({super.key});

  @override
  State<MobileLogin> createState() => MobileLoginState();
}

class MobileLoginState extends State<MobileLogin> {
  TextEditingController numberController = TextEditingController();
  String mobilenumber = "", countrycode = "", countryname = "";

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          image: DecorationImage(
              image: AssetImage("assets/images/login_bg.png"),
              fit: BoxFit.fill)),
      child: Scaffold(
        backgroundColor: transparent,
        appBar: AppBar(
          backgroundColor: transparent,
          systemOverlayStyle: SystemUiOverlayStyle(
            statusBarColor: transparent,
            systemNavigationBarColor: transparent,
          ),
          leading: InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              Navigator.of(context).pop();
            },
            child: const Icon(
              Icons.arrow_back_outlined,
              size: 20,
              color: white,
            ),
          ),
        ),
        body: Container(
          height: MediaQuery.sizeOf(context).height,
          width: MediaQuery.sizeOf(context).width,
          margin: EdgeInsets.only(top: 120),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(30), topRight: Radius.circular(30))),
          child: SingleChildScrollView(
            scrollDirection: Axis.vertical,
            physics: const BouncingScrollPhysics(),
            padding: EdgeInsets.fromLTRB(15, 50, 15, 30),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                    color: colorPrimaryDark,
                    text: "enteryourmobile",
                    fontsizeNormal: Dimens.textExtraBig,
                    fontwaight: FontWeight.w700,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    multilanguage: true,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 15),
                MyText(
                    color: colorPrimaryDark,
                    text: "youwillreceive6digitcode",
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w400,
                    maxline: 2,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal,
                    multilanguage: true),
                const SizedBox(height: 30),
                numberTextField(),
                const SizedBox(height: 50),
                sendOTP(),
                const SizedBox(height: 40),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget numberTextField() {
    return IntlPhoneField(
      disableLengthCheck: true,
      textAlignVertical: TextAlignVertical.center,
      cursorColor: black,
      autovalidateMode: AutovalidateMode.disabled,
      controller: numberController,
      pickerDialogStyle: PickerDialogStyle(backgroundColor: white),
      style: GoogleFonts.inter(
          fontSize: Dimens.textMedium,
          fontStyle: FontStyle.normal,
          color: black,
          letterSpacing: 1.0,
          fontWeight: FontWeight.w600),
      showCountryFlag: true,
      showDropdownIcon: false,
      initialCountryCode: Constant.initialCountryCode,
      dropdownTextStyle: GoogleFonts.inter(
          fontSize: Dimens.textMedium,
          fontStyle: FontStyle.normal,
          letterSpacing: 1.0,
          color: gray,
          fontWeight: FontWeight.w400),
      keyboardType: TextInputType.number,
      textInputAction: TextInputAction.next,
      decoration: InputDecoration(
        focusedBorder: OutlineInputBorder(
          borderRadius: const BorderRadius.all(Radius.circular(7)),
          borderSide:
              BorderSide(width: 1, color: gray, style: BorderStyle.solid),
        ),
        disabledBorder: OutlineInputBorder(
          borderRadius: const BorderRadius.all(Radius.circular(7)),
          borderSide:
              BorderSide(width: 1, color: gray, style: BorderStyle.solid),
        ),
        enabledBorder: OutlineInputBorder(
          borderRadius: const BorderRadius.all(Radius.circular(7)),
          borderSide:
              BorderSide(width: 1, color: gray, style: BorderStyle.solid),
        ),
        border: OutlineInputBorder(
          borderRadius: const BorderRadius.all(Radius.circular(7)),
          borderSide:
              BorderSide(width: 1, color: gray, style: BorderStyle.solid),
        ),
        hintText: "Enter the Phone number",
        hintStyle: GoogleFonts.inter(
            fontSize: Dimens.textMedium,
            fontStyle: FontStyle.normal,
            letterSpacing: 1.0,
            color: gray,
            fontWeight: FontWeight.w600),
      ),
      onChanged: (phone) {
        mobilenumber = phone.completeNumber;
        countryname = phone.countryISOCode;
        countrycode = phone.countryCode;
      },
      onCountryChanged: (country) {
        countryname = country.code.replaceAll('+', '');
        countrycode = "+${country.dialCode.toString()}";
      },
    );
  }

  Widget sendOTP() {
    return InkWell(
      onTap: () {
        if (numberController.text.isEmpty) {
          Utils().showToast("Please Enter Your Mobile Number");
        } else {
          Navigator.of(context).push(
            PageRouteBuilder(
              transitionDuration: const Duration(milliseconds: 200),
              pageBuilder: (BuildContext context, Animation<double> animation,
                  Animation<double> secondaryAnimation) {
                return VerifyOtp(
                  fullnumber: mobilenumber,
                  countrycode: countrycode,
                  countryName: countryname,
                  number: numberController.text,
                );
              },
              transitionsBuilder: (BuildContext context,
                  Animation<double> animation,
                  Animation<double> secondaryAnimation,
                  Widget child) {
                return Align(
                  child: FadeTransition(
                    opacity: animation,
                    child: child,
                  ),
                );
              },
            ),
          );
        }
      },
      child: Container(
        width: MediaQuery.of(context).size.width,
        height: 45,
        alignment: Alignment.center,
        decoration: BoxDecoration(
          color: colorPrimaryDark,
          borderRadius: BorderRadius.circular(45),
        ),
        child: MyText(
            color: white,
            text: "sendotp",
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
            multilanguage: true),
      ),
    );
  }
}
