import 'package:prakah/players/player_video.dart';
import 'package:prakah/provider/viewdetailsprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';

class MeetingDetails extends StatefulWidget {
  final String? appointmentId;
  const MeetingDetails({super.key, required this.appointmentId});

  @override
  State<MeetingDetails> createState() => _MeetingDetailsState();
}

class _MeetingDetailsState extends State<MeetingDetails> {
  ViewDetailsProvider viewDetailsProvider = ViewDetailsProvider();

  @override
  void initState() {
    super.initState();

    viewDetailsProvider =
        Provider.of<ViewDetailsProvider>(context, listen: false);
    getApi();
  }

  Future getApi() async {
    await viewDetailsProvider.getViewSession(widget.appointmentId ?? "");
  }

  @override
  void dispose() {
    viewDetailsProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "view_details",
          multilanguage: true),
      body: Consumer<ViewDetailsProvider>(
          builder: (context, meetingProvider, child) {
        return SingleChildScrollView(
          padding: EdgeInsets.fromLTRB(15, 10, 15, 10),
          physics: AlwaysScrollableScrollPhysics(),
          child: Stack(
            children: [
              SizedBox(
                height: MediaQuery.sizeOf(context).height,
                child: Column(
                  spacing: 20,
                  children: [
                    _details(),
                    _seeNoteData(),
                    _downloadSessions(),
                  ],
                ),
              ),
              Positioned(
                top: 350,
                left: 10,
                right: 10,
                child: Stack(
                  alignment: Alignment.center,
                  children: [
                    MyImage(
                      width: MediaQuery.sizeOf(context).width,
                      height: 80,
                      imagePath: "download_session.png",
                      fit: BoxFit.fill,
                    ),
                    MyText(
                      text: "Download  Sessions",
                      multilanguage: false,
                      color: white,
                      fontsizeNormal: Dimens.textBig,
                      fontsizeWeb: Dimens.textBig,
                      fontwaight: FontWeight.w600,
                    ),
                  ],
                ),
              ),
            ],
          ),
        );
      }),
    );
  }

  Widget _details() {
    if (viewDetailsProvider.viewSessionLoading) {
      return userMeetinDetailShimmer();
    } else {
      if (viewDetailsProvider.viewSessionModel.status == 200 &&
          (viewDetailsProvider.viewSessionModel.result?.length ?? 0) > 0) {
        final detailsData = viewDetailsProvider.viewSessionModel.result?[0];
        return Card(
          color: white,
          elevation: 10,
          shadowColor: transparent.withValues(alpha: 0.3),
          child: Padding(
            padding: const EdgeInsets.fromLTRB(14, 12, 14, 12),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 14,
              children: [
                Row(
                  spacing: 14,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Container(
                      padding: EdgeInsets.all(4),
                      decoration: BoxDecoration(
                          shape: BoxShape.circle,
                          border: Border.all(
                              width: 1,
                              color: colorPrimaryDark,
                              style: BorderStyle.solid)),
                      child: MyNetworkImage(
                          radius: 50,
                          imgHeight: 80,
                          imgWidth: 80,
                          imageUrl: detailsData?.lecturerImage ?? "",
                          fit: BoxFit.fill),
                    ),
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        spacing: 6,
                        children: [
                          MyText(
                            text: detailsData?.lecturerName ?? "",
                            multilanguage: false,
                            color: black,
                            fontsizeNormal: Dimens.textTitle,
                            fontsizeWeb: Dimens.textBig,
                            fontwaight: FontWeight.w600,
                          ),
                          Row(
                            spacing: 4,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              Flexible(
                                fit: FlexFit.loose,
                                child: MyText(
                                  text: detailsData?.courseTitle ?? "",
                                  multilanguage: false,
                                  maxline: 1,
                                  color: black,
                                  fontsizeNormal: Dimens.textMedium,
                                  fontsizeWeb: Dimens.textBig,
                                  fontwaight: FontWeight.w400,
                                ),
                              ),
                              Container(
                                height: 4,
                                width: 4,
                                color: gray,
                              ),
                              Flexible(
                                fit: FlexFit.loose,
                                child: MyText(
                                  text: detailsData?.date ?? "",
                                  multilanguage: false,
                                  maxline: 1,
                                  color: black,
                                  fontsizeNormal: Dimens.textMedium,
                                  fontsizeWeb: Dimens.textBig,
                                  fontwaight: FontWeight.w400,
                                ),
                              ),
                            ],
                          ),
                          Row(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.start,
                            spacing: 4,
                            children: [
                              Container(
                                padding: EdgeInsets.fromLTRB(6, 4, 6, 4),
                                decoration: BoxDecoration(
                                    color: green.withValues(alpha: 0.3),
                                    borderRadius: BorderRadius.circular(8)),
                                child: MyText(
                                  text: "completed",
                                  multilanguage: true,
                                  color: green,
                                  fontsizeNormal: Dimens.textSmall,
                                  fontsizeWeb: Dimens.textBig,
                                  fontwaight: FontWeight.w600,
                                ),
                              ),
                              Flexible(
                                fit: FlexFit.loose,
                                child: MyText(
                                  maxline: 1,
                                  text: Utils.formateTime(
                                      staTime: detailsData?.startTime ?? "",
                                      enTime: detailsData?.endTime ?? ""),
                                  multilanguage: false,
                                  color: black,
                                  fontsizeNormal: Dimens.textSmall,
                                  fontsizeWeb: Dimens.textBig,
                                  fontwaight: FontWeight.w400,
                                ),
                              ),
                            ],
                          ),
                        ],
                      ),
                    ),
                    MyText(
                      text:
                          "${Constant.currencyCode} ${detailsData?.totalPrice ?? ""}",
                      multilanguage: false,
                      color: colorPrimaryDark,
                      fontsizeNormal: Dimens.textBig,
                      fontsizeWeb: Dimens.textBig,
                      fontwaight: FontWeight.w600,
                    ),
                  ],
                ),
              ],
            ),
          ),
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget userMeetinDetailShimmer() {
    return Container(
      padding: EdgeInsets.all(16),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(16),
          boxShadow: [
            BoxShadow(
                blurRadius: 4,
                blurStyle: BlurStyle.solid,
                color: transparent.withValues(alpha: 0.25),
                offset: Offset(0, 4),
                spreadRadius: 0)
          ]),
      child: Card(
        color: white,
        elevation: 10,
        shadowColor: transparent.withValues(alpha: 0.3),
        child: Padding(
          padding: const EdgeInsets.fromLTRB(14, 12, 14, 12),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 14,
            children: [
              Row(
                spacing: 14,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                      padding: EdgeInsets.all(4),
                      decoration: BoxDecoration(
                          shape: BoxShape.circle,
                          border: Border.all(
                              width: 1,
                              color: colorPrimaryDark,
                              style: BorderStyle.solid)),
                      child: CustomWidget.circular(height: 60, width: 60)),
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      spacing: 6,
                      children: [
                        CustomWidget.roundcorner(height: 16, width: 200),
                        Row(
                          spacing: 4,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            Flexible(
                              fit: FlexFit.loose,
                              child: CustomWidget.roundcorner(
                                  height: 12, width: 200),
                            ),
                            Container(
                              height: 4,
                              width: 4,
                              color: gray,
                            ),
                            Flexible(
                              fit: FlexFit.loose,
                              child: CustomWidget.roundcorner(
                                  height: 12, width: 200),
                            ),
                          ],
                        ),
                        Row(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          spacing: 4,
                          children: [
                            Container(
                              padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                              decoration: BoxDecoration(
                                  color: green.withValues(alpha: 0.3),
                                  borderRadius: BorderRadius.circular(8)),
                              child: MyText(
                                text: "completed",
                                multilanguage: true,
                                color: green,
                                fontsizeNormal: Dimens.textSmall,
                                fontsizeWeb: Dimens.textBig,
                                fontwaight: FontWeight.w600,
                              ),
                            ),
                            Flexible(
                              fit: FlexFit.loose,
                              child: CustomWidget.roundcorner(
                                  height: 12, width: 200),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget _seeNoteData() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: () {
        if ((viewDetailsProvider.viewSessionModel.result?[0].recordingUrl ??
                "") !=
            "") {
          Navigator.of(context).pushReplacement(
            PageRouteBuilder(
              pageBuilder: (context, animation, secondaryAnimation) =>
                  PlayerVideo(
                viewDetailsProvider.viewSessionModel.result?[0].id ?? 0,
                viewDetailsProvider.viewSessionModel.result?[0].recordingUrl ??
                    "",
                "",
                0,
                viewDetailsProvider.viewSessionModel.result?[0].courseImage ??
                    "",
                0,
                "video",
                "",
                2,
              ),
              transitionsBuilder:
                  (context, animation, secondaryAnimation, child) {
                const begin = Offset(1.0, 0.0);
                const end = Offset.zero;
                const curve = Curves.ease;

                var tween = Tween(begin: begin, end: end)
                    .chain(CurveTween(curve: curve));

                return SlideTransition(
                  position: animation.drive(tween),
                  child: child,
                );
              },
            ),
          );
        } else {
          Utils.showSnackbar(context, "", "no video", false);
        }
      },
      child: Card(
        color: white,
        elevation: 10,
        shadowColor: transparent.withValues(alpha: 0.3),
        child: Padding(
          padding: const EdgeInsets.fromLTRB(14, 12, 14, 12),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            spacing: 10,
            children: [
              Expanded(
                child: MyText(
                  text: "see_notes",
                  multilanguage: true,
                  color: black,
                  fontsizeNormal: Dimens.textMedium,
                  fontsizeWeb: Dimens.textBig,
                  fontwaight: FontWeight.w600,
                ),
              ),
              Icon(Icons.visibility, size: 20, color: black),
            ],
          ),
        ),
      ),
    );
  }

  Widget _downloadSessions() {
    return Stack(
      children: [
        Container(
          padding: EdgeInsets.fromLTRB(16, 16, 16, 23),
          decoration: BoxDecoration(
              color: colorPrimary.withValues(alpha: 0.6),
              borderRadius: BorderRadius.circular(10)),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisSize: MainAxisSize.min,
            children: [
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    MyText(
                      text: "Download Recorded Sessions",
                      multilanguage: false,
                      maxline: 2,
                      color: colorPrimaryDark,
                      fontsizeNormal: Dimens.textExtraBig,
                      fontsizeWeb: Dimens.textBig,
                      fontwaight: FontWeight.w600,
                    ),
                    RichText(
                      text: TextSpan(
                        text: 'Sent you by  ',
                        style: GoogleFonts.lato(
                            fontSize: Dimens.textMedium,
                            color: black,
                            fontWeight: FontWeight.w400),
                        children: <TextSpan>[
                          TextSpan(
                              text:
                                  '${viewDetailsProvider.viewSessionModel.result?[0].lecturerName ?? ""},  ',
                              style: GoogleFonts.lato(
                                  fontSize: Dimens.textMedium,
                                  color: black,
                                  fontWeight: FontWeight.w600)),
                          TextSpan(
                            text: 'your last Meeting  session Recording',
                            style: GoogleFonts.lato(
                                fontSize: Dimens.textMedium,
                                color: black,
                                fontWeight: FontWeight.w400),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
              MyImage(
                width: 120,
                height: 120,
                imagePath: "download_re_se.png",
                fit: BoxFit.cover,
              ),
            ],
          ),
        ),
      ],
    );
  }
}
