import 'package:prakah/pages/appoinmentbooking.dart';
import 'package:prakah/pages/feedbacksession.dart';
import 'package:prakah/pages/meetingdetails.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/meetingprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:easy_date_timeline/easy_date_timeline.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class Meeting extends StatefulWidget {
  final String? selectedTab;
  const Meeting({super.key, required this.selectedTab});

  @override
  State<Meeting> createState() => _Meetingstate();
}

class _Meetingstate extends State<Meeting> {
  MeetingProvider meetingProvider = MeetingProvider();
  final ScrollController _scrollController = ScrollController();

  @override
  void initState() {
    super.initState();
    meetingProvider = Provider.of<MeetingProvider>(context, listen: false);
    _scrollController.addListener(_scrollListener);

    meetingProvider.selectedIndex = widget.selectedTab ?? "";

    getApi();
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (meetingProvider.currentPage ?? 0) < (meetingProvider.totalPage ?? 0)) {
      meetingProvider.setLoadMore(true);
      if (meetingProvider.selectedIndex == "1") {
        _fetchMeetingData(
            meetingProvider.courseId ?? "", meetingProvider.currentPage ?? 0);
      } else {
        _fetchData(meetingProvider.myTab, meetingProvider.currentPage ?? 0);
      }
    }
  }

  Future<void> getApi() async {
    await Future.wait([
      meetingProvider.getCourseName(),
      _fetchMeetingData(meetingProvider.courseId ?? "", 0),
    ]);
  }

  Future<void> _fetchMeetingData(String ids, int? nextPage) async {
    await meetingProvider.getMeeting(ids, (nextPage ?? 0) + 1);
  }

  Future<void> _fetchData(String status, int? nextPage) async {
    await meetingProvider.getUseMeeting(status, (nextPage ?? 0) + 1);
  }

  Future<void> getTimeSoltApi(String? meetingId, DateTime time) async {
    await meetingProvider.getTimeSlotSelect(meetingId ?? "", time);
  }

  @override
  void dispose() {
    _scrollController.dispose();

    meetingProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body:
          Consumer<MeetingProvider>(builder: (context, meetingProvider, child) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            _appBar(),
            Expanded(child: _buildTabbar()),
          ],
        );
      }),
    );
  }

  Widget _appBar() {
    return Container(
        padding: EdgeInsets.fromLTRB(20, 65, 20, 22),
        decoration: BoxDecoration(
            borderRadius: BorderRadius.only(
                bottomLeft: Radius.circular(16),
                bottomRight: Radius.circular(16)),
            color: colorPrimaryDark),
        child: Column(
          spacing: 14,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              spacing: 10,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  onTap: () {
                    Navigator.of(context).pop();
                  },
                  child: Icon(
                    Icons.arrow_back_outlined,
                    size: 20,
                    color: white,
                  ),
                ),
                MyText(
                  text: "meetings",
                  multilanguage: true,
                  color: white,
                  fontsizeNormal: Dimens.textBig,
                  fontsizeWeb: Dimens.textBig,
                  fontwaight: FontWeight.w600,
                ),
              ],
            ),
            tabData(),
          ],
        ));
  }

  Widget tabData() {
    return Container(
      padding: EdgeInsets.all(12),
      width: MediaQuery.sizeOf(context).width,
      decoration: BoxDecoration(
        color: white,
        borderRadius: BorderRadius.circular(12),
      ),
      child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 20,
          children: [
            Expanded(
              child: _buildTab(
                  title: Locales.string(context, "upcoming"),
                  count: "1",
                  onTap: () {
                    meetingProvider.setTab("1");
                    meetingProvider.clearContent();
                    meetingProvider.setLoading(false);
                    getApi();
                  }),
            ),
            Expanded(
              child: _buildTab(
                  title: Locales.string(context, "my_meeting"),
                  count: "2",
                  onTap: () {
                    meetingProvider.setTab("2");
                    meetingProvider.clearContent();
                    // meetingProvider.setLoading(false);
                    meetingProvider.getMeetingStatus();
                    _fetchData(meetingProvider.myTab, 0);
                  }),
            ),
          ]),
    );
  }

  Widget _buildTab({String? title, onTap, count}) {
    return InkWell(
      focusColor: transparent,
      highlightColor: transparent,
      hoverColor: transparent,
      splashColor: transparent,
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.fromLTRB(25, 10, 25, 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: meetingProvider.selectedIndex == count
              ? colorPrimaryDark
              : transparent,
        ),
        child: MyText(
            color:
                meetingProvider.selectedIndex == count ? white : colorPrimary,
            text: title ?? "",
            multilanguage: false,
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
      ),
    );
  }

  /* Course name */

  Widget _buildTabbar() {
    return Padding(
      padding: EdgeInsets.fromLTRB(20, 10, 20, 0),
      child: meetingProvider.selectedIndex == "1"
          ? Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 20,
              children: [
                courseNameData(),
                Expanded(child: _buildData()),
              ],
            )
          : _buildMyMeeting(),
    );
  }

  Widget courseNameData() {
    if (meetingProvider.courseNameLoading) {
      return SingleChildScrollView(
        padding: EdgeInsets.zero,
        scrollDirection: Axis.horizontal,
        physics: NeverScrollableScrollPhysics(),
        child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            crossAxisAlignment: CrossAxisAlignment.center,
            spacing: 20,
            children: List.generate(
              10,
              (index) {
                return Container(
                  padding: const EdgeInsets.all(10),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    color: transparent,
                  ),
                  child: CustomWidget.roundcorner(
                    height: 14,
                    width: 100,
                  ),
                );
              },
            )),
      );
    } else {
      if (meetingProvider.courseNameModel.status == 200 &&
          (meetingProvider.courseNameModel.result?.length ?? 0) > 0) {
        return SingleChildScrollView(
          physics: BouncingScrollPhysics(),
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          child: Row(
            children: [
              InkWell(
                focusColor: transparent,
                highlightColor: transparent,
                hoverColor: transparent,
                splashColor: transparent,
                onTap: () {
                  meetingProvider.setCourseId("0");

                  meetingProvider.clearMeetingData();
                  meetingProvider.setLoading(false);
                  _fetchMeetingData(meetingProvider.courseId ?? "", 0);
                },
                child: Container(
                  padding: const EdgeInsets.fromLTRB(25, 10, 25, 10),
                  alignment: Alignment.center,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    color: meetingProvider.courseId == "0"
                        ? colorPrimaryDark
                        : transparent,
                  ),
                  child: MyText(
                      color: meetingProvider.courseId == "0"
                          ? white
                          : colorPrimary,
                      text: "all",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ),
              Row(
                children: List.generate(
                  meetingProvider.courseNameModel.result?.length ?? 0,
                  (index) {
                    return InkWell(
                      focusColor: transparent,
                      highlightColor: transparent,
                      hoverColor: transparent,
                      splashColor: transparent,
                      onTap: () async {
                        meetingProvider.setCourseId(meetingProvider
                                .courseNameModel.result?[index].id
                                .toString() ??
                            "");

                        meetingProvider.clearMeetingData();
                        meetingProvider.setLoading(false);
                        await _fetchMeetingData(
                            meetingProvider.courseId ?? "", 0);
                      },
                      child: Container(
                        padding: const EdgeInsets.fromLTRB(10, 6, 10, 6),
                        alignment: Alignment.center,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(10),
                          color: meetingProvider.courseId ==
                                  (meetingProvider
                                          .courseNameModel.result?[index].id
                                          .toString() ??
                                      "")
                              ? colorPrimaryDark
                              : transparent,
                        ),
                        child: MyText(
                            color: meetingProvider.courseId ==
                                    (meetingProvider
                                            .courseNameModel.result?[index].id
                                            .toString() ??
                                        "")
                                ? white
                                : colorPrimary,
                            text: meetingProvider
                                    .courseNameModel.result?[index].title ??
                                "",
                            multilanguage: false,
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ),
                    );
                  },
                ),
              )
            ],
          ),
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }
/* Tutor meeting data */

  Widget _buildData() {
    if (meetingProvider.loading && !meetingProvider.loadMore) {
      return _upcomingShimmer();
    } else {
      if (meetingProvider.meetingList != null &&
          (meetingProvider.meetingList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          physics: AlwaysScrollableScrollPhysics(),
          controller: _scrollController,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              buildUpcommingData(),
              const SizedBox(height: 30),
              if (meetingProvider.loadMore)
                Utils.pageLoader()
              else
                const SizedBox.shrink(),
              const SizedBox(height: 10),
            ],
          ),
        );
      } else {
        return NoData();
      }
    }
  }

  Widget buildUpcommingData() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          meetingProvider.meetingList?.length ?? 0,
          (index) {
            final meetingListData = meetingProvider.meetingList?[index];
            return Card(
              color: white,
              elevation: 10,
              shadowColor: transparent.withValues(alpha: 0.3),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  spacing: 10,
                  children: [
                    Row(
                      spacing: 20,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(
                                  width: 1,
                                  color: colorPrimaryDark,
                                  style: BorderStyle.solid)),
                          child: MyNetworkImage(
                              radius: 50,
                              imgHeight: 80,
                              imgWidth: 80,
                              imageUrl: meetingListData?.lecturerImage ?? "",
                              fit: BoxFit.fill),
                        ),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            spacing: 4,
                            children: [
                              Container(
                                padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                                decoration: BoxDecoration(
                                    color: red.withValues(alpha: 0.2),
                                    borderRadius: BorderRadius.circular(8)),
                                child: Row(
                                  mainAxisSize: MainAxisSize.min,
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  spacing: 4,
                                  children: [
                                    Icon(
                                      Icons.favorite,
                                      size: 14,
                                      color: red,
                                    ),
                                    MyText(
                                      text: meetingListData?.avgRating ?? "",
                                      multilanguage: false,
                                      color: red,
                                      fontsizeNormal: Dimens.textSmall,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w600,
                                    ),
                                  ],
                                ),
                              ),
                              MyText(
                                text: meetingListData?.lecturerName ?? "",
                                multilanguage: false,
                                color: black,
                                maxline: 1,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textBig,
                                fontwaight: FontWeight.w600,
                              ),
                              MyText(
                                text: meetingListData?.title ?? "",
                                multilanguage: false,
                                color: black,
                                maxline: 1,
                                fontsizeNormal: Dimens.textMedium,
                                fontsizeWeb: Dimens.textMedium,
                                fontwaight: FontWeight.w400,
                              ),
                            ],
                          ),
                        ),
                        Container(
                          padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                          decoration: BoxDecoration(
                              color:
                                  (meetingListData?.isFree.toString() ?? "") ==
                                          "0"
                                      ? red
                                      : green,
                              borderRadius: BorderRadius.circular(8)),
                          child: MyText(
                            text: (meetingListData?.isFree.toString() ?? "") ==
                                    "0"
                                ? "paid"
                                : "free",
                            multilanguage: true,
                            color: white,
                            fontsizeNormal: Dimens.textMedium,
                            fontsizeWeb: Dimens.textBig,
                            fontwaight: FontWeight.w600,
                          ),
                        )
                      ],
                    ),
                    (meetingListData?.isFree.toString() ?? "") == "0"
                        ? Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            spacing: 20,
                            children: [
                              MyText(
                                text:
                                    "${Constant.currencyCode} ${meetingListData?.price ?? ""}",
                                multilanguage: false,
                                color: black,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textBig,
                                fontwaight: FontWeight.w600,
                              ),
                              InkWell(
                                onTap: () {
                                  AdHelper.showFullscreenAd(
                                      context, Constant.interstialAdType, () {
                                    Navigator.of(context).push(
                                      PageRouteBuilder(
                                        pageBuilder: (context, animation,
                                                secondaryAnimation) =>
                                            AppoinmentBooking(
                                          price: meetingListData?.price
                                                  .toString() ??
                                              "",
                                          meetingId:
                                              meetingListData?.id.toString() ??
                                                  "",
                                        ),
                                        transitionsBuilder: (context, animation,
                                            secondaryAnimation, child) {
                                          const begin = Offset(1.0, 0.0);
                                          const end = Offset.zero;
                                          const curve = Curves.ease;

                                          var tween = Tween(
                                                  begin: begin, end: end)
                                              .chain(CurveTween(curve: curve));

                                          return SlideTransition(
                                            position: animation.drive(tween),
                                            child: child,
                                          );
                                        },
                                      ),
                                    );
                                  });
                                },
                                child: Container(
                                  padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                                  decoration: BoxDecoration(
                                      color: colorPrimaryDark,
                                      borderRadius: BorderRadius.circular(4)),
                                  child: Row(
                                    mainAxisSize: MainAxisSize.min,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    spacing: 6,
                                    children: [
                                      Icon(
                                        Icons.calendar_month_rounded,
                                        size: 14,
                                        color: white,
                                      ),
                                      MyText(
                                        text: "book_a_session",
                                        multilanguage: true,
                                        color: white,
                                        fontsizeNormal: Dimens.textSmall,
                                        fontsizeWeb: Dimens.textBig,
                                        fontwaight: FontWeight.w600,
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            ],
                          )
                        : _btnWidget(
                            color: colorPrimaryDark,
                            textColor: white,
                            onTap: () {
                              Utils.lanchUrl(
                                  meetingListData?.meetingLink ?? "");
                            },
                            borderColor: colorPrimaryDark,
                            title: "join_now")
                  ],
                ),
              ),
            );
          },
        ));
  }

  Widget _upcomingShimmer() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Card(
              color: white,
              elevation: 10,
              shadowColor: transparent.withValues(alpha: 0.3),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      spacing: 20,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(
                                  width: 1,
                                  color: colorPrimaryDark,
                                  style: BorderStyle.solid)),
                          child: CustomWidget.circular(height: 80, width: 80),
                        ),
                        Expanded(
                          child: Align(
                            alignment: Alignment.bottomCenter,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              spacing: 6,
                              children: [
                                Container(
                                  padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                                  decoration: BoxDecoration(
                                      color: red.withValues(alpha: 0.2),
                                      borderRadius: BorderRadius.circular(8)),
                                  child: Row(
                                    mainAxisSize: MainAxisSize.min,
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    spacing: 4,
                                    children: [
                                      Icon(
                                        Icons.favorite,
                                        size: 14,
                                        color: red,
                                      ),
                                      CustomWidget.roundcorner(
                                          height: 8, width: 20),
                                    ],
                                  ),
                                ),
                                CustomWidget.roundcorner(
                                    height: 14, width: 100),
                                CustomWidget.roundcorner(
                                    height: 12, width: 100),
                              ],
                            ),
                          ),
                        ),
                        Container(
                          padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                          decoration: BoxDecoration(
                              color: green,
                              borderRadius: BorderRadius.circular(8)),
                          child:
                              CustomWidget.roundcorner(height: 20, width: 40),
                        )
                      ],
                    ),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      spacing: 20,
                      children: [
                        CustomWidget.roundcorner(height: 14, width: 100),
                        Container(
                          padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                          decoration: BoxDecoration(
                              color: colorPrimaryDark,
                              borderRadius: BorderRadius.circular(4)),
                          child:
                              CustomWidget.roundcorner(height: 14, width: 100),
                        ),
                      ],
                    )
                  ],
                ),
              ),
            );
          },
        ));
  }

/* My meeting Data */

  Widget _buildMyMeeting() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      spacing: 20,
      children: [myMeetingTab(), Expanded(child: _buildCommanData())],
    );
  }

  Widget myMeetingTab() {
    if (meetingProvider.statusLoading) {
      return Container(
        padding: EdgeInsets.all(12),
        decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(12),
        ),
        child: SingleChildScrollView(
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          physics: NeverScrollableScrollPhysics(),
          child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              crossAxisAlignment: CrossAxisAlignment.center,
              spacing: 20,
              children: List.generate(
                4,
                (index) {
                  return Container(
                    padding: const EdgeInsets.all(10),
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(10),
                      color: transparent,
                    ),
                    child: CustomWidget.roundcorner(
                      height: 14,
                      width: 100,
                    ),
                  );
                },
              )),
        ),
      );
    } else {
      if ((meetingProvider.meetingStatusModel.result?.length ?? 0) > 0) {
        return Container(
          padding: EdgeInsets.all(12),
          width: MediaQuery.sizeOf(context).width,
          decoration: BoxDecoration(
            color: white,
            borderRadius: BorderRadius.circular(12),
          ),
          child: SingleChildScrollView(
            padding: EdgeInsets.zero,
            scrollDirection: Axis.horizontal,
            physics: BouncingScrollPhysics(),
            child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 0,
                children: List.generate(
                  meetingProvider.meetingStatusModel.result?.length ?? 0,
                  (index) {
                    return _buildMyTab(
                        title: meetingProvider
                                .meetingStatusModel.result?[index].name ??
                            "",
                        count: meetingProvider
                                .meetingStatusModel.result?[index].value
                                .toString() ??
                            "",
                        onTap: () {
                          meetingProvider.setMyTab(meetingProvider
                                  .meetingStatusModel.result?[index].value
                                  .toString() ??
                              "");

                          meetingProvider.clearUserMeetingContent();
                          meetingProvider.setLoading(false);
                          _fetchData(
                              meetingProvider
                                      .meetingStatusModel.result?[index].value
                                      .toString() ??
                                  "",
                              0);
                        });
                  },
                )),
          ),
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget _buildMyTab({String? title, onTap, count}) {
    return InkWell(
      borderRadius: BorderRadius.circular(10),
      focusColor: transparent,
      highlightColor: transparent,
      hoverColor: transparent,
      splashColor: transparent,
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.fromLTRB(12, 10, 12, 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color:
              meetingProvider.myTab == count ? colorPrimaryDark : transparent,
        ),
        child: MyText(
            color: meetingProvider.myTab == count ? white : colorPrimary,
            text: title ?? "",
            multilanguage: false,
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w600,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
      ),
    );
  }

/* upcoming data started */

  Widget _buildCommanData() {
    if (meetingProvider.loading && !meetingProvider.loadMore) {
      return _userMeetingShimmer();
    } else {
      if (meetingProvider.userMeetingList != null &&
          (meetingProvider.userMeetingList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          physics: AlwaysScrollableScrollPhysics(),
          controller: _scrollController,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              _commanData(),
              const SizedBox(height: 30),
              if (meetingProvider.loadMore)
                Utils.pageLoader()
              else
                const SizedBox.shrink(),
              const SizedBox(height: 10),
            ],
          ),
        );
      } else {
        return NoData();
      }
    }
  }

  Widget _commanData() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          meetingProvider.userMeetingList?.length ?? 0,
          (index) {
            final meetingListData = meetingProvider.userMeetingList?[index];
            return Card(
              color: white,
              elevation: 10,
              shadowColor: transparent.withValues(alpha: 0.3),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(14, 12, 14, 12),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  spacing: 14,
                  children: [
                    Row(
                      spacing: 14,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(
                                  width: 1,
                                  color: colorPrimaryDark,
                                  style: BorderStyle.solid)),
                          child: MyNetworkImage(
                              radius: 50,
                              imgHeight: 80,
                              imgWidth: 80,
                              imageUrl: meetingListData?.lecturerImage ?? "",
                              fit: BoxFit.fill),
                        ),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            spacing: 6,
                            children: [
                              MyText(
                                text: meetingListData?.lecturerName ?? "",
                                multilanguage: false,
                                color: black,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textBig,
                                fontwaight: FontWeight.w600,
                              ),
                              Row(
                                spacing: 4,
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: MyText(
                                      text: meetingListData?.courseTitle ?? "",
                                      multilanguage: false,
                                      maxline: 1,
                                      color: black,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w400,
                                    ),
                                  ),
                                  Container(
                                    height: 4,
                                    width: 4,
                                    color: gray,
                                  ),
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: MyText(
                                      text: meetingListData?.date ?? "",
                                      multilanguage: false,
                                      maxline: 1,
                                      color: black,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w400,
                                    ),
                                  ),
                                ],
                              ),
                              Row(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.start,
                                spacing: 4,
                                children: [
                                  Container(
                                    padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                                    decoration: BoxDecoration(
                                        color:
                                            _statusColor(meetingProvider.myTab)
                                                .withValues(alpha: 0.3),
                                        borderRadius: BorderRadius.circular(8)),
                                    child: MyText(
                                      text: _statusName(meetingProvider.myTab),
                                      multilanguage: true,
                                      color: _statusTextColor(
                                          meetingProvider.myTab),
                                      fontsizeNormal: Dimens.textSmall,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w600,
                                    ),
                                  ),
                                  Flexible(
                                    fit: FlexFit.loose,
                                    child: MyText(
                                      maxline: 1,
                                      text: Utils.formateTime(
                                          staTime:
                                              meetingListData?.startTime ?? "",
                                          enTime:
                                              meetingListData?.endTime ?? ""),
                                      multilanguage: false,
                                      color: black,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontsizeWeb: Dimens.textBig,
                                      fontwaight: FontWeight.w400,
                                    ),
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ),
                        MyText(
                          text:
                              "${Constant.currencyCode} ${meetingListData?.totalPrice.toString() ?? ""}",
                          multilanguage: false,
                          color: colorPrimaryDark,
                          fontsizeNormal: Dimens.textBig,
                          fontsizeWeb: Dimens.textBig,
                          fontwaight: FontWeight.w600,
                        ),
                      ],
                    ),
                    (meetingProvider.myTab == "1")
                        ? Row(
                            spacing: 20,
                            children: [
                              Expanded(
                                child: _btnWidget(
                                    color: colorPrimaryDark,
                                    textColor: white,
                                    onTap: () {
                                      Utils.lanchUrl(
                                          meetingListData?.joinLinks ?? "");
                                    },
                                    borderColor: colorPrimaryDark,
                                    title: "join_now"),
                              ),
                              Expanded(
                                child: _btnWidget(
                                    color: white,
                                    textColor: colorPrimaryDark,
                                    onTap: () async {
                                      Utils()
                                          .showProgress(context, "Please Wait");
                                      await meetingProvider
                                          .getCancelAppointment(
                                              meetingListData?.id.toString() ??
                                                  "");

                                      if (!mounted) return;
                                      Utils().hideProgress(context);

                                      /* API Call */

                                      meetingProvider.clearUserMeetingContent();
                                      meetingProvider.setMyTab("3");
                                      meetingProvider.getUseMeeting("3", 0);
                                    },
                                    borderColor: colorPrimaryDark,
                                    title: "cancel"),
                              ),
                            ],
                          )
                        : (meetingProvider.myTab == "3")
                            ? _btnWidget(
                                color: colorPrimaryDark,
                                textColor: white,
                                onTap: () async {
                                  meetingProvider.clearTimeSolt();

                                  showDateAndTime(
                                      meetingListData?.mettingId.toString() ??
                                          "",
                                      meetingListData?.id.toString() ?? "");

                                  /* Api Call */

                                  getTimeSoltApi(
                                      meetingListData?.mettingId.toString() ??
                                          "",
                                      meetingProvider.selectedValue);
                                },
                                borderColor: colorPrimaryDark,
                                title: "re_schedule")
                            : Row(
                                spacing: 20,
                                children: [
                                  Expanded(
                                    child: _btnWidget(
                                        color: colorPrimaryDark,
                                        textColor: white,
                                        borderColor: colorPrimaryDark,
                                        onTap: () {
                                          AdHelper.showFullscreenAd(context,
                                              Constant.interstialAdType, () {
                                            Navigator.of(context).push(
                                              PageRouteBuilder(
                                                pageBuilder: (context,
                                                        animation,
                                                        secondaryAnimation) =>
                                                    MeetingDetails(
                                                  appointmentId: meetingListData
                                                          ?.id
                                                          .toString() ??
                                                      "",
                                                ),
                                                transitionsBuilder: (context,
                                                    animation,
                                                    secondaryAnimation,
                                                    child) {
                                                  const begin =
                                                      Offset(1.0, 0.0);
                                                  const end = Offset.zero;
                                                  const curve = Curves.ease;

                                                  var tween = Tween(
                                                          begin: begin,
                                                          end: end)
                                                      .chain(CurveTween(
                                                          curve: curve));

                                                  return SlideTransition(
                                                    position:
                                                        animation.drive(tween),
                                                    child: child,
                                                  );
                                                },
                                              ),
                                            );
                                          });
                                        },
                                        title: "view_details"),
                                  ),
                                  Expanded(
                                    child: _btnWidget(
                                        color: white,
                                        borderColor: colorPrimaryDark,
                                        textColor: colorPrimaryDark,
                                        onTap: () {
                                          AdHelper.showFullscreenAd(context,
                                              Constant.interstialAdType, () {
                                            Navigator.of(context).push(
                                              PageRouteBuilder(
                                                pageBuilder: (context,
                                                        animation,
                                                        secondaryAnimation) =>
                                                    FeedbackSession(
                                                  contentId: meetingListData?.id
                                                          .toString() ??
                                                      "",
                                                  tutorImage: meetingListData
                                                          ?.lecturerImage
                                                          .toString() ??
                                                      "",
                                                  tutorName: meetingListData
                                                          ?.lecturerName
                                                          .toString() ??
                                                      "",
                                                ),
                                                transitionsBuilder: (context,
                                                    animation,
                                                    secondaryAnimation,
                                                    child) {
                                                  const begin =
                                                      Offset(1.0, 0.0);
                                                  const end = Offset.zero;
                                                  const curve = Curves.ease;

                                                  var tween = Tween(
                                                          begin: begin,
                                                          end: end)
                                                      .chain(CurveTween(
                                                          curve: curve));

                                                  return SlideTransition(
                                                    position:
                                                        animation.drive(tween),
                                                    child: child,
                                                  );
                                                },
                                              ),
                                            );
                                          });
                                        },
                                        title: "write_review"),
                                  )
                                ],
                              ),
                  ],
                ),
              ),
            );
          },
        ));
  }

/* Reschldeldata */

  void showDateAndTime(String meetingId, appointmentId) {
    showModalBottomSheet(
      backgroundColor: white,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      context: context,
      builder: (context) {
        return Consumer<MeetingProvider>(
            builder: (context, meetingProvider, child) {
          return Container(
            padding: EdgeInsets.fromLTRB(20, 10, 20, 0),
            height: 500,
            width: MediaQuery.sizeOf(context).width,
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 16,
                children: [
                  dateCalender(meetingId),
                  timeSlotData(),
                  SizedBox(height: 20),
                  _btnWidget(
                      borderColor: transparent,
                      color: colorPrimary,
                      textColor: white,
                      title: "submit",
                      onTap: () {
                        String? dateC = DateFormat("yyyy-MM-dd")
                            .format(meetingProvider.selectedValue);
                        redchduledAPI(appointmentId,
                            meetingProvider.meetingScheduledId, dateC);
                      }),
                ],
              ),
            ),
          );
        });
      },
    );
  }

  Widget dateCalender(String mettingId) {
    return Column(
      children: [
        Align(
          alignment: Alignment.centerLeft,
          child: MyText(
            text: "choose_date",
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w700,
            fontstyle: FontStyle.normal,
            color: black,
          ),
        ),
        EasyDateTimeLine(
          timeLineProps: EasyTimeLineProps(margin: EdgeInsets.zero),
          initialDate: meetingProvider.selectedValue,
          onDateChange: (selectedDate) {
            meetingProvider.setDate(selectedDate);
            // Get weekday name (e.g., Monday)
            final weekDayName = DateFormat('EEEE').format(selectedDate);
            meetingProvider.setWeekDay(weekDayName);
            meetingProvider.clearContent();
            getTimeSoltApi(mettingId, meetingProvider.selectedValue);
          },
          activeColor: white,
          headerProps: EasyHeaderProps(
              showHeader: true,
              padding: EdgeInsets.zero,
              monthPickerType: MonthPickerType.switcher,
              showMonthPicker: true,
              centerHeader: true,
              monthStyle: GoogleFonts.lato(
                  fontSize: Dimens.textMedium,
                  color: colorPrimaryDark,
                  fontWeight: FontWeight.w600),
              showSelectedDate: false),
          locale: "en",
          dayProps: EasyDayProps(
              todayHighlightStyle: TodayHighlightStyle.withBackground,
              borderColor: gray,
              dayStructure: DayStructure.dayNumDayStr,
              height: 80,
              width: 50,
              inactiveDayStyle: DayStyle(
                  borderRadius: 10,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(
                          width: 1, color: gray, style: BorderStyle.solid)),
                  dayNumStyle: GoogleFonts.lato(
                      fontSize: Dimens.textBig,
                      color: black,
                      fontWeight: FontWeight.w600)),
              activeDayStyle: DayStyle(
                  borderRadius: 10,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(
                          width: 1,
                          color: colorPrimaryDark,
                          style: BorderStyle.solid)),
                  dayStrStyle: GoogleFonts.lato(
                      fontSize: Dimens.textMedium,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600),
                  monthStrStyle: GoogleFonts.lato(
                      fontSize: Dimens.textTitle,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600),
                  dayNumStyle: GoogleFonts.lato(
                      fontSize: Dimens.textBig,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600))),
        )
      ],
    );
  }

  Widget timeSlotData() {
    if (meetingProvider.timeSelectLoading) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          MyText(
            text: 'choose_time_slot',
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w600,
            fontstyle: FontStyle.normal,
            color: black,
          ),
          SingleChildScrollView(
            padding: EdgeInsets.zero,
            scrollDirection: Axis.horizontal,
            physics: NeverScrollableScrollPhysics(),
            child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 20,
                children: List.generate(
                  4,
                  (index) {
                    return Container(
                      padding: const EdgeInsets.all(10),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(10),
                        color: transparent,
                      ),
                      child: CustomWidget.roundcorner(
                        height: 14,
                        width: 100,
                      ),
                    );
                  },
                )),
          ),
        ],
      );
    } else {
      /* Main Result Data */
      if (meetingProvider.selectedTimeSloteModel.status == 200 &&
          (meetingProvider.selectedTimeSloteModel.result?.length ?? 0) > 0) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 10,
          children: [
            MyText(
              text: 'choose_time_slot',
              multilanguage: true,
              fontsizeNormal: Dimens.textTitle,
              fontwaight: FontWeight.w600,
              fontstyle: FontStyle.normal,
              color: black,
            ),
            SingleChildScrollView(
              scrollDirection: Axis.horizontal,
              padding: EdgeInsets.zero,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                children: List.generate(
                  meetingProvider.selectedTimeSloteModel.result?.length ?? 0,
                  (index) {
                    final timeSlot =
                        meetingProvider.selectedTimeSloteModel.result?[index];
                    /* Time slot Data Result show */
                    return Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: List.generate(
                        timeSlot?.timeSlotes?.length ?? 0,
                        (postion) {
                          final subTimeSlot = timeSlot?.timeSlotes?[postion];
                          /* Time schedul Data Result show */
                          return Row(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            spacing: 10,
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: List.generate(
                              subTimeSlot?.timeSchedul?.length ?? 0,
                              (timeSchedulPostion) {
                                final subTimeSlotSchedul = subTimeSlot
                                    ?.timeSchedul?[timeSchedulPostion];
                                return InkWell(
                                  splashColor: transparent,
                                  focusColor: transparent,
                                  hoverColor: transparent,
                                  onTap: () {
                                    if ((subTimeSlotSchedul?.isBook
                                                .toString() ??
                                            "") ==
                                        "1") {
                                      printLog("selecte the time slot");
                                    } else {
                                      meetingProvider.setMeetingId(
                                          id: subTimeSlotSchedul?.id
                                                  .toString() ??
                                              "",
                                          start: subTimeSlotSchedul?.startTime
                                                  .toString() ??
                                              "",
                                          end: subTimeSlotSchedul?.endTime
                                                  .toString() ??
                                              "");
                                    }
                                  },
                                  child: Container(
                                    padding: const EdgeInsets.fromLTRB(
                                        15, 10, 15, 10),
                                    alignment: Alignment.center,
                                    decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(10),
                                        color: (subTimeSlotSchedul?.isBook
                                                        .toString() ??
                                                    "") ==
                                                "1"
                                            ? colorPrimary
                                            : meetingProvider
                                                        .meetingScheduledId ==
                                                    (subTimeSlotSchedul?.id
                                                            .toString() ??
                                                        "")
                                                ? colorPrimaryDark
                                                : transparent),
                                    child: MyText(
                                      text: Utils.formateTime(
                                          staTime:
                                              subTimeSlotSchedul?.startTime ??
                                                  "",
                                          enTime: subTimeSlotSchedul?.endTime ??
                                              ""),
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w600,
                                      color: (subTimeSlotSchedul?.isBook
                                                      .toString() ??
                                                  "") ==
                                              "1"
                                          ? white
                                          : meetingProvider
                                                      .meetingScheduledId ==
                                                  (subTimeSlotSchedul?.id
                                                          .toString() ??
                                                      "")
                                              ? white
                                              : black,
                                    ),
                                  ),
                                );
                              },
                            ),
                          );
                        },
                      ),
                    );
                  },
                ),
              ),
            ),
          ],
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

/* API Call Reschduled */

  Future<void> redchduledAPI(
      String appointmentId, mettingScheduleId, date) async {
    Utils().showProgress(context, "Please Wait");
    try {
      await meetingProvider.getReschedulesAppointment(
          appointmentId, mettingScheduleId, date);

      if (meetingProvider.successModel.status == 200) {
        if (!mounted) return;
        Utils().hideProgress(context);
        if (Navigator.canPop(context)) {
          Navigator.of(context).pop();
        }

        /* API Call */

        meetingProvider.clearUserMeetingContent();
        meetingProvider.setMyTab("1");
        meetingProvider.getUseMeeting("1", 0);
      } else {
        if (!mounted) return;
        Utils().hideProgress(context);
        Utils.showSnackbar(
            context, "fail", meetingProvider.successModel.message ?? "", false);
        printLog(meetingProvider.successModel.message ?? "");
      }
    } catch (e) {
      if (!mounted) return;
      Utils().hideProgress(context);
      printLog(e.toString());
      Utils.showSnackbar(
          context, "fail", meetingProvider.successModel.message ?? "", false);
      printLog(meetingProvider.successModel.message ?? "");
    }
  }

  Widget _btnWidget({String? title, textColor, color, borderColor, onTap}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.fromLTRB(24, 10, 24, 10),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: borderColor, style: BorderStyle.solid),
            color: color,
            borderRadius: BorderRadius.circular(10)),
        child: MyText(
          text: title ?? "",
          multilanguage: true,
          color: textColor,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textMedium,
          fontwaight: FontWeight.w600,
        ),
      ),
    );
  }

  String _statusName(String index) {
    switch (index) {
      case "1":
        return "upcoming";
      case "2":
        return "completed";
      case "3":
        return "cancelled";
      default:
        return "";
    }
  }

  Color _statusTextColor(String index) {
    switch (index) {
      case "1":
        return colorAccent;
      case "2":
        return green;
      case "3":
        return red;
      default:
        return white;
    }
  }

  Color _statusColor(String index) {
    switch (index) {
      case "1":
        return colorAccent;
      case "2":
        return green;
      case "3":
        return red;
      default:
        return white;
    }
  }

  Widget _userMeetingShimmer() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Card(
              color: white,
              elevation: 10,
              shadowColor: transparent.withValues(alpha: 0.3),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  spacing: 10,
                  children: [
                    Row(
                      spacing: 20,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Container(
                          padding: EdgeInsets.all(4),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              border: Border.all(
                                  width: 1,
                                  color: colorPrimaryDark,
                                  style: BorderStyle.solid)),
                          child: CustomWidget.circular(height: 80, width: 80),
                        ),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            spacing: 6,
                            children: [
                              CustomWidget.roundcorner(height: 14, width: 100),
                              CustomWidget.roundcorner(height: 12, width: 100),
                              CustomWidget.roundcorner(height: 12, width: 100),
                            ],
                          ),
                        ),
                        CustomWidget.roundcorner(height: 20, width: 40)
                      ],
                    ),
                    Container(
                      padding: EdgeInsets.fromLTRB(8, 4, 8, 4),
                      width: MediaQuery.sizeOf(context).width,
                      decoration: BoxDecoration(
                          color: colorPrimaryDark,
                          borderRadius: BorderRadius.circular(4)),
                      child: CustomWidget.roundcorner(height: 14, width: 100),
                    ),
                  ],
                ),
              ),
            );
          },
        ));
  }
}
