import 'dart:convert';
import 'dart:io';
import 'package:prakah/pages/bottombar.dart';
import 'package:prakah/pages/editprofile.dart';
import 'package:prakah/pages/mobilelogin.dart';
import 'package:prakah/pages/register.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webwidget/forgotpassword.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:firebase_auth/firebase_auth.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:google_sign_in/google_sign_in.dart';
import 'package:provider/provider.dart';
import 'package:crypto/crypto.dart';
import 'package:sign_in_with_apple/sign_in_with_apple.dart';

class Login extends StatefulWidget {
  const Login({super.key});

  @override
  State<Login> createState() => LoginState();
}

class LoginState extends State<Login> {
  GeneralProvider generalProvider = GeneralProvider();
  TextEditingController emailController = TextEditingController();
  TextEditingController passwordController = TextEditingController();
  bool obscureTextPassword = true;
  bool? isCheck = false;
  final FirebaseAuth auth = FirebaseAuth.instance;
  String email = "", password = "";
  String? userName;
  File? mProfileImg;
  String? strDeviceType, strDeviceToken;
  final GoogleSignIn googleSignIn = GoogleSignIn.instance;
  bool initialized = false;

  @override
  initState() {
    super.initState();
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    if (Constant.isDemoMode == "1") {
      emailController.text = "jo@gmail.com";
      passwordController.text = "123456";
    }
    _getDeviceToken();
  }

  Future<void> _getDeviceToken() async {
    try {
      if (Platform.isAndroid) {
        strDeviceType = "1";
      } else {
        strDeviceType = "2";
      }
      strDeviceToken = await FirebaseMessaging.instance.getToken();
    } catch (e) {
      printLog("_getDeviceToken Exception ===> $e");
    }
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          image: DecorationImage(
              image: AssetImage("assets/images/login_bg.png"),
              fit: BoxFit.fill)),
      child: Scaffold(
        backgroundColor: transparent,
        appBar: AppBar(
          backgroundColor: transparent,
          systemOverlayStyle: SystemUiOverlayStyle(
            statusBarColor: transparent,
            systemNavigationBarColor: transparent,
          ),
          leading: InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              Navigator.of(context).pop();
            },
            child: const Icon(
              Icons.arrow_back_outlined,
              size: 20,
              color: white,
            ),
          ),
        ),
        body: Container(
          height: MediaQuery.sizeOf(context).height,
          width: MediaQuery.sizeOf(context).width,
          margin: EdgeInsets.only(top: 120),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.only(
                  topLeft: Radius.circular(30), topRight: Radius.circular(30))),
          child: SingleChildScrollView(
            scrollDirection: Axis.vertical,
            physics: const BouncingScrollPhysics(),
            padding: EdgeInsets.fromLTRB(15, 30, 15, 30),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                    color: colorPrimaryDark,
                    text: "login",
                    fontsizeNormal: Dimens.textExtraBig,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    multilanguage: true,
                    fontstyle: FontStyle.normal),
                const SizedBox(height: 10),
                emailAndpassword(),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  spacing: 20,
                  children: [
                    Expanded(
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        spacing: 2,
                        children: [
                          Checkbox(
                            hoverColor: transparent,
                            tristate: false,
                            activeColor: colorPrimaryDark,
                            focusColor: transparent,
                            checkColor: white,
                            value: isCheck,
                            materialTapTargetSize:
                                MaterialTapTargetSize.shrinkWrap,
                            visualDensity: VisualDensity.compact,
                            onChanged: (value) {
                              isCheck = value;
                              if (mounted) {
                                setState(() {});
                              }
                            },
                          ),
                          MyText(
                              color: black,
                              text: "remember_me",
                              fontsizeNormal: Dimens.textMedium,
                              fontwaight: FontWeight.w600,
                              maxline: 1,
                              overflow: TextOverflow.ellipsis,
                              textalign: TextAlign.center,
                              multilanguage: true,
                              fontstyle: FontStyle.normal),
                        ],
                      ),
                    ),
                    Expanded(
                      child: InkWell(
                        onTap: () {
                          Navigator.of(context).push(
                            PageRouteBuilder(
                              transitionDuration:
                                  const Duration(milliseconds: 200),
                              pageBuilder: (BuildContext context,
                                  Animation<double> animation,
                                  Animation<double> secondaryAnimation) {
                                return const ForgotPassword();
                              },
                              transitionsBuilder: (BuildContext context,
                                  Animation<double> animation,
                                  Animation<double> secondaryAnimation,
                                  Widget child) {
                                return Align(
                                  child: FadeTransition(
                                    opacity: animation,
                                    child: child,
                                  ),
                                );
                              },
                            ),
                          );
                        },
                        child: MyText(
                            color: colorPrimaryDark,
                            text: "forget_password",
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.end,
                            multilanguage: true,
                            fontstyle: FontStyle.normal),
                      ),
                    ),
                  ],
                ),
                const SizedBox(height: 30),
                loginBtn(),
                const SizedBox(height: 25),
                loginWithSocial(),
                const SizedBox(height: 20),
                goingRegister(),
                const SizedBox(height: 30),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget emailAndpassword() {
    return Padding(
      padding: const EdgeInsets.only(top: 25),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          /* Email */
          TextFormField(
            autofillHints: const [AutofillHints.email],
            obscureText: false,
            keyboardType: TextInputType.emailAddress,
            controller: emailController,
            textInputAction: TextInputAction.next,
            cursorColor: black,
            style: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: black,
                letterSpacing: 1,
                fontWeight: FontWeight.w600),
            decoration: InputDecoration(
              focusedBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(10)),
                borderSide:
                    BorderSide(width: 1, color: gray, style: BorderStyle.solid),
              ),
              disabledBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(10)),
                borderSide:
                    BorderSide(width: 1, color: gray, style: BorderStyle.solid),
              ),
              enabledBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(10)),
                borderSide:
                    BorderSide(width: 1, color: gray, style: BorderStyle.solid),
              ),
              border: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(10)),
                borderSide:
                    BorderSide(width: 1, color: gray, style: BorderStyle.solid),
              ),
              labelText: "Email Address",
              labelStyle: GoogleFonts.inter(
                  fontSize: Dimens.textMedium,
                  fontStyle: FontStyle.normal,
                  letterSpacing: 1,
                  color: gray,
                  fontWeight: FontWeight.w500),
            ),
          ),
          const SizedBox(height: 25),
          /* Password */
          TextFormField(
            autofillHints: const [AutofillHints.password],
            obscureText: obscureTextPassword,
            keyboardType: TextInputType.text,
            controller: passwordController,
            textInputAction: TextInputAction.done,
            cursorColor: Theme.of(context).colorScheme.surface,
            style: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: Theme.of(context).colorScheme.surface,
                letterSpacing: 5.0,
                fontWeight: FontWeight.w500),
            decoration: InputDecoration(
              suffixIcon: InkWell(
                onTap: () {
                  setState(() {
                    obscureTextPassword = !obscureTextPassword;
                  });
                },
                child: Container(
                  width: 25,
                  height: 25,
                  alignment: Alignment.center,
                  child: Icon(
                    obscureTextPassword
                        ? Icons.visibility
                        : Icons.visibility_off,
                    color: gray,
                  ),
                ),
              ),
              focusedBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(10)),
                borderSide:
                    BorderSide(width: 1, color: gray, style: BorderStyle.solid),
              ),
              disabledBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(10)),
                borderSide:
                    BorderSide(width: 1, color: gray, style: BorderStyle.solid),
              ),
              enabledBorder: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(10)),
                borderSide:
                    BorderSide(width: 1, color: gray, style: BorderStyle.solid),
              ),
              border: OutlineInputBorder(
                borderRadius: const BorderRadius.all(Radius.circular(10)),
                borderSide:
                    BorderSide(width: 1, color: gray, style: BorderStyle.solid),
              ),
              labelText: "Password",
              labelStyle: GoogleFonts.inter(
                  fontSize: Dimens.textMedium,
                  fontStyle: FontStyle.normal,
                  letterSpacing: 1,
                  color: gray,
                  fontWeight: FontWeight.w400),
            ),
          ),
        ],
      ),
    );
  }

  Widget loginBtn() {
    return Consumer<GeneralProvider>(
        builder: (context, generalprovider, child) {
      return (isCheck == false)
          ? Container(
              clipBehavior: Clip.antiAliasWithSaveLayer,
              width: MediaQuery.of(context).size.width,
              height: 45,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                color: gray,
                borderRadius: BorderRadius.circular(10),
              ),
              child: MyText(
                color: white,
                text: "login",
                fontsizeNormal: Dimens.textMedium,
                fontsizeWeb: Dimens.textMedium,
                fontwaight: FontWeight.w600,
                maxline: 1,
                multilanguage: true,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal,
              ),
            )
          : InkWell(
              onTap: () {
                email = emailController.text.toString();
                password = passwordController.text.toString();

                bool emailValidation = RegExp(
                        r"^[a-zA-Z0-9.a-zA-Z0-9.!#$%&'*+-/=?^_`{|}~]+@[a-zA-Z0-9]+\.[a-zA-Z]+")
                    .hasMatch(email);

                if (email.isEmpty) {
                  Utils.showSnackbar(context, "fail", "pleasenteremail", true);
                } else if (password.isEmpty) {
                  Utils.showSnackbar(
                      context, "fail", "pleaseenteryourpassword", true);
                } else if (password.length < 6) {
                  Utils.showSnackbar(
                      context, "fail", "pleaseenterpasswordonlysixdigit", true);
                } else if (!emailValidation) {
                  Utils.showSnackbar(
                      context, "fail", "invalidemailaddress", true);
                } else {
                  nomalLogin(email, password, "4");
                }
              },
              child: AnimatedContainer(
                duration: const Duration(milliseconds: 80),
                clipBehavior: Clip.antiAliasWithSaveLayer,
                curve: Curves.bounceInOut,
                width: generalProvider.isProgressLoading
                    ? 100
                    : MediaQuery.of(context).size.width,
                height: 45,
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  color: colorPrimaryDark,
                  borderRadius: BorderRadius.circular(10),
                ),
                child: generalProvider.isProgressLoading
                    ? const SizedBox(
                        width: 25,
                        height: 25,
                        child: CircularProgressIndicator(
                          color: white,
                          strokeWidth: 2,
                        ),
                      )
                    : MyText(
                        color: white,
                        text: "login",
                        fontsizeNormal: 16,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        multilanguage: true,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                      ),
              ),
            );
    });
  }

  Widget goingRegister() {
    return InkWell(
      onTap: () {
        Navigator.of(context).pushReplacement(
          PageRouteBuilder(
            transitionDuration: const Duration(milliseconds: 200),
            pageBuilder: (BuildContext context, Animation<double> animation,
                Animation<double> secondaryAnimation) {
              return const Register();
            },
            transitionsBuilder: (BuildContext context,
                Animation<double> animation,
                Animation<double> secondaryAnimation,
                Widget child) {
              return Align(
                child: FadeTransition(
                  opacity: animation,
                  child: child,
                ),
              );
            },
          ),
        );
      },
      child: Row(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          MyText(
              color: gray,
              text: "donthaveanaccount",
              fontsizeNormal: Dimens.textMedium,
              maxline: 1,
              fontwaight: FontWeight.w500,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
          const SizedBox(width: 5),
          MyText(
              color: colorPrimaryDark,
              text: "register",
              fontsizeNormal: Dimens.textTitle,
              maxline: 1,
              fontwaight: FontWeight.w600,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.center,
              fontstyle: FontStyle.normal,
              multilanguage: true),
        ],
      ),
    );
  }

  Widget loginWithSocial() {
    return Row(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        InkWell(
          onTap: (() {
            gmailLogin();
          }),
          child: Container(
            width: 50,
            height: 50,
            alignment: Alignment.center,
            decoration: BoxDecoration(
                color: white.withValues(alpha: 0.8),
                border: Border.all(
                    width: 2,
                    color: gray.withValues(alpha: 0.25),
                    style: BorderStyle.solid),
                shape: BoxShape.rectangle,
                borderRadius: BorderRadius.circular(10)),
            child: MyImage(width: 20, height: 20, imagePath: "ic_gmail.png"),
          ),
        ),
        Padding(
          padding: const EdgeInsets.fromLTRB(15, 0, 0, 0),
          child: InkWell(
            onTap: (() {
              Navigator.of(context).push(
                PageRouteBuilder(
                  transitionDuration: const Duration(milliseconds: 200),
                  pageBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation) {
                    return const MobileLogin();
                  },
                  transitionsBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation,
                      Widget child) {
                    return Align(
                      child: FadeTransition(
                        opacity: animation,
                        child: child,
                      ),
                    );
                  },
                ),
              );
            }),
            child: Container(
              width: 50,
              height: 50,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                  color: white.withValues(alpha: 0.8),
                  border: Border.all(
                      width: 2,
                      color: gray.withValues(alpha: 0.25),
                      style: BorderStyle.solid),
                  shape: BoxShape.rectangle,
                  borderRadius: BorderRadius.circular(10)),
              child: MyImage(
                width: 20,
                height: 20,
                imagePath: "ic_mobile.png",
                color: Theme.of(context).colorScheme.surface,
              ),
            ),
          ),
        ),
        Platform.isIOS
            ? Padding(
                padding: const EdgeInsets.fromLTRB(15, 0, 0, 0),
                child: InkWell(
                  onTap: (() {
                    printLog("clck");
                    signInWithApple();
                  }),
                  child: Container(
                    width: 50,
                    height: 50,
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                        color: white.withValues(alpha: 0.8),
                        border: Border.all(
                            width: 2,
                            color: gray.withValues(alpha: 0.25),
                            style: BorderStyle.solid),
                        shape: BoxShape.rectangle,
                        borderRadius: BorderRadius.circular(10)),
                    child: MyImage(
                        width: 20, height: 20, imagePath: "applestore.png"),
                  ),
                ),
              )
            : const SizedBox.shrink(),
      ],
    );
  }

  // Signin With Apple
  String sha256ofString(String input) {
    final bytes = utf8.encode(input);
    final digest = sha256.convert(bytes);
    return digest.toString();
  }

  Future<User?> signInWithApple() async {
    printLog("Click Apple");
    // To prevent replay attacks with the credential returned from Apple, we
    // include a nonce in the credential request. When signing in in with
    // Firebase, the nonce in the id token returned by Apple, is expected to
    // match the sha256 hash of `rawNonce`.
    final rawNonce = generateNonce();
    final nonce = sha256ofString(rawNonce);

    try {
      // Request credential for the currently signed in Apple account.
      final appleCredential = await SignInWithApple.getAppleIDCredential(
        scopes: [
          AppleIDAuthorizationScopes.email,
          AppleIDAuthorizationScopes.fullName,
        ],
        nonce: nonce,
      );

      printLog(appleCredential.authorizationCode);

      // Create an `OAuthCredential` from the credential returned by Apple.
      final oauthCredential = OAuthProvider("apple.com").credential(
        idToken: appleCredential.identityToken,
        rawNonce: rawNonce,
        accessToken: appleCredential.authorizationCode,
      );

      // Sign in the user with Firebase. If the nonce we generated earlier does
      // not match the nonce in `appleCredential.identityToken`, sign in will fail.
      final authResult = await auth.signInWithCredential(oauthCredential);

      final firebaseUser = authResult.user;
      printLog("=================");

      final userEmail = '${firebaseUser?.email}';

      checkAndNavigate(userEmail, "3");
    } catch (exception) {
      printLog("Apple Login exception =====> $exception");
    }
    return null;
  }

/* Google(Gmail) Login */

  Future<void> _initGoogleSignIn() async {
    try {
      await googleSignIn.initialize(
        /* Web client → used as serverClientId in your code.
            web server client id pass
         */
        serverClientId: 'Web client → used as serverClientId in your code.',
      );
      initialized = true;
    } catch (e) {
      debugPrint("GoogleSignIn initialization failed: $e");
      return;
    }
  }

  Future<void> gmailLogin() async {
    if (!initialized) {
      await _initGoogleSignIn();
    }
    GoogleSignInAccount user =
        await googleSignIn.authenticate(scopeHint: ['email', 'profile']);

    if (!mounted) return;
    generalProvider.setLoading(true);

    try {
      final GoogleSignInAuthentication googleAuth = user.authentication;
      final AuthCredential credential =
          GoogleAuthProvider.credential(idToken: googleAuth.idToken);

      UserCredential userCredential =
          await auth.signInWithCredential(credential);

      if (!mounted) return;
      generalProvider.setLoading(true);

      // sign in to Firebase with the Google credential (unchanged)
      userCredential = await auth.signInWithCredential(credential);
      assert(await userCredential.user?.getIdToken() != null);

      final firebaseId = userCredential.user?.uid ?? "";
      await SharedPre().save("firebaseId", firebaseId);

      checkAndNavigate(userCredential.user?.email ?? "", "2");
    } on FirebaseAuthException catch (e) {
      printLog('FirebaseAuthException ===CODE====> ${e.code.toString()}');
      printLog('FirebaseAuthException ==MESSAGE==> ${e.message.toString()}');
      generalProvider.setLoading(false);
    }
  }

  void nomalLogin(String email, String password, String type) async {
    generalProvider.setLoading(true);
    await generalProvider.login(
        type, email, password, strDeviceType ?? "", strDeviceToken ?? "");

    if (!generalProvider.loading) {
      if (generalProvider.loginmodel.status == 200) {
        Utils.saveUserCreds(
          userID: generalProvider.loginmodel.result?[0].id.toString(),
          userName:
              generalProvider.loginmodel.result?[0].userName.toString() ?? "",
          fullName:
              generalProvider.loginmodel.result?[0].fullName.toString() ?? "",
          email: generalProvider.loginmodel.result?[0].email.toString() ?? "",
          mobileNumber:
              generalProvider.loginmodel.result?[0].mobileNumber.toString() ??
                  "",
          image: generalProvider.loginmodel.result?[0].image.toString() ?? "",
          deviceType:
              generalProvider.loginmodel.result?[0].deviceType.toString() ?? "",
          deviceToken:
              generalProvider.loginmodel.result?[0].deviceToken.toString() ??
                  "",
          userIsBuy:
              generalProvider.loginmodel.result?[0].isBuy.toString() ?? "",
          type: generalProvider.loginmodel.result?[0].type.toString() ?? "",
        );
        generalProvider.setLoading(false);

        /* Initialize Hive */
        await Utils.initializeHiveBoxes();
/* email and mobile and name is empty open the edit profie */
        if (type == "4") {
          await SharedPre().save("edit", "1");
          if (!mounted) return;
          Utils.navigatePage(context, Bottombar(), '');
        } else if (generalProvider.loginmodel.result?[0].fullName.toString() ==
                "" ||
            generalProvider.loginmodel.result?[0].email.toString() == "" ||
            generalProvider.loginmodel.result?[0].mobileNumber.toString() ==
                "") {
          await SharedPre().save("edit", "0");
          if (!mounted) return;
          Utils.navigatePage(context, EditProfile(editType: "2"), '');
        } else {
          await SharedPre().save("edit", "1");
          if (!mounted) return;
          Utils.navigatePage(context, Bottombar(), '');
        }
      } else {
        generalProvider.setLoading(false);
        if (!mounted) return;
        Utils.showSnackbar(
            context, "fail", "${generalProvider.loginmodel.message}", false);
      }
    }
  }

/* Google and apple */
  Future<void> checkAndNavigate(String email, String type) async {
    Utils().showProgress(context, "Please Wait");
    try {
      await generalProvider.getSocialLogin(
          type, email, strDeviceType ?? "", strDeviceToken ?? "");

      if (!generalProvider.loading) {
        if (generalProvider.loginmodel.status == 200) {
          Utils.saveUserCreds(
            userID: generalProvider.loginmodel.result?[0].id.toString(),
            userName:
                generalProvider.loginmodel.result?[0].userName.toString() ?? "",
            fullName:
                generalProvider.loginmodel.result?[0].fullName.toString() ?? "",
            email: generalProvider.loginmodel.result?[0].email.toString() ?? "",
            mobileNumber:
                generalProvider.loginmodel.result?[0].mobileNumber.toString() ??
                    "",
            image: generalProvider.loginmodel.result?[0].image.toString() ?? "",
            deviceType:
                generalProvider.loginmodel.result?[0].deviceType.toString() ??
                    "",
            deviceToken:
                generalProvider.loginmodel.result?[0].deviceToken.toString() ??
                    "",
            userIsBuy:
                generalProvider.loginmodel.result?[0].isBuy.toString() ?? "",
            type: generalProvider.loginmodel.result?[0].type.toString() ?? "",
          );
          if (!mounted) return;
          Utils().hideProgress(context);

          /* Initialize Hive */
          await Utils.initializeHiveBoxes();
/* email and mobile and name is empty open the edit profie */
          if (type == "4") {
            await SharedPre().save("edit", "1");
            if (!mounted) return;
            Navigator.of(context).pushAndRemoveUntil(
                PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        Bottombar(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    }),
                (Route route) => false);
          } else if (generalProvider.loginmodel.result?[0].fullName
                      .toString() ==
                  "" ||
              generalProvider.loginmodel.result?[0].email.toString() == "" ||
              generalProvider.loginmodel.result?[0].mobileNumber.toString() ==
                  "") {
            await SharedPre().save("edit", "0");
            if (!mounted) return;

            Navigator.of(context).pushAndRemoveUntil(
                PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        EditProfile(editType: "2"),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    }),
                (Route route) => false);
          } else {
            await SharedPre().save("edit", "1");
            if (!mounted) return;
            Navigator.of(context).pushAndRemoveUntil(
                PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        Bottombar(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    }),
                (Route route) => false);
          }
        } else {
          if (!mounted) return;
          Utils().hideProgress(context);
          if (!mounted) return;
          Utils.showSnackbar(
              context, "fail", "${generalProvider.loginmodel.message}", false);
        }
      }
    } catch (e) {
      printLog(e.toString());
      if (!mounted) return;
      Utils().hideProgress(context);
      if (!mounted) return;
      Utils.showSnackbar(
          context, "fail", "${generalProvider.loginmodel.message}", false);
    }
  }
}
