import 'dart:io';

import 'package:flutter/material.dart';
import 'package:smooth_page_indicator/smooth_page_indicator.dart';
import 'package:prakah/model/introscreenmodel.dart';
import 'package:prakah/pages/bottombar.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';

class Intro extends StatefulWidget {
  final List<Result>? introList;
  const Intro({super.key, required this.introList});

  @override
  State<Intro> createState() => _IntroState();
}

class _IntroState extends State<Intro> {
  SharedPre sharedPre = SharedPre();
  PageController pageController = PageController();
  final currentPageNotifier = ValueNotifier<int>(0);
  int position = 0;
  double progress = 0.0;
  @override
  void initState() {
    super.initState();
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Padding(
        padding: EdgeInsets.fromLTRB(20, Platform.isIOS ? 100 : 40, 20, 50),
        child: Column(
          children: [
            Flexible(
              fit: FlexFit.loose,
              child: Stack(
                children: [
                  PageView.builder(
                    itemCount: widget.introList?.length ?? 0,
                    controller: pageController,
                    scrollDirection: Axis.horizontal,
                    itemBuilder: (BuildContext context, int index) {
                      return Column(
                        spacing: 25,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          MyNetworkImage(
                            imageUrl:
                                widget.introList?[index].image.toString() ?? "",
                            imgWidth: MediaQuery.of(context).size.width,
                            imgHeight: MediaQuery.of(context).size.height * .46,
                            fit: BoxFit.fill,
                          ),
                          MyText(
                              color: Theme.of(context).colorScheme.surface,
                              text: widget.introList?[index].description
                                      .toString() ??
                                  "",
                              textalign: TextAlign.center,
                              fontsizeNormal: Dimens.textBig,
                              multilanguage: false,
                              maxline: 5,
                              fontwaight: FontWeight.w600,
                              overflow: TextOverflow.ellipsis,
                              fontstyle: FontStyle.normal),
                        ],
                      );
                    },
                    onPageChanged: (index) {
                      position = index;
                      currentPageNotifier.value = index;
                      progress = (index + 1) / (widget.introList?.length ?? 1);

                      setState(() {});
                    },
                  ),
                ],
              ),
            ),
            SmoothPageIndicator(
              controller: pageController,
              count: widget.introList?.length ?? 0,
              effect: const ExpandingDotsEffect(
                dotWidth: 6,
                dotHeight: 6,
                dotColor: colorPrimaryDark,
                expansionFactor: 4,
                offset: 1,
                activeDotColor: colorAccent,
                radius: 100,
                strokeWidth: 1,
                spacing: 8,
              ),
            ),
            const SizedBox(height: 35),
            InkWell(
                focusColor: transparent,
                hoverColor: transparent,
                highlightColor: transparent,
                splashColor: transparent,
                onTap: () async {
                  if (position == ((widget.introList?.length ?? 0) - 1)) {
                    await sharedPre.save("seen", "1");
                    if (!context.mounted) return;
                    Navigator.of(context).pushReplacement(
                      PageRouteBuilder(
                        transitionDuration: const Duration(milliseconds: 200),
                        pageBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation) {
                          return const Bottombar();
                        },
                        transitionsBuilder: (BuildContext context,
                            Animation<double> animation,
                            Animation<double> secondaryAnimation,
                            Widget child) {
                          return FadeTransition(
                            opacity: animation,
                            child: child,
                          );
                        },
                      ),
                    );
                  }
                  pageController.nextPage(
                      duration: const Duration(milliseconds: 500),
                      curve: Curves.easeIn);
                },
                child: Container(
                  width: MediaQuery.sizeOf(context).width,
                  height: 55,
                  alignment: Alignment.center,
                  padding: EdgeInsets.all(10),
                  decoration: BoxDecoration(
                      color: colorPrimaryDark,
                      borderRadius: BorderRadius.circular(50)),
                  child: MyText(
                    text: (position == ((widget.introList?.length ?? 0) - 1))
                        ? "get_started"
                        : "next",
                    maxline: 1,
                    multilanguage: true,
                    fontsizeNormal: Dimens.textTitle,
                    color: white,
                    fontwaight: FontWeight.w600,
                  ),
                )),
          ],
        ),
      ),
    );
  }
}
