import 'package:prakah/provider/feedbackprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_pannable_rating_bar/flutter_pannable_rating_bar.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';

class FeedbackSession extends StatefulWidget {
  final String? contentId, tutorName, tutorImage;
  const FeedbackSession(
      {super.key,
      required this.tutorImage,
      required this.tutorName,
      required this.contentId});

  @override
  State<FeedbackSession> createState() => _FeedbackSessionState();
}

class _FeedbackSessionState extends State<FeedbackSession> {
  TextEditingController reviewController = TextEditingController();
  String? imageUser;
  late FeedbackProvider feedbackProvider;
  @override
  void initState() {
    feedbackProvider = Provider.of<FeedbackProvider>(context, listen: false);
    getData();
    super.initState();
  }

  Future<void> getData() async {
    imageUser = await SharedPre().read('userimage');
    if (mounted) {
      setState(() {});
    }
    printLog("My Mobile number $imageUser");
  }

  @override
  void dispose() {
    feedbackProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: white,
      appBar: Utils.myAppBarWithBack(
          context: context,
          appBarTitle: "write_review",
          multilanguage: true,
          editType: "1"),
      body: Consumer<FeedbackProvider>(
          builder: (context, feedbackProvider, child) {
        return SingleChildScrollView(
          physics: const AlwaysScrollableScrollPhysics(),
          clipBehavior: Clip.antiAlias,
          child: Column(
            children: [
              Padding(
                padding: const EdgeInsets.fromLTRB(15, 30, 15, 10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Center(
                      child: SizedBox(
                        width: 300,
                        child: Stack(
                          alignment: Alignment.center,
                          children: [
                            Positioned(
                              left: 60,
                              child: MyNetworkImage(
                                imgWidth: 80,
                                imgHeight: 80,
                                imageUrl: widget.tutorImage ?? "",
                                radius: 200,
                                fit: BoxFit.cover,
                              ),
                            ),
                            MyNetworkImage(
                              imgWidth: 80,
                              imgHeight: 80,
                              imageUrl: imageUser ?? "",
                              radius: 200,
                              fit: BoxFit.cover,
                            ),
                          ],
                        ),
                      ),
                    ),
                    const SizedBox(height: 20),
                    MyText(
                      text:
                          "Your Booking with ${widget.tutorName ?? ""} is complete! 🎉",
                      fontsizeNormal: Dimens.textBig,
                      maxline: 2,
                      textalign: TextAlign.center,
                      color: colorPrimaryDark,
                      fontwaight: FontWeight.w700,
                    ),
                  ],
                ),
              ),
              Divider(thickness: 3, color: gray.withValues(alpha: 0.2)),
              const SizedBox(height: 10),
              Container(
                padding: const EdgeInsets.all(16),
                margin: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                decoration: BoxDecoration(
                    color: white,
                    borderRadius: BorderRadius.circular(12),
                    boxShadow: [
                      BoxShadow(
                          blurRadius: 11,
                          color: colorPrimaryDark.withValues(alpha: 0.08),
                          offset: const Offset(0, 3),
                          spreadRadius: 0)
                    ]),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    MyText(
                      text: "We would love to hear from you",
                      fontsizeNormal: Dimens.textTitle,
                      maxline: 2,
                      textalign: TextAlign.center,
                      color: colorPrimaryDark,
                      fontwaight: FontWeight.w700,
                    ),
                    const SizedBox(height: 15),
                    PannableRatingBar(
                      rate: feedbackProvider.rating ?? 0.0,
                      items: List.generate(
                          5,
                          (index) => const RatingWidget(
                                selectedColor: red,
                                unSelectedColor: gray,
                                child: Icon(
                                  Icons.favorite,
                                  size: 24,
                                ),
                              )),
                      onHover: (value) {
                        feedbackProvider.setRating(value);
                      },
                      onChanged: (value) {
                        feedbackProvider.setRating(value);
                      },
                    ),
                    const SizedBox(height: 20),
                    TextFormField(
                      maxLines: 4,
                      controller: reviewController,
                      keyboardType: TextInputType.multiline,
                      textInputAction: TextInputAction.newline,
                      style: GoogleFonts.inter(
                          fontSize: Dimens.textMedium,
                          fontStyle: FontStyle.normal,
                          color: Theme.of(context).colorScheme.surface,
                          letterSpacing: 1.0,
                          fontWeight: FontWeight.w600),
                      decoration: InputDecoration(
                          enabledBorder: OutlineInputBorder(
                              borderRadius: BorderRadius.circular(8),
                              borderSide: BorderSide(
                                  color: gray.withValues(alpha: .8),
                                  style: BorderStyle.solid,
                                  width: 1)),
                          errorBorder: OutlineInputBorder(
                              borderRadius: BorderRadius.circular(8),
                              borderSide: BorderSide(
                                  color: gray.withValues(alpha: .8),
                                  style: BorderStyle.solid,
                                  width: 1)),
                          focusedBorder: OutlineInputBorder(
                              borderRadius: BorderRadius.circular(8),
                              borderSide: BorderSide(
                                  color: gray.withValues(alpha: .8),
                                  style: BorderStyle.solid,
                                  width: 1)),
                          hintText: "Write your feekback here",
                          labelText: "Feedback",
                          labelStyle: GoogleFonts.inter(
                              fontSize: Dimens.textMedium,
                              fontStyle: FontStyle.normal,
                              color: Theme.of(context).colorScheme.surface,
                              letterSpacing: 1.0,
                              fontWeight: FontWeight.w600),
                          hintStyle: GoogleFonts.inter(
                              fontSize: Dimens.textMedium,
                              fontStyle: FontStyle.normal,
                              color: Theme.of(context).colorScheme.surface,
                              letterSpacing: 1.0,
                              fontWeight: FontWeight.w600)),
                    )
                  ],
                ),
              )
            ],
          ),
        );
      }),
      bottomNavigationBar: Consumer<FeedbackProvider>(
          builder: (context, feedbackProvider, child) {
        return BottomAppBar(
          color: white,
          child: Align(
            alignment: Alignment.center,
            child: InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              highlightColor: transparent,
              onTap: () async {
                if (reviewController.text.isEmpty) {
                  Utils.showSnackbar(context, '', "please_enter_review", true);
                } else if (feedbackProvider.rating == null) {
                  Utils.showSnackbar(context, '', "please_rating", true);
                } else {
                  reviewAdd("3", widget.contentId ?? "", reviewController.text,
                      feedbackProvider.rating);
                }
              },
              child: AnimatedContainer(
                duration: const Duration(milliseconds: 80),
                clipBehavior: Clip.antiAliasWithSaveLayer,
                curve: Curves.bounceInOut,
                width: feedbackProvider.isReview
                    ? 100
                    : MediaQuery.of(context).size.width,
                height: 45,
                alignment: Alignment.center,
                decoration: BoxDecoration(
                  color: colorPrimary,
                  borderRadius: BorderRadius.circular(50),
                ),
                child: feedbackProvider.isReview
                    ? const SizedBox(
                        width: 25,
                        height: 25,
                        child: CircularProgressIndicator(
                          color: white,
                          strokeWidth: 2,
                        ),
                      )
                    : MyText(
                        color: white,
                        text: "submit",
                        fontsizeNormal: Dimens.textTitle,
                        maxline: 1,
                        fontwaight: FontWeight.w600,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal,
                        multilanguage: true),
              ),
            ),
          ),
        );
      }),
    );
  }

/* Api */
  Future<void> reviewAdd(String type, contentId, comment, rating) async {
    feedbackProvider.setRescheduled(true);

    await feedbackProvider.getRescheduled(type, contentId, comment, rating);

    if (feedbackProvider.successModel.status == 200) {
      feedbackProvider.setRescheduled(false);

      if (!mounted) return;
      Navigator.pop(context);
    } else {
      feedbackProvider.setRescheduled(false);
      if (!mounted) return;

      Utils.showSnackbar(
          context, "fail", feedbackProvider.successModel.message ?? "", false);
    }
  }
}
