import 'dart:io';

import 'package:prakah/pages/bottombar.dart';
import 'package:prakah/provider/profileeditprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:image_picker/image_picker.dart';
import 'package:intl_phone_field/country_picker_dialog.dart';
import 'package:intl_phone_field/intl_phone_field.dart';
import 'package:provider/provider.dart';

class EditProfile extends StatefulWidget {
  final String? editType;
  const EditProfile({super.key, required this.editType});

  @override
  State<EditProfile> createState() => _EditProfileState();
}

class _EditProfileState extends State<EditProfile> {
  ProfileEditProvider profileEditProvider = ProfileEditProvider();
  ImagePicker imagePicker = ImagePicker();
  File? pickedProfileFile;
  bool imageSelected = false;
  TextEditingController userNameController = TextEditingController();
  TextEditingController nameController = TextEditingController();
  TextEditingController emailController = TextEditingController();
  TextEditingController numberController = TextEditingController();
  String mobilenumber = "", countrycode = "", countryname = "", type = "";
  String? strDeviceType, strDeviceToken;

  @override
  void initState() {
    super.initState();
    profileEditProvider =
        Provider.of<ProfileEditProvider>(context, listen: false);
    _getDeviceToken();
    getApi();
  }

  Future<void> _getDeviceToken() async {
    try {
      if (Platform.isAndroid) {
        strDeviceType = "1";
      } else {
        strDeviceType = "2";
      }
      strDeviceToken = await FirebaseMessaging.instance.getToken();
    } catch (e) {
      printLog("_getDeviceToken Exception ===> $e");
    }
  }

  Future<void> getApi() async {
    await profileEditProvider.getprofile();
    if (profileEditProvider.profileModel.result != null &&
        profileEditProvider.profileModel.status == 200) {
      nameController.text =
          profileEditProvider.profileModel.result?[0].fullName ?? "";
      emailController.text =
          profileEditProvider.profileModel.result?[0].email ?? "";
      numberController.text =
          profileEditProvider.profileModel.result?[0].mobileNumber ?? "";
      userNameController.text =
          profileEditProvider.profileModel.result?[0].userName ?? "";
    }
  }

  @override
  void dispose() {
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: widget.editType ?? "",
          context: context,
          appBarTitle: "editprofile",
          multilanguage: true),
      body: Consumer<ProfileEditProvider>(
        builder: (context, profileEditProvider, child) {
          return SingleChildScrollView(
            padding: const EdgeInsets.fromLTRB(20, 30, 20, 30),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.center,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                /* User Image */
                Align(alignment: Alignment.center, child: _buildImage()),
                // _buildFrontThumb(),
                const SizedBox(height: 40),
                editableTextField(
                    controller: userNameController,
                    keybordType: TextInputType.text,
                    hintText: "username",
                    textInputAction: TextInputAction.next),
                editableTextField(
                    controller: nameController,
                    keybordType: TextInputType.text,
                    hintText: "fullname",
                    textInputAction: TextInputAction.next),
                editableTextField(
                    controller: emailController,
                    keybordType: TextInputType.emailAddress,
                    hintText: "email",
                    textInputAction: TextInputAction.next),
                const SizedBox(height: 8),
                MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: "mobilenumber",
                    fontsizeNormal: Dimens.textMedium,
                    maxline: 1,
                    fontwaight: FontWeight.w500,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.center,
                    fontstyle: FontStyle.normal,
                    multilanguage: true),
                const SizedBox(height: 8),
                phoneFiled(), SizedBox(height: 30),
                Align(
                  alignment: Alignment.center,
                  child: InkWell(
                    splashColor: transparent,
                    focusColor: transparent,
                    hoverColor: transparent,
                    highlightColor: transparent,
                    onTap: () async {
                      final profileProvider =
                          Provider.of<ProfileProvider>(context, listen: false);
                      dynamic image;

                      if (imageSelected == false) {
                        image = File("");
                      } else {
                        image = pickedProfileFile;
                      }
                      profileEditProvider.setUpdateLoading(true);
                      await profileEditProvider.getUpdateProfile(
                          userNameController.text,
                          nameController.text.toString(),
                          numberController.text.toString(),
                          emailController.text.toString(),
                          countrycode,
                          countryname,
                          image,
                          "",
                          "",
                          strDeviceType ?? "",
                          strDeviceToken ?? "");

                      if (profileEditProvider.profileModel.status == 200) {
                        profileEditProvider.setUpdateLoading(false);
                        if (widget.editType == "1") {
                          if (!context.mounted) return;
                          Navigator.pop(context);
                        } else {
                          await SharedPre().save("edit", "1");
                          if (!context.mounted) return;
                          Navigator.of(context).pushAndRemoveUntil(
                              PageRouteBuilder(
                                  pageBuilder: (context, animation,
                                          secondaryAnimation) =>
                                      Bottombar(),
                                  transitionsBuilder: (context, animation,
                                      secondaryAnimation, child) {
                                    const begin = Offset(1.0, 0.0);
                                    const end = Offset.zero;
                                    const curve = Curves.ease;

                                    var tween = Tween(begin: begin, end: end)
                                        .chain(CurveTween(curve: curve));

                                    return SlideTransition(
                                      position: animation.drive(tween),
                                      child: child,
                                    );
                                  }),
                              (Route route) => false);
                        }
                      } else {
                        profileEditProvider.setUpdateLoading(false);
                        if (!context.mounted) return;
                        Utils.showSnackbar(
                            context,
                            "fail",
                            profileEditProvider.profileModel.message.toString(),
                            false);
                      }

                      /* Api call */
                      profileProvider.getprofile(context);
                    },
                    child: AnimatedContainer(
                      duration: const Duration(milliseconds: 80),
                      clipBehavior: Clip.antiAliasWithSaveLayer,
                      curve: Curves.bounceInOut,
                      width: profileEditProvider.loadingUpdate
                          ? 100
                          : MediaQuery.of(context).size.width,
                      height: 45,
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        color: colorPrimaryDark,
                        borderRadius: BorderRadius.circular(50),
                      ),
                      child: profileEditProvider.loadingUpdate
                          ? const SizedBox(
                              width: 25,
                              height: 25,
                              child: CircularProgressIndicator(
                                color: white,
                                strokeWidth: 2,
                              ),
                            )
                          : MyText(
                              color: white,
                              text: "updatetext",
                              fontsizeNormal: Dimens.textTitle,
                              maxline: 1,
                              fontwaight: FontWeight.w600,
                              overflow: TextOverflow.ellipsis,
                              textalign: TextAlign.center,
                              fontstyle: FontStyle.normal,
                              multilanguage: true),
                    ),
                  ),
                ),
              ],
            ),
          );
        },
      ),
    );
  }

  Widget _buildImage() {
    return Container(
      padding: const EdgeInsets.all(6),
      decoration: BoxDecoration(
          shape: BoxShape.circle,
          border: Border.all(width: 1, color: black, style: BorderStyle.solid)),
      child: Stack(
        children: [
          pickedProfileFile != null
              ? Container(
                  height: 100,
                  width: 100,
                  decoration: BoxDecoration(
                      shape: BoxShape.circle,
                      image: DecorationImage(
                        image: FileImage(pickedProfileFile ?? File('')),
                        fit: BoxFit.cover,
                      )),
                )
              : MyNetworkImage(
                  imageUrl:
                      profileEditProvider.profileModel.result?[0].image ?? "",
                  imgHeight: 120,
                  imgWidth: 120,
                  radius: 200,
                  fit: BoxFit.fill,
                ),
          Positioned(
            bottom: 0,
            right: 2,
            child: InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                imagePickDialog();
              },
              child: const Icon(
                Icons.camera_alt_rounded,
                size: 25,
                color: black,
              ),
            ),
          )
        ],
      ),
    );
  }

  Future<void> imagePickDialog() async {
    return showDialog<void>(
      context: context,

      barrierDismissible: false, // user must tap button!
      builder: (BuildContext context) {
        return AlertDialog(
          backgroundColor: white,
          content: SingleChildScrollView(
            child: ListBody(
              children: <Widget>[
                MyText(
                  multilanguage: true,
                  text: "add_photo",
                  color: black,
                  fontsizeNormal: Dimens.textBig,
                  fontsizeWeb: 16,
                  maxline: 4,
                  fontstyle: FontStyle.normal,
                  fontwaight: FontWeight.bold,
                  textalign: TextAlign.start,
                ),
              ],
            ),
          ),
          actions: <Widget>[
            TextButton(
              child: MyText(
                multilanguage: true,
                text: "choose_from_gallery",
                color: black,
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: 16,
                fontstyle: FontStyle.normal,
                fontwaight: FontWeight.bold,
                textalign: TextAlign.center,
              ),
              onPressed: () {
                Navigator.of(context).pop();
                getFromGallery();
              },
            ),
            TextButton(
              child: MyText(
                multilanguage: true,
                text: "take_photo",
                color: black,
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: 16,
                fontstyle: FontStyle.normal,
                fontwaight: FontWeight.bold,
                textalign: TextAlign.center,
              ),
              onPressed: () {
                Navigator.of(context).pop();
                getFromCamera();
              },
            ),
            TextButton(
              child: MyText(
                multilanguage: true,
                text: "cancel",
                color: black,
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: 16,
                fontstyle: FontStyle.normal,
                fontwaight: FontWeight.w500,
                textalign: TextAlign.center,
              ),
              onPressed: () {
                Navigator.of(context).pop();
              },
            ),
          ],
        );
      },
    );
  }

  /// Get from gallery
  void getFromGallery() async {
    final XFile? pickedFile = await imagePicker.pickImage(
      source: ImageSource.gallery,
      maxWidth: 1000,
      maxHeight: 1000,
      imageQuality: 100,
    );
    if (pickedFile != null) {
      pickedProfileFile = File(pickedFile.path);
      imageSelected = true;

      profileEditProvider.providerNotified();
    }
  }

  /// Get from Camera
  void getFromCamera() async {
    final XFile? pickedFile = await imagePicker.pickImage(
      source: ImageSource.camera,
      maxWidth: 1000,
      maxHeight: 1000,
      imageQuality: 100,
    );
    if (pickedFile != null) {
      pickedProfileFile = File(pickedFile.path);
      imageSelected = true;
      profileEditProvider.providerNotified();
    }
  }

  Widget phoneFiled() {
    String initialCountryCode =
        (profileEditProvider.profileModel.result?[0].countryName?.isNotEmpty ??
                false)
            ? (profileEditProvider.profileModel.result![0].countryName ?? "")
            : "IN";

    return IntlPhoneField(
      disableLengthCheck: true,
      textAlignVertical: TextAlignVertical.center,
      cursorColor: Theme.of(context).colorScheme.surface,
      autovalidateMode: AutovalidateMode.disabled,
      controller: numberController,
      pickerDialogStyle: PickerDialogStyle(backgroundColor: white),
      style: GoogleFonts.inter(
          fontSize: Dimens.textMedium,
          fontStyle: FontStyle.normal,
          color: Theme.of(context).colorScheme.surface,
          letterSpacing: 1.0,
          fontWeight: FontWeight.w600),
      showCountryFlag: true,
      showDropdownIcon: false,
      initialCountryCode: initialCountryCode,
      dropdownTextStyle: GoogleFonts.inter(
          fontSize: Dimens.textSmall,
          fontStyle: FontStyle.normal,
          letterSpacing: 1.0,
          color: black,
          fontWeight: FontWeight.w400),
      keyboardType: TextInputType.number,
      textInputAction: TextInputAction.done,
      decoration: InputDecoration(
        fillColor: gray.withValues(alpha: 0.10),
        filled: true,
        contentPadding: const EdgeInsets.fromLTRB(20, 0, 0, 0),
        focusedBorder: const OutlineInputBorder(
          borderRadius: BorderRadius.all(Radius.circular(7)),
          borderSide: BorderSide(width: 1, color: white),
        ),
        disabledBorder: const OutlineInputBorder(
          borderRadius: BorderRadius.all(Radius.circular(7)),
          borderSide: BorderSide(width: 1, color: white),
        ),
        enabledBorder: const OutlineInputBorder(
          borderRadius: BorderRadius.all(Radius.circular(7)),
          borderSide: BorderSide(width: 1, color: white),
        ),
        border: const OutlineInputBorder(
            borderRadius: BorderRadius.all(Radius.circular(7)),
            borderSide: BorderSide(width: 1, color: white)),
        hintText: "mobilenumber",
        hintStyle: GoogleFonts.inter(
            fontSize: Dimens.textMedium,
            fontStyle: FontStyle.normal,
            color: Theme.of(context).colorScheme.surface,
            fontWeight: FontWeight.w400),
      ),
      onChanged: (phone) {
        mobilenumber = phone.completeNumber;
        countryname = phone.countryISOCode;
        countrycode = phone.countryCode;
      },
      onCountryChanged: (country) {
        countryname = country.code.replaceAll('+', '');
        countrycode = "+${country.dialCode.toString()}";
      },
    );
  }

  Widget editableTextField(
      {TextEditingController? controller,
      hintText,
      textInputAction,
      keybordType}) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        MyText(
            color: Theme.of(context).colorScheme.surface,
            text: hintText,
            fontsizeNormal: Dimens.textMedium,
            maxline: 1,
            fontwaight: FontWeight.w500,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
            multilanguage: true),
        const SizedBox(height: 8),
        TextFormField(
          obscureText: false,
          keyboardType: keybordType,
          controller: controller,
          textInputAction: textInputAction,
          cursorColor: Theme.of(context).colorScheme.surface,
          style: GoogleFonts.inter(
              fontSize: Dimens.textMedium,
              fontStyle: FontStyle.normal,
              color: Theme.of(context).colorScheme.surface,
              fontWeight: FontWeight.w400),
          decoration: InputDecoration(
            fillColor: gray.withValues(alpha: 0.10),
            filled: true,
            contentPadding: const EdgeInsets.fromLTRB(20, 0, 0, 0),
            focusedBorder: const OutlineInputBorder(
              borderRadius: BorderRadius.all(Radius.circular(7)),
              borderSide: BorderSide(width: 1, color: white),
            ),
            disabledBorder: const OutlineInputBorder(
              borderRadius: BorderRadius.all(Radius.circular(7)),
              borderSide: BorderSide(width: 1, color: white),
            ),
            enabledBorder: const OutlineInputBorder(
              borderRadius: BorderRadius.all(Radius.circular(7)),
              borderSide: BorderSide(width: 1, color: white),
            ),
            border: const OutlineInputBorder(
                borderRadius: BorderRadius.all(Radius.circular(7)),
                borderSide: BorderSide(width: 1, color: white)),
            hintText: hintText,
            hintStyle: GoogleFonts.inter(
                fontSize: Dimens.textMedium,
                fontStyle: FontStyle.normal,
                color: Theme.of(context).colorScheme.surface,
                fontWeight: FontWeight.w400),
          ),
        ),
      ],
    );
  }
}
