import 'dart:io';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:flutter_rating_bar/flutter_rating_bar.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';
import 'package:readmore/readmore.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import 'package:prakah/pages/login.dart';
import 'package:prakah/pages/readbook.dart';
import 'package:prakah/provider/ebookdetailprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import '../utils/utils.dart';

class EbookDetails extends StatefulWidget {
  final String? ebookId, ebookName;
  const EbookDetails(
      {super.key, required this.ebookId, required this.ebookName});

  @override
  State<EbookDetails> createState() => _EbookDetailsState();
}

class _EbookDetailsState extends State<EbookDetails> {
  EbookDetailProvider ebookDetailProvider = EbookDetailProvider();
  TextEditingController commentController = TextEditingController();
  double? height, width;
  double bookrating = 0.0;

  @override
  void initState() {
    super.initState();
    ebookDetailProvider =
        Provider.of<EbookDetailProvider>(context, listen: false);

    WidgetsBinding.instance.addPostFrameCallback((_) {
      getApi();
    });
  }

  void getApi() {
    ebookDetailProvider.setLoading(true);
    ebookDetailProvider.getEbooksDetail(widget.ebookId.toString());
    getRelatedList(0);
    _fetchReviewData(0);
  }

  Future<void> getRelatedList(int? nextPage) async {
    await ebookDetailProvider.getRelatedBooks(
        widget.ebookId ?? "", (nextPage ?? 0) + 1);
  }

  Future<void> _fetchReviewData(int? nextPage) async {
    await ebookDetailProvider.getReviewByBook(
        "1", widget.ebookId, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    ebookDetailProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        elevation: 0,
        systemOverlayStyle: SystemUiOverlayStyle(
            statusBarColor: transparent,
            systemNavigationBarColor: transparent,
            systemNavigationBarDividerColor: transparent),
        backgroundColor: colorPrimaryDark,
        surfaceTintColor: transparent,
        automaticallyImplyLeading: false,
        leading: InkWell(
          onTap: () {
            Navigator.of(context).pop(false);
          },
          child: Icon(Icons.arrow_back_outlined, size: 20, color: white),
        ),
        actions: [
          Consumer<EbookDetailProvider>(
              builder: (context, ebookdetailprovider, child) {
            return Padding(
              padding: const EdgeInsets.all(5),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(10, 0, 10, 0),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.end,
                  children: [
                    InkWell(
                      borderRadius: BorderRadius.circular(50),
                      onTap: () async {
                        AdHelper.showFullscreenAd(
                            context, Constant.interstialAdType, () async {
                          if (Constant.userID == null) {
                            Navigator.of(context).push(
                              PageRouteBuilder(
                                pageBuilder:
                                    (context, animation, secondaryAnimation) =>
                                        const Login(),
                                transitionsBuilder: (context, animation,
                                    secondaryAnimation, child) {
                                  const begin = Offset(1.0, 0.0);
                                  const end = Offset.zero;
                                  const curve = Curves.ease;

                                  var tween = Tween(begin: begin, end: end)
                                      .chain(CurveTween(curve: curve));

                                  return SlideTransition(
                                    position: animation.drive(tween),
                                    child: child,
                                  );
                                },
                              ),
                            );
                          } else {
                            ebookdetailprovider.addRemoveWishlist(
                                "2",
                                ebookdetailprovider
                                        .ebookDetailModel.result?[0].id
                                        .toString() ??
                                    "");
                          }
                        });
                      },
                      child: Padding(
                        padding: const EdgeInsets.all(10.0),
                        child: Icon(
                          ebookdetailprovider
                                      .ebookDetailModel.result?[0].isWishlist ==
                                  1
                              ? Icons.favorite
                              : Icons.favorite_border,
                          color: ebookdetailprovider
                                      .ebookDetailModel.result?[0].isWishlist ==
                                  1
                              ? red
                              : white,
                        ),
                      ),
                    ),
                    InkWell(
                      borderRadius: BorderRadius.circular(50),
                      onTap: () async {
                        AdHelper.showFullscreenAd(
                            context, Constant.interstialAdType, () {
                          if (Utils.checkLoginUser(context)) {
                            if (ebookDetailProvider
                                        .ebookDetailModel.result?[0].isFree ==
                                    0 &&
                                ebookDetailProvider.ebookDetailModel.result?[0]
                                        .isUserBuy !=
                                    1) {
                              /* Primium Page  */
                              Navigator.of(context).push(
                                PageRouteBuilder(
                                  pageBuilder: (context, animation,
                                          secondaryAnimation) =>
                                      AllPayment(
                                    contentType: "4",
                                    payType: 'Package',
                                    itemId: ebookDetailProvider
                                            .ebookDetailModel.result?[0].id
                                            .toString() ??
                                        "",
                                    price: ebookDetailProvider
                                            .ebookDetailModel.result?[0].price
                                            .toString() ??
                                        "",
                                    itemTitle: ebookDetailProvider
                                            .ebookDetailModel.result?[0].title
                                            .toString() ??
                                        "",
                                  ),
                                  transitionsBuilder: (context, animation,
                                      secondaryAnimation, child) {
                                    const begin = Offset(1.0, 0.0);
                                    const end = Offset.zero;
                                    const curve = Curves.ease;

                                    var tween = Tween(begin: begin, end: end)
                                        .chain(CurveTween(curve: curve));

                                    return SlideTransition(
                                      position: animation.drive(tween),
                                      child: child,
                                    );
                                  },
                                ),
                              );
                            } else {
                              addReviewBottomSheet(context);
                            }
                          }
                        });
                      },
                      child: Padding(
                        padding: const EdgeInsets.all(10.0),
                        child: Icon(
                          Icons.star_border,
                          color: white,
                        ),
                      ),
                    ),
                    InkWell(
                      borderRadius: BorderRadius.circular(50),
                      onTap: () {
                        AdHelper.showFullscreenAd(
                            context, Constant.interstialAdType, () {
                          Utils.shareApp(Platform.isIOS
                              ? "Hey! I'm Reading ${widget.ebookName}. Check it out now on ${Constant.appName}! \nhttps://apps.apple.com/us/app/${Constant.appName.toLowerCase()}/${Constant.appPackageName} \n"
                              : "Hey! I'm Reading ${widget.ebookName}. Check it out now on ${Constant.appName}! \nhttps://play.google.com/store/apps/details?id=${Constant.appPackageName} \n");
                        });
                      },
                      child: Padding(
                        padding: const EdgeInsets.all(10.0),
                        child: MyImage(
                          width: 18,
                          height: 18,
                          imagePath: "ic_rightturn.png",
                          color: white,
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            );
          }),
        ],
      ),
      body: Consumer<EbookDetailProvider>(
          builder: (context, ebookDetailProvider, child) {
        return Stack(
          children: [
            SingleChildScrollView(
              padding: const EdgeInsets.fromLTRB(20, 20, 20, 150),
              scrollDirection: Axis.vertical,
              physics: const BouncingScrollPhysics(),
              child: Column(
                spacing: 20,
                children: [
                  bookInformation(),
                  tabWithItem(),
                  aboutAuthor(),
                  buildRelatedBook(),
                  buildStudentFeedback(),
                ],
              ),
            ),
            Positioned.fill(
              child: Align(
                alignment: Alignment.bottomCenter,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.end,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    buyButton(),
                    Utils.showBannerAd(context),
                  ],
                ),
              ),
            ),
          ],
        );
      }),
    );
  }

  Widget bookInformation() {
    if (ebookDetailProvider.loading) {
      return bookInformationShimmer();
    } else {
      if (ebookDetailProvider.ebookDetailModel.status == 200 &&
          ebookDetailProvider.ebookDetailModel.result!.isNotEmpty) {
        return Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            MyNetworkImage(
                imgWidth: 150,
                radius: 5,
                imgHeight: 170,
                imageUrl: ebookDetailProvider
                        .ebookDetailModel.result?[0].thumbnailImg
                        .toString() ??
                    "",
                fit: BoxFit.fill),
            const SizedBox(height: 15),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: ebookDetailProvider.ebookDetailModel.result?[0].title
                        .toString() ??
                    "",
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w700,
                maxline: 3,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal),
            const SizedBox(height: 10),
            MyText(
                color: gray,
                text: ebookDetailProvider.ebookDetailModel.result?[0].tutorName
                        .toString() ??
                    "",
                fontsizeNormal: Dimens.textMedium,
                fontwaight: FontWeight.w500,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal),
          ],
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget bookInformationShimmer() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      crossAxisAlignment: CrossAxisAlignment.center,
      children: [
        CustomWidget.roundrectborder(
          width: 150,
          height: 170,
        ),
        CustomWidget.roundrectborder(width: 250, height: 10),
        CustomWidget.roundrectborder(width: 150, height: 10),
      ],
    );
  }

  Widget tabWithItem() {
    if (ebookDetailProvider.loading) {
      return tabWithItemShimmer();
    } else {
      if (ebookDetailProvider.ebookDetailModel.status == 200 &&
          ebookDetailProvider.ebookDetailModel.result!.isNotEmpty) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            SizedBox(
              height: 45,
              child: Align(
                alignment: Alignment.centerLeft,
                child: ListView.builder(
                  scrollDirection: Axis.horizontal,
                  shrinkWrap: true,
                  physics: const BouncingScrollPhysics(),
                  itemCount: Constant().detailTab.length,
                  itemBuilder: (BuildContext context, int index) {
                    return InkWell(
                      focusColor: transparent,
                      autofocus: false,
                      highlightColor: transparent,
                      hoverColor: transparent,
                      splashColor: transparent,
                      onTap: () {
                        ebookDetailProvider.ebookTab(index);
                      },
                      child: Padding(
                        padding: const EdgeInsets.fromLTRB(0, 0, 10, 0),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            MyText(
                                color: ebookDetailProvider.ebookType == index
                                    ? colorPrimary
                                    : gray,
                                text: Constant().detailTab[index],
                                fontsizeNormal: Dimens.textMedium,
                                fontsizeWeb: Dimens.textMedium,
                                maxline: 1,
                                multilanguage: true,
                                overflow: TextOverflow.ellipsis,
                                fontwaight: FontWeight.w600,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal),
                            const SizedBox(height: 10),
                            Container(
                              width: 60,
                              height: 2,
                              color: ebookDetailProvider.ebookType == index
                                  ? colorPrimary
                                  : transparent,
                            ),
                          ],
                        ),
                      ),
                    );
                  },
                ),
              ),
            ),
            Column(
              children: [
                Container(
                  width: width,
                  height: 1,
                  color: gray,
                ),
                const SizedBox(height: 20),
                ReadMoreText(
                  (ebookDetailProvider.ebookType == 0)
                      ? (ebookDetailProvider.ebookDetailModel.result?[0].summary
                              .toString() ??
                          "")
                      : (ebookDetailProvider
                              .ebookDetailModel.result?[0].specification
                              .toString() ??
                          ""),
                  trimLines: 5,
                  textAlign: TextAlign.left,
                  style: GoogleFonts.montserrat(
                      fontSize: Dimens.textMedium,
                      fontWeight: FontWeight.w500,
                      color: gray),
                  trimCollapsedText: 'Read More',
                  colorClickableText: black,
                  trimMode: TrimMode.Line,
                  trimExpandedText: 'Read less',
                  lessStyle: GoogleFonts.montserrat(
                      fontSize: Dimens.textMedium,
                      fontWeight: FontWeight.w600,
                      color: black),
                  moreStyle: GoogleFonts.montserrat(
                      fontSize: Dimens.textMedium,
                      fontWeight: FontWeight.w600,
                      color: black),
                )
              ],
            ),
          ],
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget tabWithItemShimmer() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        SizedBox(
          height: 45,
          child: Align(
            alignment: Alignment.centerLeft,
            child: ListView.builder(
              scrollDirection: Axis.horizontal,
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              itemCount: Constant().detailTab.length,
              itemBuilder: (BuildContext context, int index) {
                return InkWell(
                  focusColor: white,
                  autofocus: false,
                  highlightColor: white,
                  hoverColor: white,
                  onTap: () {},
                  child: Padding(
                    padding: const EdgeInsets.fromLTRB(0, 0, 10, 0),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyText(
                            color: gray,
                            text: Constant().detailTab[index],
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textSmall,
                            maxline: 1,
                            multilanguage: true,
                            overflow: TextOverflow.ellipsis,
                            fontwaight: FontWeight.w600,
                            textalign: TextAlign.center,
                            fontstyle: FontStyle.normal),
                        const Spacer(),
                        Container(
                          width: 60,
                          height: 2,
                          color: white,
                        ),
                      ],
                    ),
                  ),
                );
              },
            ),
          ),
        ),
        Column(
          children: [
            Container(
              width: width,
              height: 1,
              color: gray,
            ),
            const SizedBox(height: 20),
            Column(
              children: [
                CustomWidget.roundrectborder(
                  height: 10,
                  width: width ?? 0.0 * 0.75,
                ),
                const SizedBox(height: 10),
                CustomWidget.roundrectborder(
                  height: 10,
                  width: width ?? 0.0 * 0.75,
                ),
                const SizedBox(height: 10),
                CustomWidget.roundrectborder(
                  height: 10,
                  width: width ?? 0.0 * 0.75,
                ),
                const SizedBox(height: 10),
                CustomWidget.roundrectborder(
                  height: 10,
                  width: width ?? 0.0 * 0.75,
                ),
                const SizedBox(height: 10),
                CustomWidget.roundrectborder(
                  height: 10,
                  width: width ?? 0.0 * 0.75,
                ),
              ],
            ),
          ],
        ),
      ],
    );
  }

  Widget aboutAuthor() {
    if (ebookDetailProvider.loading) {
      return aboutAuthorShimmer();
    } else {
      if (ebookDetailProvider.ebookDetailModel.status == 200 &&
          ebookDetailProvider.ebookDetailModel.result!.isNotEmpty) {
        return Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                    color: gray,
                    text: "last_update",
                    fontsizeNormal: Dimens.textSmall,
                    multilanguage: true,
                    fontwaight: FontWeight.w500,
                    maxline: 1,
                    fontsizeWeb: Dimens.textSmall,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(width: 3),
                MyText(
                    color: gray,
                    text: Utils.formateDate(
                        ebookDetailProvider
                                .ebookDetailModel.result?[0].updatedAt
                                .toString() ??
                            "",
                        "dd MMMM yyy"),
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    fontsizeWeb: Dimens.textSmall,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            const SizedBox(height: 10),
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                    color: gray,
                    text: "totalhours",
                    fontsizeNormal: Dimens.textSmall,
                    multilanguage: true,
                    fontwaight: FontWeight.w500,
                    maxline: 1,
                    fontsizeWeb: Dimens.textSmall,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(width: 3),
                MyText(
                    color: gray,
                    text: Utils.timeAgoCustom(DateTime.parse(ebookDetailProvider
                            .ebookDetailModel.result?[0].updatedAt
                            .toString() ??
                        "")),
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    fontsizeWeb: Dimens.textSmall,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            const SizedBox(height: 10),
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                    color: gray,
                    text: "language",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w500,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(width: 3),
                MyText(
                    color: gray,
                    text: ":",
                    multilanguage: false,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(width: 3),
                MyText(
                    color: gray,
                    text: ebookDetailProvider
                            .ebookDetailModel.result?[0].languageName
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w500,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            const SizedBox(height: 10),
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyText(
                    color: gray,
                    text: "category",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w500,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(width: 3),
                MyText(
                    color: gray,
                    text: ":",
                    multilanguage: false,
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
                const SizedBox(width: 3),
                MyText(
                    color: gray,
                    text: ebookDetailProvider
                            .ebookDetailModel.result?[0].categoryName
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w700,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            SizedBox(height: 14),
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                MyRating(
                    rating: double.parse(
                      ebookDetailProvider.ebookDetailModel.result?[0].avgRating
                              .toString() ??
                          "",
                    ),
                    spacing: 1,
                    size: 20),
                const SizedBox(width: 10),
                MyText(
                    color: colorAccent,
                    text:
                        "${double.parse(ebookDetailProvider.ebookDetailModel.result?[0].avgRating.toString() ?? "")}",
                    fontsizeNormal: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    maxline: 1,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
            SizedBox(height: 14),
            Utils.htmlTexts(
                context,
                ebookDetailProvider.ebookDetailModel.result?[0].description
                        .toString() ??
                    ""),
          ],
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget aboutAuthorShimmer() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        CustomWidget.roundrectborder(height: 14, width: 250),
        CustomWidget.roundrectborder(width: 200, height: 14),
        CustomWidget.roundrectborder(width: 200, height: 14),
        CustomWidget.roundrectborder(width: 200, height: 14),
        CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
        CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
        CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
        CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
        CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
        CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
        CustomWidget.roundrectborder(height: 10, width: width ?? 0.0 * 0.75),
        CustomWidget.roundrectborder(width: 300, height: 10),
      ],
    );
  }

/* Related BookList */

  Widget buildRelatedBook() {
    if (ebookDetailProvider.relatedBookLoading &&
        !ebookDetailProvider.relatedBookloadMore) {
      return relatedBookItemShimmer();
    } else {
      if (ebookDetailProvider.relatedBookList != null &&
          (ebookDetailProvider.relatedBookList?.length ?? 0) > 0) {
        final isLastPage = (ebookDetailProvider.currentPage ?? 0) >=
            (ebookDetailProvider.totalPage ?? 0);
        final isListNotEmpty =
            (ebookDetailProvider.relatedBookList?.isNotEmpty ?? false);
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 10,
          children: [
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: "relatedbooks",
                fontsizeNormal: Dimens.textTitle,
                fontsizeWeb: Dimens.textTitle,
                maxline: 2,
                multilanguage: true,
                overflow: TextOverflow.ellipsis,
                fontwaight: FontWeight.w600,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            relatedBookItem(),
            if (ebookDetailProvider.relatedBookloadMore)
              Utils.pageLoader()
            else
              const SizedBox.shrink(),

            /// Show More button logic
            if (!isLastPage && isListNotEmpty)
              Align(
                alignment: Alignment.center,
                child: InkWell(
                  hoverColor: transparent,
                  splashColor: transparent,
                  focusColor: transparent,
                  highlightColor: transparent,
                  onTap: () async {
                    ebookDetailProvider.setLoadMore(true);
                    await getRelatedList(ebookDetailProvider.currentPage ?? 0);
                  },
                  child: MyText(
                    text: "more",
                    maxline: 1,
                    multilanguage: true,
                    fontsizeNormal: Dimens.textlargeBig,
                    fontwaight: FontWeight.w700,
                  ),
                ),
              ),
          ],
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget relatedBookItem() {
    return ResponsiveGridList(
        minItemWidth: 300,
        minItemsPerRow: 1,
        maxItemsPerRow: 1,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          padding: EdgeInsets.zero,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(
            ebookDetailProvider.relatedBookList?.length ?? 0, (index) {
          return InkWell(
            focusColor: transparent,
            splashColor: transparent,
            highlightColor: transparent,
            hoverColor: transparent,
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).pushReplacement(PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        EbookDetails(
                          ebookId: ebookDetailProvider
                                  .relatedBookList?[index].id
                                  .toString() ??
                              "",
                          ebookName: ebookDetailProvider
                                  .relatedBookList?[index].title
                                  .toString() ??
                              "",
                        ),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                          position: animation.drive(tween), child: child);
                    }));
              });
            },
            child: Container(
              width: MediaQuery.of(context).size.width,
              decoration: BoxDecoration(
                color: Theme.of(context).cardColor,
                borderRadius: BorderRadius.circular(5),
                boxShadow: [
                  BoxShadow(
                    color: gray.withValues(alpha: 0.50),
                    blurRadius: 2,
                    offset: const Offset(0.1, 0.1),
                  ),
                ],
              ),
              child: Row(
                children: [
                  ClipRRect(
                    borderRadius: const BorderRadius.only(
                        bottomLeft: Radius.circular(5),
                        topLeft: Radius.circular(5)),
                    child: MyNetworkImage(
                      imgWidth: 110,
                      imgHeight: 100,
                      imageUrl: ebookDetailProvider
                              .relatedBookList?[index].thumbnailImg
                              .toString() ??
                          "",
                      fit: BoxFit.fill,
                    ),
                  ),
                  const SizedBox(width: 8),
                  Expanded(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      spacing: 4,
                      children: [
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: ebookDetailProvider
                                    .relatedBookList?[index].title
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 2,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            MyText(
                                color: gray,
                                text: Utils.kmbGenerator(
                                  int.parse(ebookDetailProvider
                                          .relatedBookList?[index].totalView
                                          .toString() ??
                                      ""),
                                ),
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                            const SizedBox(width: 5),
                            MyText(
                                color: gray,
                                text: "students",
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1,
                                multilanguage: true,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            MyRating(
                                rating: double.parse((ebookDetailProvider
                                        .relatedBookList?[index].avgRating
                                        .toString() ??
                                    "")),
                                spacing: 1,
                                size: 10),
                            const SizedBox(width: 8),
                            MyText(
                                color: colorAccent,
                                text:
                                    "${double.parse(ebookDetailProvider.relatedBookList?[index].avgRating.toString() ?? "")} ",
                                fontsizeNormal: Dimens.textMedium,
                                fontwaight: FontWeight.w600,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          );
        }));
  }

  Widget relatedBookItemShimmer() {
    return Padding(
      padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
      child: ResponsiveGridList(
        minItemWidth: 160,
        minItemsPerRow: 1,
        maxItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
          shrinkWrap: true,
          physics: const NeverScrollableScrollPhysics(),
        ),
        children: List.generate(
          10,
          (index) {
            return const Row(
              children: [
                CustomWidget.roundrectborder(
                  width: 125,
                  height: 110,
                ),
                SizedBox(width: 10),
                Expanded(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CustomWidget.roundcorner(
                        width: 180,
                        height: 5,
                      ),
                      SizedBox(height: 8),
                      CustomWidget.roundcorner(
                        width: 180,
                        height: 5,
                      ),
                      SizedBox(height: 8),
                      CustomWidget.roundcorner(
                        width: 180,
                        height: 5,
                      ),
                    ],
                  ),
                ),
              ],
            );
          },
        ),
      ),
    );
  }

/* Review List  */

  Widget buildStudentFeedback() {
    if (ebookDetailProvider.reviewloading &&
        !ebookDetailProvider.reviewloadmore) {
      return const SizedBox.shrink();
    } else {
      if (ebookDetailProvider.reviewList != null &&
          (ebookDetailProvider.reviewList?.length ?? 0) > 0) {
        final isLastPage = (ebookDetailProvider.reviewcurrentPage ?? 0) >=
            (ebookDetailProvider.reviewtotalPage ?? 0);
        final isListNotEmpty =
            (ebookDetailProvider.reviewList?.isNotEmpty ?? false);
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          mainAxisAlignment: MainAxisAlignment.start,
          spacing: 14,
          children: [
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: "studentfeedback",
                fontsizeNormal: Dimens.textTitle,
                fontwaight: FontWeight.w600,
                maxline: 1,
                multilanguage: true,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal),
            buildStudentFeedbackItem(),
            if (ebookDetailProvider.reviewloadmore)
              Utils.pageLoader()
            else
              const SizedBox.shrink(),

            /// Show More button logic
            if (!isLastPage && isListNotEmpty)
              Align(
                alignment: Alignment.center,
                child: InkWell(
                  hoverColor: transparent,
                  splashColor: transparent,
                  focusColor: transparent,
                  highlightColor: transparent,
                  onTap: () async {
                    ebookDetailProvider.setReviewLoadMore(true);
                    await _fetchReviewData(
                        ebookDetailProvider.currentPage ?? 0);
                  },
                  child: MyText(
                    text: "more",
                    maxline: 1,
                    multilanguage: true,
                    fontsizeNormal: Dimens.textlargeBig,
                    fontwaight: FontWeight.w700,
                  ),
                ),
              ),
          ],
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget buildStudentFeedbackItem() {
    return ResponsiveGridList(
      minItemWidth: 120,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      horizontalGridSpacing: 10,
      verticalGridSpacing: 0,
      listViewBuilderOptions: ListViewBuilderOptions(
        scrollDirection: Axis.vertical,
        shrinkWrap: true,
        padding: EdgeInsets.zero,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        ebookDetailProvider.reviewList?.length ?? 0,
        (index) {
          return Container(
            padding: const EdgeInsets.fromLTRB(15, 5, 15, 5),
            decoration: BoxDecoration(
              color: Theme.of(context).cardColor,
              borderRadius: BorderRadius.circular(5),
              boxShadow: [
                BoxShadow(
                  color: gray.withValues(alpha: 0.3),
                  spreadRadius: 1.5,
                  blurRadius: 0.5,
                  offset: const Offset(0, 1),
                ),
              ],
            ),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    MyNetworkImage(
                      imgWidth: 30,
                      radius: 200,
                      imgHeight: 30,
                      imageUrl:
                          ebookDetailProvider.reviewList?[index].userImage ??
                              "",
                      fit: BoxFit.fill,
                    ),
                    const SizedBox(width: 8),
                    Expanded(
                      child: Align(
                        alignment: Alignment.centerLeft,
                        child: ebookDetailProvider
                                        .reviewList?[index].firstName ==
                                    "" ||
                                ebookDetailProvider
                                        .reviewList?[index].lastName ==
                                    ""
                            ? MyText(
                                color: Theme.of(context).colorScheme.surface,
                                text: ebookDetailProvider
                                        .reviewList?[index].userName
                                        .toString() ??
                                    "",
                                fontsizeNormal: Dimens.textMedium,
                                fontwaight: FontWeight.w700,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal)
                            : MyText(
                                color: Theme.of(context).colorScheme.surface,
                                text:
                                    "${ebookDetailProvider.reviewList?[index].firstName.toString() ?? ""} ${ebookDetailProvider.reviewList?[index].lastName.toString() ?? ""}",
                                fontsizeNormal: Dimens.textMedium,
                                fontwaight: FontWeight.w700,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.center,
                                fontstyle: FontStyle.normal),
                      ),
                    ),
                    const SizedBox(width: 8),
                    MyText(
                        color: colorPrimary,
                        text: Utils.formateDate(
                            ebookDetailProvider.reviewList?[index].createdAt
                                    .toString() ??
                                "",
                            Constant.dateformat),
                        fontsizeNormal: Dimens.textSmall,
                        fontwaight: FontWeight.w500,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
                const SizedBox(height: 10),
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    MyRating(
                      size: 18,
                      rating: double.parse((ebookDetailProvider
                              .reviewList?[index].rating
                              .toString() ??
                          "")),
                      spacing: 3,
                    ),
                    const SizedBox(width: 5),
                    MyText(
                        color: colorAccent,
                        text:
                            "${double.parse((ebookDetailProvider.reviewList?[index].rating.toString() ?? ""))}",
                        fontsizeNormal: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
                const SizedBox(height: 10),
                MyText(
                    color: gray,
                    text: ebookDetailProvider.reviewList?[index].comment
                            .toString() ??
                        "",
                    fontsizeNormal: Dimens.textSmall,
                    fontwaight: FontWeight.w400,
                    maxline: 5,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal),
              ],
            ),
          );
        },
      ),
    );
  }

/* Buy Button in Bottom */

  Widget buyButton() {
    if (ebookDetailProvider.loading) {
      return const SizedBox.shrink();
    } else {
      return Container(
        height: 80,
        alignment: Alignment.center,
        padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
        width: MediaQuery.of(context).size.width,
        color: lightblack,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Container(
              height: 50,
              width: 80,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(50),
                border: Border.all(width: 0.7, color: colorAccent),
              ),
              child: MyText(
                  color: colorAccent,
                  text: ebookDetailProvider
                                  .ebookDetailModel.result?[0].isFree ==
                              1 ||
                          ebookDetailProvider
                                  .ebookDetailModel.result?[0].isUserBuy ==
                              1
                      ? "free"
                      : "${Constant.currencyCode}${ebookDetailProvider.ebookDetailModel.result?[0].price}",
                  multilanguage: false,
                  fontsizeNormal: Dimens.textTitle,
                  fontwaight: FontWeight.w700,
                  maxline: 1,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal),
            ),
            const SizedBox(width: 10),
            Expanded(
              child: InkWell(
                onTap: () async {
                  if (Constant.userID == null) {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            const Login(),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  } else {
                    if (ebookDetailProvider
                                .ebookDetailModel.result?[0].isFree ==
                            0 &&
                        ebookDetailProvider
                                .ebookDetailModel.result?[0].isUserBuy !=
                            1) {
                      /* Primium Page  */
                      Navigator.of(context).push(
                        PageRouteBuilder(
                          pageBuilder:
                              (context, animation, secondaryAnimation) =>
                                  AllPayment(
                            contentType: "4",
                            payType: 'Package',
                            itemId: ebookDetailProvider
                                    .ebookDetailModel.result?[0].id
                                    .toString() ??
                                "",
                            price: ebookDetailProvider
                                    .ebookDetailModel.result?[0].price
                                    .toString() ??
                                "",
                            itemTitle: ebookDetailProvider
                                    .ebookDetailModel.result?[0].title
                                    .toString() ??
                                "",
                          ),
                          transitionsBuilder:
                              (context, animation, secondaryAnimation, child) {
                            const begin = Offset(1.0, 0.0);
                            const end = Offset.zero;
                            const curve = Curves.ease;

                            var tween = Tween(begin: begin, end: end)
                                .chain(CurveTween(curve: curve));

                            return SlideTransition(
                              position: animation.drive(tween),
                              child: child,
                            );
                          },
                        ),
                      );
                    } else {
                      if (ebookDetailProvider
                                  .ebookDetailModel.result?[0].bookUrl ==
                              "" ||
                          ebookDetailProvider
                                  .ebookDetailModel.result?[0].bookUrl ==
                              null) {
                        Utils.showSnackbar(
                            context, "fail", "bookcontentnotavailable", true);
                      } else {
                        Navigator.of(context).push(
                          PageRouteBuilder(
                            pageBuilder:
                                (context, animation, secondaryAnimation) =>
                                    ReadBook(
                              bookId: ebookDetailProvider
                                      .ebookDetailModel.result?[0].id
                                      .toString() ??
                                  "",
                              pdfURL: ebookDetailProvider
                                      .ebookDetailModel.result?[0].bookUrl
                                      .toString() ??
                                  "",
                              bookName: ebookDetailProvider
                                      .ebookDetailModel.result?[0].title
                                      .toString() ??
                                  "",
                            ),
                            transitionsBuilder: (context, animation,
                                secondaryAnimation, child) {
                              const begin = Offset(1.0, 0.0);
                              const end = Offset.zero;
                              const curve = Curves.ease;

                              var tween = Tween(begin: begin, end: end)
                                  .chain(CurveTween(curve: curve));

                              return SlideTransition(
                                position: animation.drive(tween),
                                child: child,
                              );
                            },
                          ),
                        );
                      }
                    }
                  }
                },
                child: Container(
                  width: MediaQuery.of(context).size.width,
                  height: 50,
                  alignment: Alignment.center,
                  padding: const EdgeInsets.fromLTRB(0, 8, 0, 8),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(50),
                    color: colorPrimary,
                  ),
                  child: MyText(
                      color: white,
                      text: ebookDetailProvider
                                      .ebookDetailModel.result?[0].isFree ==
                                  1 ||
                              ebookDetailProvider
                                      .ebookDetailModel.result?[0].isUserBuy ==
                                  1
                          ? "readnow"
                          : "buynow",
                      multilanguage: true,
                      fontsizeNormal: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ),
              ),
            ),
          ],
        ),
      );
    }
  }

  Future<Future> addReviewBottomSheet(BuildContext context) async {
    return showModalBottomSheet(
      context: context,
      isScrollControlled: true,
      clipBehavior: Clip.antiAliasWithSaveLayer,
      builder: (BuildContext context) {
        return StatefulBuilder(
            builder: (BuildContext context, StateSetter setState) {
          return Consumer<EbookDetailProvider>(
              builder: (context, detailprovider, child) {
            return Container(
              color: Theme.of(context).cardColor,
              padding: const EdgeInsets.all(20).copyWith(
                bottom: MediaQuery.of(context).viewInsets.bottom,
              ),
              child: Wrap(
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      MyText(
                          color: Theme.of(context).colorScheme.surface,
                          fontsizeNormal: Dimens.textBig,
                          fontsizeWeb: Dimens.textBig,
                          multilanguage: true,
                          maxline: 1,
                          fontwaight: FontWeight.w600,
                          text: "addreview",
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      RatingBar(
                        initialRating: 0,
                        direction: Axis.horizontal,
                        allowHalfRating: true,
                        itemSize: 25,
                        itemCount: 5,
                        ratingWidget: RatingWidget(
                          full: const Icon(
                            Icons.star,
                            color: colorAccent,
                          ),
                          half: const Icon(Icons.star_half, color: colorAccent),
                          empty:
                              const Icon(Icons.star_border, color: colorAccent),
                        ),
                        itemPadding:
                            const EdgeInsets.symmetric(horizontal: 4.0),
                        onRatingUpdate: (rating) {
                          bookrating = rating;
                        },
                      ),
                    ],
                  ),
                  Padding(
                    padding: const EdgeInsets.fromLTRB(0, 20, 0, 20),
                    child: TextField(
                      textAlign: TextAlign.start,
                      controller: commentController,
                      cursorColor: Theme.of(context).colorScheme.surface,
                      keyboardType: TextInputType.multiline,
                      textInputAction: TextInputAction.newline,
                      minLines: 2,
                      maxLines: 5,
                      style: GoogleFonts.inter(
                        fontSize: Dimens.textTitle,
                        fontStyle: FontStyle.normal,
                        color: Theme.of(context).colorScheme.surface,
                        fontWeight: FontWeight.w400,
                      ),
                      decoration: InputDecoration(
                        hintText: Locales.string(context, "addcomment"),
                        hintStyle: GoogleFonts.inter(
                          fontSize: Dimens.textTitle,
                          fontStyle: FontStyle.normal,
                          color: colorPrimary.withValues(alpha: 0.40),
                          fontWeight: FontWeight.w400,
                        ),
                        border: OutlineInputBorder(
                          borderRadius: BorderRadius.circular(8),
                          borderSide: BorderSide(
                              width: 1,
                              color: colorPrimaryDark,
                              style: BorderStyle.solid),
                        ),
                        errorBorder: OutlineInputBorder(
                          borderRadius: BorderRadius.circular(8),
                          borderSide: BorderSide(
                              width: 1,
                              color: colorPrimaryDark,
                              style: BorderStyle.solid),
                        ),
                        focusedBorder: OutlineInputBorder(
                          borderRadius: BorderRadius.circular(8),
                          borderSide: BorderSide(
                              width: 1,
                              color: colorPrimaryDark,
                              style: BorderStyle.solid),
                        ),
                        enabledBorder: OutlineInputBorder(
                          borderRadius: BorderRadius.circular(8),
                          borderSide: BorderSide(
                              width: 1,
                              color: colorPrimaryDark,
                              style: BorderStyle.solid),
                        ),
                        filled: true,
                        contentPadding: const EdgeInsets.all(15),
                        fillColor: white,
                      ),
                    ),
                  ),
                  Padding(
                    padding: const EdgeInsets.fromLTRB(0, 20, 0, 55),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.end,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        InkWell(
                          onTap: () {
                            Navigator.pop(context);
                          },
                          child: Container(
                            padding: const EdgeInsets.fromLTRB(15, 8, 15, 8),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(5),
                              border: Border.all(
                                width: 0.8,
                                color: gray,
                              ),
                            ),
                            child: MyText(
                                color: black,
                                fontsizeNormal: Dimens.textTitle,
                                fontsizeWeb: Dimens.textTitle,
                                multilanguage: true,
                                maxline: 1,
                                fontwaight: FontWeight.w500,
                                text: "cancel",
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ),
                        ),
                        const SizedBox(width: 15),
                        InkWell(
                          onTap: () async {
                            if (bookrating == 0.0) {
                              Utils.showSnackbar(
                                  context, "fail", "pleaseenterrating", true);
                            } else if (commentController.text.toString() ==
                                "") {
                              Utils.showSnackbar(
                                  context, "fail", "pleaseentercomment", true);
                            } else {
                              detailprovider.setAddReviewLoding(true);
                              await detailprovider.addReview(
                                  "1",
                                  widget.ebookId ?? "",
                                  commentController.text,
                                  bookrating);

                              if (detailprovider.successModel.status == 200) {
                                if (!context.mounted) return;
                                Navigator.pop(context);

                                commentController.clear();
                                bookrating = 0;
                                _fetchReviewData(0);
                                detailprovider.setAddReviewLoding(false);
                              } else {
                                if (!context.mounted) return;
                                Navigator.pop(context);
                                Utils.showSnackbar(
                                    context,
                                    "fail",
                                    detailprovider.successModel.message ?? "",
                                    false);
                                detailprovider.setAddReviewLoding(false);
                              }
                            }
                          },
                          child: AnimatedContainer(
                            duration: const Duration(milliseconds: 200),
                            clipBehavior: Clip.antiAliasWithSaveLayer,
                            curve: Curves.bounceInOut,
                            padding: const EdgeInsets.fromLTRB(15, 8, 15, 8),
                            decoration: BoxDecoration(
                              borderRadius: BorderRadius.circular(5),
                              color: colorPrimary,
                            ),
                            child: detailprovider.isReviewLoding
                                ? Container(
                                    padding: EdgeInsets.all(4),
                                    height: 25,
                                    child: CircularProgressIndicator(
                                      color: white,
                                    ),
                                  )
                                : MyText(
                                    color: white,
                                    fontsizeNormal: Dimens.textTitle,
                                    fontsizeWeb: Dimens.textTitle,
                                    multilanguage: true,
                                    maxline: 1,
                                    fontwaight: FontWeight.w700,
                                    text: "submit",
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                          ),
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            );
          });
        });
      },
    );
  }
}
