import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/couponprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class Coupon extends StatefulWidget {
  final int? price;
  const Coupon({super.key, required this.price});

  @override
  State<Coupon> createState() => _CouponState();
}

class _CouponState extends State<Coupon> {
  CouponProvider couponProvider = CouponProvider();
  final ScrollController _scrollController = ScrollController();
  @override
  void initState() {
    super.initState();
    couponProvider = Provider.of<CouponProvider>(context, listen: false);
    _scrollController.addListener(_scrollListener);

    getApi(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (couponProvider.currentPage ?? 0) < (couponProvider.totalPage ?? 0)) {
      couponProvider.setLoadMore(true);
      getApi(couponProvider.currentPage ?? 0);
    }
  }

  Future<void> getApi(int? nextPage) async {
    await couponProvider.getUseMeeting((nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    couponProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "coupon",
          multilanguage: true),
      body: Consumer<CouponProvider>(builder: (context, couponProvider, child) {
        return _buildData();
      }),
    );
  }

  Widget _buildData() {
    if (couponProvider.loading) {
      return shimmer();
    } else {
      if (couponProvider.cartList != null &&
          (couponProvider.cartList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          controller: _scrollController,
          padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
          clipBehavior: Clip.antiAliasWithSaveLayer,
          physics: const AlwaysScrollableScrollPhysics(),
          child: Column(
            children: [
              couponData(),
              const SizedBox(height: 10),
              if (couponProvider.loadMore)
                Utils.pageLoader()
              else
                const SizedBox.shrink(),
              const SizedBox(height: 20),
            ],
          ),
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget couponData() {
    return ResponsiveGridList(
        minItemWidth: 300,
        verticalGridMargin: 0,
        horizontalGridMargin: 0,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          couponProvider.cartList?.length ?? 0,
          (index) {
            return InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                applyApi(
                    index,
                    couponProvider.cartList?[index].id.toString() ?? "",
                    widget.price,
                    couponProvider.cartList?[index].name.toString() ?? "");
              },
              child: Card(
                color: white,
                child: Padding(
                  padding: const EdgeInsets.fromLTRB(14, 10, 14, 10),
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 20,
                    children: [
                      MyNetworkImage(
                          imageUrl: couponProvider.cartList?[index].image
                                  .toString() ??
                              "",
                          imgHeight: 60,
                          imgWidth: 60,
                          radius: 10,
                          fit: BoxFit.contain),
                      Expanded(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            MyText(
                              text: couponProvider.cartList?[index].name
                                      .toString() ??
                                  "",
                              maxline: 2,
                              overflow: TextOverflow.ellipsis,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: black,
                              fontwaight: FontWeight.w500,
                            ),
                            MyText(
                              text:
                                  "${Locales.string(context, "use_code")} : ${couponProvider.cartList?[index].promoCode.toString() ?? ""}",
                              maxline: 2,
                              overflow: TextOverflow.ellipsis,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: black,
                              fontwaight: FontWeight.w500,
                            ),
                            const SizedBox(height: 5),
                            MyText(
                              text: (couponProvider.cartList?[index].type
                                              .toString() ??
                                          "") ==
                                      "1"
                                  ? '${Constant.currencyCode} ${couponProvider.cartList?[index].discountAmount ?? ""}'
                                  : "% ${couponProvider.cartList?[index].discountAmount ?? ""}",
                              maxline: 2,
                              overflow: TextOverflow.ellipsis,
                              multilanguage: false,
                              fontsizeNormal: Dimens.textMedium,
                              color: colorPrimaryDark,
                              fontwaight: FontWeight.w400,
                            ),
                          ],
                        ),
                      ),
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () {
                          applyApi(
                              index,
                              couponProvider.cartList?[index].id.toString() ??
                                  "",
                              widget.price,
                              couponProvider.cartList?[index].name.toString() ??
                                  "");
                        },
                        child: AnimatedContainer(
                          duration: Duration(milliseconds: 600),
                          padding: const EdgeInsets.fromLTRB(10, 4, 10, 4),
                          decoration: BoxDecoration(
                              color: white,
                              borderRadius: BorderRadius.circular(6),
                              border: Border.all(
                                  width: 1,
                                  color: gray,
                                  style: BorderStyle.solid)),
                          child: couponProvider.applyLoded &&
                                  couponProvider.index == index
                              ? SizedBox(
                                  height: 20,
                                  width: 20,
                                  child: CircularProgressIndicator(
                                    color: colorPrimaryDark,
                                  ),
                                )
                              : MyText(
                                  text: 'apply',
                                  maxline: 2,
                                  overflow: TextOverflow.ellipsis,
                                  multilanguage: true,
                                  fontsizeNormal: Dimens.textSmall,
                                  color: black,
                                  fontwaight: FontWeight.w400,
                                ),
                        ),
                      )
                    ],
                  ),
                ),
              ),
            );
          },
        ));
  }

  Widget shimmer() {
    return ResponsiveGridList(
        minItemWidth: 300,
        verticalGridMargin: 10,
        horizontalGridMargin: 10,
        verticalGridSpacing: 10,
        horizontalGridSpacing: 10,
        minItemsPerRow: 1,
        maxItemsPerRow: 2,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true, physics: const NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return const Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.circular(height: 20, width: 20),
                SizedBox(width: 20),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      CustomWidget.roundcorner(height: 22, width: 100),
                      SizedBox(height: 3),
                      CustomWidget.roundcorner(height: 16, width: 200),
                      SizedBox(height: 3),
                      CustomWidget.roundcorner(height: 18, width: 100),
                    ],
                  ),
                )
              ],
            );
          },
        ));
  }

  /* Apply coupen Api */
  Future<void> applyApi(
      int index, promocodeId, totalPrice, promocodeName) async {
    couponProvider.setApplyLoding(true);

    await couponProvider.getApplyCoupon(index, promocodeId, totalPrice);
    if (!mounted) return;
    if (couponProvider.applyCouponModel.status == 200 &&
        (couponProvider.applyCouponModel.result?.length ?? 0) > 0) {
      couponProvider.setApplyLoding(false);

      Navigator.of(context).pop({
        "discount_price": couponProvider
                .applyCouponModel.result?[0].discountAmount
                .toString() ??
            "",
        "promocodeId": promocodeId,
        "promocodeName": promocodeName,
        "price":
            couponProvider.applyCouponModel.result?[0].price.toString() ?? ""
      });
    } else {
      couponProvider.setApplyLoding(false);

      printLog(couponProvider.applyCouponModel.message ?? "");
    }
  }
}
