import 'package:prakah/pages/coupon.dart';
import 'package:prakah/provider/meetingdetailsprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';

class ConfirmAppoinment extends StatefulWidget {
  final String? mettingId,
      mettingScheduleId,
      chapterId,
      totalPrice,
      details,
      attachment,
      weekDayName,
      startedTime,
      endTime;

  final DateTime date;

  const ConfirmAppoinment({
    super.key,
    required this.mettingId,
    required this.attachment,
    required this.chapterId,
    required this.date,
    required this.details,
    required this.mettingScheduleId,
    required this.totalPrice,
    required this.weekDayName,
    required this.startedTime,
    required this.endTime,
  });

  @override
  State<ConfirmAppoinment> createState() => _ConfirmAppoinmentState();
}

class _ConfirmAppoinmentState extends State<ConfirmAppoinment> {
  MeetingDetailsProvider meetingDetailsProvider = MeetingDetailsProvider();
  String? date;
  String? discountPrice, price, promocodeId, promocodeName = "";
  @override
  void initState() {
    printLog(
        "My Data== me ${widget.mettingId}\n meSC${widget.mettingScheduleId} \ndate ${widget.date} \ncha${widget.chapterId} \npric ${widget.totalPrice} \ndetai ${widget.details} \natt ${widget.attachment}");

    super.initState();

    date = DateFormat("MMM dd, yyyy").format(widget.date);

    meetingDetailsProvider =
        Provider.of<MeetingDetailsProvider>(context, listen: false);

    getApi();
  }

  Future<void> getApi() async {
    await meetingDetailsProvider.getMeetingDetails(widget.mettingId ?? "");
  }

  @override
  void dispose() {
    meetingDetailsProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "confirm_appointment",
          multilanguage: true),
      body: Consumer<MeetingDetailsProvider>(
        builder: (context, meetingDetailsProvider, child) {
          return SingleChildScrollView(
            padding: EdgeInsets.fromLTRB(15, 10, 15, 10),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              spacing: 10,
              children: [
                MyText(
                  text: "booking_info",
                  multilanguage: true,
                  color: black,
                  maxline: 1,
                  fontsizeNormal: Dimens.textTitle,
                  fontsizeWeb: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                ),
                bookingInfoData(),
                SizedBox(height: 10),
                _couponeShowdata(),
                SizedBox(height: 10),
                MyText(
                  text: "payment_info",
                  multilanguage: true,
                  color: black,
                  maxline: 1,
                  fontsizeNormal: Dimens.textTitle,
                  fontsizeWeb: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                ),
                paymentSummaryData(),
              ],
            ),
          );
        },
      ),
      bottomNavigationBar: BottomAppBar(
        color: white,
        child: _btnWidget(),
      ),
    );
  }

  Widget bookingInfoData() {
    if (meetingDetailsProvider.loading) {
      return shimmer();
    } else {
      if (meetingDetailsProvider.meetingDetailsModel.status == 200 &&
          (meetingDetailsProvider.meetingDetailsModel.result?.length ?? 0) >
              0) {
        final meetingListData =
            meetingDetailsProvider.meetingDetailsModel.result?[0];
        return Container(
          width: MediaQuery.sizeOf(context).width,
          padding: EdgeInsets.fromLTRB(16, 10, 16, 10),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.circular(12),
              boxShadow: [
                BoxShadow(
                    blurRadius: 11,
                    blurStyle: BlurStyle.outer,
                    offset: Offset(0, 3),
                    color: transparent.withValues(alpha: 0.08),
                    spreadRadius: 0)
              ]),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 10,
            children: [
              Row(
                spacing: 20,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    padding: EdgeInsets.all(4),
                    decoration: BoxDecoration(
                        shape: BoxShape.circle,
                        border: Border.all(
                            width: 1,
                            color: colorPrimaryDark,
                            style: BorderStyle.solid)),
                    child: MyNetworkImage(
                        radius: 50,
                        imgHeight: 80,
                        imgWidth: 80,
                        imageUrl: meetingListData?.lecturerImage ?? "",
                        fit: BoxFit.fill),
                  ),
                  Expanded(
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      spacing: 4,
                      children: [
                        MyText(
                          text: meetingListData?.lecturerName ?? "",
                          multilanguage: false,
                          color: black,
                          maxline: 1,
                          fontsizeNormal: Dimens.textTitle,
                          fontsizeWeb: Dimens.textMedium,
                          fontwaight: FontWeight.w600,
                        ),
                        Row(
                          spacing: 2,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: [
                            MyText(
                              text: Locales.string(context, "topic"),
                              multilanguage: false,
                              color: black,
                              maxline: 1,
                              fontsizeNormal: Dimens.textMedium,
                              fontsizeWeb: Dimens.textMedium,
                              fontwaight: FontWeight.w400,
                            ),
                            Expanded(
                              child: MyText(
                                text: meetingListData?.title ?? "",
                                multilanguage: false,
                                color: gray,
                                maxline: 1,
                                fontsizeNormal: Dimens.textMedium,
                                fontsizeWeb: Dimens.textMedium,
                                fontwaight: FontWeight.w400,
                              ),
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                    decoration: BoxDecoration(
                        color: red, borderRadius: BorderRadius.circular(8)),
                    child: MyText(
                      text: "paid",
                      multilanguage: true,
                      color: white,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                    ),
                  )
                ],
              ),
              Container(
                width: MediaQuery.sizeOf(context).width,
                padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                decoration: BoxDecoration(
                    color: colorPrimary.withValues(alpha: 0.4),
                    borderRadius: BorderRadius.circular(8)),
                child: Wrap(
                  crossAxisAlignment: WrapCrossAlignment.center,
                  runSpacing: 3,
                  spacing: 10,
                  children: [
                    Icon(
                      Icons.watch_later,
                      size: 20,
                      color: colorPrimaryDark,
                    ),
                    MyText(
                      text: widget.weekDayName ?? "",
                      multilanguage: false,
                      color: black,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w600,
                    ),
                    MyText(
                      text: date ?? "",
                      multilanguage: false,
                      color: black,
                      fontstyle: FontStyle.normal,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w400,
                    ),
                    MyText(
                      text: Utils.formateTime(
                          staTime: widget.startedTime, enTime: widget.endTime),
                      multilanguage: false,
                      color: black,
                      maxline: 1,
                      fontstyle: FontStyle.normal,
                      fontsizeNormal: Dimens.textMedium,
                      fontsizeWeb: Dimens.textMedium,
                      fontwaight: FontWeight.w400,
                    ),
                  ],
                ),
              )
            ],
          ),
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget shimmer() {
    return Container(
      width: MediaQuery.sizeOf(context).width,
      padding: EdgeInsets.fromLTRB(16, 10, 16, 10),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(12),
          boxShadow: [
            BoxShadow(
                blurRadius: 11,
                blurStyle: BlurStyle.outer,
                offset: Offset(0, 3),
                color: transparent.withValues(alpha: 0.08),
                spreadRadius: 0)
          ]),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          Row(
            spacing: 20,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Container(
                  padding: EdgeInsets.all(4),
                  decoration: BoxDecoration(
                      shape: BoxShape.circle,
                      border: Border.all(
                          width: 1,
                          color: colorPrimaryDark,
                          style: BorderStyle.solid)),
                  child: CustomWidget.circular(height: 80, width: 80)),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  spacing: 4,
                  children: [
                    CustomWidget.roundcorner(height: 16, width: 150),
                    CustomWidget.roundcorner(height: 14, width: 130),
                    CustomWidget.roundcorner(height: 14, width: 130),
                  ],
                ),
              ),
              Container(
                padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
                decoration: BoxDecoration(
                    color: red, borderRadius: BorderRadius.circular(8)),
                child: CustomWidget.roundcorner(height: 16, width: 60),
              )
            ],
          ),
          Container(
            width: MediaQuery.sizeOf(context).width,
            padding: EdgeInsets.fromLTRB(10, 6, 10, 6),
            decoration: BoxDecoration(
                color: colorPrimary.withValues(alpha: 0.4),
                borderRadius: BorderRadius.circular(8)),
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.start,
              spacing: 10,
              children: [
                CustomWidget.circular(height: 16, width: 16),
                Expanded(
                    child: CustomWidget.roundcorner(height: 16, width: 150)),
                Expanded(
                    child: CustomWidget.roundcorner(height: 16, width: 150)),
              ],
            ),
          )
        ],
      ),
    );
  }

/* coupone apply code ui show or not */
  Widget _couponeShowdata() {
    return InkWell(
      onTap: () async {
        var result = await Navigator.of(context).push(
          PageRouteBuilder(
            pageBuilder: (context, animation, secondaryAnimation) => Coupon(
              price: int.parse(widget.totalPrice ?? ""),
            ),
            transitionsBuilder:
                (context, animation, secondaryAnimation, child) {
              const begin = Offset(1.0, 0.0);
              const end = Offset.zero;
              const curve = Curves.ease;

              var tween =
                  Tween(begin: begin, end: end).chain(CurveTween(curve: curve));

              return SlideTransition(
                position: animation.drive(tween),
                child: child,
              );
            },
          ),
        );
        if (result != null) {
          discountPrice = result['discount_price'];
          price = result["price"];
          promocodeName = result['promocodeName'];
          promocodeId = result["promocodeId"];

          printLog("$discountPrice, $price, $promocodeId, $promocodeName");
        }

        meetingDetailsProvider.providerNoti();
      },
      child: Container(
        padding: EdgeInsets.fromLTRB(15, 10, 15, 10),
        decoration: BoxDecoration(
            color: white,
            borderRadius: BorderRadius.circular(16),
            boxShadow: [
              BoxShadow(
                  blurRadius: 4,
                  blurStyle: BlurStyle.outer,
                  offset: Offset(0, 4),
                  spreadRadius: 0,
                  color: transparent.withValues(alpha: 0.25))
            ]),
        child: Row(
          spacing: 10,
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            Icon(Icons.discount, size: 20, color: colorPrimary),
            Expanded(
              child: MyText(
                text: (promocodeName ?? "").isEmpty
                    ? Locales.string(context, "add_coupon")
                    : promocodeName ?? "",
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textBig,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ),
            (promocodeName ?? "").isEmpty
                ? SizedBox.shrink()
                : InkWell(
                    splashColor: transparent,
                    focusColor: transparent,
                    hoverColor: transparent,
                    highlightColor: transparent,
                    onTap: () async {
                      await meetingDetailsProvider
                          .getRemoveCoupone(widget.totalPrice ?? "");

                      if (meetingDetailsProvider.applyCouponModel.status ==
                          200) {
                        discountPrice = meetingDetailsProvider
                            .applyCouponModel.result?[0].discountAmount
                            .toString();
                        price = meetingDetailsProvider
                            .applyCouponModel.result?[0].price
                            .toString();
                        promocodeName = "";
                        promocodeId = "";
                      } else {
                        if (!mounted) return;

                        Utils.showSnackbar(
                            context,
                            "fail",
                            meetingDetailsProvider.applyCouponModel.message ??
                                "",
                            false);
                      }
                    },
                    child: Container(
                      height: 24,
                      width: 24,
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                          color: colorPrimaryDark, shape: BoxShape.circle),
                      child: Icon(
                        Icons.close,
                        size: 20,
                        color: white,
                      ),
                    ),
                  ),
            Container(
              height: 24,
              width: 24,
              alignment: Alignment.center,
              decoration: BoxDecoration(
                  color: gray.withValues(alpha: 0.3), shape: BoxShape.circle),
              child: Icon(
                Icons.keyboard_arrow_right,
                size: 20,
                color: black,
              ),
            )
          ],
        ),
      ),
    );
  }
  /* PaymentSummary Data */

  Widget paymentSummaryData() {
    return Container(
      width: MediaQuery.sizeOf(context).width,
      padding: const EdgeInsets.fromLTRB(15, 15, 25, 15),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(12),
          boxShadow: [
            BoxShadow(
                blurRadius: 11,
                blurStyle: BlurStyle.outer,
                offset: Offset(0, 3),
                color: transparent.withValues(alpha: 0.08),
                spreadRadius: 0)
          ]),
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'item_total',
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text: '${Constant.currencyCode} ${widget.totalPrice}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          const SizedBox(height: 10),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'taxes_fee',
                decoration: TextDecoration.underline,
                decorationStyle: TextDecorationStyle.dotted,
                decorationColor: black,
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text: '${Constant.currencyCode} ${discountPrice ?? "0"}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
          Divider(
            thickness: 1,
            height: 20,
            color: gray.withValues(alpha: .8),
          ),
          const SizedBox(height: 10),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MyText(
                text: 'total_price',
                multilanguage: true,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: gray,
                fontwaight: FontWeight.w500,
              ),
              MyText(
                text:
                    '${Constant.currencyCode} ${price ?? "${widget.totalPrice}"}',
                multilanguage: false,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontsizeNormal: Dimens.textTitle,
                color: black,
                fontwaight: FontWeight.w500,
              ),
            ],
          ),
        ],
      ),
    );
  }

  Widget _btnWidget() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: () {
        String? dateformatData = DateFormat("yyyy-MM-dd").format(widget.date);
        String? totalPrice =
            (price ?? "").isNotEmpty ? price : widget.totalPrice;

        if (Utils.checkLoginUser(context)) {
          Navigator.of(context).push(
            PageRouteBuilder(
              pageBuilder: (context, animation, secondaryAnimation) =>
                  AllPayment(
                payType: "book_session",
                mettingId: widget.mettingId ?? "",
                date: dateformatData,
                attachment: widget.attachment,
                mettingScheduleId: widget.mettingScheduleId,
                chapterId: widget.chapterId,
                price: totalPrice,
                details: widget.details,
                promoCodeId: promocodeId,
              ),
              transitionsBuilder:
                  (context, animation, secondaryAnimation, child) {
                const begin = Offset(1.0, 0.0);
                const end = Offset.zero;
                const curve = Curves.ease;

                var tween = Tween(begin: begin, end: end)
                    .chain(CurveTween(curve: curve));

                return SlideTransition(
                  position: animation.drive(tween),
                  child: child,
                );
              },
            ),
          );
        }
      },
      child: Container(
        padding: EdgeInsets.fromLTRB(20, 8, 20, 8),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: transparent, style: BorderStyle.solid),
            color: colorPrimaryDark,
            borderRadius: BorderRadius.circular(36)),
        child: MyText(
          text:
              "${Locales.string(context, "confirm_pay")} ${Constant.currencyCode} ${price ?? widget.totalPrice}",
          multilanguage: false,
          color: white,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textMedium,
          fontwaight: FontWeight.w600,
        ),
      ),
    );
  }
}
