import 'package:prakah/pages/bottombar.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

class Certificate extends StatefulWidget {
  const Certificate({super.key});

  @override
  State<Certificate> createState() => _CertificateState();
}

class _CertificateState extends State<Certificate> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          context: context,
          appBarTitle: "certificate",
          multilanguage: true,
          editType: "1"),
      body: SingleChildScrollView(
        padding: EdgeInsets.fromLTRB(20, 20, 20, 20),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 20,
          children: [
            MyNetworkImage(
              imageUrl:
                  "https://marketplace.canva.com/EAE5W0peQ78/1/0/1600w/canva-white-and-blue-elegant-public-speaking-course-certificate-template--qpA_9iguQA.jpg",
              fit: BoxFit.fill,
              imgHeight: 250,
              imgWidth: MediaQuery.sizeOf(context).width,
            ),
            MyText(
              color: Theme.of(context).colorScheme.surface,
              text: "UI/Ux  Courses",
              maxline: 1,
              multilanguage: false,
              fontsizeNormal: Dimens.textExtraBig,
              fontwaight: FontWeight.w500,
            ),
            Stack(
              alignment: Alignment.center,
              children: [
                MyNetworkImage(
                  imageUrl:
                      "https://marketplace.canva.com/EAE5W0peQ78/1/0/1600w/canva-white-and-blue-elegant-public-speaking-course-certificate-template--qpA_9iguQA.jpg",
                  fit: BoxFit.fill,
                  imgHeight: 250,
                  imgWidth: MediaQuery.sizeOf(context).width,
                ),
                Positioned.fill(
                  child: Container(color: transparent.withValues(alpha: 0.5)),
                ),
                Column(
                  spacing: 6,
                  children: [
                    Icon(
                      Icons.lock,
                      size: 25,
                      color: white,
                    ),
                    MyText(
                      color: white,
                      text: "Complete your courses to get the certificate",
                      maxline: 2,
                      multilanguage: false,
                      fontsizeNormal: Dimens.textBig,
                      fontwaight: FontWeight.w500,
                      textalign: TextAlign.center,
                    ),
                    InkWell(
                      onTap: () {
                        final generalProvider = Provider.of<GeneralProvider>(
                            context,
                            listen: false);

                        Navigator.of(context).push(
                          PageRouteBuilder(
                            pageBuilder:
                                (context, animation, secondaryAnimation) =>
                                    const Bottombar(selectInde: 2),
                            transitionsBuilder: (context, animation,
                                secondaryAnimation, child) {
                              const begin = Offset(1.0, 0.0);
                              const end = Offset.zero;
                              const curve = Curves.ease;

                              var tween = Tween(begin: begin, end: end)
                                  .chain(CurveTween(curve: curve));

                              return SlideTransition(
                                position: animation.drive(tween),
                                child: child,
                              );
                            },
                          ),
                        );

                        generalProvider.onItemTapped(context, 2);
                      },
                      child: Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 10, vertical: 8),
                        decoration: BoxDecoration(
                            color: white,
                            borderRadius: BorderRadius.circular(8)),
                        child: MyText(
                          color: black,
                          text: "Go to my courses",
                          maxline: 2,
                          multilanguage: false,
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          textalign: TextAlign.center,
                        ),
                      ),
                    )
                  ],
                )
              ],
            ),
            MyText(
              color: Theme.of(context).colorScheme.surface,
              text: "Master Data Excel Courses",
              maxline: 1,
              multilanguage: false,
              fontsizeNormal: Dimens.textExtraBig,
              fontwaight: FontWeight.w500,
            )
          ],
        ),
      ),
    );
  }
}
