import 'dart:io';
import 'dart:isolate';
import 'dart:ui';

import 'package:flutter/foundation.dart';
import 'package:flutter_downloader/flutter_downloader.dart';
import 'package:path_provider/path_provider.dart';
import 'package:prakah/pages/detail.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/mycourseprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import 'package:path/path.dart' as path;

class MyCourse extends StatefulWidget {
  const MyCourse({super.key});

  @override
  State<MyCourse> createState() => MyCourseState();
}

class MyCourseState extends State<MyCourse> {
  MyCourseProvider myCourseProvider = MyCourseProvider();
  final ScrollController _scrollController = ScrollController();
  double? width;
  double? height;

  /* Download Certificate */
  final ReceivePort _port = ReceivePort();
  dynamic _tasks;
  int progress = 0;

  @override
  void initState() {
    super.initState();
    if (!kIsWeb) {
      /* Download init ****/
      _bindBackgroundIsolate();
      FlutterDownloader.registerCallback(downloadCallback, step: 1);
      /* ****/
    }
    myCourseProvider = Provider.of<MyCourseProvider>(context, listen: false);

    _scrollController.addListener(_scrollListener);
    _fetchData(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (myCourseProvider.currentPage ?? 0) <
            (myCourseProvider.totalPage ?? 0)) {
      myCourseProvider.setLoadMore(true);
      _fetchData(myCourseProvider.currentPage ?? 0);
    }
  }

  Future<void> _fetchData(int? nextPage) async {
    await myCourseProvider.getMyCourse((nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    myCourseProvider.clearProvider();
    super.dispose();
  }

  /* ======== Download Start=========== */

  void _bindBackgroundIsolate() {
    final isSuccess = IsolateNameServer.registerPortWithName(
      _port.sendPort,
      'downloader_send_port',
    );
    if (!isSuccess) {
      _unbindBackgroundIsolate();
      _bindBackgroundIsolate();
      return;
    }
    _port.listen((dynamic data) {
      final taskId = (data as List<dynamic>)[0] as String;
      final status = data[1] as int;
      final progress = data[2] as int;

      printLog(
        'Callback on UI isolate: '
        'task ($taskId) is in status ($status) and process ($progress)',
      );

      if (_tasks != null && _tasks!.isNotEmpty) {
        final task = _tasks!.firstWhere((task) => task.taskId == taskId);
        printLog(task.toString());

        if (progress > 0) {
          printLog("progress==>${progress.toString()}%");
          myCourseProvider.setDownloadProgress(progress);
        }
      }
    });
  }

  void _unbindBackgroundIsolate() {
    IsolateNameServer.removePortNameMapping('downloader_send_port');
  }

  @pragma('vm:entry-point')
  static void downloadCallback(
    String id,
    int status,
    int progress,
  ) {
    printLog(
      'Callback on background isolate: '
      'task ($id) is in status ($status) and process ($progress)',
    );

    if (!kIsWeb) {
      IsolateNameServer.lookupPortByName(Constant.videoDownloadPort)
          ?.send([id, status, progress]);
    }
  }

/* ======== Download End =========== */

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return buildPage();
  }

  Widget buildPage() {
    return Consumer<MyCourseProvider>(
        builder: (context, mycourseProvider, child) {
      if (myCourseProvider.loading && !myCourseProvider.loadMore) {
        return buildShimmer();
      } else {
        if (myCourseProvider.mycourseList != null &&
            (myCourseProvider.mycourseList?.length ?? 0) > 0) {
          return SingleChildScrollView(
            physics: const BouncingScrollPhysics(),
            controller: _scrollController,
            padding: EdgeInsets.fromLTRB(20, 20, 20, 0),
            child: Column(
              children: [
                mycourselist(),
                if (mycourseProvider.loadMore)
                  Container(
                    height: 50,
                    margin: const EdgeInsets.fromLTRB(5, 5, 5, 10),
                    child: Utils.pageLoader(),
                  )
                else
                  const SizedBox.shrink(),
              ],
            ),
          );
        } else {
          return const NoData();
        }
      }
    });
  }

  Widget mycourselist() {
    return MediaQuery.removePadding(
      context: context,
      removeTop: true,
      child: ResponsiveGridList(
        minItemWidth: 120,
        minItemsPerRow: 1,
        maxItemsPerRow: 1,
        horizontalGridSpacing: 5,
        verticalGridSpacing: 10,
        listViewBuilderOptions: ListViewBuilderOptions(
          scrollDirection: Axis.vertical,
          shrinkWrap: true,
          padding: EdgeInsets.zero,
          physics: const BouncingScrollPhysics(),
        ),
        children: List.generate(
          myCourseProvider.mycourseList?.length ?? 0,
          (index) {
            return InkWell(
              onTap: () {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      transitionDuration: const Duration(milliseconds: 200),
                      pageBuilder: (BuildContext context,
                          Animation<double> animation,
                          Animation<double> secondaryAnimation) {
                        return Detail(
                            courseId: myCourseProvider.mycourseList?[index].id
                                    .toString() ??
                                "");
                      },
                      transitionsBuilder: (BuildContext context,
                          Animation<double> animation,
                          Animation<double> secondaryAnimation,
                          Widget child) {
                        return Align(
                          child: FadeTransition(
                            opacity: animation,
                            child: child,
                          ),
                        );
                      },
                    ),
                  );
                });
              },
              child: Card(
                color: Theme.of(context).cardColor,
                shadowColor: transparent.withValues(alpha: 0.25),
                elevation: 8,
                child: Padding(
                  padding: const EdgeInsets.fromLTRB(16, 8, 10, 8),
                  child: Row(
                    spacing: 10,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      MyNetworkImage(
                        radius: 8,
                        imgWidth: 127,
                        imgHeight: 137,
                        imageUrl: myCourseProvider
                                .mycourseList?[index].thumbnailImg
                                .toString() ??
                            "",
                        fit: BoxFit.fill,
                      ),
                      Expanded(
                        child: Column(
                          spacing: 8,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              spacing: 5,
                              children: [
                                MyText(
                                    color: gray,
                                    text: Utils.kmbGenerator(
                                      int.parse(myCourseProvider
                                              .mycourseList?[index].totalView
                                              .toString() ??
                                          ""),
                                    ),
                                    fontsizeNormal: Dimens.textSmall,
                                    fontwaight: FontWeight.w500,
                                    maxline: 1,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                                MyText(
                                    color: gray,
                                    text: "students",
                                    fontsizeNormal: Dimens.textSmall,
                                    fontwaight: FontWeight.w500,
                                    maxline: 1,
                                    multilanguage: true,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                                Container(
                                  height: 5,
                                  width: 5,
                                  decoration: BoxDecoration(
                                      color: gray, shape: BoxShape.circle),
                                ),
                                MyText(
                                    color: gray,
                                    text: Utils.kmbGenerator(5),
                                    fontsizeNormal: Dimens.textSmall,
                                    fontwaight: FontWeight.w500,
                                    maxline: 1,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                                MyText(
                                    color: gray,
                                    text: "Proojects",
                                    fontsizeNormal: Dimens.textSmall,
                                    fontwaight: FontWeight.w500,
                                    maxline: 1,
                                    multilanguage: false,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ],
                            ),
                            MyText(
                                color: Theme.of(context).colorScheme.surface,
                                text: myCourseProvider
                                        .mycourseList?[index].title
                                        .toString() ??
                                    "",
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w600,
                                maxline: 2,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                            LinearProgressIndicator(
                              borderRadius: BorderRadius.circular(8),
                              value: (double.tryParse(myCourseProvider
                                              .mycourseList?[index]
                                              .percentageStopTime
                                              .toString() ??
                                          "0") ??
                                      0) /
                                  100, // Convert percentage to decimal
                              backgroundColor: gray.withValues(alpha: 0.6),
                              color: colorPrimary,
                              minHeight: 8,
                            ),
                            MyText(
                                color: gray.withValues(alpha: .8),
                                text:
                                    "${myCourseProvider.mycourseList?[index].percentageStopTime.toString() ?? ""} % Completed",
                                fontsizeNormal: Dimens.textBigSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 2,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: [
                                MyRating(
                                  size: 13,
                                  rating: double.parse(myCourseProvider
                                          .mycourseList?[index].avgRating
                                          .toString() ??
                                      ""),
                                  spacing: 2,
                                ),
                                const SizedBox(width: 5),
                                MyText(
                                    color: colorAccent,
                                    text:
                                        "${double.parse(myCourseProvider.mycourseList?[index].avgRating.toString() ?? "")}",
                                    fontsizeNormal: Dimens.textBigSmall,
                                    fontwaight: FontWeight.w600,
                                    maxline: 2,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                              ],
                            ),
                            generateCertificate(myCourseProvider
                                    .mycourseList?[index].id
                                    .toString() ??
                                ""),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            );
          },
        ),
      ),
    );
  }

  Widget buildShimmer() {
    return Padding(
      padding: const EdgeInsets.all(15.0),
      child: MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ResponsiveGridList(
          minItemWidth: 120,
          minItemsPerRow: 1,
          maxItemsPerRow: 1,
          horizontalGridSpacing: 5,
          verticalGridSpacing: 10,
          listViewBuilderOptions: ListViewBuilderOptions(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
          ),
          children: List.generate(
            10,
            (index) {
              return Column(
                children: [
                  const Padding(
                    padding: EdgeInsets.only(top: 10),
                    child: Row(
                      children: [
                        ClipRRect(
                          borderRadius: BorderRadius.only(
                              bottomLeft: Radius.circular(5),
                              topLeft: Radius.circular(5)),
                          child: CustomWidget.rectangular(
                            width: 115,
                            height: 100,
                          ),
                        ),
                        SizedBox(width: 10),
                        Expanded(
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              CustomWidget.rectangular(
                                height: 5,
                              ),
                              SizedBox(height: 8),
                              CustomWidget.rectangular(
                                height: 5,
                              ),
                              SizedBox(height: 8),
                              CustomWidget.rectangular(
                                height: 5,
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
                  ),
                  const SizedBox(height: 20),
                  myCourseProvider.mycourseList?.length == index + 1
                      ? const SizedBox.shrink()
                      : Container(
                          width: MediaQuery.of(context).size.width,
                          height: 0.9,
                          color: gray.withValues(alpha: 0.15),
                        ),
                ],
              );
            },
          ),
        ),
      ),
    );
  }

/* Generate Certificate Button With Api Calling Start */

  Widget generateCertificate(String courseId) {
    if ((myCourseProvider.mycourseList?[0].isDownloadCertificate ?? 0) == 1 &&
        Constant.userID != null) {
      return InkWell(
        highlightColor: transparent,
        hoverColor: transparent,
        splashColor: transparent,
        focusColor: transparent,
        onTap: () async {
          getCertificateApiWithDownload(courseId);
        },
        child: Padding(
          padding: const EdgeInsets.fromLTRB(0, 8, 8, 8),
          child: MyText(
              color: colorPrimary,
              fontsizeNormal: Dimens.textSmall,
              maxline: 1,
              fontwaight: FontWeight.w600,
              multilanguage: true,
              overflow: TextOverflow.ellipsis,
              text: "downloadcertificate",
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal),
        ),
      );
    } else {
      return const SizedBox.shrink();
    }
  }

  Future<String> prepareSaveDir() async {
    String localPath = (await _getSavedDir())!;
    printLog("localPath ------------> $localPath");
    final savedDir = Directory(localPath);
    printLog("savedDir -------------> $savedDir");
    printLog("is exists ? ----------> ${savedDir.existsSync()}");
    if (!(await savedDir.exists())) {
      await savedDir.create(recursive: true);
    }
    return localPath;
  }

  Future<String?> _getSavedDir() async {
    String? externalStorageDirPath;

    if (Platform.isAndroid) {
      final directory = await getExternalStorageDirectory();
      try {
        externalStorageDirPath = "${directory?.absolute.path}/downloads/";
      } catch (err, st) {
        printLog('failed to get downloads path: $err, $st');
        externalStorageDirPath = "${directory?.absolute.path}/downloads/";
      }
    } else if (Platform.isIOS) {
      externalStorageDirPath =
          (await getApplicationDocumentsDirectory()).absolute.path;
    }
    printLog("externalStorageDirPath ------------> $externalStorageDirPath");
    return externalStorageDirPath;
  }

  Future<void> getCertificateApiWithDownload(String courseId) async {
    File? mTargetFile;
    String? localPath;
    String? mFileName = '${("certificate")}' '${(courseId)}';
    try {
      localPath = await prepareSaveDir();
      printLog("localPath ====> $localPath");
      mTargetFile = File(path.join(localPath, '$mFileName.${("pdf")}'));
    } catch (e) {
      printLog("saveVideoStorage Exception ===> $e");
    }
    printLog("mFileName ========> $mFileName");
    printLog("mTargetFile ========> $mTargetFile");
    if (!mounted) return;
    Utils().showProgress(context, "Generate Certificate...");
    await myCourseProvider.fetchCertificate(courseId);

    if (!myCourseProvider.certificateDownloading) {
      if (myCourseProvider.certificateModel.status == 200 &&
          myCourseProvider.certificateModel.result != null) {
        if (!mounted) return;
        Utils().hideProgress(context);
        if (mTargetFile != null) {
          myCourseProvider.downloadCertificate(
              myCourseProvider.certificateModel.result?.pdfUrl ?? "",
              localPath,
              mTargetFile);
          printLog("mTargetFile length ========> ${mTargetFile.length()}");
        }
      } else {
        if (!mounted) return;
        Utils().hideProgress(context);
        Utils.showSnackbar(context, "fail", "somethingwentwronge", true);
      }
    }
  }

/* Download certicicate End */
}
