import 'package:prakah/model/liveclasssectionmodel.dart';
import 'package:prakah/pages/mycart.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/pages/notificationpage.dart';
import 'package:prakah/pages/viewseriespage.dart';
import 'package:prakah/provider/liveclassprovider.dart';
import 'package:prakah/subscription/allpayment.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class LiveClass extends StatefulWidget {
  const LiveClass({super.key});

  @override
  State<LiveClass> createState() => _LiveClassState();
}

class _LiveClassState extends State<LiveClass> {
  LiveClassProvider liveClassProvider = LiveClassProvider();
  PageController pageController = PageController();
  DateTime endDate = DateTime.now();
  final _scrollController = ScrollController();
  final _historyScrollController = ScrollController();
  final _searchScrollController = ScrollController();

  double? width;
  double? height;

  @override
  void initState() {
    super.initState();
    liveClassProvider = Provider.of<LiveClassProvider>(context, listen: false);
    _scrollController.addListener(_scrollListener);
    _historyScrollController.addListener(_historyScrollListener);
    _searchScrollController.addListener(_searchScrollListener);

    getApi();
  }

  Future<void> getApi() async {
    await Future.wait([
      _fetchData(0),
      _fetchHistoryData(0),
    ]);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (liveClassProvider.sectioncurrentPage ?? 0) <
            (liveClassProvider.sectiontotalPage ?? 0)) {
      liveClassProvider.setLoadMore(true);
      _fetchData(liveClassProvider.sectioncurrentPage ?? 0);
    }
  }

  Future _fetchData(int? nextPage) async {
    await liveClassProvider.getSeactionList((nextPage ?? 0) + 1);
  }

  void _historyScrollListener() {
    if (!_historyScrollController.hasClients) return;
    if (_historyScrollController.offset >=
            _historyScrollController.position.maxScrollExtent &&
        !_historyScrollController.position.outOfRange &&
        (liveClassProvider.histroycurrentPage ?? 0) <
            (liveClassProvider.histroytotalPage ?? 0)) {
      liveClassProvider.setHistroyLoadMore(true);
      _fetchHistoryData(liveClassProvider.histroycurrentPage ?? 0);
    }
  }

  Future _fetchHistoryData(int? nextPage) async {
    await liveClassProvider.getHistroyList((nextPage ?? 0) + 1);
  }

/* Search */
  void _searchScrollListener() {
    if (!_searchScrollController.hasClients) return;
    if (_searchScrollController.offset >=
            _searchScrollController.position.maxScrollExtent &&
        !_searchScrollController.position.outOfRange &&
        (liveClassProvider.searchcurrentPage ?? 0) <
            (liveClassProvider.searchtotalPage ?? 0)) {
      liveClassProvider.setSearchLoadMore(true);
      _fetchsearchData(liveClassProvider.searchcurrentPage ?? 0);
    }
  }

  Future _fetchsearchData(int? nextPage) async {
    await liveClassProvider.getSearchList(
        liveClassProvider.startDate,
        endDate,
        liveClassProvider.isFree,
        liveClassProvider.courseId ?? "",
        liveClassProvider.classTimeStatus ?? "",
        (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    _historyScrollController.dispose();
    _searchScrollController.dispose();

    liveClassProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.sizeOf(context).width;
    height = MediaQuery.sizeOf(context).height;
    return Scaffold(
      extendBody: true,
      backgroundColor: white,
      appBar: AppBar(
        backgroundColor: colorPrimaryDark,
        systemOverlayStyle: SystemUiOverlayStyle(
          statusBarColor: transparent,
          systemNavigationBarColor: transparent,
        ),
        surfaceTintColor: transparent,
        leading: Padding(
          padding: const EdgeInsets.all(10.0),
          child: MyImage(
            width: 34,
            height: 32,
            imagePath: 'appiconweb.png',
            isAppicon: true,
            fit: BoxFit.contain,
          ),
        ),
        title: MyText(
          color: white,
          text: "appname",
          multilanguage: true,
          fontsizeNormal: Dimens.textBig,
          fontwaight: FontWeight.w700,
          maxline: 1,
          overflow: TextOverflow.ellipsis,
        ),
        actions: [
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              if (Utils.checkLoginUser(context)) {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          const MyCart(),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                  );
                });
              }
            },
            child: const Icon(
              Icons.shopping_cart_outlined,
              size: 25,
              color: Colors.white,
            ),
          ),
          const SizedBox(width: 15),
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () async {
              showFilterData();

              /* Course name api call */

              await liveClassProvider.getCourseName();
            },
            child: Icon(
              FontAwesomeIcons.filter,
              size: 25,
              color: Colors.white,
            ),
          ),
          const SizedBox(width: 15),
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                if (Utils.checkLoginUser(context)) {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          const NotificationPage(),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                  );
                }
              });
            },
            child: const Icon(
              Icons.notifications_outlined,
              size: 25,
              color: Colors.white,
            ),
          ),
          const SizedBox(width: 15),
        ],
      ),
      body: Consumer<LiveClassProvider>(
          builder: (context, liveClassProvider, child) {
        if (liveClassProvider.isSearch == "0") {
          return buildPage();
        } else {
          return _buildSearchData();
        }
      }),
    );
  }

  Widget buildPage() {
    if (liveClassProvider.loading && !liveClassProvider.loadmore) {
      return SingleChildScrollView(
        padding: const EdgeInsets.fromLTRB(10, 15, 10, 15),
        child: Column(
          children: [
            landscapeShimmer(),
            proShimmer(),
            recordingPortriatShimmer()
          ],
        ),
      );
    } else {
      return SingleChildScrollView(
        physics: AlwaysScrollableScrollPhysics(),
        controller: _scrollController,
        padding: const EdgeInsets.fromLTRB(14, 0, 14, 0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            setSectionByType(),
            classhistoryData(),
            if (liveClassProvider.loadmore)
              SizedBox(
                height: 50,
                child: Utils.pageLoader(),
              )
            else
              const SizedBox.shrink(),
          ],
        ),
      );
    }
  }

  Widget setSectionByType() {
    if (liveClassProvider.livesectionList != null &&
        (liveClassProvider.livesectionList?.length ?? 0) > 0) {
      return MediaQuery.removePadding(
        context: context,
        removeTop: true,
        child: ListView.builder(
          itemCount: liveClassProvider.livesectionList?.length ?? 0,
          shrinkWrap: true,
          reverse: false,
          physics: const NeverScrollableScrollPhysics(),
          itemBuilder: (BuildContext context, int index) {
            if (liveClassProvider.livesectionList?[index].data != null &&
                (liveClassProvider.livesectionList?[index].data?.length ?? 0) >
                    0) {
              return Column(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  // Section Title
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: liveClassProvider.livesectionList?[index].title
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textBig,
                      fontwaight: FontWeight.w600,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.start,
                      fontstyle: FontStyle.normal,
                      multilanguage: false),
                  const SizedBox(height: 5),
                  (liveClassProvider.livesectionList?[index].shortTitle
                                  .toString() ??
                              "") ==
                          ""
                      ? SizedBox.shrink()
                      : MyText(
                          color: gray,
                          multilanguage: false,
                          text: liveClassProvider
                                  .livesectionList?[index].shortTitle
                                  .toString() ??
                              "",
                          textalign: TextAlign.center,
                          fontsizeNormal: 12,
                          fontsizeWeb: 12,
                          maxline: 1,
                          fontwaight: FontWeight.w400,
                          overflow: TextOverflow.ellipsis,
                          fontstyle: FontStyle.normal),
                  const SizedBox(height: 10),
                  // Section Data List
                  setSectionData(
                      index: index,
                      sectionList: liveClassProvider.livesectionList),
                  const SizedBox(height: 6),
                ],
              );
            } else {
              return const SizedBox.shrink();
            }
          },
        ),
      );
    } else {
      return const NoData();
    }
  }

  Widget setSectionData(
      {required int index, required List<Result>? sectionList}) {
    if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "index_landscape") {
      if ((sectionList?[index].type.toString() ?? "") == "1") {
        return indexLandscapeData(index, sectionList);
      } else {
        return recordingIndexLandscape(index, sectionList);
      }
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "index_portrait") {
      if ((sectionList?[index].type.toString() ?? "") == "1") {
        return indexLandscapeData(index, sectionList);
      } else {
        return recordingIndexLandscape(index, sectionList);
      }
    } else {
      return const SizedBox.shrink();
    }
  }

  /* index_landscape Data Started */

  Widget indexLandscapeData(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
      padding: EdgeInsets.zero,
      scrollDirection: Axis.horizontal,
      physics: BouncingScrollPhysics(),
      child: Row(
        children: List.generate(
          sectionList?[sectionindex].data?.length ?? 0,
          (index) {
            final commanList = sectionList?[sectionindex].data?[index];
            return Container(
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
              width: 320,
              margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
              decoration: BoxDecoration(
                  color: white,
                  borderRadius: BorderRadius.circular(16),
                  border: Border.all(width: 1, color: transparent),
                  boxShadow: [
                    BoxShadow(
                        blurRadius: 4,
                        blurStyle: BlurStyle.solid,
                        offset: Offset(0, 4),
                        spreadRadius: 0,
                        color: transparent.withValues(alpha: 0.25))
                  ]),
              child: Column(
                spacing: 10,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    spacing: 5,
                    children: [
                      Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 10, vertical: 4),
                        decoration: BoxDecoration(
                            color: (commanList?.isFree.toString() ?? "") ==
                                        "1" &&
                                    ((commanList?.isUserBuy.toString() ?? "") ==
                                        "0")
                                ? green
                                : red,
                            borderRadius: BorderRadius.circular(14)),
                        child: MyText(
                          text: (commanList?.isFree.toString() ?? "") == "1" &&
                                  ((commanList?.isUserBuy.toString() ?? "") ==
                                      "0")
                              ? Locales.string(context, "free")
                              : commanList?.price.toString() ?? "",
                          color: white,
                          fontsizeNormal: Dimens.textSmall,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                        ),
                      ),
                      Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 6, vertical: 4),
                        decoration: BoxDecoration(
                            color: liveTextColor,
                            borderRadius: BorderRadius.circular(7)),
                        child: MyText(
                          text: commanList?.title.toString() ?? "",
                          color: black,
                          fontsizeNormal: Dimens.textSmall,
                          fontsizeWeb: Dimens.textTitle,
                          fontwaight: FontWeight.w400,
                        ),
                      )
                    ],
                  ),
                  Stack(
                    alignment: Alignment.center,
                    children: [
                      Row(
                        spacing: 14,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          SizedBox(
                            width: 160,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 20,
                              children: [
                                MyText(
                                  text:
                                      commanList?.courseTitle.toString() ?? "",
                                  color: black,
                                  fontsizeNormal: Dimens.textMedium,
                                  fontsizeWeb: Dimens.textTitle,
                                  fontwaight: FontWeight.w500,
                                ),
                                Row(
                                  spacing: 4,
                                  children: [
                                    (commanList?.status.toString() ?? "") == "1"
                                        ? SizedBox.shrink()
                                        : MyNetworkImage(
                                            imageUrl:
                                                "https://i.fbcd.co/products/resized/resized-750-500/2419-9ff351c8d3c2dcbe30da81041c911438a6559890b83490e3a1fd55f8e3b4fc06.jpg",
                                            radius: 0,
                                            imgHeight: 20,
                                            imgWidth: 20,
                                            fit: BoxFit.cover),
                                    Container(
                                      padding: EdgeInsets.symmetric(
                                          horizontal: 6, vertical: 4),
                                      decoration: BoxDecoration(
                                          gradient: LinearGradient(
                                              colors: [
                                                red.withValues(alpha: 0.5),
                                                red.withValues(alpha: 0.6)
                                              ],
                                              tileMode: TileMode.mirror,
                                              begin: Alignment.topCenter,
                                              end: Alignment.bottomCenter),
                                          borderRadius:
                                              BorderRadius.circular(7)),
                                      child: MyText(
                                        text: (commanList?.status.toString() ??
                                                    "") ==
                                                "1"
                                            ? "starting_soon"
                                            : (commanList?.status.toString() ??
                                                        "") ==
                                                    "2"
                                                ? "live_now"
                                                : (commanList?.status
                                                                .toString() ??
                                                            "") ==
                                                        "3"
                                                    ? "completed"
                                                    : "cancelled",
                                        multilanguage: true,
                                        color: black,
                                        fontsizeNormal: Dimens.textSmall,
                                        fontsizeWeb: Dimens.textTitle,
                                        fontwaight: FontWeight.w400,
                                      ),
                                    ),
                                  ],
                                )
                              ],
                            ),
                          ),
                        ],
                      ),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        children: [
                          MyNetworkImage(
                              imageUrl:
                                  commanList?.lecturerImage.toString() ?? "",
                              radius: 10,
                              imgHeight: 100,
                              imgWidth: 100,
                              fit: BoxFit.cover),
                          SizedBox(height: 2),
                          ClipPath(
                            clipper: LeftDiagonalClipper(),
                            child: Container(
                              padding: EdgeInsets.fromLTRB(
                                  18, 4, 6, 4), // increased left padding

                              decoration: BoxDecoration(
                                color: black,
                              ),
                              child: MyText(
                                text: commanList?.lecturerName.toString() ?? "",
                                color: white,
                                fontsizeNormal: Dimens.textSmall,
                                fontsizeWeb: Dimens.textTitle,
                                fontwaight: FontWeight.w600,
                              ),
                            ),
                          ),
                          Container(
                            height: 1,
                            width: width,
                            color: gray,
                          ),
                        ],
                      ),
                    ],
                  ),
                  Row(
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                          child: btnWidget(
                        text: "remind_me",
                        color: colorPrimaryDark,
                        textColor: white,
                        borderColor: colorPrimaryDark,
                      )),
                      Expanded(
                          child: btnWidget(
                        onTap: () {
                          if (Utils.checkLoginUser(context)) {
                            if ((commanList?.isFree.toString() ?? "") == "1" &&
                                ((commanList?.isUserBuy.toString() ?? "") ==
                                    "0")) {
                              Utils.lanchUrl(
                                  commanList?.meetingLink.toString() ?? "");
                            } else {
                              Navigator.of(context).push(
                                PageRouteBuilder(
                                  pageBuilder: (context, animation,
                                          secondaryAnimation) =>
                                      AllPayment(
                                    contentType: "3",
                                    payType: 'Package',
                                    itemId: commanList?.id.toString() ?? "",
                                    price: commanList?.price.toString() ?? "",
                                    itemTitle:
                                        commanList?.title.toString() ?? "",
                                  ),
                                  transitionsBuilder: (context, animation,
                                      secondaryAnimation, child) {
                                    const begin = Offset(1.0, 0.0);
                                    const end = Offset.zero;
                                    const curve = Curves.ease;

                                    var tween = Tween(begin: begin, end: end)
                                        .chain(CurveTween(curve: curve));

                                    return SlideTransition(
                                      position: animation.drive(tween),
                                      child: child,
                                    );
                                  },
                                ),
                              );
                            }
                          }
                        },
                        text: "jion_this_class",
                        color: white,
                        textColor: colorPrimaryDark,
                        borderColor: colorPrimaryDark,
                      ))
                    ],
                  )
                ],
              ),
            );
          },
        ),
      ),
    );
  }

/* Class Recording Sction Data */

  Widget recordingIndexLandscape(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
        scrollDirection: Axis.horizontal,
        padding: EdgeInsets.zero,
        physics: BouncingScrollPhysics(),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: List.generate(
            sectionList?[sectionindex].data?.length ?? 0,
            (index) {
              final commanList = sectionList?[sectionindex].data?[index];
              return InkWell(
                splashColor: transparent,
                focusColor: transparent,
                hoverColor: transparent,
                highlightColor: transparent,
                onTap: () {
                  Utils.openPlayer(
                    context: context,
                    viewApiType: 2,
                    secreateKey: "",
                    type: "video",
                    videoId: commanList?.id ?? 0,
                    videoUrl: commanList?.recordingUrl.toString() ?? "",
                    vUploadType: "external",
                    videoThumb: commanList?.courseImage.toString() ?? "",
                    courseId: commanList?.id ?? 0,
                    chepterId: 0,
                  );
                },
                child: Container(
                  margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
                  padding:
                      const EdgeInsets.symmetric(horizontal: 12, vertical: 14),
                  width: 360,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(10),
                      border: Border.all(width: 1, color: transparent),
                      boxShadow: [
                        BoxShadow(
                            blurRadius: 4,
                            blurStyle: BlurStyle.solid,
                            offset: Offset(0, 4),
                            spreadRadius: 0,
                            color: transparent.withValues(alpha: 0.25))
                      ]),
                  child: Row(
                    spacing: 14,
                    children: [
                      MyNetworkImage(
                          imgHeight: 90,
                          imgWidth: 130,
                          radius: 5,
                          imageUrl: commanList?.courseImage ?? "",
                          fit: BoxFit.fill),
                      Expanded(
                          child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        spacing: 4,
                        children: [
                          MyText(
                            text: commanList?.title.toString() ?? "",
                            maxline: 1,
                            color: black,
                            fontsizeNormal: Dimens.textMedium,
                            fontsizeWeb: Dimens.textTitle,
                            fontwaight: FontWeight.w400,
                          ),
                          MyText(
                            text: commanList?.categoryName.toString() ?? "",
                            maxline: 1,
                            color: black,
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textTitle,
                            fontwaight: FontWeight.w400,
                          ),
                          Row(
                            spacing: 20,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                child: Row(
                                  children: [
                                    Icon(Icons.date_range_sharp,
                                        size: 16, color: gray),
                                    Expanded(
                                      child: MyText(
                                        text: Utils.dateConvert(
                                            commanList?.updatedAt.toString() ??
                                                "",
                                            "dd MMM yyyy"),
                                        maxline: 1,
                                        color: black,
                                        fontsizeNormal: Dimens.textSmall,
                                        fontsizeWeb: Dimens.textTitle,
                                        fontwaight: FontWeight.w400,
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              Expanded(
                                child: Row(
                                  spacing: 10,
                                  children: [
                                    Icon(Icons.watch_later_outlined,
                                        size: 16, color: gray),
                                    Expanded(
                                      child: MyText(
                                        text: Utils.dateConvert(
                                            commanList?.updatedAt.toString() ??
                                                "",
                                            "hh:mm a"),
                                        maxline: 1,
                                        color: black,
                                        fontsizeNormal: Dimens.textSmall,
                                        fontsizeWeb: Dimens.textTitle,
                                        fontwaight: FontWeight.w400,
                                      ),
                                    ),
                                  ],
                                ),
                              )
                            ],
                          ),
                          InkWell(
                            splashColor: transparent,
                            focusColor: transparent,
                            hoverColor: transparent,
                            highlightColor: transparent,
                            onTap: () {
                              Utils.openPlayer(
                                context: context,
                                secreateKey: "",
                                type: "video",
                                viewApiType: 2,
                                videoId: commanList?.id ?? 0,
                                videoUrl:
                                    commanList?.recordingUrl.toString() ?? "",
                                vUploadType: "external",
                                videoThumb:
                                    commanList?.courseImage.toString() ?? "",
                                courseId: commanList?.id ?? 0,
                                chepterId: 0,
                              );
                            },
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 6, vertical: 4),
                              alignment: Alignment.center,
                              decoration: BoxDecoration(
                                  color: colorPrimaryDark,
                                  borderRadius: BorderRadius.circular(8),
                                  border: Border.all(
                                      width: 1,
                                      color: colorPrimaryDark,
                                      style: BorderStyle.solid)),
                              child: MyText(
                                text: "watchrecording",
                                color: white,
                                multilanguage: true,
                                fontsizeNormal: Dimens.textSmall,
                                fontsizeWeb: Dimens.textTitle,
                                fontwaight: FontWeight.w600,
                              ),
                            ),
                          )
                        ],
                      ))
                    ],
                  ),
                ),
              );
            },
          ),
        ));
  }

  Widget btnWidget({String? text, color, textColor, borderColor, onTap}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: 6, vertical: 10),
        alignment: Alignment.center,
        decoration: BoxDecoration(
            color: color,
            borderRadius: BorderRadius.circular(8),
            border: Border.all(
                width: 1, color: borderColor, style: BorderStyle.solid)),
        child: MyText(
          text: text ?? "",
          color: textColor,
          multilanguage: true,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textTitle,
          fontwaight: FontWeight.w600,
        ),
      ),
    );
  }
/* Recording Data End*/

/* Class History Data Started */
  Widget classhistoryData() {
    if (liveClassProvider.histroyLoding && !liveClassProvider.histroyLoadmore) {
      return landscapeShimmer();
    } else {
      if (liveClassProvider.histroyList != null &&
          (liveClassProvider.histroyList?.length ?? 0) > 0) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: "my_class_history",
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w600,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.start,
                fontstyle: FontStyle.normal,
                multilanguage: true),
            const SizedBox(height: 5),
            Row(
              spacing: 16,
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Expanded(
                  child: SingleChildScrollView(
                    controller: _historyScrollController,
                    physics: BouncingScrollPhysics(),
                    scrollDirection: Axis.horizontal,
                    padding: EdgeInsets.zero,
                    child: _buildClassHistory(),
                  ),
                ),
                if (liveClassProvider.histroyLoadmore)
                  Utils.pageLoader()
                else
                  SizedBox.shrink()
              ],
            ),
          ],
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget _buildClassHistory() {
    return Row(
        children: List.generate(
      liveClassProvider.histroyList?.length ?? 0,
      (index) {
        final commanList = liveClassProvider.histroyList?[index];
        return Container(
          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
          width: 320,
          margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
          decoration: BoxDecoration(
              color: white,
              borderRadius: BorderRadius.circular(16),
              border: Border.all(width: 1, color: transparent),
              boxShadow: [
                BoxShadow(
                    blurRadius: 4,
                    blurStyle: BlurStyle.solid,
                    offset: Offset(0, 4),
                    spreadRadius: 0,
                    color: transparent.withValues(alpha: 0.25))
              ]),
          child: Column(
            spacing: 10,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                spacing: 5,
                children: [
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 4),
                    decoration: BoxDecoration(
                        color: green, borderRadius: BorderRadius.circular(14)),
                    child: MyText(
                      text: Locales.string(context, "free"),
                      color: white,
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textTitle,
                      fontwaight: FontWeight.w600,
                    ),
                  ),
                  Container(
                    padding: EdgeInsets.symmetric(horizontal: 6, vertical: 4),
                    decoration: BoxDecoration(
                        color: liveTextColor,
                        borderRadius: BorderRadius.circular(7)),
                    child: MyText(
                      text: commanList?.categoryName.toString() ?? "",
                      color: black,
                      fontsizeNormal: Dimens.textSmall,
                      fontsizeWeb: Dimens.textTitle,
                      fontwaight: FontWeight.w400,
                    ),
                  )
                ],
              ),
              Stack(
                alignment: Alignment.center,
                children: [
                  Row(
                    spacing: 14,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      SizedBox(
                        width: 160,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          spacing: 20,
                          children: [
                            MyText(
                              text: commanList?.liveClassTitle.toString() ?? "",
                              color: black,
                              fontsizeNormal: Dimens.textMedium,
                              fontsizeWeb: Dimens.textTitle,
                              fontwaight: FontWeight.w500,
                            ),
                            Row(
                              spacing: 4,
                              children: [
                                (commanList?.status.toString() ?? "") == "1"
                                    ? SizedBox.shrink()
                                    : MyNetworkImage(
                                        imageUrl:
                                            "https://i.fbcd.co/products/resized/resized-750-500/2419-9ff351c8d3c2dcbe30da81041c911438a6559890b83490e3a1fd55f8e3b4fc06.jpg",
                                        radius: 0,
                                        imgHeight: 20,
                                        imgWidth: 20,
                                        fit: BoxFit.cover),
                                Container(
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 6, vertical: 4),
                                  decoration: BoxDecoration(
                                      gradient: LinearGradient(
                                          colors: [
                                            red.withValues(alpha: 0.5),
                                            red.withValues(alpha: 0.6)
                                          ],
                                          tileMode: TileMode.mirror,
                                          begin: Alignment.topCenter,
                                          end: Alignment.bottomCenter),
                                      borderRadius: BorderRadius.circular(7)),
                                  child: MyText(
                                    text: "lesson_end",
                                    multilanguage: true,
                                    color: black,
                                    fontsizeNormal: Dimens.textSmall,
                                    fontsizeWeb: Dimens.textTitle,
                                    fontwaight: FontWeight.w400,
                                  ),
                                ),
                              ],
                            )
                          ],
                        ),
                      ),
                    ],
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.end,
                    children: [
                      MyNetworkImage(
                          imageUrl: commanList?.lecturerImage.toString() ?? "",
                          radius: 10,
                          imgHeight: 100,
                          imgWidth: 100,
                          fit: BoxFit.cover),
                      SizedBox(height: 2),
                      ClipPath(
                        clipper: LeftDiagonalClipper(),
                        child: Container(
                          padding: EdgeInsets.fromLTRB(
                              18, 4, 6, 4), // increased left padding

                          decoration: BoxDecoration(
                            color: black,
                          ),
                          child: MyText(
                            text: commanList?.lecturerName.toString() ?? "",
                            color: white,
                            fontsizeNormal: Dimens.textSmall,
                            fontsizeWeb: Dimens.textTitle,
                            fontwaight: FontWeight.w600,
                          ),
                        ),
                      ),
                      Container(
                        height: 1,
                        width: width,
                        color: gray,
                      ),
                    ],
                  ),
                ],
              ),
              Row(
                spacing: 20,
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Expanded(
                      child: btnWidget(
                    text: "view_certificates",
                    color: colorPrimaryDark,
                    textColor: white,
                    borderColor: colorPrimaryDark,
                  )),
                  Expanded(
                      child: btnWidget(
                    onTap: () {
                      AdHelper.showFullscreenAd(
                          context, Constant.interstialAdType, () {
                        Navigator.of(context).push(
                          PageRouteBuilder(
                            pageBuilder: (context, animation,
                                    secondaryAnimation) =>
                                ViewSeriesPage(
                                    detailsType: "history",
                                    liveClassId:
                                        commanList?.id.toString() ?? "",
                                    title:
                                        commanList?.liveClassTitle.toString() ??
                                            ""),
                            transitionsBuilder: (context, animation,
                                secondaryAnimation, child) {
                              const begin = Offset(1.0, 0.0);
                              const end = Offset.zero;
                              const curve = Curves.ease;

                              var tween = Tween(begin: begin, end: end)
                                  .chain(CurveTween(curve: curve));

                              return SlideTransition(
                                position: animation.drive(tween),
                                child: child,
                              );
                            },
                          ),
                        );
                      });
                    },
                    text: "view_details",
                    color: white,
                    textColor: colorPrimaryDark,
                    borderColor: colorPrimaryDark,
                  ))
                ],
              )
            ],
          ),
        );
      },
    ));
  }
/* Class Histroy Data END */

/* Search Data Started */
  Widget _buildSearchData() {
    if (liveClassProvider.searchLoding && !liveClassProvider.searchLoadmore) {
      return Padding(
        padding: const EdgeInsets.fromLTRB(10, 15, 10, 15),
        child: searchShimmer(),
      );
    } else {
      if (liveClassProvider.searchList != null &&
          (liveClassProvider.searchList?.length ?? 0) > 0) {
        return SingleChildScrollView(
          physics: AlwaysScrollableScrollPhysics(),
          controller: _searchScrollController,
          padding: const EdgeInsets.fromLTRB(14, 20, 14, 20),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              _buildSearch(),
              if (liveClassProvider.searchLoadmore)
                SizedBox(
                  height: 50,
                  child: Utils.pageLoader(),
                )
              else
                const SizedBox.shrink(),
            ],
          ),
        );
      } else {
        return NoData();
      }
    }
  }

  Widget _buildSearch() {
    return ResponsiveGridList(
      minItemWidth: 300,
      maxItemsPerRow: 2,
      minItemsPerRow: 1,
      listViewBuilderOptions: ListViewBuilderOptions(
          shrinkWrap: true,
          padding: EdgeInsets.zero,
          physics: NeverScrollableScrollPhysics()),
      children: List.generate(
        liveClassProvider.searchList?.length ?? 0,
        (index) {
          final commanList = liveClassProvider.searchList?[index];
          return Container(
            padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
            margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
            decoration: BoxDecoration(
                color: white,
                borderRadius: BorderRadius.circular(16),
                border: Border.all(width: 1, color: transparent),
                boxShadow: [
                  BoxShadow(
                      blurRadius: 4,
                      blurStyle: BlurStyle.solid,
                      offset: Offset(0, 4),
                      spreadRadius: 0,
                      color: transparent.withValues(alpha: 0.25))
                ]),
            child: Column(
              spacing: 10,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.start,
                  spacing: 5,
                  children: [
                    Container(
                      padding:
                          EdgeInsets.symmetric(horizontal: 10, vertical: 4),
                      decoration: BoxDecoration(
                          color: green,
                          borderRadius: BorderRadius.circular(14)),
                      child: MyText(
                        text: (commanList?.isFree.toString() ?? "") == "1"
                            ? Locales.string(context, "free")
                            : commanList?.price.toString() ?? "",
                        color: white,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w600,
                      ),
                    ),
                    Container(
                      padding: EdgeInsets.symmetric(horizontal: 6, vertical: 4),
                      decoration: BoxDecoration(
                          color: liveTextColor,
                          borderRadius: BorderRadius.circular(7)),
                      child: MyText(
                        text: commanList?.title.toString() ?? "",
                        color: black,
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textTitle,
                        fontwaight: FontWeight.w400,
                      ),
                    )
                  ],
                ),
                Stack(
                  alignment: Alignment.center,
                  children: [
                    Row(
                      spacing: 14,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        SizedBox(
                          width: 160,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            spacing: 20,
                            children: [
                              MyText(
                                text: commanList?.courseTitle.toString() ?? "",
                                color: black,
                                fontsizeNormal: Dimens.textMedium,
                                fontsizeWeb: Dimens.textTitle,
                                fontwaight: FontWeight.w500,
                              ),
                              Row(
                                spacing: 4,
                                children: [
                                  (commanList?.status.toString() ?? "") == "2"
                                      ? MyImage(
                                          imagePath: "live.png",
                                          radius: 0,
                                          height: 20,
                                          width: 20,
                                          fit: BoxFit.cover)
                                      : SizedBox.shrink(),
                                  Container(
                                    padding: EdgeInsets.symmetric(
                                        horizontal: 6, vertical: 4),
                                    decoration: BoxDecoration(
                                        gradient: LinearGradient(
                                            colors: [
                                              red.withValues(alpha: 0.5),
                                              red.withValues(alpha: 0.6)
                                            ],
                                            tileMode: TileMode.mirror,
                                            begin: Alignment.topCenter,
                                            end: Alignment.bottomCenter),
                                        borderRadius: BorderRadius.circular(7)),
                                    child: MyText(
                                      text: (commanList?.status.toString() ??
                                                  "") ==
                                              "1"
                                          ? "starting_soon"
                                          : (commanList?.status.toString() ??
                                                      "") ==
                                                  "2"
                                              ? "live_now"
                                              : (commanList?.status
                                                              .toString() ??
                                                          "") ==
                                                      "3"
                                                  ? "completed"
                                                  : "cancelled",
                                      multilanguage: true,
                                      color: black,
                                      fontsizeNormal: Dimens.textSmall,
                                      fontsizeWeb: Dimens.textTitle,
                                      fontwaight: FontWeight.w400,
                                    ),
                                  ),
                                ],
                              )
                            ],
                          ),
                        ),
                      ],
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.end,
                      children: [
                        MyNetworkImage(
                            imageUrl:
                                commanList?.lecturerImage.toString() ?? "",
                            radius: 10,
                            imgHeight: 100,
                            imgWidth: 100,
                            fit: BoxFit.cover),
                        SizedBox(height: 2),
                        ClipPath(
                          clipper: LeftDiagonalClipper(),
                          child: Container(
                            padding: EdgeInsets.fromLTRB(
                                18, 4, 6, 4), // increased left padding

                            decoration: BoxDecoration(
                              color: black,
                            ),
                            child: MyText(
                              text: commanList?.lecturerName.toString() ?? "",
                              color: white,
                              fontsizeNormal: Dimens.textSmall,
                              fontsizeWeb: Dimens.textTitle,
                              fontwaight: FontWeight.w600,
                            ),
                          ),
                        ),
                        Container(
                          height: 1,
                          width: width,
                          color: gray,
                        ),
                      ],
                    ),
                  ],
                ),
                Row(
                  spacing: 20,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Expanded(
                        child: btnWidget(
                      text: "remind_me",
                      color: colorPrimaryDark,
                      textColor: white,
                      borderColor: colorPrimaryDark,
                    )),
                    Expanded(
                        child: btnWidget(
                      onTap: () {
                        if (Utils.checkLoginUser(context)) {
                          if ((commanList?.isFree.toString() ?? "") == "1") {
                            Utils.lanchUrl(
                                commanList?.meetingLink.toString() ?? "");
                          } else {
                            Navigator.of(context).push(
                              PageRouteBuilder(
                                pageBuilder:
                                    (context, animation, secondaryAnimation) =>
                                        AllPayment(
                                  contentType: "3",
                                  payType: 'Package',
                                  itemId: commanList?.id.toString() ?? "",
                                  price: commanList?.price.toString() ?? "",
                                  itemTitle: commanList?.title.toString() ?? "",
                                ),
                                transitionsBuilder: (context, animation,
                                    secondaryAnimation, child) {
                                  const begin = Offset(1.0, 0.0);
                                  const end = Offset.zero;
                                  const curve = Curves.ease;

                                  var tween = Tween(begin: begin, end: end)
                                      .chain(CurveTween(curve: curve));

                                  return SlideTransition(
                                    position: animation.drive(tween),
                                    child: child,
                                  );
                                },
                              ),
                            );
                          }
                        }
                      },
                      text: "jion_this_class",
                      color: white,
                      textColor: colorPrimaryDark,
                      borderColor: colorPrimaryDark,
                    ))
                  ],
                )
              ],
            ),
          );
        },
      ),
    );
  }

  void showFilterData() {
    showModalBottomSheet(
      context: context,
      showDragHandle: true,
      isDismissible: true,
      isScrollControlled: true,
      backgroundColor: white,
      enableDrag: true,
      builder: (context) {
        return Consumer<LiveClassProvider>(
            builder: (context, liveClassProvider, child) {
          return Container(
            padding: EdgeInsets.fromLTRB(15, 10, 15, 20),
            height: 650,
            color: white,
            width: MediaQuery.sizeOf(context).width,
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyText(
                    text: "filter_by",
                    multilanguage: true,
                    fontsizeNormal: Dimens.textMedium,
                    fontwaight: FontWeight.w500,
                  ),
                  SizedBox(height: 10),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Expanded(
                        child: MyText(
                          text: "date_range",
                          color: black,
                          multilanguage: true,
                          fontsizeNormal: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                        ),
                      ),
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () {
                          liveClassProvider.setDateValue(DateTime.now());
                        },
                        child: MyText(
                          text: "reset",
                          color: colorPrimaryDark,
                          multilanguage: true,
                          fontsizeNormal: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                        ),
                      ),
                    ],
                  ),
                  SizedBox(height: 10),

                  /* Date Picked Code */
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 20,
                    children: [
                      Expanded(
                          child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 5,
                              children: [
                            MyText(
                                text: "from",
                                multilanguage: true,
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1),
                            InkWell(
                              splashColor: transparent,
                              focusColor: transparent,
                              hoverColor: transparent,
                              onTap: () async {
                                DateTime? pickedDate = await showDatePicker(
                                  context: context,
                                  initialDate: liveClassProvider.startDate,
                                  firstDate: DateTime(2000),
                                  lastDate: DateTime(2100),
                                  locale: const Locale('en'),
                                  builder: (context, child) {
                                    return Theme(
                                      data: Theme.of(context).copyWith(
                                        colorScheme: ColorScheme.light(
                                          primary: colorPrimaryDark,
                                          onPrimary: white,
                                          onSurface: black,
                                        ),
                                        textButtonTheme: TextButtonThemeData(
                                          style: TextButton.styleFrom(
                                            foregroundColor: colorPrimaryDark,
                                          ),
                                        ),
                                      ),
                                      child: child!,
                                    );
                                  },
                                );
                                if (pickedDate != null &&
                                    pickedDate != liveClassProvider.startDate) {
                                  liveClassProvider.setDateValue(pickedDate);
                                  // liveClassProvider.clearContent();
                                  // await _fetchData(liveClassProvider.startDate, 0);
                                }
                              },
                              child: Container(
                                alignment: Alignment.center,
                                padding: const EdgeInsets.symmetric(
                                    horizontal: 16, vertical: 8),
                                decoration: BoxDecoration(
                                  border: Border.all(
                                      width: 1,
                                      color: gray.withValues(alpha: .5),
                                      style: BorderStyle.solid),
                                  color: gray.withValues(alpha: 0.1),
                                  borderRadius: BorderRadius.circular(12),
                                ),
                                child: Row(
                                  children: [
                                    Expanded(
                                      child: MyText(
                                        text: DateFormat('dd-MM-yyyy').format(
                                            liveClassProvider.startDate),
                                        textalign: TextAlign.center,
                                        color: black.withValues(alpha: 0.8),
                                        multilanguage: false,
                                        fontsizeNormal: Dimens.textMedium,
                                        fontwaight: FontWeight.w500,
                                      ),
                                    ),
                                    const SizedBox(width: 10),
                                    Container(
                                      height: 40,
                                      width: 40,
                                      alignment: Alignment.center,
                                      // padding: EdgeInsets.all(11),
                                      decoration: BoxDecoration(
                                        color: gray.withValues(alpha: 0.4),
                                        borderRadius: BorderRadius.circular(12),
                                      ),
                                      child: Icon(
                                        FontAwesomeIcons.calendarCheck,
                                        size: 20,
                                        color: black.withValues(alpha: 0.6),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ])),
                      Expanded(
                          child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 5,
                              children: [
                            MyText(
                                text: "to",
                                multilanguage: true,
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1),
                            Container(
                              alignment: Alignment.center,
                              padding: const EdgeInsets.symmetric(
                                  horizontal: 16, vertical: 8),
                              decoration: BoxDecoration(
                                border: Border.all(
                                    width: 1,
                                    color: gray.withValues(alpha: .5),
                                    style: BorderStyle.solid),
                                color: gray.withValues(alpha: 0.1),
                                borderRadius: BorderRadius.circular(12),
                              ),
                              child: Row(
                                children: [
                                  Expanded(
                                    child: MyText(
                                      text: DateFormat('dd-MM-yyyy')
                                          .format(endDate),
                                      textalign: TextAlign.center,
                                      color: black.withValues(alpha: 0.8),
                                      multilanguage: false,
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w500,
                                    ),
                                  ),
                                  const SizedBox(width: 10),
                                  Container(
                                    height: 40,
                                    width: 40,
                                    alignment: Alignment.center,
                                    // padding: EdgeInsets.all(11),
                                    decoration: BoxDecoration(
                                      color: gray.withValues(alpha: 0.4),
                                      borderRadius: BorderRadius.circular(12),
                                    ),
                                    child: Icon(
                                      FontAwesomeIcons.calendarCheck,
                                      size: 20,
                                      color: black.withValues(alpha: 0.6),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ]))
                    ],
                  ),
                  SizedBox(height: 10),
                  Divider(
                    thickness: 1,
                    color: gray.withValues(alpha: 0.2),
                    height: 10,
                  ),
                  SizedBox(height: 10),

                  /* classes_plan plan */
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Expanded(
                        child: MyText(
                          text: "classes_plan",
                          color: black,
                          multilanguage: true,
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w500,
                        ),
                      ),
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () {
                          liveClassProvider.setPlan("0");
                        },
                        child: MyText(
                          text: "reset",
                          color: colorPrimaryDark,
                          multilanguage: true,
                          fontsizeNormal: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                        ),
                      ),
                    ],
                  ),
                  SizedBox(height: 6),
                  RadioGroup(
                    groupValue: liveClassProvider.isFree,
                    onChanged: (value) {
                      liveClassProvider.setPlan(value ?? "");
                    },
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        Row(
                          children: [
                            Radio(
                              activeColor: green,
                              focusColor: transparent,
                              hoverColor: transparent,
                              splashRadius: 0,
                              value: "0",
                            ),
                            MyText(
                              text: "paid",
                              multilanguage: true,
                              fontsizeNormal: Dimens.textMedium,
                              fontwaight: FontWeight.w500,
                            ),
                          ],
                        ),
                        Row(
                          children: [
                            Radio(
                              activeColor: green,
                              focusColor: transparent,
                              hoverColor: transparent,
                              splashRadius: 0,
                              value: "1",
                            ),
                            MyText(
                              text: "free",
                              multilanguage: true,
                              fontsizeNormal: Dimens.textMedium,
                              fontwaight: FontWeight.w500,
                            ),
                          ],
                        ),
                      ],
                    ),
                  ),
                  SizedBox(height: 10),
                  Divider(
                    thickness: 1,
                    color: gray.withValues(alpha: 0.2),
                    height: 10,
                  ),
                  SizedBox(height: 10),

                  /* Subject Data */
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Expanded(
                        child: MyText(
                          text: "subject",
                          color: black,
                          multilanguage: true,
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w500,
                        ),
                      ),
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () {
                          liveClassProvider.setCourseId("");
                        },
                        child: MyText(
                          text: "reset",
                          color: colorPrimaryDark,
                          multilanguage: true,
                          fontsizeNormal: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                        ),
                      ),
                    ],
                  ),
                  SizedBox(height: 14),
                  courseNameData(),
                  SizedBox(height: 10),
                  Divider(
                    thickness: 1,
                    color: gray.withValues(alpha: 0.2),
                    height: 10,
                  ),
                  SizedBox(height: 10),

                  /* Classes Timeing */
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      Expanded(
                        child: MyText(
                          text: "classes_time",
                          color: black,
                          multilanguage: true,
                          fontsizeNormal: Dimens.textMedium,
                          fontwaight: FontWeight.w500,
                        ),
                      ),
                      InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        onTap: () {
                          liveClassProvider.setStatus("");
                        },
                        child: MyText(
                          text: "reset",
                          color: colorPrimaryDark,
                          multilanguage: true,
                          fontsizeNormal: Dimens.textTitle,
                          fontwaight: FontWeight.w600,
                          maxline: 1,
                        ),
                      ),
                    ],
                  ),
                  SizedBox(height: 14),
                  SingleChildScrollView(
                    physics: BouncingScrollPhysics(),
                    scrollDirection: Axis.horizontal,
                    child: Row(
                      spacing: 10,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        _statusShow(
                            onTap: () {
                              liveClassProvider.setStatus("1");
                            },
                            value: "1",
                            title: "scheduled"),
                        _statusShow(
                            onTap: () {
                              liveClassProvider.setStatus("2");
                            },
                            value: "2",
                            title: "ongoing"),
                        _statusShow(
                            onTap: () {
                              liveClassProvider.setStatus("3");
                            },
                            value: "3",
                            title: "completed"),
                        _statusShow(
                            onTap: () {
                              liveClassProvider.setStatus("4");
                            },
                            value: "4",
                            title: "cancelled"),
                      ],
                    ),
                  ),
                  SizedBox(height: 10),
                  Divider(
                    thickness: 1,
                    color: gray.withValues(alpha: 0.2),
                    height: 10,
                  ),
                  SizedBox(height: 10),
                  /* Button show */
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    spacing: 20,
                    children: [
                      Expanded(
                        child: btnWidget(
                            borderColor: transparent,
                            color: colorPrimary.withValues(alpha: 0.3),
                            textColor: colorPrimaryDark,
                            text: "reset_all",
                            onTap: () {
                              if (Navigator.canPop(context)) {
                                Navigator.of(context).pop();
                              }
                              liveClassProvider.resetFilters();
                              liveClassProvider.searchList?.clear();
                              liveClassProvider.setSearch("0");
                              printLog("this is click btn");
                            }),
                      ),
                      Expanded(
                        child: btnWidget(
                          borderColor: transparent,
                          color: colorPrimaryDark,
                          textColor: white,
                          text: "apply_filters",
                          onTap: () {
                            if (Navigator.canPop(context)) {
                              Navigator.of(context).pop();
                            }

                            liveClassProvider.setSearch("1");
                            liveClassProvider.searchList?.clear();
                            _fetchsearchData(0);
                          },
                        ),
                      ),
                    ],
                  ),
                  SizedBox(height: 20),
                ],
              ),
            ),
          );
        });
      },
    );
  }

/* Course name Started */
  Widget courseNameData() {
    if (liveClassProvider.courseNameLoading) {
      return CustomWidget.roundcorner(
        height: 50,
        width: MediaQuery.sizeOf(context).width,
      );
    } else {
      if (liveClassProvider.courseNameModel.status == 200 &&
          (liveClassProvider.courseNameModel.result?.length ?? 0) > 0) {
        return Container(
          color: gray.withValues(alpha: 0.1),
          child: DropdownMenu(
            initialSelection: liveClassProvider.courseId,
            onSelected: (value) {
              if (value != null) {
                liveClassProvider.setCourseId(value);
              }
            },
            trailingIcon: Container(
                height: 40,
                width: 40,
                alignment: Alignment.center,
                // padding: EdgeInsets.all(11),
                decoration: BoxDecoration(
                  color: gray.withValues(alpha: 0.4),
                  borderRadius: BorderRadius.circular(12),
                ),
                child: Icon(Icons.keyboard_arrow_down, color: black, size: 20)),
            selectedTrailingIcon: Container(
              height: 40,
              width: 40,
              alignment: Alignment.center,
              // padding: EdgeInsets.all(11),
              decoration: BoxDecoration(
                color: gray.withValues(alpha: 0.4),
                borderRadius: BorderRadius.circular(12),
              ),
              child: Icon(Icons.keyboard_arrow_up, color: black, size: 20),
            ),
            width: MediaQuery.sizeOf(context).width,
            menuStyle: MenuStyle(
                visualDensity: VisualDensity.comfortable,
                backgroundColor: WidgetStatePropertyAll(white)),
            inputDecorationTheme: InputDecorationTheme(
                enabledBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.solid),
                    borderRadius: BorderRadius.circular(12)),
                errorBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.solid),
                    borderRadius: BorderRadius.circular(12)),
                focusedBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.solid),
                    borderRadius: BorderRadius.circular(12)),
                border: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.solid),
                    borderRadius: BorderRadius.circular(12))),
            hintText: "Select the Subject Name...",
            textStyle: GoogleFonts.manrope(
                fontSize: Dimens.textTitle,
                fontWeight: FontWeight.w500,
                fontStyle: FontStyle.normal,
                color: black),
            dropdownMenuEntries:
                (liveClassProvider.courseNameModel.result ?? [])
                    .map((category) {
              return DropdownMenuEntry(
                  value: category.id.toString(), label: category.title ?? "");
            }).toList(),
          ),
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget _statusShow({required VoidCallback onTap, String? title, value}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Container(
        alignment: Alignment.center,
        padding: EdgeInsets.fromLTRB(16, 12, 16, 12),
        decoration: BoxDecoration(
          color: liveClassProvider.classTimeStatus == value
              ? colorPrimaryDark
              : white,
          border: Border.all(
              width: 1,
              color: gray.withValues(alpha: .5),
              style: BorderStyle.solid),
          borderRadius: BorderRadius.circular(12),
        ),
        child: MyText(
          text: title ?? "",
          color: liveClassProvider.classTimeStatus == value ? white : black,
          multilanguage: true,
          fontsizeNormal: Dimens.textMedium,
          fontwaight: FontWeight.w500,
        ),
      ),
    );
  }

/* Filter data End */
  Widget landscapeShimmer() {
    return Column(
      children: [
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.roundrectborder(height: 10, width: 150),
                SizedBox(height: 5),
                CustomWidget.roundrectborder(height: 10, width: 80),
              ],
            ),
            CustomWidget.roundrectborder(height: 10, width: 50),
          ],
        ),
        SingleChildScrollView(
          padding: EdgeInsets.zero,
          scrollDirection: Axis.horizontal,
          physics: BouncingScrollPhysics(),
          child: Row(
            children: List.generate(
              10,
              (index) {
                return Container(
                  padding:
                      const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
                  width: 320,
                  margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(16),
                      border: Border.all(width: 1, color: transparent),
                      boxShadow: [
                        BoxShadow(
                            blurRadius: 4,
                            blurStyle: BlurStyle.solid,
                            offset: Offset(0, 4),
                            spreadRadius: 0,
                            color: transparent.withValues(alpha: 0.25))
                      ]),
                  child: Column(
                    spacing: 10,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        spacing: 5,
                        children: [
                          Container(
                            padding: EdgeInsets.symmetric(
                                horizontal: 10, vertical: 4),
                            decoration: BoxDecoration(
                                color: green,
                                borderRadius: BorderRadius.circular(14)),
                            child:
                                CustomWidget.roundcorner(height: 4, width: 50),
                          ),
                          Container(
                            padding: EdgeInsets.symmetric(
                                horizontal: 6, vertical: 4),
                            decoration: BoxDecoration(
                                color: liveTextColor,
                                borderRadius: BorderRadius.circular(7)),
                            child:
                                CustomWidget.roundcorner(height: 4, width: 100),
                          )
                        ],
                      ),
                      Stack(
                        alignment: Alignment.center,
                        children: [
                          Row(
                            spacing: 14,
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              SizedBox(
                                width: 160,
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  spacing: 20,
                                  children: [
                                    CustomWidget.roundcorner(
                                        height: 14, width: 120),
                                    Row(
                                      spacing: 4,
                                      children: [
                                        CustomWidget.roundcorner(
                                            height: 14, width: 50),
                                        Expanded(
                                          child: Container(
                                            padding: EdgeInsets.symmetric(
                                                horizontal: 6, vertical: 4),
                                            decoration: BoxDecoration(
                                                gradient: LinearGradient(
                                                    colors: [
                                                      red.withValues(
                                                          alpha: 0.5),
                                                      red.withValues(alpha: 0.6)
                                                    ],
                                                    tileMode: TileMode.mirror,
                                                    begin: Alignment.topCenter,
                                                    end:
                                                        Alignment.bottomCenter),
                                                borderRadius:
                                                    BorderRadius.circular(7)),
                                            child: CustomWidget.roundcorner(
                                                height: 14, width: 120),
                                          ),
                                        ),
                                      ],
                                    )
                                  ],
                                ),
                              ),
                            ],
                          ),
                          SizedBox(height: 2),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.end,
                            children: [
                              CustomWidget.roundcorner(height: 100, width: 100),
                              SizedBox(height: 2),
                              ClipPath(
                                clipper: LeftDiagonalClipper(),
                                child: Container(
                                  padding: EdgeInsets.fromLTRB(
                                      18, 4, 6, 4), // increased left padding

                                  decoration: BoxDecoration(
                                    color: black,
                                  ),
                                  child: CustomWidget.roundcorner(
                                      height: 14, width: 120),
                                ),
                              ),
                              Container(
                                height: 1,
                                width: width,
                                color: gray,
                              ),
                            ],
                          ),
                        ],
                      ),
                      Row(
                        spacing: 20,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Expanded(
                            child: CustomWidget.roundcorner(
                                height: 30, width: 120),
                          ),
                          Expanded(
                            child: CustomWidget.roundcorner(
                                height: 30, width: 120),
                          )
                        ],
                      )
                    ],
                  ),
                );
              },
            ),
          ),
        ),
      ],
    );
  }

/* Search Shimmer */
  Widget searchShimmer() {
    return ResponsiveGridList(
        minItemWidth: 300,
        maxItemsPerRow: 2,
        minItemsPerRow: 1,
        listViewBuilderOptions: ListViewBuilderOptions(
            shrinkWrap: true,
            padding: EdgeInsets.zero,
            physics: NeverScrollableScrollPhysics()),
        children: List.generate(
          10,
          (index) {
            return Container(
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
              margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
              decoration: BoxDecoration(
                  color: white,
                  borderRadius: BorderRadius.circular(16),
                  border: Border.all(width: 1, color: transparent),
                  boxShadow: [
                    BoxShadow(
                        blurRadius: 4,
                        blurStyle: BlurStyle.solid,
                        offset: Offset(0, 4),
                        spreadRadius: 0,
                        color: transparent.withValues(alpha: 0.25))
                  ]),
              child: Column(
                spacing: 10,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    spacing: 5,
                    children: [
                      Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 10, vertical: 4),
                        decoration: BoxDecoration(
                            color: green,
                            borderRadius: BorderRadius.circular(14)),
                        child: CustomWidget.roundcorner(height: 4, width: 50),
                      ),
                      Container(
                        padding:
                            EdgeInsets.symmetric(horizontal: 6, vertical: 4),
                        decoration: BoxDecoration(
                            color: liveTextColor,
                            borderRadius: BorderRadius.circular(7)),
                        child: CustomWidget.roundcorner(height: 4, width: 100),
                      )
                    ],
                  ),
                  Stack(
                    alignment: Alignment.center,
                    children: [
                      Row(
                        spacing: 14,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          SizedBox(
                            width: 160,
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 20,
                              children: [
                                CustomWidget.roundcorner(
                                    height: 14, width: 120),
                                Row(
                                  spacing: 4,
                                  children: [
                                    CustomWidget.roundcorner(
                                        height: 14, width: 50),
                                    Expanded(
                                      child: Container(
                                        padding: EdgeInsets.symmetric(
                                            horizontal: 6, vertical: 4),
                                        decoration: BoxDecoration(
                                            gradient: LinearGradient(
                                                colors: [
                                                  red.withValues(alpha: 0.5),
                                                  red.withValues(alpha: 0.6)
                                                ],
                                                tileMode: TileMode.mirror,
                                                begin: Alignment.topCenter,
                                                end: Alignment.bottomCenter),
                                            borderRadius:
                                                BorderRadius.circular(7)),
                                        child: CustomWidget.roundcorner(
                                            height: 14, width: 120),
                                      ),
                                    ),
                                  ],
                                )
                              ],
                            ),
                          ),
                        ],
                      ),
                      SizedBox(height: 2),
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        children: [
                          CustomWidget.roundcorner(height: 100, width: 100),
                          SizedBox(height: 2),
                          ClipPath(
                            clipper: LeftDiagonalClipper(),
                            child: Container(
                              padding: EdgeInsets.fromLTRB(
                                  18, 4, 6, 4), // increased left padding

                              decoration: BoxDecoration(
                                color: black,
                              ),
                              child: CustomWidget.roundcorner(
                                  height: 14, width: 120),
                            ),
                          ),
                          Container(
                            height: 1,
                            width: width,
                            color: gray,
                          ),
                        ],
                      ),
                    ],
                  ),
                  Row(
                    spacing: 20,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: CustomWidget.roundcorner(height: 30, width: 120),
                      ),
                      Expanded(
                        child: CustomWidget.roundcorner(height: 30, width: 120),
                      )
                    ],
                  )
                ],
              ),
            );
          },
        ));
  }

  Widget proShimmer() {
    return Column(
      children: [
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.roundrectborder(height: 10, width: 150),
                SizedBox(height: 5),
                CustomWidget.roundrectborder(height: 10, width: 80),
              ],
            ),
            CustomWidget.roundrectborder(height: 10, width: 50),
          ],
        ),
        ResponsiveGridList(
            minItemWidth: 140,
            maxItemsPerRow: 4,
            minItemsPerRow: 2,
            listViewBuilderOptions: ListViewBuilderOptions(
                scrollDirection: Axis.vertical,
                padding: EdgeInsets.zero,
                shrinkWrap: true,
                physics: NeverScrollableScrollPhysics()),
            children: List.generate(
              5,
              (index) {
                return Container(
                  margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(10),
                      border: Border.all(width: 1, color: transparent),
                      boxShadow: [
                        BoxShadow(
                            blurRadius: 4,
                            blurStyle: BlurStyle.solid,
                            offset: Offset(0, 4),
                            spreadRadius: 0,
                            color: transparent.withValues(alpha: 0.25))
                      ]),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 10,
                    children: [
                      Stack(
                        children: [
                          CustomWidget.roundcorner(
                              height: 150, width: width ?? 0),
                          Positioned(
                            top: 10,
                            left: 5,
                            child: Container(
                              padding: EdgeInsets.symmetric(
                                  horizontal: 6, vertical: 4),
                              decoration: BoxDecoration(
                                  gradient: LinearGradient(
                                      colors: [
                                        red.withValues(alpha: 0.5),
                                        red.withValues(alpha: 0.6)
                                      ],
                                      tileMode: TileMode.mirror,
                                      begin: Alignment.topCenter,
                                      end: Alignment.bottomCenter),
                                  borderRadius: BorderRadius.circular(7)),
                              child: CustomWidget.roundcorner(
                                  height: 10, width: 80),
                            ),
                          ),
                        ],
                      ),
                      Padding(
                        padding: const EdgeInsets.fromLTRB(8, 0, 8, 10),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          spacing: 4,
                          children: [
                            CustomWidget.roundcorner(height: 10, width: 80),
                            SizedBox(height: 4),
                            Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.start,
                              spacing: 5,
                              children: [
                                Container(
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 4, vertical: 2),
                                  decoration: BoxDecoration(
                                      color: green,
                                      borderRadius: BorderRadius.circular(4)),
                                  child: CustomWidget.roundcorner(
                                      height: 10, width: 80),
                                ),
                                Flexible(
                                  fit: FlexFit.loose,
                                  child: CustomWidget.roundcorner(
                                      height: 10, width: 80),
                                )
                              ],
                            ),
                            CustomWidget.roundcorner(height: 10, width: 80),
                            CustomWidget.roundcorner(height: 10, width: 80),
                            SizedBox(height: 4),
                            CustomWidget.roundcorner(height: 30, width: 80),
                          ],
                        ),
                      )
                    ],
                  ),
                );
              },
            )),
      ],
    );
  }

  Widget recordingPortriatShimmer() {
    return Column(
      children: [
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomWidget.roundrectborder(height: 10, width: 150),
                SizedBox(height: 5),
                CustomWidget.roundrectborder(height: 10, width: 80),
              ],
            ),
            CustomWidget.roundrectborder(height: 10, width: 50),
          ],
        ),
        SingleChildScrollView(
            scrollDirection: Axis.horizontal,
            padding: EdgeInsets.zero,
            physics: BouncingScrollPhysics(),
            child: Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: List.generate(
                  5,
                  (index) {
                    return Container(
                      margin: EdgeInsets.only(bottom: 10, right: 10, left: 2),
                      width: 150,
                      decoration: BoxDecoration(
                          color: white,
                          borderRadius: BorderRadius.circular(10),
                          border: Border.all(width: 1, color: transparent),
                          boxShadow: [
                            BoxShadow(
                                blurRadius: 4,
                                blurStyle: BlurStyle.solid,
                                offset: Offset(0, 4),
                                spreadRadius: 0,
                                color: transparent.withValues(alpha: 0.25))
                          ]),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        spacing: 10,
                        children: [
                          CustomWidget.roundcorner(
                              height: 150, width: width ?? 0),
                          Padding(
                            padding: const EdgeInsets.fromLTRB(8, 0, 8, 10),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              spacing: 4,
                              children: [
                                CustomWidget.roundcorner(height: 10, width: 80),
                                SizedBox(height: 4),
                                CustomWidget.roundcorner(height: 10, width: 80),
                                CustomWidget.roundcorner(height: 10, width: 80),
                                SizedBox(height: 4),
                                CustomWidget.roundcorner(height: 30, width: 80),
                              ],
                            ),
                          )
                        ],
                      ),
                    );
                  },
                ))),
      ],
    );
  }
}

class LeftDiagonalClipper extends CustomClipper<Path> {
  @override
  Path getClip(Size size) {
    Path path = Path();
    path.moveTo(20, 0); // top-left diagonal offset
    path.lineTo(size.width, 0); // top-right
    path.lineTo(size.width, size.height); // bottom-right
    path.lineTo(0, size.height); // bottom-left
    path.close(); // close the shape
    return path;
  }

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) => false;
}
