import 'package:carousel_slider/carousel_slider.dart';
import 'package:prakah/pages/blogdetail.dart';
import 'package:prakah/pages/detail.dart';
import 'package:prakah/pages/ebookdetails.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/pages/tutorprofilepage.dart';
import 'package:prakah/pages/videobyidviewall.dart';
import 'package:prakah/pages/viewall.dart';
import 'package:prakah/provider/homeprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/myrating.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:flutter_rating_bar/flutter_rating_bar.dart';
import 'package:provider/provider.dart';
import 'package:smooth_page_indicator/smooth_page_indicator.dart';
import '../../model/sectionlistmodel.dart';

class Home extends StatefulWidget {
  const Home({super.key});

  @override
  State<Home> createState() => HomeState();
}

class HomeState extends State<Home> {
  HomeProvider homeProvider = HomeProvider();
  PageController pageController = PageController();
  final ScrollController _scrollController = ScrollController();
  double? width;
  double? height;

  @override
  void initState() {
    super.initState();
    homeProvider = Provider.of<HomeProvider>(context, listen: false);
    _scrollController.addListener(_scrollListener);
    _fetchData(0);
  }

  void _scrollListener() {
    if (!_scrollController.hasClients) return;
    if (_scrollController.offset >=
            _scrollController.position.maxScrollExtent &&
        !_scrollController.position.outOfRange &&
        (homeProvider.sectioncurrentPage ?? 0) <
            (homeProvider.sectiontotalPage ?? 0)) {
      homeProvider.setLoadMore(true);
      _fetchData(homeProvider.sectioncurrentPage ?? 0);
    }
  }

  Future<void> _fetchData(int? nextPage) async {
    await homeProvider.getSeactionList((nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    _scrollController.dispose();
    homeProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    width = MediaQuery.of(context).size.width;
    height = MediaQuery.of(context).size.height;
    return Scaffold(
      backgroundColor: white,
      body: buildPage(),
    );
  }

/* END */
  Widget buildPage() {
    return Consumer<HomeProvider>(builder: (context, homeprovider, child) {
      if (homeprovider.loading && !homeprovider.loadmore) {
        return Padding(
          padding: const EdgeInsets.fromLTRB(10, 15, 10, 15),
          child: commanShimmer(),
        );
      } else {
        return setSectionByType();
      }
    });
  }

  Widget setSectionByType() {
    if (homeProvider.sectionList != null &&
        (homeProvider.sectionList?.length ?? 0) > 0) {
      return SingleChildScrollView(
        physics: AlwaysScrollableScrollPhysics(),
        controller: _scrollController,
        child: Column(
          children: [
            MediaQuery.removePadding(
              context: context,
              removeTop: true,
              child: ListView.builder(
                itemCount: homeProvider.sectionList?.length ?? 0,
                shrinkWrap: true,
                reverse: false,
                physics: const NeverScrollableScrollPhysics(),
                itemBuilder: (BuildContext context, int index) {
                  if (homeProvider.sectionList?[index].data != null &&
                      (homeProvider.sectionList?[index].data?.length ?? 0) >
                          0) {
                    return Padding(
                      padding: homeProvider.sectionList?[index].screenLayout ==
                              "landscape"
                          ? EdgeInsets.zero
                          : const EdgeInsets.fromLTRB(14, 0, 14, 0),
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.center,
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          // Section Title
                          homeProvider.sectionList?[index].screenLayout ==
                                      "banner" ||
                                  homeProvider
                                          .sectionList?[index].screenLayout ==
                                      "landscape"
                              ? const SizedBox.shrink()
                              : Padding(
                                  padding:
                                      const EdgeInsets.fromLTRB(0, 25, 0, 0),
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      Expanded(
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            MyText(
                                                color: Theme.of(context)
                                                    .colorScheme
                                                    .surface,
                                                text: homeProvider
                                                        .sectionList?[index]
                                                        .title
                                                        .toString() ??
                                                    "",
                                                fontsizeNormal: Dimens.textBig,
                                                fontwaight: FontWeight.w600,
                                                maxline: 1,
                                                overflow: TextOverflow.ellipsis,
                                                textalign: TextAlign.start,
                                                fontstyle: FontStyle.normal,
                                                multilanguage: false),
                                            const SizedBox(height: 5),
                                            (homeProvider.sectionList?[index]
                                                            .shortTitle
                                                            .toString() ??
                                                        "") ==
                                                    ""
                                                ? SizedBox.shrink()
                                                : MyText(
                                                    color: gray,
                                                    multilanguage: false,
                                                    text: homeProvider
                                                            .sectionList?[index]
                                                            .shortTitle
                                                            .toString() ??
                                                        "",
                                                    textalign: TextAlign.center,
                                                    fontsizeNormal: 12,
                                                    fontsizeWeb: 12,
                                                    maxline: 1,
                                                    fontwaight: FontWeight.w400,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    fontstyle:
                                                        FontStyle.normal),
                                          ],
                                        ),
                                      ),
                                      homeProvider.sectionList?[index]
                                                  .viewAll ==
                                              1
                                          ? InkWell(
                                              splashColor: transparent,
                                              focusColor: transparent,
                                              hoverColor: transparent,
                                              highlightColor: transparent,
                                              onTap: () {
                                                AdHelper.showFullscreenAd(
                                                    context,
                                                    Constant.interstialAdType,
                                                    () {
                                                  Navigator.of(context).push(
                                                    PageRouteBuilder(
                                                      pageBuilder: (context,
                                                              animation,
                                                              secondaryAnimation) =>
                                                          ViewAll(
                                                        screenLayout: homeProvider
                                                                .sectionList?[
                                                                    index]
                                                                .screenLayout
                                                                .toString() ??
                                                            "",
                                                        title: homeProvider
                                                                .sectionList?[
                                                                    index]
                                                                .title
                                                                .toString() ??
                                                            "",
                                                        contentId: homeProvider
                                                                .sectionList?[
                                                                    index]
                                                                .id
                                                                .toString() ??
                                                            "",
                                                        viewAllType: "section",
                                                      ),
                                                      transitionsBuilder:
                                                          (context,
                                                              animation,
                                                              secondaryAnimation,
                                                              child) {
                                                        const begin =
                                                            Offset(1.0, 0.0);
                                                        const end = Offset.zero;
                                                        const curve =
                                                            Curves.ease;

                                                        var tween = Tween(
                                                                begin: begin,
                                                                end: end)
                                                            .chain(CurveTween(
                                                                curve: curve));

                                                        return SlideTransition(
                                                          position: animation
                                                              .drive(tween),
                                                          child: child,
                                                        );
                                                      },
                                                    ),
                                                  );
                                                });
                                              },
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.all(10.0),
                                                child: MyText(
                                                    color: Theme.of(context)
                                                        .colorScheme
                                                        .surface,
                                                    text: "viewall",
                                                    fontsizeNormal:
                                                        Dimens.textDesc,
                                                    fontwaight: FontWeight.w500,
                                                    maxline: 1,
                                                    overflow:
                                                        TextOverflow.ellipsis,
                                                    textalign: TextAlign.right,
                                                    fontstyle: FontStyle.normal,
                                                    multilanguage: true),
                                              ))
                                          : const SizedBox.shrink(),
                                    ],
                                  ),
                                ),
                          const SizedBox(height: 10),
                          // Section Data List
                          setSectionData(
                              index: index,
                              sectionList: homeProvider.sectionList),
                        ],
                      ),
                    );
                  } else {
                    return const SizedBox.shrink();
                  }
                },
              ),
            ),
            if (homeProvider.loadmore)
              SizedBox(
                height: 50,
                child: Utils.pageLoader(),
              )
            else
              const SizedBox.shrink(),
          ],
        ),
      );
    } else {
      return const NoData();
    }
  }

  Widget setSectionData(
      {required int index, required List<Result>? sectionList}) {
    if ((sectionList?[index].screenLayout.toString() ?? "") == "banner") {
      return banner(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "landscape") {
      return landscap(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "portrait") {
      return portrait(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "list_view") {
      return listView(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "category") {
      return category(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") ==
        "language") {
      return language(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") == "tutor") {
      return tutorlist(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") == "blog") {
      return blogList(index, sectionList);
    } else if ((sectionList?[index].screenLayout.toString() ?? "") == "book") {
      return bookList(index, sectionList);
    } else {
      return const SizedBox.shrink();
    }
  }

  /* Banner */
  Widget banner(int sectionindex, List<Result>? sectionList) {
    return SizedBox(
      width: MediaQuery.of(context).size.width,
      height: 280,
      child: CarouselSlider.builder(
        itemCount: sectionList?[sectionindex].data?.length ?? 0,
        options: CarouselOptions(
          height: MediaQuery.of(context).size.height,
          enlargeCenterPage: true,
          enlargeStrategy: CenterPageEnlargeStrategy.zoom,
          autoPlay: true,
          autoPlayCurve: Curves.linear,
          enableInfiniteScroll: true,
          autoPlayInterval: const Duration(seconds: 5),
          autoPlayAnimationDuration: const Duration(seconds: 1),
          viewportFraction: 0.86,
          onPageChanged: (index, reason) {
            homeProvider.setInde(index);
          },
        ),
        itemBuilder: (BuildContext context, int index, int pageViewIndex) {
          return InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            highlightColor: transparent,
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    transitionDuration: const Duration(milliseconds: 200),
                    pageBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation) {
                      return Detail(
                          courseId: sectionList?[sectionindex]
                                  .data?[index]
                                  .id
                                  .toString() ??
                              "");
                    },
                    transitionsBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation,
                        Widget child) {
                      return Align(
                        child: FadeTransition(
                          opacity: animation,
                          child: child,
                        ),
                      );
                    },
                  ),
                );
              });
            },
            child: Container(
              margin: EdgeInsets.only(
                  right: 10, left: 0.0, top: 10.0, bottom: 12.0),
              padding: EdgeInsets.zero,
              decoration: BoxDecoration(
                color: white,
                borderRadius: BorderRadius.circular(15),
                boxShadow: [
                  BoxShadow(
                    blurRadius: 4,
                    color: transparent.withValues(alpha: 0.17),
                  )
                ],
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 6,
                children: [
                  ClipRRect(
                    borderRadius: BorderRadius.only(
                        topLeft: Radius.circular(15),
                        topRight: Radius.circular(15)),
                    child: MyNetworkImage(
                        islandscap: true,
                        imgWidth: MediaQuery.of(context).size.width,
                        imgHeight: 180,
                        fit: BoxFit.fill,
                        imageUrl: sectionList?[sectionindex]
                                .data?[index]
                                .landscapeImg
                                .toString() ??
                            ""),
                  ),
                  Padding(
                    padding: const EdgeInsets.fromLTRB(10, 0, 10, 6),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyText(
                            color: black,
                            text: sectionList?[sectionindex]
                                    .data?[index]
                                    .title
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        MyText(
                            color: black,
                            text:
                                "${Utils.kmbGenerator(sectionList?[sectionindex].data?[index].totalView ?? 0)} Students",
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          spacing: 4,
                          children: [
                            MyRating(
                                rating: double.parse(sectionList?[sectionindex]
                                        .data?[index]
                                        .avgRating
                                        .toString() ??
                                    ""),
                                spacing: 5,
                                size: 15),
                            MyText(
                                color: colorAccent,
                                text:
                                    "${double.parse(sectionList?[sectionindex].data?[index].avgRating.toString() ?? "")}",
                                fontsizeNormal: Dimens.textMedium,
                                fontwaight: FontWeight.w600,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                      ],
                    ),
                  )
                ],
              ),
            ),
          );
        },
      ),
    );
  }

  Widget bannerShimmer() {
    return Column(
      children: [
        SizedBox(
          width: MediaQuery.of(context).size.width,
          height: 500,
          child: PageView.builder(
            itemCount: 3,
            controller: pageController,
            itemBuilder: (context, index) {
              return Container(
                margin: const EdgeInsets.fromLTRB(20, 15, 20, 15),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                ),
                child: CustomWidget.roundcorner(
                  height: MediaQuery.of(context).size.height,
                  width: MediaQuery.of(context).size.width,
                ),
              );
            },
          ),
        ),
        Container(
          width: MediaQuery.of(context).size.width,
          height: 20,
          alignment: Alignment.topCenter,
          child: SmoothPageIndicator(
            controller: pageController,
            count: 3,
            axisDirection: Axis.horizontal,
            effect: ExpandingDotsEffect(
                spacing: 5,
                radius: 50,
                dotWidth: 5,
                expansionFactor: 7,
                dotColor: gray.withValues(alpha: 0.40),
                dotHeight: 5,
                activeDotColor: gray),
          ),
        ),
      ],
    );
  }

  /* Category */
  Widget category(int sectionindex, List<Result>? sectionList) {
    return SizedBox(
      height: 100,
      child: SingleChildScrollView(
        padding: EdgeInsets.zero,
        scrollDirection: Axis.horizontal,
        child: Wrap(
            spacing: 10,
            runSpacing: 10,
            direction: Axis.vertical,
            alignment: WrapAlignment.start,
            crossAxisAlignment: WrapCrossAlignment.start,
            children: [
              ...List.generate(
                sectionList?[sectionindex].data?.length ?? 0,
                (index) => InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  highlightColor: transparent,
                  onTap: () {
                    AdHelper.showFullscreenAd(
                        context, Constant.interstialAdType, () {
                      Navigator.of(context).push(
                        PageRouteBuilder(
                          pageBuilder:
                              (context, animation, secondaryAnimation) =>
                                  VideoByIdViewAll(
                            apiType: "category",
                            title: sectionList?[sectionindex]
                                    .data?[index]
                                    .name
                                    .toString() ??
                                "",
                            contentId: sectionList?[sectionindex]
                                    .data?[index]
                                    .id
                                    .toString() ??
                                "",
                          ),
                          transitionsBuilder:
                              (context, animation, secondaryAnimation, child) {
                            const begin = Offset(1.0, 0.0);
                            const end = Offset.zero;
                            const curve = Curves.ease;

                            var tween = Tween(begin: begin, end: end)
                                .chain(CurveTween(curve: curve));

                            return SlideTransition(
                              position: animation.drive(tween),
                              child: child,
                            );
                          },
                        ),
                      );
                    });
                  },
                  child: Container(
                    width: 160,
                    padding: const EdgeInsets.fromLTRB(10, 5, 10, 5),
                    height: 40,
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      borderRadius: const BorderRadius.all(Radius.circular(25)),
                      border: Border.all(width: 0.8, color: gray),
                    ),
                    child: MyText(
                        color: gray,
                        text: sectionList?[sectionindex]
                                .data?[index]
                                .name
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textBigSmall,
                        overflow: TextOverflow.ellipsis,
                        maxline: 1,
                        fontwaight: FontWeight.w600,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal),
                  ),
                ),
              ),
            ]),
      ),
    );
  }

  Widget language(int sectionindex, List<Result>? sectionList) {
    return SizedBox(
      height: 100,
      child: SingleChildScrollView(
        padding: EdgeInsets.zero,
        scrollDirection: Axis.horizontal,
        child: Wrap(
            spacing: 10,
            runSpacing: 10,
            direction: Axis.vertical,
            alignment: WrapAlignment.start,
            crossAxisAlignment: WrapCrossAlignment.start,
            children: [
              ...List.generate(
                sectionList?[sectionindex].data?.length ?? 0,
                (index) => InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  highlightColor: transparent,
                  onTap: () {
                    AdHelper.showFullscreenAd(
                        context, Constant.interstialAdType, () {
                      Navigator.of(context).push(
                        PageRouteBuilder(
                          pageBuilder:
                              (context, animation, secondaryAnimation) =>
                                  VideoByIdViewAll(
                            apiType: "language",
                            title: sectionList?[sectionindex]
                                    .data?[index]
                                    .name
                                    .toString() ??
                                "",
                            contentId: sectionList?[sectionindex]
                                    .data?[index]
                                    .id
                                    .toString() ??
                                "",
                          ),
                          transitionsBuilder:
                              (context, animation, secondaryAnimation, child) {
                            const begin = Offset(1.0, 0.0);
                            const end = Offset.zero;
                            const curve = Curves.ease;

                            var tween = Tween(begin: begin, end: end)
                                .chain(CurveTween(curve: curve));

                            return SlideTransition(
                              position: animation.drive(tween),
                              child: child,
                            );
                          },
                        ),
                      );
                    });
                  },
                  child: Container(
                    width: 160,
                    padding: const EdgeInsets.fromLTRB(10, 5, 10, 5),
                    height: 40,
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      borderRadius: const BorderRadius.all(Radius.circular(25)),
                      border: Border.all(width: 0.8, color: gray),
                    ),
                    child: MyText(
                        color: gray,
                        text: sectionList?[sectionindex]
                                .data?[index]
                                .name
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textBigSmall,
                        overflow: TextOverflow.ellipsis,
                        maxline: 1,
                        fontwaight: FontWeight.w600,
                        textalign: TextAlign.center,
                        fontstyle: FontStyle.normal),
                  ),
                ),
              ),
            ]),
      ),
    );
  }

/* landscap List */
  Widget landscap(int sectionindex, List<Result>? sectionList) {
    return Container(
      color: colorPrimary.withValues(alpha: 0.16),
      width: MediaQuery.of(context).size.width,
      alignment: Alignment.centerLeft,
      padding: const EdgeInsets.only(top: 8, bottom: 8, left: 10, right: 00),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 14,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  spacing: 4,
                  children: [
                    MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: homeProvider.sectionList?[sectionindex].title
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textBig,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.start,
                        fontstyle: FontStyle.normal,
                        multilanguage: false),
                    (homeProvider.sectionList?[sectionindex].shortTitle
                                    .toString() ??
                                "") ==
                            ""
                        ? SizedBox.shrink()
                        : MyText(
                            color: gray,
                            multilanguage: false,
                            text: homeProvider
                                    .sectionList?[sectionindex].shortTitle
                                    .toString() ??
                                "",
                            textalign: TextAlign.center,
                            fontsizeNormal: 12,
                            fontsizeWeb: 12,
                            maxline: 1,
                            fontwaight: FontWeight.w400,
                            overflow: TextOverflow.ellipsis,
                            fontstyle: FontStyle.normal),
                  ],
                ),
              ),
              homeProvider.sectionList?[sectionindex].viewAll == 1
                  ? InkWell(
                      splashColor: transparent,
                      focusColor: transparent,
                      hoverColor: transparent,
                      highlightColor: transparent,
                      onTap: () {
                        AdHelper.showFullscreenAd(
                            context, Constant.interstialAdType, () {
                          Navigator.of(context).push(
                            PageRouteBuilder(
                              pageBuilder:
                                  (context, animation, secondaryAnimation) =>
                                      ViewAll(
                                screenLayout: homeProvider
                                        .sectionList?[sectionindex].screenLayout
                                        .toString() ??
                                    "",
                                title: homeProvider
                                        .sectionList?[sectionindex].title
                                        .toString() ??
                                    "",
                                contentId: homeProvider
                                        .sectionList?[sectionindex].id
                                        .toString() ??
                                    "",
                                viewAllType: "section",
                              ),
                              transitionsBuilder: (context, animation,
                                  secondaryAnimation, child) {
                                const begin = Offset(1.0, 0.0);
                                const end = Offset.zero;
                                const curve = Curves.ease;

                                var tween = Tween(begin: begin, end: end)
                                    .chain(CurveTween(curve: curve));

                                return SlideTransition(
                                  position: animation.drive(tween),
                                  child: child,
                                );
                              },
                            ),
                          );
                        });
                      },
                      child: Padding(
                        padding: const EdgeInsets.only(right: 10.0),
                        child: MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: "viewall",
                            fontsizeNormal: Dimens.textDesc,
                            fontwaight: FontWeight.w500,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.right,
                            fontstyle: FontStyle.normal,
                            multilanguage: true),
                      ))
                  : const SizedBox.shrink(),
            ],
          ),
          SingleChildScrollView(
            physics: BouncingScrollPhysics(),
            scrollDirection: Axis.horizontal,
            padding: EdgeInsets.zero,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              mainAxisSize: MainAxisSize.min,
              children: List.generate(
                sectionList?[sectionindex].data?.length ?? 0,
                (index) {
                  return InkWell(
                    splashColor: transparent,
                    focusColor: transparent,
                    hoverColor: transparent,
                    highlightColor: transparent,
                    onTap: () {
                      AdHelper.showFullscreenAd(
                          context, Constant.interstialAdType, () {
                        Navigator.of(context).push(
                          PageRouteBuilder(
                            transitionDuration:
                                const Duration(milliseconds: 200),
                            pageBuilder: (BuildContext context,
                                Animation<double> animation,
                                Animation<double> secondaryAnimation) {
                              return Detail(
                                  courseId: sectionList?[sectionindex]
                                          .data?[index]
                                          .id
                                          .toString() ??
                                      "");
                            },
                            transitionsBuilder: (BuildContext context,
                                Animation<double> animation,
                                Animation<double> secondaryAnimation,
                                Widget child) {
                              return Align(
                                child: FadeTransition(
                                  opacity: animation,
                                  child: child,
                                ),
                              );
                            },
                          ),
                        );
                      });
                    },
                    child: Container(
                      width: 250,
                      margin: const EdgeInsets.fromLTRB(5, 0, 5, 5),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(15),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          Stack(
                            children: [
                              MyNetworkImage(
                                  imgWidth: MediaQuery.of(context).size.width,
                                  imgHeight: 120,
                                  radius: 15,
                                  fit: BoxFit.fill,
                                  islandscap: true,
                                  imageUrl: sectionList?[sectionindex]
                                          .data?[index]
                                          .thumbnailImg
                                          .toString() ??
                                      ""),
                              sectionList?[sectionindex].data?[index].isFree !=
                                      1
                                  ? Positioned.fill(
                                      top: 10,
                                      left: 10,
                                      right: 10,
                                      child: Align(
                                        alignment: Alignment.topRight,
                                        child: Container(
                                          padding: const EdgeInsets.fromLTRB(
                                              8, 8, 8, 8),
                                          decoration: const BoxDecoration(
                                            shape: BoxShape.circle,
                                            color: colorAccent,
                                          ),
                                          child: MyImage(
                                            width: 18,
                                            height: 18,
                                            imagePath: "ic_premium.png",
                                            color: Theme.of(context)
                                                .colorScheme
                                                .surface,
                                          ),
                                        ),
                                      ),
                                    )
                                  : const SizedBox.shrink(),
                            ],
                          ),
                          Padding(
                            padding: const EdgeInsets.fromLTRB(0, 8, 0, 5),
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                MyText(
                                    color:
                                        Theme.of(context).colorScheme.surface,
                                    text: sectionList?[sectionindex]
                                            .data?[index]
                                            .title
                                            .toString() ??
                                        "",
                                    fontsizeNormal: Dimens.textBigSmall,
                                    fontwaight: FontWeight.w600,
                                    maxline: 1,
                                    overflow: TextOverflow.ellipsis,
                                    textalign: TextAlign.left,
                                    fontstyle: FontStyle.normal),
                                const SizedBox(height: 5),
                                Row(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: [
                                    MyText(
                                        color: gray,
                                        text: Utils.kmbGenerator(
                                          int.parse(sectionList?[sectionindex]
                                                  .data?[index]
                                                  .totalView
                                                  .toString() ??
                                              ""),
                                        ),
                                        fontsizeNormal: Dimens.textSmall,
                                        fontwaight: FontWeight.w500,
                                        maxline: 1,
                                        overflow: TextOverflow.ellipsis,
                                        textalign: TextAlign.left,
                                        fontstyle: FontStyle.normal),
                                    const SizedBox(width: 5),
                                    MyText(
                                        color: gray,
                                        text: "students",
                                        fontsizeNormal: Dimens.textSmall,
                                        fontwaight: FontWeight.w500,
                                        maxline: 1,
                                        multilanguage: true,
                                        overflow: TextOverflow.ellipsis,
                                        textalign: TextAlign.left,
                                        fontstyle: FontStyle.normal),
                                  ],
                                ),
                                const SizedBox(height: 5),
                                Row(
                                  children: [
                                    MyRating(
                                      size: 13,
                                      rating: double.parse(
                                          (sectionList?[sectionindex]
                                                  .data?[index]
                                                  .avgRating
                                                  .toString() ??
                                              "")),
                                      spacing: 3,
                                    ),
                                    const SizedBox(width: 5),
                                    MyText(
                                        color: colorAccent,
                                        text:
                                            "${double.parse(sectionList?[sectionindex].data?[index].avgRating.toString() ?? "")}",
                                        fontsizeNormal: Dimens.textBigSmall,
                                        fontwaight: FontWeight.w600,
                                        maxline: 1,
                                        overflow: TextOverflow.ellipsis,
                                        textalign: TextAlign.left,
                                        fontstyle: FontStyle.normal),
                                  ],
                                )
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget landscapShimmer() {
    return Column(
      children: [
        SizedBox(
          width: MediaQuery.of(context).size.width,
          height: 80,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              CustomWidget.roundrectborder(
                  height: 15, width: MediaQuery.of(context).size.width * 0.30),
              const SizedBox(
                height: 10,
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Container(
                    width: 70,
                    height: 1,
                    color: gray,
                  ),
                  const SizedBox(
                    width: 10,
                  ),
                  CustomWidget.roundrectborder(
                      height: 15,
                      width: MediaQuery.of(context).size.width * 0.20),
                  const SizedBox(
                    width: 10,
                  ),
                  Container(
                    width: 70,
                    height: 1,
                    color: gray,
                  ),
                ],
              ),
            ],
          ),
        ),
        Container(
          width: MediaQuery.of(context).size.width,
          height: 250,
          alignment: Alignment.centerLeft,
          child: ListView.builder(
            scrollDirection: Axis.horizontal,
            shrinkWrap: true,
            itemCount: 3,
            itemBuilder: (BuildContext context, int index) {
              return Padding(
                padding: const EdgeInsets.fromLTRB(20, 0, 20, 0),
                child: Container(
                  width: 220,
                  height: 220,
                  margin: const EdgeInsets.fromLTRB(0, 0, 0, 5),
                  decoration: BoxDecoration(
                    color: white,
                    border: Border.all(width: 1, color: colorAccent),
                  ),
                  child: Column(
                    children: [
                      SizedBox(
                        width: MediaQuery.of(context).size.width,
                        height: 120,
                        child: Padding(
                          padding: const EdgeInsets.all(5),
                          child: CustomWidget.roundrectborder(
                              height: MediaQuery.of(context).size.height,
                              width: MediaQuery.of(context).size.width),
                        ),
                      ),
                      Container(
                        width: MediaQuery.of(context).size.width,
                        height: 120,
                        padding: const EdgeInsets.only(left: 5),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            CustomWidget.roundrectborder(
                                height:
                                    MediaQuery.of(context).size.height * 0.02,
                                width:
                                    MediaQuery.of(context).size.width * 0.20),
                            const SizedBox(height: 10),
                            CustomWidget.roundrectborder(
                                height:
                                    MediaQuery.of(context).size.height * 0.02,
                                width:
                                    MediaQuery.of(context).size.width * 0.25),
                            const SizedBox(height: 10),
                            Row(
                              children: [
                                RatingBar(
                                  initialRating: 5,
                                  direction: Axis.horizontal,
                                  allowHalfRating: true,
                                  itemCount: 5,
                                  itemSize: 10,
                                  ratingWidget: RatingWidget(
                                    full: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                    half: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                    empty: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                  ),
                                  itemPadding:
                                      const EdgeInsets.fromLTRB(1, 0, 1, 0),
                                  onRatingUpdate: (rating) {
                                    printLog("$rating");
                                  },
                                ),
                                const SizedBox(width: 5),
                                CustomWidget.roundrectborder(
                                    height: MediaQuery.of(context).size.height *
                                        0.02,
                                    width: MediaQuery.of(context).size.width *
                                        0.30),
                              ],
                            )
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              );
            },
          ),
        ),
      ],
    );
  }

  /* Portrait List */
  Widget portrait(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
      physics: BouncingScrollPhysics(),
      scrollDirection: Axis.horizontal,
      child: Row(
          children: List.generate(
        sectionList?[sectionindex].data?.length ?? 0,
        (index) {
          return InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            highlightColor: transparent,
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    transitionDuration: const Duration(milliseconds: 200),
                    pageBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation) {
                      return Detail(
                          courseId: sectionList?[sectionindex]
                                  .data?[index]
                                  .id
                                  .toString() ??
                              "");
                    },
                    transitionsBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation,
                        Widget child) {
                      return Align(
                        child: FadeTransition(
                          opacity: animation,
                          child: child,
                        ),
                      );
                    },
                  ),
                );
              });
            },
            child: Container(
              width: 240,
              margin: const EdgeInsets.fromLTRB(4, 10, 10, 10),
              decoration: BoxDecoration(
                  color: Theme.of(context).cardColor,
                  borderRadius: BorderRadius.circular(16),
                  boxShadow: [
                    BoxShadow(
                        color: transparent.withValues(alpha: 0.4),
                        blurRadius: 4,
                        blurStyle: BlurStyle.outer,
                        offset: Offset(0, 3))
                  ]),
              child: Column(
                children: [
                  Stack(
                    children: [
                      ClipRRect(
                        borderRadius: BorderRadius.only(
                            topLeft: Radius.circular(16),
                            topRight: Radius.circular(16)),
                        child: MyNetworkImage(
                            imgWidth: MediaQuery.of(context).size.width,
                            imgHeight: 140,
                            fit: BoxFit.fill,
                            islandscap: true,
                            imageUrl: sectionList?[sectionindex]
                                    .data?[index]
                                    .landscapeImg
                                    .toString() ??
                                ""),
                      ),
                      (sectionList?[sectionindex].isFree.toString() ?? "") ==
                              "1"
                          ? SizedBox.shrink()
                          : Positioned(
                              left: 10,
                              top: 10,
                              child: IntrinsicWidth(
                                // Wrap with IntrinsicWidth
                                child: Container(
                                  padding: EdgeInsets.symmetric(
                                      horizontal: 8, vertical: 4),
                                  decoration: BoxDecoration(
                                    color: colorAccent,
                                    borderRadius: BorderRadius.circular(4),
                                  ),
                                  child: Row(
                                    mainAxisSize: MainAxisSize
                                        .min, // Ensures the Row only takes necessary space
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    children: [
                                      Icon(
                                        Icons.workspace_premium_outlined,
                                        size: 14,
                                        color: white,
                                      ),
                                      SizedBox(
                                          width:
                                              5), // Spacing between icon and text
                                      Flexible(
                                        fit: FlexFit.loose,
                                        child: MyText(
                                          color: white,
                                          text: "premium",
                                          maxline: 1,
                                          multilanguage: true,
                                          fontsizeNormal: Dimens.textMedium,
                                          fontwaight: FontWeight.w500,
                                        ),
                                      ),
                                    ],
                                  ),
                                ),
                              ),
                            )
                    ],
                  ),
                  const SizedBox(height: 8),
                  Padding(
                    padding: EdgeInsets.fromLTRB(12, 0, 12, 10),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: sectionList?[sectionindex]
                                    .data?[index]
                                    .title
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textBigSmall,
                            fontwaight: FontWeight.w600,
                            maxline: 2,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        const SizedBox(height: 2),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            MyText(
                                color: gray,
                                text: Utils.kmbGenerator(
                                  int.parse(sectionList?[sectionindex]
                                          .data?[index]
                                          .totalView
                                          .toString() ??
                                      ""),
                                ),
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                            const SizedBox(width: 2),
                            MyText(
                                color: gray,
                                text: "students",
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1,
                                multilanguage: true,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                        const SizedBox(height: 2),
                        Row(
                          children: [
                            MyRating(
                              size: 15,
                              rating: double.parse((sectionList?[sectionindex]
                                      .data?[index]
                                      .avgRating
                                      .toString() ??
                                  "")),
                              spacing: 3,
                            ),
                            const SizedBox(width: 5),
                            MyText(
                                color: colorAccent,
                                text:
                                    "${double.parse(sectionList?[sectionindex].data?[index].avgRating.toString() ?? "")}",
                                fontsizeNormal: Dimens.textBigSmall,
                                fontwaight: FontWeight.w600,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                        MyText(
                            color: black,
                            text: (sectionList?[sectionindex]
                                            .data?[index]
                                            .isFree
                                            .toString() ??
                                        "") ==
                                    "0"
                                ? "${Constant.currencyCode} ${sectionList?[sectionindex].data?[index].price.toString() ?? ""}"
                                : Locales.string(context, "free"),
                            fontsizeNormal: Dimens.textSmall,
                            fontwaight: FontWeight.w500,
                            maxline: 1,
                            multilanguage: false,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          );
        },
      )),
    );
  }

  Widget portraitShimmer() {
    return Column(
      children: [
        SizedBox(
          width: MediaQuery.of(context).size.width,
          height: 80,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              CustomWidget.roundrectborder(
                  height: 15, width: MediaQuery.of(context).size.width * 0.30),
              const SizedBox(
                height: 10,
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Container(
                    width: 70,
                    height: 1,
                    color: gray,
                  ),
                  const SizedBox(
                    width: 10,
                  ),
                  CustomWidget.roundrectborder(
                      height: 15,
                      width: MediaQuery.of(context).size.width * 0.20),
                  const SizedBox(
                    width: 10,
                  ),
                  Container(
                    width: 70,
                    height: 1,
                    color: gray,
                  ),
                ],
              ),
            ],
          ),
        ),
        Container(
          width: MediaQuery.of(context).size.width,
          height: 250,
          alignment: Alignment.centerLeft,
          child: ListView.builder(
            scrollDirection: Axis.horizontal,
            shrinkWrap: true,
            itemCount: 3,
            itemBuilder: (BuildContext context, int index) {
              return Padding(
                padding: const EdgeInsets.fromLTRB(20, 0, 20, 0),
                child: Container(
                  width: 220,
                  height: 220,
                  margin: const EdgeInsets.fromLTRB(0, 0, 0, 5),
                  decoration: BoxDecoration(
                    color: white,
                    border: Border.all(width: 1, color: colorAccent),
                  ),
                  child: Column(
                    children: [
                      SizedBox(
                        width: MediaQuery.of(context).size.width,
                        height: 120,
                        child: Padding(
                          padding: const EdgeInsets.all(5),
                          child: CustomWidget.roundrectborder(
                              height: MediaQuery.of(context).size.height,
                              width: MediaQuery.of(context).size.width),
                        ),
                      ),
                      Container(
                        width: MediaQuery.of(context).size.width,
                        height: 120,
                        padding: const EdgeInsets.only(left: 5),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            CustomWidget.roundrectborder(
                                height:
                                    MediaQuery.of(context).size.height * 0.02,
                                width:
                                    MediaQuery.of(context).size.width * 0.20),
                            const SizedBox(height: 10),
                            CustomWidget.roundrectborder(
                                height:
                                    MediaQuery.of(context).size.height * 0.02,
                                width:
                                    MediaQuery.of(context).size.width * 0.25),
                            const SizedBox(height: 10),
                            Row(
                              children: [
                                RatingBar(
                                  initialRating: 5,
                                  direction: Axis.horizontal,
                                  allowHalfRating: true,
                                  itemCount: 5,
                                  itemSize: 10,
                                  ratingWidget: RatingWidget(
                                    full: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                    half: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                    empty: const CustomWidget.roundrectborder(
                                        height: 15, width: 15),
                                  ),
                                  itemPadding:
                                      const EdgeInsets.fromLTRB(1, 0, 1, 0),
                                  onRatingUpdate: (rating) {
                                    printLog("$rating");
                                  },
                                ),
                                const SizedBox(width: 5),
                                CustomWidget.roundrectborder(
                                    height: MediaQuery.of(context).size.height *
                                        0.02,
                                    width: MediaQuery.of(context).size.width *
                                        0.30),
                              ],
                            )
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              );
            },
          ),
        ),
      ],
    );
  }

  /* Listview  */
  Widget listView(int sectionindex, List<Result>? sectionList) {
    return ListView.builder(
      scrollDirection: Axis.vertical,
      shrinkWrap: true,
      physics: const NeverScrollableScrollPhysics(),
      itemCount: sectionList?[sectionindex].data?.length ?? 0,
      itemBuilder: (BuildContext context, int index) {
        return InkWell(
          splashColor: transparent,
          focusColor: transparent,
          hoverColor: transparent,
          highlightColor: transparent,
          onTap: () {
            AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
              Navigator.of(context).push(
                PageRouteBuilder(
                  transitionDuration: const Duration(milliseconds: 200),
                  pageBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation) {
                    return Detail(
                        courseId: sectionList?[sectionindex]
                                .data?[index]
                                .id
                                .toString() ??
                            "");
                  },
                  transitionsBuilder: (BuildContext context,
                      Animation<double> animation,
                      Animation<double> secondaryAnimation,
                      Widget child) {
                    return Align(
                      child: FadeTransition(
                        opacity: animation,
                        child: child,
                      ),
                    );
                  },
                ),
              );
            });
          },
          child: Container(
            width: MediaQuery.sizeOf(context).width,
            margin: EdgeInsets.only(bottom: 15),
            decoration: BoxDecoration(
                border: Border.all(
                    width: 1,
                    color: gray.withValues(alpha: .4),
                    style: BorderStyle.solid),
                boxShadow: [
                  BoxShadow(
                      blurRadius: 4,
                      blurStyle: BlurStyle.outer,
                      color: transparent.withValues(alpha: .3),
                      offset: Offset(0, 0),
                      spreadRadius: 0)
                ],
                color: white,
                borderRadius: BorderRadius.circular(5)),
            child: Row(
              children: [
                Container(
                  width: 115,
                  height: 100,
                  decoration: BoxDecoration(
                      image: DecorationImage(
                          image: NetworkImage(sectionList?[sectionindex]
                                  .data?[index]
                                  .landscapeImg
                                  .toString() ??
                              ""),
                          fit: BoxFit.fill),
                      border: Border(
                        right: BorderSide(
                            width: 1,
                            color: gray.withValues(alpha: .4),
                            style: BorderStyle.solid),
                      ),
                      boxShadow: [
                        BoxShadow(
                            blurRadius: 4,
                            blurStyle: BlurStyle.outer,
                            color: transparent.withValues(alpha: .2),
                            offset: Offset(0, 0),
                            spreadRadius: 0)
                      ],
                      borderRadius: const BorderRadius.only(
                          bottomLeft: Radius.circular(5),
                          topLeft: Radius.circular(5))),
                ),
                const SizedBox(width: 10),
                Expanded(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 4,
                    children: [
                      MyText(
                          color: Theme.of(context).colorScheme.surface,
                          text: sectionList?[sectionindex]
                                  .data?[index]
                                  .title
                                  .toString() ??
                              "",
                          fontsizeNormal: Dimens.textBigSmall,
                          fontwaight: FontWeight.w600,
                          maxline: 2,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          MyText(
                              color: gray,
                              text: Utils.kmbGenerator(int.parse(
                                  sectionList?[sectionindex]
                                          .data?[index]
                                          .totalView
                                          .toString() ??
                                      "")),
                              fontsizeNormal: Dimens.textSmall,
                              fontwaight: FontWeight.w500,
                              maxline: 1,
                              overflow: TextOverflow.ellipsis,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                          const SizedBox(width: 5),
                          MyText(
                              color: gray,
                              text: "students",
                              fontsizeNormal: Dimens.textSmall,
                              fontwaight: FontWeight.w500,
                              maxline: 1,
                              multilanguage: true,
                              overflow: TextOverflow.ellipsis,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                        ],
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          MyRating(
                            size: 13,
                            rating: double.parse(sectionList?[sectionindex]
                                    .data?[index]
                                    .avgRating
                                    .toString() ??
                                ""),
                            spacing: 2,
                          ),
                          const SizedBox(width: 5),
                          MyText(
                              color: colorAccent,
                              text:
                                  "${double.parse(sectionList?[sectionindex].data?[index].avgRating.toString() ?? "")}",
                              fontsizeNormal: Dimens.textBigSmall,
                              fontwaight: FontWeight.w600,
                              maxline: 2,
                              overflow: TextOverflow.ellipsis,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                        ],
                      ),
                      MyText(
                          color: black,
                          text: (sectionList?[sectionindex]
                                          .data?[index]
                                          .isFree
                                          .toString() ??
                                      "") ==
                                  "0"
                              ? "${Constant.currencyCode} ${sectionList?[sectionindex].data?[index].price.toString() ?? ""}"
                              : Locales.string(context, "free"),
                          fontsizeNormal: Dimens.textSmall,
                          fontwaight: FontWeight.w500,
                          maxline: 1,
                          multilanguage: false,
                          overflow: TextOverflow.ellipsis,
                          textalign: TextAlign.left,
                          fontstyle: FontStyle.normal),
                    ],
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }

  /* Top Tutor */
  Widget tutorlist(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
      scrollDirection: Axis.horizontal,
      physics: BouncingScrollPhysics(),
      child: Row(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: List.generate(
            sectionList?[sectionindex].data?.length ?? 0,
            (index) {
              return Container(
                width: 280,
                margin: const EdgeInsets.fromLTRB(5, 0, 5, 0),
                padding: const EdgeInsets.fromLTRB(20, 20, 20, 15),
                decoration: BoxDecoration(
                    color: Theme.of(context).secondaryHeaderColor,
                    borderRadius: BorderRadius.circular(6)),
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        MyNetworkImage(
                            imgWidth: 60,
                            imgHeight: 60,
                            radius: 200,
                            fit: BoxFit.cover,
                            imageUrl: sectionList?[sectionindex]
                                    .data?[index]
                                    .image
                                    .toString() ??
                                ""),
                        const SizedBox(width: 10),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              MyText(
                                  color: Theme.of(context).colorScheme.surface,
                                  text: sectionList?[sectionindex]
                                              .data?[index]
                                              .fullName ==
                                          ""
                                      ? "Guest User"
                                      : sectionList?[sectionindex]
                                              .data?[index]
                                              .fullName
                                              .toString() ??
                                          "",
                                  fontsizeNormal: Dimens.textDesc,
                                  fontwaight: FontWeight.w600,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  textalign: TextAlign.center,
                                  fontstyle: FontStyle.normal),
                              const SizedBox(height: 5),
                              MyText(
                                  color: gray,
                                  text: sectionList?[sectionindex]
                                          .data?[index]
                                          .email
                                          .toString() ??
                                      "",
                                  fontsizeNormal: Dimens.textBigSmall,
                                  fontwaight: FontWeight.w400,
                                  maxline: 1,
                                  overflow: TextOverflow.ellipsis,
                                  textalign: TextAlign.left,
                                  fontstyle: FontStyle.normal),
                            ],
                          ),
                        ),
                      ],
                    ),
                    const SizedBox(height: 8),
                    MyText(
                        color: colorPrimaryDark,
                        text:
                            "${Utils.kmbGenerator(sectionList?[sectionindex].data?[index].totalView ?? 0)} Students",
                        fontsizeNormal: Dimens.textSmall,
                        fontwaight: FontWeight.w500,
                        maxline: 2,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 8),
                    MyText(
                        color: gray,
                        text: sectionList?[sectionindex]
                                .data?[index]
                                .description
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textSmall,
                        fontwaight: FontWeight.w400,
                        maxline: 2,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 8),
                    Align(
                      alignment: Alignment.center,
                      child: InkWell(
                        splashColor: transparent,
                        focusColor: transparent,
                        hoverColor: transparent,
                        highlightColor: transparent,
                        onTap: () {
                          AdHelper.showFullscreenAd(
                              context, Constant.interstialAdType, () {
                            Navigator.of(context).push(
                              PageRouteBuilder(
                                pageBuilder:
                                    (context, animation, secondaryAnimation) =>
                                        TutorProfilePage(
                                  tutorid: sectionList?[sectionindex]
                                          .data?[index]
                                          .id
                                          .toString() ??
                                      "",
                                ),
                                transitionsBuilder: (context, animation,
                                    secondaryAnimation, child) {
                                  const begin = Offset(1.0, 0.0);
                                  const end = Offset.zero;
                                  const curve = Curves.ease;

                                  var tween = Tween(begin: begin, end: end)
                                      .chain(CurveTween(curve: curve));

                                  return SlideTransition(
                                    position: animation.drive(tween),
                                    child: child,
                                  );
                                },
                              ),
                            );
                          });
                        },
                        child: Container(
                          padding: const EdgeInsets.fromLTRB(18, 8, 18, 8),
                          decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(50),
                            border:
                                Border.all(width: 0.8, color: colorPrimaryDark),
                          ),
                          child: MyText(
                              color: colorPrimaryDark,
                              text: "View Profile",
                              fontsizeNormal: Dimens.textSmall,
                              fontwaight: FontWeight.w500,
                              maxline: 1,
                              overflow: TextOverflow.ellipsis,
                              textalign: TextAlign.left,
                              fontstyle: FontStyle.normal),
                        ),
                      ),
                    ),
                  ],
                ),
              );
            },
          )),
    );
  }

  /* Blog  */
  Widget blogList(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
      scrollDirection: Axis.horizontal,
      physics: BouncingScrollPhysics(),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: List.generate(sectionList?[sectionindex].data?.length ?? 0,
            (index) {
          return InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            highlightColor: transparent,
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    transitionDuration: const Duration(milliseconds: 200),
                    pageBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation) {
                      return BlogDetail(
                          blogId: sectionList?[sectionindex]
                                  .data?[index]
                                  .id
                                  .toString() ??
                              "");
                    },
                    transitionsBuilder: (BuildContext context,
                        Animation<double> animation,
                        Animation<double> secondaryAnimation,
                        Widget child) {
                      return Align(
                        child: FadeTransition(
                          opacity: animation,
                          child: child,
                        ),
                      );
                    },
                  ),
                );
              });
            },
            child: Container(
              margin: EdgeInsets.only(right: 10),
              width: 265,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyNetworkImage(
                      imgWidth: width,
                      radius: 10,
                      imgHeight: 145,
                      fit: BoxFit.fill,
                      islandscap: true,
                      imageUrl: sectionList?[sectionindex]
                              .data?[index]
                              .image
                              .toString() ??
                          ""),
                  const SizedBox(height: 8),
                  MyText(
                      color: Theme.of(context).colorScheme.surface,
                      text: sectionList?[sectionindex]
                              .data?[index]
                              .title
                              .toString() ??
                          "",
                      fontsizeNormal: Dimens.textBigSmall,
                      fontwaight: FontWeight.w600,
                      maxline: 3,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                  const SizedBox(height: 5),
                  MyText(
                      color: gray,
                      text: Utils.timeAgoCustom(DateTime.parse(
                          sectionList?[sectionindex]
                                  .data?[index]
                                  .createdAt
                                  .toString() ??
                              "")),
                      fontsizeNormal: Dimens.textSmall,
                      fontwaight: FontWeight.w600,
                      maxline: 3,
                      overflow: TextOverflow.ellipsis,
                      textalign: TextAlign.left,
                      fontstyle: FontStyle.normal),
                ],
              ),
            ),
          );
        }),
      ),
    );
  }

  /* Book  */
  Widget bookList(int sectionindex, List<Result>? sectionList) {
    return SingleChildScrollView(
      scrollDirection: Axis.horizontal,
      physics: BouncingScrollPhysics(),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: List.generate(
          sectionList?[sectionindex].data?.length ?? 0,
          (index) {
            return InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              highlightColor: transparent,
              onTap: () {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Navigator.of(context).push(
                    PageRouteBuilder(
                      pageBuilder: (context, animation, secondaryAnimation) =>
                          EbookDetails(
                        ebookId: sectionList?[sectionindex]
                                .data?[index]
                                .id
                                .toString() ??
                            "",
                        ebookName: sectionList?[sectionindex]
                                .data?[index]
                                .name
                                .toString() ??
                            "",
                      ),
                      transitionsBuilder:
                          (context, animation, secondaryAnimation, child) {
                        const begin = Offset(1.0, 0.0);
                        const end = Offset.zero;
                        const curve = Curves.ease;

                        var tween = Tween(begin: begin, end: end)
                            .chain(CurveTween(curve: curve));

                        return SlideTransition(
                          position: animation.drive(tween),
                          child: child,
                        );
                      },
                    ),
                  );
                });
              },
              child: Container(
                margin: EdgeInsets.fromLTRB(0, 0, 10, 0),
                width: 140,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.start,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    MyNetworkImage(
                        imgWidth: width,
                        imgHeight: 155,
                        radius: 20,
                        imageUrl: sectionList?[sectionindex]
                                .data?[index]
                                .thumbnailImg
                                .toString() ??
                            "",
                        fit: BoxFit.cover),
                    const SizedBox(height: 8),
                    MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: sectionList?[sectionindex]
                                .data?[index]
                                .title
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textSmall,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontwaight: FontWeight.w600,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 4),
                    MyText(
                        color: gray,
                        text: sectionList?[sectionindex]
                                .data?[index]
                                .tutorName
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textSmall,
                        fontsizeWeb: Dimens.textSmall,
                        maxline: 2,
                        overflow: TextOverflow.ellipsis,
                        fontwaight: FontWeight.w600,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                    const SizedBox(height: 4),
                    Row(
                      children: [
                        MyRating(
                          size: 13,
                          rating: double.parse((sectionList?[sectionindex]
                                  .data?[index]
                                  .avgRating
                                  .toString() ??
                              "")),
                          spacing: 3,
                        ),
                        const SizedBox(width: 5),
                        MyText(
                            color: colorAccent,
                            text:
                                "${double.parse(sectionList?[sectionindex].data?[index].avgRating.toString() ?? "")}",
                            fontsizeNormal: Dimens.textBigSmall,
                            fontwaight: FontWeight.w600,
                            maxline: 1,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                      ],
                    ),
                    MyText(
                        color: black,
                        text: (sectionList?[sectionindex]
                                        .data?[index]
                                        .isFree
                                        .toString() ??
                                    "") ==
                                "0"
                            ? "${Constant.currencyCode} ${sectionList?[sectionindex].data?[index].price.toString() ?? ""}"
                            : Locales.string(context, "free"),
                        fontsizeNormal: Dimens.textBigSmall,
                        fontwaight: FontWeight.w600,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ],
                ),
              ),
            );
          },
        ),
      ),
    );
  }

  /* Comman Shimmer */
  Widget commanShimmer() {
    return SingleChildScrollView(
      physics: NeverScrollableScrollPhysics(),
      child: Column(
        children: [
          SizedBox(
            width: width,
            height: 180,
            child: CarouselSlider.builder(
              itemCount: 10,
              options: CarouselOptions(
                initialPage: 0,
                height: height,
                enlargeCenterPage: true,
                enlargeStrategy: CenterPageEnlargeStrategy.zoom,
                autoPlay: true,
                autoPlayCurve: Curves.linear,
                enableInfiniteScroll: true,
                autoPlayInterval: const Duration(seconds: 5),
                autoPlayAnimationDuration: const Duration(seconds: 1),
                viewportFraction: 1,
              ),
              itemBuilder:
                  (BuildContext context, int index, int pageViewIndex) {
                return Stack(
                  children: [
                    CustomWidget.roundrectborder(
                        width: MediaQuery.sizeOf(context).width, height: 180),
                    Positioned(
                        bottom: 10,
                        right: 10,
                        left: 10,
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            CustomWidget.roundrectborder(
                              width: MediaQuery.sizeOf(context).width,
                              height: 12,
                            ),
                            CustomWidget.roundrectborder(
                              width: MediaQuery.sizeOf(context).width,
                              height: 10,
                            ),
                          ],
                        )),
                  ],
                );
              },
            ),
          ),
          const Padding(
            padding: EdgeInsets.fromLTRB(20, 25, 20, 0),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    CustomWidget.roundrectborder(height: 10, width: 150),
                    SizedBox(height: 5),
                    CustomWidget.roundrectborder(height: 10, width: 80),
                  ],
                ),
                CustomWidget.roundrectborder(height: 10, width: 50),
              ],
            ),
          ),
          const SizedBox(height: 15),
          Container(
            color: gray.withValues(alpha: 0.20),
            width: width,
            alignment: Alignment.centerLeft,
            height: 240,
            padding: const EdgeInsets.only(top: 8, bottom: 8),
            child: ListView.builder(
              scrollDirection: Axis.horizontal,
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              padding: const EdgeInsets.fromLTRB(10, 0, 10, 0),
              itemCount: 5,
              itemBuilder: (BuildContext context, int index) {
                return Container(
                  width: 200,
                  height: MediaQuery.sizeOf(context).height,
                  margin: const EdgeInsets.fromLTRB(5, 0, 5, 5),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(15),
                  ),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      CustomWidget.rectangular(
                        width: width ?? 0.0,
                        height: 120,
                      ),
                      Expanded(
                        child: Padding(
                          padding: const EdgeInsets.fromLTRB(0, 8, 0, 5),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              CustomWidget.roundrectborder(
                                width: width ?? 0.0,
                                height: 5,
                              ),
                              const SizedBox(height: 8),
                              const CustomWidget.roundrectborder(
                                width: 100,
                                height: 5,
                              ),
                              const SizedBox(height: 8),
                              CustomWidget.roundrectborder(
                                width: width ?? 0.0,
                                height: 5,
                              ),
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                );
              },
            ),
          ),
          const SizedBox(height: 15),
          const Padding(
            padding: EdgeInsets.fromLTRB(20, 25, 20, 0),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    CustomWidget.roundrectborder(height: 10, width: 150),
                    SizedBox(height: 5),
                    CustomWidget.roundrectborder(height: 10, width: 80),
                  ],
                ),
                CustomWidget.roundrectborder(height: 10, width: 50),
              ],
            ),
          ),
          const SizedBox(height: 15),
          Container(
            color: gray.withValues(alpha: 0.20),
            width: width,
            alignment: Alignment.centerLeft,
            height: 240,
            padding: const EdgeInsets.only(top: 8, bottom: 8),
            child: ListView.builder(
              scrollDirection: Axis.horizontal,
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              padding: const EdgeInsets.fromLTRB(10, 0, 10, 0),
              itemCount: 5,
              itemBuilder: (BuildContext context, int index) {
                return Container(
                  width: 200,
                  height: MediaQuery.sizeOf(context).height,
                  margin: const EdgeInsets.fromLTRB(5, 0, 5, 5),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(15),
                  ),
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      CustomWidget.rectangular(
                        width: width ?? 0.0,
                        height: 120,
                      ),
                      Expanded(
                        child: Padding(
                          padding: const EdgeInsets.fromLTRB(0, 8, 0, 5),
                          child: Column(
                            mainAxisAlignment: MainAxisAlignment.start,
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              CustomWidget.roundrectborder(
                                width: width ?? 0.0,
                                height: 5,
                              ),
                              const SizedBox(height: 8),
                              const CustomWidget.roundrectborder(
                                width: 100,
                                height: 5,
                              ),
                              const SizedBox(height: 8),
                              CustomWidget.roundrectborder(
                                width: width ?? 0.0,
                                height: 5,
                              ),
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                );
              },
            ),
          ),
          const SizedBox(height: 15),
          const Padding(
            padding: EdgeInsets.fromLTRB(20, 25, 20, 0),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    CustomWidget.roundrectborder(height: 10, width: 150),
                    SizedBox(height: 5),
                    CustomWidget.roundrectborder(height: 10, width: 80),
                  ],
                ),
                CustomWidget.roundrectborder(height: 10, width: 50),
              ],
            ),
          ),
          const SizedBox(height: 15),
          ListView.builder(
            scrollDirection: Axis.vertical,
            shrinkWrap: true,
            physics: const BouncingScrollPhysics(),
            padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
            itemCount: 5,
            itemBuilder: (BuildContext context, int index) {
              return Padding(
                padding: const EdgeInsets.only(bottom: 15),
                child: Stack(
                  alignment: Alignment.centerRight,
                  children: [
                    Container(
                      width: width,
                      decoration: BoxDecoration(
                        color: Theme.of(context).cardColor,
                        borderRadius: BorderRadius.circular(5),
                        boxShadow: [
                          BoxShadow(
                            color: gray.withValues(alpha: 0.50),
                            blurRadius: 2,
                            offset: const Offset(0.1, 0.1),
                          ),
                        ],
                      ),
                      child: Row(
                        children: [
                          const ClipRRect(
                            borderRadius: BorderRadius.only(
                                bottomLeft: Radius.circular(5),
                                topLeft: Radius.circular(5)),
                            child: CustomWidget.rectangular(
                              width: 110,
                              height: 100,
                            ),
                          ),
                          const SizedBox(width: 10),
                          Expanded(
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                CustomWidget.roundrectborder(
                                  width: width ?? 0.0,
                                  height: 5,
                                ),
                                const SizedBox(height: 8),
                                const CustomWidget.roundrectborder(
                                  width: 100,
                                  height: 5,
                                ),
                                const SizedBox(height: 8),
                                CustomWidget.roundrectborder(
                                  width: width ?? 0.0,
                                  height: 5,
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              );
            },
          ),
        ],
      ),
    );
  }
}
