import 'package:prakah/pages/search.dart';
import 'package:prakah/pages/videobyidviewall.dart';
import 'package:prakah/provider/exploreprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:provider/provider.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';

class Expore extends StatefulWidget {
  const Expore({super.key});

  @override
  State<Expore> createState() => ExporeState();
}

class ExporeState extends State<Expore> {
  ExploreProvider exploreProvider = ExploreProvider();
  TextEditingController searchControler = TextEditingController();
  final ScrollController categoryController = ScrollController();
  final ScrollController categoryVerticalController = ScrollController();

  @override
  void initState() {
    super.initState();
    exploreProvider = Provider.of<ExploreProvider>(context, listen: false);
    categoryController.addListener(_scrollListenerCategoryHorizontal);
    categoryVerticalController.addListener(_scrollListenerCategoryVertical);
    _fetchCategory(0);
  }

  void _scrollListenerCategoryHorizontal() {
    if (!categoryController.hasClients) return;
    if (categoryController.offset >=
            categoryController.position.maxScrollExtent &&
        !categoryController.position.outOfRange &&
        (exploreProvider.currentPage ?? 0) < (exploreProvider.totalPage ?? 0)) {
      exploreProvider.setLoadMore(true);
      _fetchCategory(exploreProvider.currentPage ?? 0);
    }
  }

  void _scrollListenerCategoryVertical() {
    if (!categoryVerticalController.hasClients) return;
    if (categoryVerticalController.offset >=
            categoryVerticalController.position.maxScrollExtent &&
        !categoryVerticalController.position.outOfRange &&
        (exploreProvider.currentPage ?? 0) < (exploreProvider.totalPage ?? 0)) {
      exploreProvider.setLoadMore(true);
      _fetchCategory(exploreProvider.currentPage ?? 0);
    }
  }

  Future<void> _fetchCategory(int? nextPage) async {
    await exploreProvider.getCategory((nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    categoryController.dispose();
    categoryController.removeListener(_scrollListenerCategoryHorizontal);
    categoryVerticalController.dispose();
    categoryVerticalController.removeListener(_scrollListenerCategoryVertical);
    exploreProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<ExploreProvider>(
        builder: (context, exploreProvider, child) {
      return SingleChildScrollView(
        controller: categoryVerticalController,
        physics: const BouncingScrollPhysics(),
        padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
        scrollDirection: Axis.vertical,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 14,
          children: [
            buildCategory(),
            allCategory(),
          ],
        ),
      );
    });
  }

  /* Search bar  */

  Widget searchbar() {
    return TextFormField(
      obscureText: false,
      keyboardType: TextInputType.text,
      controller: searchControler,
      onChanged: (value) async {},
      textInputAction: TextInputAction.done,
      cursorColor: black,
      readOnly: true,
      style: GoogleFonts.inter(
          fontSize: Dimens.textMedium,
          fontStyle: FontStyle.normal,
          color: black,
          fontWeight: FontWeight.w500),
      decoration: InputDecoration(
        prefixIcon: const Icon(
          Icons.search,
          size: 25,
          color: gray,
        ),
        filled: true,
        fillColor: gray.withValues(alpha: 0.15),
        contentPadding: const EdgeInsets.all(16),
        focusedBorder: const OutlineInputBorder(
          borderRadius: BorderRadius.all(Radius.circular(40)),
          borderSide: BorderSide(
            width: 1,
            color: white,
          ),
        ),
        disabledBorder: const OutlineInputBorder(
          borderRadius: BorderRadius.all(Radius.circular(40)),
          borderSide: BorderSide(
            width: 1,
            color: white,
          ),
        ),
        enabledBorder: const OutlineInputBorder(
          borderRadius: BorderRadius.all(Radius.circular(40)),
          borderSide: BorderSide(
            width: 1,
            color: white,
          ),
        ),
        border: const OutlineInputBorder(
          borderRadius: BorderRadius.all(Radius.circular(40)),
          borderSide: BorderSide(
            width: 1,
            color: white,
          ),
        ),
        hintText: "Search Course",
        hintStyle: GoogleFonts.inter(
            fontSize: Dimens.textMedium,
            fontStyle: FontStyle.normal,
            color: gray,
            fontWeight: FontWeight.w500),
      ),
      onTap: () {
        AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
          Navigator.of(context).push(
            PageRouteBuilder(
              pageBuilder: (context, animation, secondaryAnimation) =>
                  const Search(),
              transitionsBuilder:
                  (context, animation, secondaryAnimation, child) {
                const begin = Offset(1.0, 0.0);
                const end = Offset.zero;
                const curve = Curves.ease;

                var tween = Tween(begin: begin, end: end)
                    .chain(CurveTween(curve: curve));

                return SlideTransition(
                  position: animation.drive(tween),
                  child: child,
                );
              },
            ),
          );
        });
      },
    );
  }

  /* Category Horizontal */

  Widget buildCategory() {
    if (exploreProvider.loading && !exploreProvider.loadMore) {
      return buildCategoryItemShimmer();
    } else {
      if (exploreProvider.categoryList != null &&
          ((exploreProvider.categoryList?.length ?? 0) > 0)) {
        return SingleChildScrollView(
          scrollDirection: Axis.horizontal,
          physics: const BouncingScrollPhysics(),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              buildCategoryItem(),
              if (exploreProvider.loadMore)
                Utils.pageLoader()
              else
                const SizedBox.shrink(),
            ],
          ),
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget buildCategoryItem() {
    return Container(
      height: 180,
      alignment: Alignment.centerLeft,
      child: SingleChildScrollView(
        scrollDirection: Axis.horizontal,
        child: IntrinsicWidth(
          child: Wrap(
              spacing: 10,
              runSpacing: 10,
              direction: Axis.vertical,
              crossAxisAlignment: WrapCrossAlignment.start,
              children: [
                ...List.generate(
                  exploreProvider.categoryList?.length ?? 0,
                  (index) => InkWell(
                    onTap: () {
                      AdHelper.showFullscreenAd(
                          context, Constant.interstialAdType, () {
                        Utils.navigatePage(
                            context,
                            VideoByIdViewAll(
                              title: exploreProvider.categoryList?[index].name
                                      .toString() ??
                                  "",
                              contentId: exploreProvider.categoryList?[index].id
                                      .toString() ??
                                  "",
                              apiType: "category",
                            ),
                            "2");
                      });
                    },
                    child: IntrinsicWidth(
                      child: Container(
                        padding: const EdgeInsets.fromLTRB(15, 10, 15, 10),
                        width: 200,
                        decoration: BoxDecoration(
                            borderRadius: BorderRadius.circular(20),
                            border: Border.all(width: 1, color: gray)),
                        child: MyText(
                            color: gray,
                            text: exploreProvider.categoryList?[index].name
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textMedium,
                            overflow: TextOverflow.ellipsis,
                            maxline: 2,
                            fontwaight: FontWeight.w500,
                            textalign: TextAlign.center,
                            fontstyle: FontStyle.normal),
                      ),
                    ),
                  ),
                ),
              ]),
        ),
      ),
    );
  }

  Widget buildCategoryItemShimmer() {
    return Container(
      height: 200,
      alignment: Alignment.centerLeft,
      padding: const EdgeInsets.fromLTRB(15, 0, 15, 0),
      child: SingleChildScrollView(
        scrollDirection: Axis.horizontal,
        child: Wrap(spacing: -1, direction: Axis.vertical, children: [
          ...List.generate(
            12,
            (index) => const CustomWidget.circleborder(
              width: 130,
              height: 40,
            ),
          ),
        ]),
      ),
    );
  }

  /* Category Vertical */

  Widget allCategory() {
    if (exploreProvider.loading && !exploreProvider.loadMore) {
      return allCategoryItemShimmer();
    } else {
      if (exploreProvider.categoryList != null &&
          (exploreProvider.categoryList?.length ?? 0) > 0) {
        return Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            MyText(
                color: black,
                text: "allcategories",
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w600,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.start,
                fontstyle: FontStyle.normal,
                multilanguage: true),
            const SizedBox(height: 20),
            allCategoryItem(),
            if (exploreProvider.loadMore)
              CircularProgressIndicator(
                color: colorPrimary,
                strokeWidth: 1,
              )
            else
              const SizedBox.shrink(),
          ],
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget allCategoryItem() {
    return ResponsiveGridList(
      minItemWidth: 120,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      horizontalGridSpacing: 10,
      verticalGridSpacing: 15,
      listViewBuilderOptions: ListViewBuilderOptions(
        scrollDirection: Axis.vertical,
        shrinkWrap: true,
        physics: const BouncingScrollPhysics(),
      ),
      children:
          List.generate(exploreProvider.categoryList?.length ?? 0, (index) {
        return InkWell(
          onTap: () {
            AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
              Utils.navigatePage(
                  context,
                  VideoByIdViewAll(
                    title:
                        exploreProvider.categoryList?[index].name.toString() ??
                            "",
                    contentId:
                        exploreProvider.categoryList?[index].id.toString() ??
                            "",
                    apiType: "category",
                  ),
                  "2");
            });
          },
          child: Column(
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                children: [
                  MyNetworkImage(
                      imgWidth: 60,
                      radius: 30,
                      imgHeight: 60,
                      fit: BoxFit.fill,
                      imageUrl: exploreProvider.categoryList?[index].image
                              .toString() ??
                          ""),
                  const SizedBox(width: 10),
                  Expanded(
                    child: MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: exploreProvider.categoryList?[index].name
                                .toString() ??
                            "",
                        fontsizeNormal: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                        maxline: 2,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  ),
                  const SizedBox(width: 10),
                  Icon(
                    Icons.arrow_forward_ios_outlined,
                    size: 20,
                    color: gray,
                  ),
                ],
              ),
              const SizedBox(height: 15),
              exploreProvider.categoryList?.length == index + 1
                  ? const SizedBox.shrink()
                  : Container(
                      width: MediaQuery.of(context).size.width,
                      height: 0.8,
                      color: gray.withValues(alpha: 0.20),
                    ),
            ],
          ),
        );
      }),
    );
  }

  Widget allCategoryItemShimmer() {
    return Padding(
      padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const CustomWidget.roundrectborder(
            width: 120,
            height: 10,
          ),
          const SizedBox(height: 20),
          ResponsiveGridList(
            minItemWidth: 120,
            minItemsPerRow: 1,
            maxItemsPerRow: 1,
            horizontalGridSpacing: 10,
            verticalGridSpacing: 15,
            listViewBuilderOptions: ListViewBuilderOptions(
              scrollDirection: Axis.vertical,
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
            ),
            children: List.generate(5, (index) {
              return Column(
                children: [
                  const Row(
                    crossAxisAlignment: CrossAxisAlignment.center,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      CustomWidget.circular(
                        width: 60,
                        height: 60,
                      ),
                      SizedBox(width: 10),
                      Expanded(
                        child: CustomWidget.roundrectborder(
                          width: 120,
                          height: 5,
                        ),
                      ),
                      SizedBox(width: 10),
                      CustomWidget.circular(
                        width: 15,
                        height: 15,
                      ),
                    ],
                  ),
                  const SizedBox(height: 15),
                  exploreProvider.categoryList?.length == index + 1
                      ? const SizedBox.shrink()
                      : Container(
                          width: MediaQuery.of(context).size.width,
                          height: 0.8,
                          color: gray.withValues(alpha: 0.20),
                        ),
                ],
              );
            }),
          ),
        ],
      ),
    );
  }
}
