import 'package:prakah/pages/addbecometutor.dart';
import 'package:prakah/pages/certificate.dart';
import 'package:prakah/pages/editprofile.dart';
import 'package:prakah/pages/meeting.dart';
import 'package:prakah/pages/mycart.dart';
import 'package:prakah/pages/mydownloads.dart';
import 'package:prakah/pages/mypurchasesbook.dart';
import 'package:prakah/pages/mywallet.dart';
import 'package:prakah/pages/transcationlist.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/subscription/subscription.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:prakah/pages/getpages.dart';
import 'package:prakah/pages/login.dart';
import 'package:prakah/pages/wishlist.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:firebase_auth/firebase_auth.dart';
import 'package:flutter/material.dart';
import 'package:flutter_staggered_grid_view/flutter_staggered_grid_view.dart';
import 'package:google_sign_in/google_sign_in.dart';
import 'package:provider/provider.dart';

class Account extends StatefulWidget {
  const Account({super.key});

  @override
  State<Account> createState() => AccountState();
}

class AccountState extends State<Account> {
  SharedPre sharedpre = SharedPre();
  final FirebaseAuth _auth = FirebaseAuth.instance;
  ProfileProvider profileProvider = ProfileProvider();

  @override
  void initState() {
    super.initState();
    profileProvider = Provider.of<ProfileProvider>(context, listen: false);
    getApi();
  }

  Future<void> getApi() async {
    await Future.wait([
      profileProvider.getprofile(context),
      profileProvider.getPages(),
      profileProvider.getSocialLink(),
    ]);
  }

  @override
  void dispose() {
    profileProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<ProfileProvider>(
        builder: (context, profileprovider, child) {
      return SafeArea(
        child: SingleChildScrollView(
          scrollDirection: Axis.vertical,
          physics: const BouncingScrollPhysics(),
          padding:
              const EdgeInsets.only(top: 20, left: 15, right: 15, bottom: 20),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 20,
            children: [
              Align(
                  alignment: Alignment.center,
                  child: userInfoWithSubscription()),
              buildTitle(),
              buildSettings(),
            ],
          ),
        ),
      );
    });
  }

  Widget userInfoWithSubscription() {
    if (Constant.userID != null) {
      if (profileProvider.loading) {
        return Row(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            spacing: 10,
            children: [
              Container(
                padding: const EdgeInsets.all(1),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(50),
                  border: Border.all(width: 1, color: colorPrimary),
                ),
                child: CustomWidget.circular(
                  width: 70,
                  height: 70,
                ),
              ),
              Expanded(
                  child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                    CustomWidget.roundrectborder(width: 150, height: 8),
                    CustomWidget.roundrectborder(width: 150, height: 8)
                  ])),
              CustomWidget.circular(width: 25, height: 25)
            ]);
      } else if (profileProvider.profileModel.status == 200 &&
          (profileProvider.profileModel.result?.length ?? 0) > 0) {
        return Row(
            mainAxisAlignment: MainAxisAlignment.start,
            crossAxisAlignment: CrossAxisAlignment.center,
            spacing: 20,
            children: [
              Container(
                  decoration: BoxDecoration(
                      shape: BoxShape.circle,
                      border: Border.all(
                          width: 2,
                          color: colorPrimaryDark,
                          style: BorderStyle.solid)),
                  child: MyNetworkImage(
                      imgWidth: 60,
                      imgHeight: 60,
                      radius: 200,
                      fit: BoxFit.cover,
                      imageUrl: profileProvider.profileModel.result?[0].image
                              .toString() ??
                          "")),
              Expanded(
                  child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                    MyText(
                        color: Theme.of(context).colorScheme.surface,
                        text: profileProvider.profileModel.result?[0].fullName
                                    .toString() ==
                                ""
                            ? "New User"
                            : profileProvider.profileModel.result?[0].fullName
                                    .toString() ??
                                "",
                        maxline: 2,
                        fontwaight: FontWeight.w700,
                        fontsizeNormal: Dimens.textlargeBig,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal,
                        multilanguage: false),
                    MyText(
                        color: black,
                        text: profileProvider.profileModel.result?[0].email
                                .toString() ??
                            "",
                        maxline: 2,
                        fontwaight: FontWeight.w400,
                        fontsizeNormal: Dimens.textDesc,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal,
                        multilanguage: false)
                  ])),
              InkWell(
                  splashColor: transparent,
                  hoverColor: transparent,
                  focusColor: transparent,
                  onTap: () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            EditProfile(editType: "1"),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  },
                  child: Icon(Icons.edit, size: 25, color: colorPrimaryDark))
            ]);
      } else {
        return Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Container(
              padding: const EdgeInsets.all(1),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(50),
                border: Border.all(width: 1, color: colorPrimary),
              ),
              child: MyImage(
                width: 100,
                height: 100,
                radius: 200,
                fit: BoxFit.fill,
                imagePath: "ic_tutor.png",
              ),
            ),
            const SizedBox(width: 15),
            MyText(
              color: Theme.of(context).colorScheme.surface,
              text: "Guest User",
              maxline: 2,
              fontwaight: FontWeight.w700,
              fontsizeNormal: Dimens.textlargeBig,
              overflow: TextOverflow.ellipsis,
              textalign: TextAlign.left,
              fontstyle: FontStyle.normal,
              multilanguage: false,
            ),
          ],
        );
      }
    } else {
      return Row(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Container(
            padding: const EdgeInsets.all(1),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(50),
              border: Border.all(width: 1, color: colorPrimary),
            ),
            child: MyImage(
              width: 100,
              height: 100,
              radius: 200,
              fit: BoxFit.fill,
              imagePath: "ic_tutor.png",
            ),
          ),
          const SizedBox(width: 15),
          MyText(
            color: Theme.of(context).colorScheme.surface,
            text: "Guest User",
            maxline: 2,
            fontwaight: FontWeight.w700,
            fontsizeNormal: Dimens.textlargeBig,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal,
            multilanguage: false,
          ),
        ],
      );
    }
  }

  Widget buildTitle() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      highlightColor: transparent,
      onTap: () {
        if (Utils.checkLoginUser(context)) {
          AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
            Navigator.of(context).push(
              PageRouteBuilder(
                pageBuilder: (context, animation, secondaryAnimation) =>
                    const Subscription(),
                transitionsBuilder:
                    (context, animation, secondaryAnimation, child) {
                  const begin = Offset(1.0, 0.0);
                  const end = Offset.zero;
                  const curve = Curves.ease;

                  var tween = Tween(begin: begin, end: end)
                      .chain(CurveTween(curve: curve));

                  return SlideTransition(
                    position: animation.drive(tween),
                    child: child,
                  );
                },
              ),
            );
          });
        }
      },
      child: Container(
        padding: EdgeInsets.fromLTRB(15, 20, 15, 20),
        decoration: BoxDecoration(
            color: white,
            borderRadius: BorderRadius.circular(14),
            boxShadow: [
              BoxShadow(
                  blurRadius: 2.4,
                  blurStyle: BlurStyle.solid,
                  offset: Offset(0, 0),
                  spreadRadius: 0,
                  color: transparent.withValues(alpha: 0.25))
            ]),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.center,
          spacing: 10,
          children: [
            MyImage(
              width: 50,
              height: 50,
              imagePath: "ic_premium.png",
              color: colorAccent,
            ),
            Expanded(
              child: MyText(
                color: black,
                text: "subscribedisc",
                maxline: 2,
                fontwaight: FontWeight.w600,
                fontsizeNormal: Dimens.textMedium,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal,
                multilanguage: true,
              ),
            ),
            Icon(
              Icons.arrow_forward_ios_outlined,
              size: 20,
              color: black,
            )
          ],
        ),
      ),
    );
  }

  /* Dynamic Widget */
  Widget _myTitle(
      {required IconData iconData,
      required String title,
      bool? multilanguage,
      required VoidCallback onTap}) {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: onTap,
      child: Row(children: [
        Container(
          padding: const EdgeInsets.all(10),
          decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: colorPrimaryDark,
              shape: BoxShape.rectangle),
          child: Icon(iconData, size: 20, color: white),
        ),
        const SizedBox(width: 20),
        Expanded(
          child: MyText(
            color: black,
            text: title,
            multilanguage: multilanguage ?? true,
            maxline: 1,
            overflow: TextOverflow.ellipsis,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w500,
          ),
        ),
        const Icon(Icons.arrow_forward_ios_outlined, size: 20, color: black),
      ]),
    );
  }

  Widget buildSettings() {
    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      mainAxisSize: MainAxisSize.min,
      children: [
        /* Certificate */
        Constant.userID == null
            ? SizedBox.shrink()
            : _myTitle(
                iconData: FontAwesomeIcons.certificate,
                title: "certificate",
                onTap: () {
                  AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                      () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            const Certificate(),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  });
                },
              ),
        Constant.userID == null ? SizedBox.shrink() : SizedBox(height: 20),
        /* Tutuor Meeting */
        Constant.userID == null
            ? SizedBox.shrink()
            : _myTitle(
                iconData: FontAwesomeIcons.video,
                title: "tutor_meetings",
                onTap: () {
                  AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                      () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            const Meeting(
                          selectedTab: "1",
                        ),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  });
                },
              ),
        Constant.userID == null ? SizedBox.shrink() : SizedBox(height: 20),
/* My Cart */
        Constant.userID == null
            ? SizedBox.shrink()
            : _myTitle(
                iconData: Icons.shopping_cart_outlined,
                title: "my_cart",
                onTap: () {
                  AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                      () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            const MyCart(),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  });
                },
              ),
        Constant.userID == null ? SizedBox.shrink() : SizedBox(height: 20),
        /* My Purchase Book */
        Constant.userID == null
            ? SizedBox.shrink()
            : _myTitle(
                iconData: Icons.book,
                title: "my_purchases",
                onTap: () {
                  AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                      () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            const MyPurchasesBook(),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  });
                },
              ),
        Constant.userID == null ? SizedBox.shrink() : SizedBox(height: 20),
        /* My Wallet */
        Constant.userID == null
            ? SizedBox.shrink()
            : _myTitle(
                iconData: Icons.wallet_outlined,
                title: "my_wallet",
                onTap: () {
                  AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                      () {
                    Navigator.of(context).push(
                      PageRouteBuilder(
                        pageBuilder: (context, animation, secondaryAnimation) =>
                            const MyWallet(),
                        transitionsBuilder:
                            (context, animation, secondaryAnimation, child) {
                          const begin = Offset(1.0, 0.0);
                          const end = Offset.zero;
                          const curve = Curves.ease;

                          var tween = Tween(begin: begin, end: end)
                              .chain(CurveTween(curve: curve));

                          return SlideTransition(
                            position: animation.drive(tween),
                            child: child,
                          );
                        },
                      ),
                    );
                  });
                },
              ),
        Constant.userID == null ? SizedBox.shrink() : SizedBox(height: 20),
        /* Become a tutor */
        Constant.userID == null
            ? SizedBox.shrink()
            : profileProvider.profileModel.status == 200
                ? (profileProvider.profileModel.result?[0].tutorStatus ?? "") ==
                        "approved"
                    ? SizedBox.shrink()
                    : _myTitle(
                        iconData: Icons.local_library,
                        title: "become_tutor",
                        onTap: () {
                          AdHelper.showFullscreenAd(
                              context, Constant.interstialAdType, () {
                            Utils.navigatePage(
                                context,
                                AddBecomeTutor(
                                  tutorStatus: profileProvider.profileModel
                                          .result?[0].tutorStatus ??
                                      "",
                                ),
                                "2");
                          });
                        },
                      )
                : SizedBox.shrink(),
        Constant.userID == null
            ? SizedBox.shrink()
            : profileProvider.profileModel.status == 200
                ? (profileProvider.profileModel.result?[0].tutorStatus ?? "") ==
                        "approved"
                    ? SizedBox.shrink()
                    : SizedBox(height: 20)
                : SizedBox.shrink(),
        _myTitle(
          iconData: FontAwesomeIcons.sackDollar,
          title: "subsciption",
          onTap: () {
            if (Utils.checkLoginUser(context)) {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        const Subscription(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              });
            }
          },
        ),
        SizedBox(height: 20),
        /* Transaction */
        _myTitle(
          iconData: FontAwesomeIcons.wallet,
          title: "my_transactions",
          onTap: () {
            if (Utils.checkLoginUser(context)) {
              Navigator.of(context).push(
                PageRouteBuilder(
                  pageBuilder: (context, animation, secondaryAnimation) =>
                      const TranscationList(),
                  transitionsBuilder:
                      (context, animation, secondaryAnimation, child) {
                    const begin = Offset(1.0, 0.0);
                    const end = Offset.zero;
                    const curve = Curves.ease;

                    var tween = Tween(begin: begin, end: end)
                        .chain(CurveTween(curve: curve));

                    return SlideTransition(
                      position: animation.drive(tween),
                      child: child,
                    );
                  },
                ),
              );
            }
          },
        ),
        SizedBox(height: 20),

        /* Wishlist */
        _myTitle(
          iconData: Icons.favorite_border,
          title: "wishlist",
          onTap: () {
            AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
              if (Constant.userID == null) {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        const Login(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              } else {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        const WishList(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              }
            });
          },
        ),
        SizedBox(height: 20),
        /* Download */
        _myTitle(
          iconData: FontAwesomeIcons.cloudArrowDown,
          title: "downloads",
          onTap: () {
            AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
              if (Constant.userID == null) {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        const Login(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              } else {
                Navigator.of(context).push(
                  PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        const MyDownloads(),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                        position: animation.drive(tween),
                        child: child,
                      );
                    },
                  ),
                );
              }
            });
          },
        ),
        SizedBox(height: 20),
        /* Get Pages */
        _buildPages(),
        SizedBox(height: 20),

        /* Change Language */
        _myTitle(
          iconData: Icons.translate_outlined,
          title: "language",
          onTap: () {
            Utils.languageChangeDialogMobile(context);
          },
        ),
        SizedBox(height: 20),
        /* Login Logout Delete Accounts */
        Constant.userID == null
            ? const SizedBox.shrink()
            : _myTitle(
                iconData: FontAwesomeIcons.trash,
                title: 'delete_accounts',
                onTap: () {
                  _logoutDeleteDialog(
                    title: "delete_accounts",
                    subtitle: "delete_account_msg",
                  );
                }),
        Constant.userID == null
            ? const SizedBox.shrink()
            : SizedBox(height: 20),
        InkWell(
          splashColor: transparent,
          focusColor: transparent,
          hoverColor: transparent,
          onTap: () {
            if (Constant.userID == null) {
              Navigator.push(
                  context,
                  MaterialPageRoute(
                    builder: (context) => const Login(),
                  ));
            } else {
              _logoutDeleteDialog(
                title: "logoutsure",
                subtitle: "areyousurewanttologout",
              );
            }
          },
          child: Container(
            height: 50,
            width: MediaQuery.sizeOf(context).width,
            alignment: Alignment.center,
            decoration: BoxDecoration(
                color: white,
                borderRadius: BorderRadius.circular(10),
                boxShadow: [
                  BoxShadow(
                      blurRadius: 7,
                      blurStyle: BlurStyle.outer,
                      color: transparent.withValues(alpha: 0.07),
                      offset: Offset(0, 2))
                ]),
            child: MyText(
                color: Theme.of(context).colorScheme.surface,
                text: Constant.userID == null ? "login" : 'logout',
                fontsizeNormal: Dimens.textTitle,
                maxline: 1,
                fontwaight: FontWeight.w600,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal,
                multilanguage: true),
          ),
        ),
        SizedBox(height: 20),
        /* Social */
        MyText(
            color: Theme.of(context).colorScheme.surface,
            text: "social",
            fontsizeNormal: Dimens.textTitle,
            maxline: 1,
            fontwaight: FontWeight.w600,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.center,
            fontstyle: FontStyle.normal,
            multilanguage: true),
        SizedBox(height: 20),
        _buildSocialLink(),
      ],
    );
  }

  Widget _buildPages() {
    if (profileProvider.pageLoding) {
      return const SizedBox.shrink();
    } else {
      if (profileProvider.getpagemodel.status == 200 &&
          profileProvider.getpagemodel.result != null) {
        return AlignedGridView.count(
          shrinkWrap: true,
          crossAxisCount: 1,
          crossAxisSpacing: 0,
          mainAxisSpacing: 20,
          padding: EdgeInsets.zero,
          itemCount: profileProvider.getpagemodel.result?.length ?? 0,
          physics: const NeverScrollableScrollPhysics(),
          itemBuilder: (BuildContext context, int position) {
            return InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Utils.navigatePage(
                      context,
                      AboutPrivacyTerms(
                        appBarTitle: profileProvider
                                .getpagemodel.result?[position].title ??
                            '',
                        loadURL: profileProvider
                                .getpagemodel.result?[position].url ??
                            '',
                      ),
                      "2");
                });
              },
              child: Row(
                  spacing: 20,
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      padding: const EdgeInsets.all(10),
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(8),
                          color: colorPrimaryDark,
                          shape: BoxShape.rectangle),
                      child: MyNetworkImage(
                          imgHeight: 20,
                          imgWidth: 20,
                          fit: BoxFit.cover,
                          color: white,
                          imageUrl: profileProvider
                                  .getpagemodel.result?[position].icon ??
                              ""),
                    ),
                    Expanded(
                      child: MyText(
                        color: black,
                        text: profileProvider
                                .getpagemodel.result?[position].title ??
                            "",
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontsizeNormal: Dimens.textTitle,
                        fontwaight: FontWeight.w500,
                      ),
                    ),
                    const Icon(Icons.arrow_forward_ios_outlined,
                        size: 20, color: black),
                  ]),
            );
          },
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget _buildSocialLink() {
    if (profileProvider.linkLoding) {
      return const SizedBox.shrink();
    } else {
      if (profileProvider.socialLinkModel.status == 200 &&
          profileProvider.socialLinkModel.result != null) {
        return AlignedGridView.count(
          shrinkWrap: true,
          crossAxisCount: 1,
          crossAxisSpacing: 0,
          mainAxisSpacing: 20,
          padding: EdgeInsets.zero,
          itemCount: (profileProvider.socialLinkModel.result?.length ?? 0),
          physics: const NeverScrollableScrollPhysics(),
          itemBuilder: (BuildContext context, int position) {
            return InkWell(
              splashColor: transparent,
              focusColor: transparent,
              hoverColor: transparent,
              onTap: () {
                AdHelper.showFullscreenAd(context, Constant.interstialAdType,
                    () {
                  Utils.lanchUrl(
                      profileProvider.socialLinkModel.result?[position].url ??
                          "");
                });
              },
              child: Row(
                  spacing: 20,
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      padding: const EdgeInsets.all(10),
                      decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(8),
                          color: colorPrimaryDark,
                          shape: BoxShape.rectangle),
                      child: MyNetworkImage(
                          imgHeight: 20,
                          imgWidth: 20,
                          fit: BoxFit.cover,
                          imageUrl: profileProvider
                                  .socialLinkModel.result?[position].image ??
                              ''),
                    ),
                    Expanded(
                      child: MyText(
                        color: black,
                        text: profileProvider
                                .socialLinkModel.result?[position].name ??
                            '',
                        multilanguage: false,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontsizeNormal: Dimens.textTitle,
                        fontwaight: FontWeight.w500,
                      ),
                    ),
                    const Icon(Icons.arrow_forward_ios_outlined,
                        size: 20, color: black),
                  ]),
            );
          },
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  void _logoutDeleteDialog({required String? title, required String subtitle}) {
    showDialog(
      context: context,
      builder: (context) {
        return AlertDialog(
          backgroundColor: white,
          title: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                height: 50,
                width: 50,
                padding: const EdgeInsets.all(8),
                decoration: BoxDecoration(
                    color: colorPrimaryDark.withValues(alpha: .2),
                    shape: BoxShape.circle),
                child: Container(
                  height: 25,
                  width: 25,
                  padding: const EdgeInsets.all(5),
                  decoration: BoxDecoration(
                      color: colorPrimaryDark.withValues(alpha: 0.3),
                      shape: BoxShape.circle),
                  child: const Icon(FontAwesomeIcons.trash,
                      size: 20, color: colorPrimaryDark),
                ),
              ),
              InkWell(
                  splashColor: transparent,
                  focusColor: transparent,
                  hoverColor: transparent,
                  onTap: () {
                    Navigator.of(context).pop();
                  },
                  child:
                      const Icon(FontAwesomeIcons.xmark, size: 20, color: gray))
            ],
          ),
          content: Wrap(
            crossAxisAlignment: WrapCrossAlignment.start,
            children: [
              MyText(
                color: black,
                text: title ?? "",
                multilanguage: true,
                textalign: TextAlign.start,
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w600,
                maxline: 1,
                overflow: TextOverflow.ellipsis,
                fontstyle: FontStyle.normal,
              ),
              const SizedBox(height: 3),
              MyText(
                color: black,
                text: subtitle,
                multilanguage: true,
                textalign: TextAlign.start,
                fontsizeNormal: Dimens.textMedium,
                fontwaight: FontWeight.w400,
                maxline: 2,
                overflow: TextOverflow.ellipsis,
                fontstyle: FontStyle.normal,
              )
            ],
          ),
          actions: [
            Column(
              children: [
                InkWell(
                  splashColor: transparent,
                  hoverColor: transparent,
                  focusColor: transparent,
                  onTap: () async {
                    final generalProvider =
                        Provider.of<GeneralProvider>(context, listen: false);
/* Clear Local Data */
                    await SharedPre().save('edit', "0");
                    await _auth.signOut();
                    await GoogleSignIn.instance.disconnect();
                    profileProvider.clearProvider();
                    generalProvider.clearProvider();
                    Utils.setUserId();
                    Constant.userID = null;
                    Constant.userImage = null;
                    Constant.isBuy = null;

                    if (!context.mounted) return;
                    /* Close Logout Popup */
                    Navigator.pop(context);
                    /* Open Login Page */
                    Utils.navigatePage(context, Login(), "2");

                    // Notify UI about the changes
                    profileProvider.providerNotifi();
                  },
                  child: Container(
                    constraints: const BoxConstraints(
                      minWidth: 75,
                    ),
                    height: 50,
                    padding: const EdgeInsets.only(left: 10, right: 10),
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      color: colorPrimaryDark,
                      border: Border.all(
                        color: colorPrimaryDark,
                        width: 1,
                      ),
                      borderRadius: BorderRadius.circular(8),
                      shape: BoxShape.rectangle,
                    ),
                    child: MyText(
                      color: white,
                      text: "confirm",
                      textalign: TextAlign.center,
                      fontsizeNormal: Dimens.textTitle,
                      multilanguage: true,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      fontstyle: FontStyle.normal,
                    ),
                  ),
                ),
                const SizedBox(height: 20),
                InkWell(
                  onTap: () {
                    if (Navigator.canPop(context)) {
                      Navigator.pop(context);
                    }
                  },
                  child: Container(
                    constraints: const BoxConstraints(
                      minWidth: 75,
                    ),
                    height: 50,
                    padding: const EdgeInsets.only(left: 10, right: 10),
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                      border: Border.all(
                        color: gray,
                        width: 1,
                      ),
                      borderRadius: BorderRadius.circular(8),
                    ),
                    child: MyText(
                      color: colorPrimaryDark,
                      text: "cancel",
                      multilanguage: true,
                      textalign: TextAlign.center,
                      fontsizeNormal: Dimens.textTitle,
                      maxline: 1,
                      overflow: TextOverflow.ellipsis,
                      fontwaight: FontWeight.w600,
                      fontstyle: FontStyle.normal,
                    ),
                  ),
                ),
              ],
            ),
          ],
        );
      },
    ).then((value) async {
      if (!mounted) return;
      Utils.loadAds(context);
      profileProvider.providerNoti();
    });
  }
}
