import 'package:prakah/pages/bottombar_pages/explore.dart';
import 'package:prakah/pages/bottombar_pages/liveclass.dart';
import 'package:prakah/pages/mycart.dart';
import 'package:prakah/pages/notificationpage.dart';
import 'package:prakah/pages/search.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:flutter/services.dart';
import 'package:provider/provider.dart';
import 'package:prakah/pages/bottombar_pages/account.dart';
import 'package:prakah/pages/bottombar_pages/home.dart';
import 'package:prakah/pages/bottombar_pages/mycourse.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:onesignal_flutter/onesignal_flutter.dart';

class Bottombar extends StatefulWidget {
  final int? selectInde;
  const Bottombar({super.key, this.selectInde});

  @override
  State<Bottombar> createState() => BottombarState();
}

class BottombarState extends State<Bottombar> {
  SharedPre sharedpre = SharedPre();
  GeneralProvider generalProvider = GeneralProvider();
  ProfileProvider profileProvider = ProfileProvider();
  String userid = "";
  String currencycode = "";
  DateTime? currentBackPressTime;
  List allTabList = [
    {"icons": Icons.home, "text": "home"},
    {"icons": Icons.dashboard, "text": "explore"},
    {"icons": Icons.school, "text": "mycourse"},
    {"icons": Icons.live_tv_rounded, "text": "live_class"},
    {"icons": Icons.person_outline, "text": "Profile"},
  ];

  @override
  void initState() {
    super.initState();
    generalProvider = Provider.of<GeneralProvider>(context, listen: false);
    profileProvider = Provider.of<ProfileProvider>(context, listen: false);

    AdHelper().initGoogleMobileAds();
    WidgetsBinding.instance.addPostFrameCallback((_) {
      getData();
    });
  }

  Future<void> getData() async {
    pushNotification();

    if (Constant.userID != null) {
      await profileProvider.getprofile(context);
    } else {
      Utils.updatePremium("0");
      Utils.loadAds(context);
    }
    profileProvider.providerNoti();
  }

  Future<void> pushNotification() async {
    String oneSignalAppId =
        await SharedPre().read(Constant.oneSignalAppIdKey) ?? "";
    /*  Push Notification Method OneSignal Start */
    if (!kIsWeb) {
      OneSignal.Debug.setLogLevel(OSLogLevel.verbose);
      // Initialize OneSignal
      printLog("OneSignal PushNotification===> $oneSignalAppId");
      OneSignal.initialize(oneSignalAppId);
      OneSignal.Notifications.requestPermission(false);
      OneSignal.Notifications.addPermissionObserver((state) {
        printLog("Has permission ==> $state");
      });
      OneSignal.User.pushSubscription.addObserver((state) {
        printLog(
            "pushSubscription state ==> ${state.current.jsonRepresentation()}");
      });
      OneSignal.Notifications.addForegroundWillDisplayListener((event) {
        /// preventDefault to not display the notification
        event.preventDefault();
        // Do async work
        /// notification.display() to display after preventing default
        event.notification.display();
      });
    }
/*  Push Notification Method OneSignal End */
  }

  List<Widget> _children() => [
        const Home(),
        const Expore(),
        const MyCourse(),
        const LiveClass(),
        const Account(),
      ];

  Future<void> onBackPressed(dynamic didPop) async {
    if (didPop) return;
    if (generalProvider.index == 0) {
      DateTime now = DateTime.now();
      if (currentBackPressTime == null ||
          now.difference(currentBackPressTime!) > const Duration(seconds: 2)) {
        currentBackPressTime = now;
        showExitDialog();
        return;
      }
    } else {
      generalProvider.onItemTapped(context, 0);
    }
  }

  @override
  Widget build(BuildContext context) {
    final List<Widget> children = _children();
    return PopScope(
        canPop: false,
        onPopInvokedWithResult: (didPop, result) {
          onBackPressed(didPop);
        },
        child: Consumer<GeneralProvider>(
            builder: (context, generalProvider, child) {
          return Scaffold(
              appBar: generalProvider.index == 3
                  ? null
                  : AppBar(
                      backgroundColor: colorPrimaryDark,
                      systemOverlayStyle: SystemUiOverlayStyle(
                        statusBarColor: transparent,
                        systemNavigationBarColor: transparent,
                      ),
                      automaticallyImplyLeading: false,
                      surfaceTintColor: transparent,
                      leading: Padding(
                        padding: const EdgeInsets.all(10.0),
                        child: MyImage(
                          width: 34,
                          height: 32,
                          imagePath: 'appiconweb.png',
                          isAppicon: true,
                          fit: BoxFit.contain,
                        ),
                      ),
                      title: MyText(
                        color: white,
                        text: "appname",
                        multilanguage: true,
                        fontsizeNormal: Dimens.textBig,
                        fontwaight: FontWeight.w700,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                      ),
                      actions: [
                        InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          onTap: () {
                            AdHelper.showFullscreenAd(
                                context, Constant.interstialAdType, () {
                              if (Utils.checkLoginUser(context)) {
                                Utils.navigatePage(
                                    context, const MyCart(), "2");
                              }
                            });
                          },
                          child: const Icon(
                            Icons.shopping_cart_outlined,
                            size: 25,
                            color: Colors.white,
                          ),
                        ),
                        const SizedBox(width: 15),
                        InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          onTap: () {
                            AdHelper.showFullscreenAd(
                                context, Constant.interstialAdType, () {
                              Utils.navigatePage(context, const Search(), "2");
                            });
                          },
                          child: Icon(
                            Icons.search,
                            size: 25,
                            color: Colors.white,
                          ),
                        ),
                        const SizedBox(width: 15),
                        InkWell(
                          splashColor: transparent,
                          focusColor: transparent,
                          hoverColor: transparent,
                          onTap: () {
                            AdHelper.showFullscreenAd(
                                context, Constant.interstialAdType, () {
                              if (Utils.checkLoginUser(context)) {
                                Utils.navigatePage(
                                    context, const NotificationPage(), "2");
                              }
                            });
                          },
                          child: const Icon(
                            Icons.notifications_outlined,
                            size: 25,
                            color: Colors.white,
                          ),
                        ),
                        const SizedBox(width: 15),
                      ],
                    ),
              body: Column(children: [
                Expanded(
                  child: children[generalProvider.index],
                ),
                /* AdMob Banner */
                Utils.showBannerAd(context),
              ]),
              bottomNavigationBar: BottomAppBar(
                  color: white,
                  child: Row(
                      spacing: 10,
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: List.generate(allTabList.length, (index) {
                        return buildBottom(
                            count: index,
                            icon: allTabList[index]["icons"],
                            title: allTabList[index]["text"],
                            onTap: () {
                              generalProvider.onItemTapped(context, index);
                            });
                      }))));
        }));
  }

  Widget buildBottom({VoidCallback? onTap, title, icon, count}) {
    return InkWell(
      onTap: onTap,
      child: AnimatedContainer(
        duration: Duration(milliseconds: 900),
        curve: Curves.bounceOut,
        height: 50,
        padding: EdgeInsets.fromLTRB(10, 4, 10, 4),
        decoration: BoxDecoration(
          color: generalProvider.index == count
              ? colorPrimary.withValues(alpha: 0.3)
              : transparent,
          borderRadius: BorderRadius.circular(16),
        ),
        child: Row(
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.spaceAround,
          mainAxisSize: MainAxisSize.min,
          spacing: 6,
          children: [
            Icon(icon, size: 20, color: colorPrimaryDark),
            generalProvider.index == count
                ? Flexible(
                    fit: FlexFit.loose,
                    child: MyText(
                        color: colorPrimaryDark,
                        text: title,
                        multilanguage: true,
                        fontsizeNormal: Dimens.textMedium,
                        fontwaight: FontWeight.w600,
                        maxline: 3,
                        overflow: TextOverflow.ellipsis,
                        textalign: TextAlign.left,
                        fontstyle: FontStyle.normal),
                  )
                : SizedBox.shrink()
          ],
        ),
      ),
    );
  }

  void showExitDialog() {
    showDialog(
      context: context,
      builder: (context) {
        return AlertDialog(
          backgroundColor: white,
          title: MyText(
            text: "are_sure_exit",
            maxline: 2,
            overflow: TextOverflow.ellipsis,
            multilanguage: true,
            fontsizeNormal: Dimens.textBig,
            color: colorPrimary,
            fontwaight: FontWeight.w400,
          ),
          actions: [
            Row(
              children: [
                Expanded(
                  child: InkWell(
                    splashColor: transparent,
                    hoverColor: transparent,
                    focusColor: transparent,
                    onTap: () async {
                      if (Navigator.canPop(context)) {
                        Navigator.pop(context);
                      }
                      SystemNavigator.pop();
                    },
                    child: Container(
                      constraints: const BoxConstraints(
                        minWidth: 75,
                      ),
                      height: 50,
                      padding: const EdgeInsets.only(left: 10, right: 10),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        color: colorPrimaryDark,
                        border: Border.all(
                          color: colorPrimaryDark,
                          width: 1,
                        ),
                        borderRadius: BorderRadius.circular(8),
                        shape: BoxShape.rectangle,
                      ),
                      child: MyText(
                        color: white,
                        text: "yes",
                        textalign: TextAlign.center,
                        fontsizeNormal: Dimens.textTitle,
                        multilanguage: true,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontwaight: FontWeight.w600,
                        fontstyle: FontStyle.normal,
                      ),
                    ),
                  ),
                ),
                const SizedBox(width: 20),
                Expanded(
                  child: InkWell(
                    onTap: () {
                      if (Navigator.canPop(context)) {
                        Navigator.pop(context);
                      }
                    },
                    child: Container(
                      constraints: const BoxConstraints(
                        minWidth: 75,
                      ),
                      height: 50,
                      padding: const EdgeInsets.only(left: 10, right: 10),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        border: Border.all(
                          color: colorPrimaryDark,
                          width: 1,
                        ),
                        color: white,
                        borderRadius: BorderRadius.circular(8),
                      ),
                      child: MyText(
                        color: colorPrimaryDark,
                        text: "no",
                        multilanguage: true,
                        textalign: TextAlign.center,
                        fontsizeNormal: Dimens.textTitle,
                        maxline: 1,
                        overflow: TextOverflow.ellipsis,
                        fontwaight: FontWeight.w600,
                        fontstyle: FontStyle.normal,
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ],
        );
      },
    );
  }
}
