import 'dart:io';

import 'package:prakah/pages/login.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/widget/myimage.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:provider/provider.dart';
import 'package:prakah/pages/nodata.dart';
import 'package:prakah/provider/blogdetailprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/widget/mynetworkimg.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:responsive_grid_list/responsive_grid_list.dart';
import '../utils/utils.dart';

class BlogDetail extends StatefulWidget {
  final String blogId;
  const BlogDetail({super.key, required this.blogId});

  @override
  State<BlogDetail> createState() => _BlogDetailState();
}

class _BlogDetailState extends State<BlogDetail> {
  BlogDetailProvider blogDetailProvider = BlogDetailProvider();

  @override
  void initState() {
    super.initState();
    blogDetailProvider =
        Provider.of<BlogDetailProvider>(context, listen: false);
    getApi();
  }

  Future<void> getApi() async {
    await Future.wait([
      blogDetailProvider.getBlogDetail(widget.blogId.toString()),
      getRelatedList(0),
    ]);
  }

  Future<void> getRelatedList(int? nextPage) async {
    await blogDetailProvider.getRelatedCourse(
        widget.blogId, (nextPage ?? 0) + 1);
  }

  @override
  void dispose() {
    blogDetailProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        elevation: 0,
        backgroundColor: colorPrimaryDark,
        systemOverlayStyle: SystemUiOverlayStyle(
            statusBarColor: transparent,
            systemNavigationBarColor: transparent,
            systemNavigationBarDividerColor: transparent),
        surfaceTintColor: transparent,
        automaticallyImplyLeading: false,
        title: MyText(
            color: white,
            text: "blogdetail",
            multilanguage: true,
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w700,
            maxline: 3,
            overflow: TextOverflow.ellipsis,
            textalign: TextAlign.left,
            fontstyle: FontStyle.normal),
        leading: InkWell(
          onTap: () {
            Navigator.of(context).pop(false);
          },
          child: Icon(
            Icons.arrow_back_outlined,
            size: 20,
            color: white,
          ),
        ),
        actions: [
          Consumer<BlogDetailProvider>(
              builder: (context, detailprovider, child) {
            return Padding(
              padding: const EdgeInsets.all(5),
              child: Padding(
                padding: const EdgeInsets.fromLTRB(10, 0, 10, 0),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.end,
                  children: [
                    InkWell(
                      splashColor: transparent,
                      focusColor: transparent,
                      hoverColor: transparent,
                      highlightColor: transparent,
                      borderRadius: BorderRadius.circular(50),
                      onTap: () async {
                        AdHelper.showFullscreenAd(
                            context, Constant.interstialAdType, () async {
                          if (Constant.userID == null) {
                            Navigator.of(context).push(
                              PageRouteBuilder(
                                pageBuilder:
                                    (context, animation, secondaryAnimation) =>
                                        const Login(),
                                transitionsBuilder: (context, animation,
                                    secondaryAnimation, child) {
                                  const begin = Offset(1.0, 0.0);
                                  const end = Offset.zero;
                                  const curve = Curves.ease;

                                  var tween = Tween(begin: begin, end: end)
                                      .chain(CurveTween(curve: curve));

                                  return SlideTransition(
                                    position: animation.drive(tween),
                                    child: child,
                                  );
                                },
                              ),
                            );
                          } else {
                            await detailprovider.addRemoveWishlist(
                                "1",
                                detailprovider.blogDetailModel.result?[0].id
                                        .toString() ??
                                    "");
                          }
                        });
                      },
                      child: Padding(
                        padding: const EdgeInsets.all(10.0),
                        child: Icon(
                          detailprovider
                                      .blogDetailModel.result?[0].isWishlist ==
                                  1
                              ? Icons.favorite
                              : Icons.favorite_border,
                          color: detailprovider
                                      .blogDetailModel.result?[0].isWishlist ==
                                  1
                              ? red
                              : white,
                        ),
                      ),
                    ),
                    InkWell(
                      splashColor: transparent,
                      focusColor: transparent,
                      hoverColor: transparent,
                      highlightColor: transparent,
                      borderRadius: BorderRadius.circular(50),
                      onTap: () {
                        AdHelper.showFullscreenAd(
                            context, Constant.interstialAdType, () {
                          Utils.shareApp(Platform.isIOS
                              ? "Hey! I'm Watching ${blogDetailProvider.blogDetailModel.result?[0].title.toString()}. Check it out now on ${Constant.appName}! \nhttps://apps.apple.com/us/app/${Constant.appName.toLowerCase()}/${Constant.appPackageName} \n"
                              : "Hey! I'm Watching ${blogDetailProvider.blogDetailModel.result?[0].title.toString()}. Check it out now on ${Constant.appName}! \nhttps://play.google.com/store/apps/details?id=${Constant.appPackageName} \n");
                        });
                      },
                      child: Padding(
                        padding: const EdgeInsets.all(10.0),
                        child: MyImage(
                          width: 18,
                          height: 18,
                          imagePath: "ic_rightturn.png",
                          color: white,
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            );
          }),
        ],
      ),
      body: Consumer<BlogDetailProvider>(
          builder: (context, blogDetailProvider, child) {
        return Stack(
          children: [
            SingleChildScrollView(
              scrollDirection: Axis.vertical,
              physics: const BouncingScrollPhysics(),
              padding: const EdgeInsets.fromLTRB(20, 10, 20, 65),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                spacing: 10,
                children: [buildBlogDetails(), relatedCourseData()],
              ),
            ),
            /* AdMob Banner */
            Utils.showBannerAd(context),
          ],
        );
      }),
    );
  }

  Widget buildBlogDetails() {
    if (blogDetailProvider.loading) {
      return shimmer();
    } else {
      if (blogDetailProvider.blogDetailModel.status == 200 &&
          blogDetailProvider.blogDetailModel.result!.isNotEmpty) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            MyNetworkImage(
              imgWidth: MediaQuery.of(context).size.width,
              imgHeight: 200,
              radius: 5,
              islandscap: true,
              imageUrl: blogDetailProvider.blogDetailModel.result?[0].image
                      .toString() ??
                  "",
              fit: BoxFit.cover,
            ),
            const SizedBox(height: 20),
            MyText(
                color: Theme.of(context).colorScheme.surface,
                text: blogDetailProvider.blogDetailModel.result?[0].title
                        .toString() ??
                    "",
                fontsizeNormal: Dimens.textBig,
                fontwaight: FontWeight.w700,
                maxline: 3,
                overflow: TextOverflow.ellipsis,
                textalign: TextAlign.left,
                fontstyle: FontStyle.normal),
            const SizedBox(height: 10),
            Row(
              children: [
                MyText(
                  color: gray,
                  text: "update",
                  fontsizeNormal: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                  maxline: 2,
                  multilanguage: true,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal,
                ),
                const SizedBox(width: 10),
                MyText(
                  color: gray,
                  text: Utils.formateDate(
                      blogDetailProvider.blogDetailModel.result?[0].createdAt
                              .toString() ??
                          "",
                      Constant.dateformat),
                  fontsizeNormal: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                  maxline: 2,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal,
                ),
              ],
            ),
            const SizedBox(height: 10),
            Row(
              children: [
                MyText(
                  color: gray,
                  text: "createdby",
                  fontsizeNormal: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                  maxline: 2,
                  multilanguage: true,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal,
                ),
                const SizedBox(width: 5),
                MyText(
                  color: gray,
                  text: blogDetailProvider.blogDetailModel.result?[0].tutorName
                          .toString() ??
                      "",
                  fontsizeNormal: Dimens.textMedium,
                  fontwaight: FontWeight.w600,
                  maxline: 2,
                  overflow: TextOverflow.ellipsis,
                  textalign: TextAlign.left,
                  fontstyle: FontStyle.normal,
                ),
              ],
            ),
            const SizedBox(height: 15),
            Container(
              padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
              width: MediaQuery.sizeOf(context).width,
              decoration: BoxDecoration(
                color: colorPrimary.withValues(alpha: 0.10),
                borderRadius: const BorderRadius.all(
                  Radius.circular(10.0),
                ),
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  MyText(
                    color: Theme.of(context).colorScheme.surface,
                    text: "discription",
                    fontsizeNormal: Dimens.textTitle,
                    fontwaight: FontWeight.w600,
                    maxline: 20,
                    multilanguage: true,
                    overflow: TextOverflow.ellipsis,
                    textalign: TextAlign.left,
                    fontstyle: FontStyle.normal,
                  ),
                  const SizedBox(height: 15),
                  Utils.htmlTexts(
                      context,
                      blogDetailProvider.blogDetailModel.result?[0].description
                              .toString() ??
                          ""),
                ],
              ),
            ),
          ],
        );
      } else {
        return const NoData();
      }
    }
  }

  Widget shimmer() {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        CustomWidget.roundrectborder(
          width: MediaQuery.of(context).size.width,
          height: 200,
        ),
        const SizedBox(height: 20),
        CustomWidget.roundrectborder(
          width: MediaQuery.of(context).size.width,
          height: 8,
        ),
        const SizedBox(height: 10),
        const CustomWidget.roundrectborder(
          width: 250,
          height: 8,
        ),
        const SizedBox(height: 10),
        const CustomWidget.roundrectborder(
          width: 250,
          height: 8,
        ),
        const SizedBox(height: 15),
        Container(
          padding: const EdgeInsets.fromLTRB(15, 20, 15, 20),
          decoration: BoxDecoration(
            color: colorPrimary.withValues(alpha: 0.10),
            borderRadius: const BorderRadius.all(
              Radius.circular(10.0),
            ),
          ),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              const CustomWidget.roundrectborder(
                width: 250,
                height: 8,
              ),
              const SizedBox(height: 15),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
              CustomWidget.roundrectborder(
                width: MediaQuery.of(context).size.width,
                height: 5,
              ),
            ],
          ),
        ),
      ],
    );
  }
  /* Related Course */

  Widget relatedCourseData() {
    if (blogDetailProvider.relatedCourseloading &&
        !blogDetailProvider.relatedCourseloadmore) {
      return relatedShimmer();
    } else {
      if (blogDetailProvider.relatedCourseList != null &&
          (blogDetailProvider.relatedCourseList?.length ?? 0) > 0) {
        return Column(
          mainAxisAlignment: MainAxisAlignment.start,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            MyText(
                color: Theme.of(context).colorScheme.surface,
                fontwaight: FontWeight.w600,
                fontsizeNormal: Dimens.textTitle,
                overflow: TextOverflow.ellipsis,
                maxline: 1,
                text: "relatedcourse",
                textalign: TextAlign.center,
                fontstyle: FontStyle.normal,
                multilanguage: true),
            const SizedBox(height: 10),
            relatedCourseItem(),
            if (blogDetailProvider.relatedCourseloadmore)
              Utils.pageLoader()
            else
              const SizedBox.shrink(),

            /// Show More button logic
            if ((blogDetailProvider.relatedBookModel.morePage ?? true) == true)
              Align(
                alignment: Alignment.center,
                child: InkWell(
                  hoverColor: transparent,
                  splashColor: transparent,
                  focusColor: transparent,
                  highlightColor: transparent,
                  onTap: () async {
                    if ((blogDetailProvider.relatedCoursecurrentPage ?? 0) <
                        (blogDetailProvider.relatedCoursetotalPage ?? 0)) {
                      blogDetailProvider.setRelatedCourseLoadMore(true);
                      await getRelatedList(
                          blogDetailProvider.relatedCoursecurrentPage ?? 0);
                    }
                  },
                  child: MyText(
                    text: "more",
                    maxline: 1,
                    multilanguage: true,
                    fontsizeNormal: Dimens.textlargeBig,
                    fontwaight: FontWeight.w700,
                  ),
                ),
              )
            else
              SizedBox.shrink()
          ],
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget relatedCourseItem() {
    return ResponsiveGridList(
      minItemWidth: 120,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      horizontalGridSpacing: 10,
      verticalGridSpacing: 20,
      listViewBuilderOptions: ListViewBuilderOptions(
        scrollDirection: Axis.vertical,
        shrinkWrap: true,
        padding: EdgeInsets.zero,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        blogDetailProvider.relatedCourseList?.length ?? 0,
        (index) {
          return InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            highlightColor: transparent,
            onTap: () {
              AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
                Navigator.of(context).pushReplacement(PageRouteBuilder(
                    pageBuilder: (context, animation, secondaryAnimation) =>
                        BlogDetail(
                            blogId: blogDetailProvider
                                    .relatedCourseList?[index].id
                                    .toString() ??
                                ""),
                    transitionsBuilder:
                        (context, animation, secondaryAnimation, child) {
                      const begin = Offset(1.0, 0.0);
                      const end = Offset.zero;
                      const curve = Curves.ease;

                      var tween = Tween(begin: begin, end: end)
                          .chain(CurveTween(curve: curve));

                      return SlideTransition(
                          position: animation.drive(tween), child: child);
                    }));
              });
            },
            child: Container(
              width: MediaQuery.of(context).size.width,
              decoration: BoxDecoration(
                color: Theme.of(context).cardColor,
                borderRadius: BorderRadius.circular(5),
                boxShadow: [
                  BoxShadow(
                    color: gray.withValues(alpha: 0.50),
                    blurRadius: 2,
                    offset: const Offset(0.1, 0.1),
                  ),
                ],
              ),
              child: Row(
                children: [
                  ClipRRect(
                    borderRadius: const BorderRadius.only(
                        bottomLeft: Radius.circular(5),
                        topLeft: Radius.circular(5)),
                    child: MyNetworkImage(
                      imgWidth: 110,
                      imgHeight: 100,
                      imageUrl: blogDetailProvider
                              .relatedCourseList?[index].image
                              .toString() ??
                          "",
                      fit: BoxFit.fill,
                    ),
                  ),
                  const SizedBox(width: 8),
                  Expanded(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      spacing: 4,
                      children: [
                        MyText(
                            color: Theme.of(context).colorScheme.surface,
                            text: blogDetailProvider
                                    .relatedCourseList?[index].title
                                    .toString() ??
                                "",
                            fontsizeNormal: Dimens.textMedium,
                            fontwaight: FontWeight.w600,
                            maxline: 2,
                            overflow: TextOverflow.ellipsis,
                            textalign: TextAlign.left,
                            fontstyle: FontStyle.normal),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            MyText(
                                color: gray,
                                text: Utils.kmbGenerator(
                                  int.parse(blogDetailProvider
                                          .relatedCourseList?[index].totalView
                                          .toString() ??
                                      ""),
                                ),
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                            const SizedBox(width: 5),
                            MyText(
                                color: gray,
                                text: "students",
                                fontsizeNormal: Dimens.textSmall,
                                fontwaight: FontWeight.w500,
                                maxline: 1,
                                multilanguage: true,
                                overflow: TextOverflow.ellipsis,
                                textalign: TextAlign.left,
                                fontstyle: FontStyle.normal),
                          ],
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          );
        },
      ),
    );
  }

  Widget relatedShimmer() {
    return ResponsiveGridList(
      minItemWidth: 120,
      minItemsPerRow: 1,
      maxItemsPerRow: 1,
      horizontalGridSpacing: 10,
      verticalGridSpacing: 20,
      listViewBuilderOptions: ListViewBuilderOptions(
        scrollDirection: Axis.vertical,
        shrinkWrap: true,
        padding: EdgeInsets.zero,
        physics: const NeverScrollableScrollPhysics(),
      ),
      children: List.generate(
        10,
        (index) {
          return Container(
            width: MediaQuery.of(context).size.width,
            decoration: BoxDecoration(
              color: Theme.of(context).cardColor,
              borderRadius: BorderRadius.circular(5),
              boxShadow: [
                BoxShadow(
                  color: gray.withValues(alpha: 0.50),
                  blurRadius: 2,
                  offset: const Offset(0.1, 0.1),
                ),
              ],
            ),
            child: Row(
              children: [
                ClipRRect(
                  borderRadius: const BorderRadius.only(
                      bottomLeft: Radius.circular(5),
                      topLeft: Radius.circular(5)),
                  child: CustomWidget.roundcorner(
                    width: 110,
                    height: 100,
                  ),
                ),
                const SizedBox(width: 8),
                Expanded(
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    spacing: 4,
                    children: [
                      CustomWidget.roundcorner(
                          width: MediaQuery.sizeOf(context).width, height: 14),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          CustomWidget.roundcorner(width: 40, height: 14),
                          const SizedBox(width: 5),
                          Expanded(
                              child: CustomWidget.roundcorner(
                                  width: 200, height: 14)),
                        ],
                      ),
                    ],
                  ),
                ),
              ],
            ),
          );
        },
      ),
    );
  }
}
