import 'package:prakah/pages/confirmappoinment.dart';
import 'package:prakah/provider/appoinmentbookingprovider.dart';
import 'package:prakah/utils/adhelper.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/customwidget.dart';
import 'package:prakah/utils/dimens.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/widget/mytext.dart';
import 'package:easy_date_timeline/easy_date_timeline.dart';
import 'package:flutter/material.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';

class AppoinmentBooking extends StatefulWidget {
  final String? meetingId, price;
  const AppoinmentBooking(
      {super.key, required this.meetingId, required this.price});

  @override
  State<AppoinmentBooking> createState() => _AppoinmentBookingState();
}

class _AppoinmentBookingState extends State<AppoinmentBooking> {
  AppoinmentBookingProvider appoinmentBookingProvider =
      AppoinmentBookingProvider();

  TextEditingController detsilsController = TextEditingController();

  @override
  void initState() {
    super.initState();
    appoinmentBookingProvider =
        Provider.of<AppoinmentBookingProvider>(context, listen: false);

    getApi();
  }

  Future<void> getApi() async {
    await Future.wait([
      appoinmentBookingProvider.getCourseName(),
      getTimeSoltApi(appoinmentBookingProvider.selectedValue),
    ]);
  }

  Future<void> getTimeSoltApi(DateTime time) async {
    await appoinmentBookingProvider.getBlogDetail(widget.meetingId ?? "", time);
  }

  @override
  void dispose() {
    detsilsController.dispose();
    FocusManager.instance.primaryFocus?.unfocus();
    appoinmentBookingProvider.clearProvider();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: Utils.myAppBarWithBack(
          editType: "1",
          context: context,
          appBarTitle: "appointmnet",
          multilanguage: true),
      body: Consumer<AppoinmentBookingProvider>(
          builder: (context, appoinmentBookingProvider, child) {
        return SingleChildScrollView(
          padding: const EdgeInsets.fromLTRB(16, 10, 16, 40),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            spacing: 16,
            children: [
              dateCalender(),

              // _weekDayListData(),
              timeSlotData(),
              MyText(
                text: 'discussion_topic',
                multilanguage: true,
                fontsizeNormal: Dimens.textTitle,
                fontwaight: FontWeight.w600,
                fontstyle: FontStyle.normal,
                color: black,
              ),
              courseNameData(),
              TextFormField(
                obscureText: false,
                keyboardType: TextInputType.multiline,
                controller: detsilsController,
                textInputAction: TextInputAction.newline,
                minLines: 3,
                showCursor: true,
                maxLines: 5,
                cursorColor: colorPrimary,
                style: GoogleFonts.inter(
                    fontSize: Dimens.textMedium,
                    fontStyle: FontStyle.normal,
                    color: black,
                    letterSpacing: 1,
                    fontWeight: FontWeight.w600),
                decoration: InputDecoration(
                  focusedBorder: OutlineInputBorder(
                    borderRadius: const BorderRadius.all(Radius.circular(10)),
                    borderSide: BorderSide(
                        width: 1, color: black, style: BorderStyle.solid),
                  ),
                  disabledBorder: OutlineInputBorder(
                    borderRadius: const BorderRadius.all(Radius.circular(10)),
                    borderSide: BorderSide(
                        width: 1, color: black, style: BorderStyle.solid),
                  ),
                  enabledBorder: OutlineInputBorder(
                    borderRadius: const BorderRadius.all(Radius.circular(10)),
                    borderSide: BorderSide(
                        width: 1, color: black, style: BorderStyle.solid),
                  ),
                  border: OutlineInputBorder(
                    borderRadius: const BorderRadius.all(Radius.circular(10)),
                    borderSide: BorderSide(
                        width: 1, color: black, style: BorderStyle.solid),
                  ),
                  hintText: "Write your brief details here",
                  hintStyle: GoogleFonts.inter(
                      fontSize: Dimens.textMedium,
                      fontStyle: FontStyle.normal,
                      letterSpacing: 1,
                      color: gray,
                      fontWeight: FontWeight.w500),
                  labelText: Locales.string(context, "details"),
                  labelStyle: GoogleFonts.inter(
                      fontSize: Dimens.textMedium,
                      fontStyle: FontStyle.normal,
                      letterSpacing: 1,
                      color: gray,
                      fontWeight: FontWeight.w500),
                ),
              ),
              _attachMentData(),
              _bookingBtn(),
            ],
          ),
        );
      }),
    );
  }

/* Course name Started */
  Widget courseNameData() {
    if (appoinmentBookingProvider.courseNameLoading) {
      return CustomWidget.roundcorner(
        height: 50,
        width: MediaQuery.sizeOf(context).width,
      );
    } else {
      if (appoinmentBookingProvider.courseNameModel.status == 200 &&
          (appoinmentBookingProvider.courseNameModel.result?.length ?? 0) > 0) {
        return Card(
          color: white,
          elevation: 6,
          shadowColor: transparent.withValues(alpha: .6),
          child: DropdownMenu(
            initialSelection: appoinmentBookingProvider.courseId,
            onSelected: (value) {
              if (value != null) {
                appoinmentBookingProvider.setCourseId(value);
              }
            },
            trailingIcon:
                Icon(Icons.keyboard_arrow_down, color: black, size: 20),
            selectedTrailingIcon:
                Icon(Icons.keyboard_arrow_up, color: black, size: 20),
            width: MediaQuery.sizeOf(context).width,
            menuStyle: MenuStyle(
                visualDensity: VisualDensity.comfortable,
                backgroundColor: WidgetStatePropertyAll(white)),
            inputDecorationTheme: InputDecorationTheme(
                enabledBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.none),
                    borderRadius: BorderRadius.circular(12)),
                errorBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.none),
                    borderRadius: BorderRadius.circular(12)),
                focusedBorder: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.none),
                    borderRadius: BorderRadius.circular(12)),
                border: OutlineInputBorder(
                    borderSide: BorderSide(
                        width: 1,
                        color: gray.withValues(alpha: .5),
                        style: BorderStyle.none),
                    borderRadius: BorderRadius.circular(12))),
            hintText: "Select the Subject Name...",
            textStyle: GoogleFonts.manrope(
                fontSize: Dimens.textTitle,
                fontWeight: FontWeight.w500,
                fontStyle: FontStyle.normal,
                color: black),
            dropdownMenuEntries:
                (appoinmentBookingProvider.courseNameModel.result ?? [])
                    .map((category) {
              return DropdownMenuEntry(
                  value: category.id.toString(), label: category.title ?? "");
            }).toList(),
          ),
        );
      } else {
        return const SizedBox.shrink();
      }
    }
  }

  Widget dateCalender() {
    return Column(
      children: [
        Align(
          alignment: Alignment.centerLeft,
          child: MyText(
            text: "choose_date",
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w700,
            fontstyle: FontStyle.normal,
            color: black,
          ),
        ),
        EasyDateTimeLine(
          timeLineProps: EasyTimeLineProps(margin: EdgeInsets.zero),
          initialDate: appoinmentBookingProvider.selectedValue,
          onDateChange: (selectedDate) {
            appoinmentBookingProvider.setDate(selectedDate);
            // Get weekday name (e.g., Monday)
            final weekDayName = DateFormat('EEEE').format(selectedDate);
            appoinmentBookingProvider.setWeekDay(weekDayName);
            appoinmentBookingProvider.clearContent();
            getTimeSoltApi(appoinmentBookingProvider.selectedValue);
          },
          activeColor: white,
          headerProps: EasyHeaderProps(
              showHeader: true,
              padding: EdgeInsets.zero,
              monthPickerType: MonthPickerType.switcher,
              showMonthPicker: true,
              centerHeader: true,
              monthStyle: GoogleFonts.lato(
                  fontSize: Dimens.textMedium,
                  color: colorPrimaryDark,
                  fontWeight: FontWeight.w600),
              showSelectedDate: false),
          locale: "en",
          dayProps: EasyDayProps(
              todayHighlightStyle: TodayHighlightStyle.withBackground,
              borderColor: gray,
              dayStructure: DayStructure.dayNumDayStr,
              height: 80,
              width: 50,
              inactiveDayStyle: DayStyle(
                  borderRadius: 10,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(
                          width: 1, color: gray, style: BorderStyle.solid)),
                  dayNumStyle: GoogleFonts.lato(
                      fontSize: Dimens.textBig,
                      color: black,
                      fontWeight: FontWeight.w600)),
              activeDayStyle: DayStyle(
                  borderRadius: 10,
                  decoration: BoxDecoration(
                      color: white,
                      borderRadius: BorderRadius.circular(20),
                      border: Border.all(
                          width: 1,
                          color: colorPrimaryDark,
                          style: BorderStyle.solid)),
                  dayStrStyle: GoogleFonts.lato(
                      fontSize: Dimens.textMedium,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600),
                  monthStrStyle: GoogleFonts.lato(
                      fontSize: Dimens.textTitle,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600),
                  dayNumStyle: GoogleFonts.lato(
                      fontSize: Dimens.textBig,
                      color: colorPrimaryDark,
                      fontWeight: FontWeight.w600))),
        )
      ],
    );
  }

  Widget timeSlotData() {
    if (appoinmentBookingProvider.loading) {
      return Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          MyText(
            text: 'choose_time_slot',
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w600,
            fontstyle: FontStyle.normal,
            color: black,
          ),
          SingleChildScrollView(
            padding: EdgeInsets.zero,
            scrollDirection: Axis.horizontal,
            physics: NeverScrollableScrollPhysics(),
            child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.center,
                spacing: 20,
                children: List.generate(
                  4,
                  (index) {
                    return Container(
                      padding: const EdgeInsets.all(10),
                      alignment: Alignment.center,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(10),
                        color: transparent,
                      ),
                      child: CustomWidget.roundcorner(
                        height: 14,
                        width: 100,
                      ),
                    );
                  },
                )),
          ),
        ],
      );
    } else {
      /* Main Result Data */
      if (appoinmentBookingProvider.selectedTimeSloteModel.status == 200 &&
          (appoinmentBookingProvider.selectedTimeSloteModel.result?.length ??
                  0) >
              0) {
        return Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          spacing: 10,
          children: [
            MyText(
              text: 'choose_time_slot',
              multilanguage: true,
              fontsizeNormal: Dimens.textTitle,
              fontwaight: FontWeight.w600,
              fontstyle: FontStyle.normal,
              color: black,
            ),
            SingleChildScrollView(
              scrollDirection: Axis.horizontal,
              padding: EdgeInsets.zero,
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.start,
                children: List.generate(
                  appoinmentBookingProvider
                          .selectedTimeSloteModel.result?.length ??
                      0,
                  (index) {
                    final timeSlot = appoinmentBookingProvider
                        .selectedTimeSloteModel.result?[index];
                    /* Time slot Data Result show */
                    return Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: List.generate(
                        timeSlot?.timeSlotes?.length ?? 0,
                        (postion) {
                          final subTimeSlot = timeSlot?.timeSlotes?[postion];
                          /* Time schedul Data Result show */
                          return Row(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            spacing: 10,
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: List.generate(
                              subTimeSlot?.timeSchedul?.length ?? 0,
                              (timeSchedulPostion) {
                                final subTimeSlotSchedul = subTimeSlot
                                    ?.timeSchedul?[timeSchedulPostion];
                                return InkWell(
                                  splashColor: transparent,
                                  focusColor: transparent,
                                  hoverColor: transparent,
                                  onTap: () {
                                    if ((subTimeSlotSchedul?.isBook
                                                .toString() ??
                                            "") ==
                                        "1") {
                                      printLog("selecte the time slot");
                                    } else {
                                      appoinmentBookingProvider.setMeetingId(
                                          id: subTimeSlotSchedul?.id
                                                  .toString() ??
                                              "",
                                          start: subTimeSlotSchedul?.startTime
                                                  .toString() ??
                                              "",
                                          end: subTimeSlotSchedul?.endTime
                                                  .toString() ??
                                              "");
                                    }
                                  },
                                  child: Container(
                                    padding: const EdgeInsets.fromLTRB(
                                        15, 10, 15, 10),
                                    alignment: Alignment.center,
                                    decoration: BoxDecoration(
                                        borderRadius: BorderRadius.circular(10),
                                        color: (subTimeSlotSchedul?.isBook
                                                        .toString() ??
                                                    "") ==
                                                "1"
                                            ? colorPrimary
                                            : appoinmentBookingProvider
                                                        .meetingScheduledId ==
                                                    (subTimeSlotSchedul?.id
                                                            .toString() ??
                                                        "")
                                                ? colorPrimaryDark
                                                : transparent),
                                    child: MyText(
                                      text: Utils.formateTime(
                                          staTime:
                                              subTimeSlotSchedul?.startTime ??
                                                  "",
                                          enTime: subTimeSlotSchedul?.endTime ??
                                              ""),
                                      fontsizeNormal: Dimens.textMedium,
                                      fontwaight: FontWeight.w600,
                                      color: (subTimeSlotSchedul?.isBook
                                                      .toString() ??
                                                  "") ==
                                              "1"
                                          ? white
                                          : appoinmentBookingProvider
                                                      .meetingScheduledId ==
                                                  (subTimeSlotSchedul?.id
                                                          .toString() ??
                                                      "")
                                              ? white
                                              : black,
                                    ),
                                  ),
                                );
                              },
                            ),
                          );
                        },
                      ),
                    );
                  },
                ),
              ),
            ),
          ],
        );
      } else {
        return SizedBox.shrink();
      }
    }
  }

  Widget _attachMentData() {
    return Container(
      width: MediaQuery.sizeOf(context).width,
      padding: EdgeInsets.all(16),
      decoration: BoxDecoration(
          color: white,
          borderRadius: BorderRadius.circular(16),
          boxShadow: [
            BoxShadow(
                blurRadius: 12,
                blurStyle: BlurStyle.outer,
                color: transparent.withValues(alpha: 0.6),
                offset: Offset(0, 2),
                spreadRadius: 0)
          ]),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        spacing: 10,
        children: [
          MyText(
            text: "attach_notes",
            multilanguage: true,
            fontsizeNormal: Dimens.textTitle,
            fontwaight: FontWeight.w700,
            fontstyle: FontStyle.normal,
            color: black,
          ),
          MyText(
            text: ((appoinmentBookingProvider.fileName ?? "") != "")
                ? (appoinmentBookingProvider.fileName ?? "")
                : "JPEG, PNG, PDF (min 4MB - max 8MB)",
            multilanguage: false,
            fontsizeNormal: Dimens.textMedium,
            fontwaight: FontWeight.w500,
            fontstyle: FontStyle.normal,
            color: black,
          ),
          InkWell(
            splashColor: transparent,
            focusColor: transparent,
            hoverColor: transparent,
            onTap: () {
              appoinmentBookingProvider.filePickedCode();
            },
            child: Container(
              padding: EdgeInsets.fromLTRB(24, 10, 24, 10),
              alignment: Alignment.center,
              width: MediaQuery.sizeOf(context).width,
              decoration: BoxDecoration(
                  border: Border.all(
                      width: 1,
                      color: colorPrimaryDark,
                      style: BorderStyle.solid),
                  color: white,
                  borderRadius: BorderRadius.circular(20)),
              child: MyText(
                text: 'upload_file',
                multilanguage: true,
                color: colorPrimaryDark,
                fontsizeNormal: Dimens.textMedium,
                fontsizeWeb: Dimens.textMedium,
                fontwaight: FontWeight.w600,
              ),
            ),
          )
        ],
      ),
    );
  }

/* Booking Btn */
  Widget _bookingBtn() {
    return InkWell(
      splashColor: transparent,
      focusColor: transparent,
      hoverColor: transparent,
      onTap: () {
        if (appoinmentBookingProvider.meetingScheduledId == "") {
          Utils.showSnackbar(context, "info", "ple_select_time", true);
        } else if ((appoinmentBookingProvider.courseId ?? "").isEmpty &&
            appoinmentBookingProvider.courseId == null) {
          Utils.showSnackbar(context, "info", "ple_select_topic", true);
        } else {
          AdHelper.showFullscreenAd(context, Constant.interstialAdType, () {
            Navigator.of(context).push(
              PageRouteBuilder(
                pageBuilder: (context, animation, secondaryAnimation) =>
                    ConfirmAppoinment(
                  mettingId: widget.meetingId ?? "",
                  attachment: appoinmentBookingProvider.filePath ?? "",
                  chapterId: appoinmentBookingProvider.courseId ?? "",
                  date: appoinmentBookingProvider.selectedValue,
                  details: detsilsController.text.toString(),
                  mettingScheduleId:
                      appoinmentBookingProvider.meetingScheduledId ?? "",
                  totalPrice: widget.price ?? "",
                  weekDayName: appoinmentBookingProvider.weekDayName,
                  startedTime:
                      appoinmentBookingProvider.meetingScheduledStartTime,
                  endTime: appoinmentBookingProvider.meetingScheduledEndTime,
                ),
                transitionsBuilder:
                    (context, animation, secondaryAnimation, child) {
                  const begin = Offset(1.0, 0.0);
                  const end = Offset.zero;
                  const curve = Curves.ease;

                  var tween = Tween(begin: begin, end: end)
                      .chain(CurveTween(curve: curve));

                  return SlideTransition(
                    position: animation.drive(tween),
                    child: child,
                  );
                },
              ),
            );
          });
        }
      },
      child: Container(
        padding: EdgeInsets.fromLTRB(24, 12, 24, 12),
        alignment: Alignment.center,
        width: MediaQuery.sizeOf(context).width,
        decoration: BoxDecoration(
            border: Border.all(
                width: 1, color: transparent, style: BorderStyle.solid),
            color: colorPrimaryDark,
            borderRadius: BorderRadius.circular(20)),
        child: MyText(
          text: 'book_appointment',
          multilanguage: true,
          color: white,
          fontsizeNormal: Dimens.textMedium,
          fontsizeWeb: Dimens.textMedium,
          fontwaight: FontWeight.w500,
        ),
      ),
    );
  }
}
