// To parse this JSON data, do
//
//     final viewSessionModel = viewSessionModelFromJson(jsonString);

import 'dart:convert';

ViewSessionModel viewSessionModelFromJson(String str) =>
    ViewSessionModel.fromJson(json.decode(str));

String viewSessionModelToJson(ViewSessionModel data) =>
    json.encode(data.toJson());

class ViewSessionModel {
  int? status;
  String? message;
  List<Result>? result;

  ViewSessionModel({
    this.status,
    this.message,
    this.result,
  });

  factory ViewSessionModel.fromJson(Map<String, dynamic> json) =>
      ViewSessionModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  int? id;
  int? userId;
  int? mettingId;
  int? courseId;
  int? chapterId;
  int? mettingScheduleId;
  String? date;
  String? startTime;
  String? endTime;
  String? details;
  String? attachment;
  int? promoCodeId;
  int? totalPrice;
  String? transactionId;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? mettingDay;
  String? platformName;
  String? lecturerName;
  String? lecturerUserName;
  String? lecturerImage;
  String? courseTitle;
  String? courseImage;
  String? chapterName;
  String? recordingUrl;
  Metting? metting;

  Result({
    this.id,
    this.userId,
    this.mettingId,
    this.courseId,
    this.chapterId,
    this.mettingScheduleId,
    this.date,
    this.startTime,
    this.endTime,
    this.details,
    this.attachment,
    this.promoCodeId,
    this.totalPrice,
    this.transactionId,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.mettingDay,
    this.platformName,
    this.lecturerName,
    this.lecturerUserName,
    this.lecturerImage,
    this.courseTitle,
    this.courseImage,
    this.chapterName,
    this.recordingUrl,
    this.metting,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        userId: json["user_id"],
        mettingId: json["metting_id"],
        courseId: json["course_id"],
        chapterId: json["chapter_id"],
        mettingScheduleId: json["metting_schedule_id"],
        date: json["date"],
        startTime: json["start_time"],
        endTime: json["end_time"],
        details: json["details"],
        attachment: json["attachment"],
        promoCodeId: json["promo_code_id"],
        totalPrice: json["total_price"],
        transactionId: json["transaction_id"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        mettingDay: json["metting_day"],
        platformName: json["platform_name"],
        lecturerName: json["lecturer_name"],
        lecturerUserName: json["lecturer_user_name"],
        lecturerImage: json["lecturer_image"],
        courseTitle: json["course_title"],
        courseImage: json["course_image"],
        chapterName: json["chapter_name"],
        recordingUrl: json["recording_url"],
        metting:
            json["metting"] == null ? null : Metting.fromJson(json["metting"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "metting_id": mettingId,
        "course_id": courseId,
        "chapter_id": chapterId,
        "metting_schedule_id": mettingScheduleId,
        "date": date,
        "start_time": startTime,
        "end_time": endTime,
        "details": details,
        "attachment": attachment,
        "promo_code_id": promoCodeId,
        "total_price": totalPrice,
        "transaction_id": transactionId,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "metting_day": mettingDay,
        "platform_name": platformName,
        "lecturer_name": lecturerName,
        "lecturer_user_name": lecturerUserName,
        "lecturer_image": lecturerImage,
        "course_title": courseTitle,
        "course_image": courseImage,
        "chapter_name": chapterName,
        "recording_url": recordingUrl,
        "metting": metting?.toJson(),
      };
}

class Metting {
  int? id;
  String? title;
  int? courseId;
  int? type;
  int? typeId;
  int? platformId;
  String? meetingLink;
  int? isFree;
  int? price;
  int? status;
  String? createdAt;
  String? updatedAt;

  Metting({
    this.id,
    this.title,
    this.courseId,
    this.type,
    this.typeId,
    this.platformId,
    this.meetingLink,
    this.isFree,
    this.price,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory Metting.fromJson(Map<String, dynamic> json) => Metting(
        id: json["id"],
        title: json["title"],
        courseId: json["course_id"],
        type: json["type"],
        typeId: json["type_id"],
        platformId: json["platform_id"],
        meetingLink: json["meeting_link"],
        isFree: json["is_free"],
        price: json["price"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "title": title,
        "course_id": courseId,
        "type": type,
        "type_id": typeId,
        "platform_id": platformId,
        "meeting_link": meetingLink,
        "is_free": isFree,
        "price": price,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
