// To parse this JSON data, do
//
//     final userModel = userModelFromJson(jsonString);

import 'dart:convert';

UserModel userModelFromJson(String str) => UserModel.fromJson(json.decode(str));

String userModelToJson(UserModel data) => json.encode(data.toJson());

class UserModel {
  int? status;
  String? message;
  List<Result>? result;

  UserModel({
    this.status,
    this.message,
    this.result,
  });

  factory UserModel.fromJson(Map<String, dynamic> json) => UserModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  int? id;
  String? userName;
  String? fullName;
  String? email;
  String? countryCode;
  String? mobileNumber;
  String? countryName;
  String? image;
  String? description;
  int? type;
  int? deviceType;
  String? deviceToken;
  int? walletAmount;
  int? isBuy;
  int? packageId;
  int? status;
  String? createdAt;
  String? updatedAt;

  Result({
    this.id,
    this.userName,
    this.fullName,
    this.email,
    this.countryCode,
    this.mobileNumber,
    this.countryName,
    this.image,
    this.description,
    this.type,
    this.deviceType,
    this.deviceToken,
    this.walletAmount,
    this.isBuy,
    this.packageId,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        userName: json["user_name"],
        fullName: json["full_name"],
        email: json["email"],
        countryCode: json["country_code"],
        mobileNumber: json["mobile_number"],
        countryName: json["country_name"],
        image: json["image"],
        description: json["description"],
        type: json["type"],
        deviceType: json["device_type"],
        deviceToken: json["device_token"],
        walletAmount: json["wallet_amount"],
        isBuy: json["is_buy"],
        packageId: json["package_id"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_name": userName,
        "full_name": fullName,
        "email": email,
        "country_code": countryCode,
        "mobile_number": mobileNumber,
        "country_name": countryName,
        "image": image,
        "description": description,
        "type": type,
        "device_type": deviceType,
        "device_token": deviceToken,
        "wallet_amount": walletAmount,
        "is_buy": isBuy,
        "package_id": packageId,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
