// To parse this JSON data, do
//
//     final userMeetingModel = userMeetingModelFromJson(jsonString);

import 'dart:convert';

UserMeetingModel userMeetingModelFromJson(String str) =>
    UserMeetingModel.fromJson(json.decode(str));

String userMeetingModelToJson(UserMeetingModel data) =>
    json.encode(data.toJson());

class UserMeetingModel {
  int? status;
  String? message;
  List<Result>? result;
  int? totalRows;
  int? totalPage;
  int? currentPage;
  bool? morePage;

  UserMeetingModel({
    this.status,
    this.message,
    this.result,
    this.totalRows,
    this.totalPage,
    this.currentPage,
    this.morePage,
  });

  factory UserMeetingModel.fromJson(Map<String, dynamic> json) =>
      UserMeetingModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
        totalRows: json["total_rows"],
        totalPage: json["total_page"],
        currentPage: json["current_page"],
        morePage: json["more_page"],
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
        "total_rows": totalRows,
        "total_page": totalPage,
        "current_page": currentPage,
        "more_page": morePage,
      };
}

class Result {
  int? id;
  int? userId;
  int? mettingId;
  int? courseId;
  int? mettingScheduleId;
  String? date;
  String? startTime;
  String? endTime;
  String? details;
  String? attachment;
  int? promoCodeId;
  int? totalPrice;
  String? transactionId;
  int? status;
  String? createdAt;
  String? updatedAt;
  int? mettingPrice;
  String? joinLinks;
  String? platformName;
  String? lecturerName;
  String? lecturerUserName;
  String? lecturerImage;
  String? courseTitle;
  String? courseImage;

  Result({
    this.id,
    this.userId,
    this.mettingId,
    this.courseId,
    this.mettingScheduleId,
    this.date,
    this.startTime,
    this.endTime,
    this.details,
    this.attachment,
    this.promoCodeId,
    this.totalPrice,
    this.transactionId,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.mettingPrice,
    this.joinLinks,
    this.platformName,
    this.lecturerName,
    this.lecturerUserName,
    this.lecturerImage,
    this.courseTitle,
    this.courseImage,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        userId: json["user_id"],
        mettingId: json["metting_id"],
        courseId: json["course_id"],
        mettingScheduleId: json["metting_schedule_id"],
        date: json["date"],
        startTime: json["start_time"],
        endTime: json["end_time"],
        details: json["details"],
        attachment: json["attachment"],
        promoCodeId: json["promo_code_id"],
        totalPrice: json["total_price"],
        transactionId: json["transaction_id"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        mettingPrice: json["metting_price"],
        joinLinks: json["join_links"],
        platformName: json["platform_name"],
        lecturerName: json["lecturer_name"],
        lecturerUserName: json["lecturer_user_name"],
        lecturerImage: json["lecturer_image"],
        courseTitle: json["course_title"],
        courseImage: json["course_image"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "metting_id": mettingId,
        "course_id": courseId,
        "metting_schedule_id": mettingScheduleId,
        "date": date,
        "start_time": startTime,
        "end_time": endTime,
        "details": details,
        "attachment": attachment,
        "promo_code_id": promoCodeId,
        "total_price": totalPrice,
        "transaction_id": transactionId,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "metting_price": mettingPrice,
        "join_links": joinLinks,
        "platform_name": platformName,
        "lecturer_name": lecturerName,
        "lecturer_user_name": lecturerUserName,
        "lecturer_image": lecturerImage,
        "course_title": courseTitle,
        "course_image": courseImage,
      };
}
