// To parse this JSON data, do
//
//     final tutorprofilemodel = tutorprofilemodelFromJson(jsonString);

import 'dart:convert';

Tutorprofilemodel tutorprofilemodelFromJson(String str) => Tutorprofilemodel.fromJson(json.decode(str));

String tutorprofilemodelToJson(Tutorprofilemodel data) => json.encode(data.toJson());

class Tutorprofilemodel {
    int? status;
    String? message;
    List<Result>? result;

    Tutorprofilemodel({
        this.status,
        this.message,
        this.result,
    });

    factory Tutorprofilemodel.fromJson(Map<String, dynamic> json) => Tutorprofilemodel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null ? [] : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null ? [] : List<dynamic>.from(result!.map((x) => x.toJson())),
    };
}

class Result {
    int? id;
    String? userName;
    String? fullName;
    String? email;
    String? countryCode;
    String? mobileNumber;
    String? countryName;
    String? image;
    String? description;
    String? designation;
    int? deviceType;
    String? deviceToken;
    int? status;
    int? accountStatus;
    String? createdAt;
    String? updatedAt;
    int? totalCourse;
    int? totalBook;
    int? totalBlog;

    Result({
        this.id,
        this.userName,
        this.fullName,
        this.email,
        this.countryCode,
        this.mobileNumber,
        this.countryName,
        this.image,
        this.description,
        this.designation,
        this.deviceType,
        this.deviceToken,
        this.status,
        this.accountStatus,
        this.createdAt,
        this.updatedAt,
        this.totalCourse,
        this.totalBook,
        this.totalBlog,
    });

    factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        userName: json["user_name"],
        fullName: json["full_name"],
        email: json["email"],
        countryCode: json["country_code"],
        mobileNumber: json["mobile_number"],
        countryName: json["country_name"],
        image: json["image"],
        description: json["description"],
        designation: json["designation"],
        deviceType: json["device_type"],
        deviceToken: json["device_token"],
        status: json["status"],
        accountStatus: json["account_status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        totalCourse: json["total_course"],
        totalBook: json["total_book"],
        totalBlog: json["total_blog"],
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "user_name": userName,
        "full_name": fullName,
        "email": email,
        "country_code": countryCode,
        "mobile_number": mobileNumber,
        "country_name": countryName,
        "image": image,
        "description": description,
        "designation": designation,
        "device_type": deviceType,
        "device_token": deviceToken,
        "status": status,
        "account_status": accountStatus,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "total_course": totalCourse,
        "total_book": totalBook,
        "total_blog": totalBlog,
    };
}
