// To parse this JSON data, do
//
//     final transactionListModel = transactionListModelFromJson(jsonString);

import 'dart:convert';

TransactionListModel transactionListModelFromJson(String str) =>
    TransactionListModel.fromJson(json.decode(str));

String transactionListModelToJson(TransactionListModel data) =>
    json.encode(data.toJson());

class TransactionListModel {
  int? status;
  String? message;
  List<Result>? result;
  int? totalRows;
  int? totalPage;
  int? currentPage;
  bool? morePage;

  TransactionListModel({
    this.status,
    this.message,
    this.result,
    this.totalRows,
    this.totalPage,
    this.currentPage,
    this.morePage,
  });

  factory TransactionListModel.fromJson(Map<String, dynamic> json) =>
      TransactionListModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
        totalRows: json["total_rows"],
        totalPage: json["total_page"],
        currentPage: json["current_page"],
        morePage: json["more_page"],
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
        "total_rows": totalRows,
        "total_page": totalPage,
        "current_page": currentPage,
        "more_page": morePage,
      };
}

class Result {
  int? id;
  int? type;
  int? userId;
  int? contentId;
  String? transactionId;
  int? price;
  String? description;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? packageName;
  int? packagePrice;
  String? packageImage;
  int? packageDuration;
  int? maxCourses;
  int? mettingId;
  int? courseId;
  int? chapterId;
  int? mettingScheduleId;
  String? date;
  String? startTime;
  String? endTime;
  String? details;
  String? attachment;
  int? promoCodeId;
  int? totalPrice;
  String? liveClassTitle;
  String? purchaseId;
  int? coursePrice;
  int? discountPrice;
  String? courseTitle;
  String? courseImage;
  String? bookName;
  String? bookImage;
  int? isFree;
  int? bookPrice;
  String? bookUrl;

  Result({
    this.id,
    this.type,
    this.userId,
    this.contentId,
    this.transactionId,
    this.price,
    this.description,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.packageName,
    this.packagePrice,
    this.packageImage,
    this.packageDuration,
    this.maxCourses,
    this.mettingId,
    this.courseId,
    this.chapterId,
    this.mettingScheduleId,
    this.date,
    this.startTime,
    this.endTime,
    this.details,
    this.attachment,
    this.promoCodeId,
    this.totalPrice,
    this.liveClassTitle,
    this.purchaseId,
    this.coursePrice,
    this.discountPrice,
    this.courseTitle,
    this.courseImage,
    this.bookName,
    this.bookImage,
    this.isFree,
    this.bookPrice,
    this.bookUrl,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        type: json["type"],
        userId: json["user_id"],
        contentId: json["content_id"],
        transactionId: json["transaction_id"],
        price: json["price"],
        description: json["description"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        packageName: json["package_name"],
        packagePrice: json["package_price"],
        packageImage: json["package_image"],
        packageDuration: json["package_duration"],
        maxCourses: json["max_courses"],
        mettingId: json["metting_id"],
        courseId: json["course_id"],
        chapterId: json["chapter_id"],
        mettingScheduleId: json["metting_schedule_id"],
        date: json["date"],
        startTime: json["start_time"],
        endTime: json["end_time"],
        details: json["details"],
        attachment: json["attachment"],
        promoCodeId: json["promo_code_id"],
        totalPrice: json["total_price"],
        liveClassTitle: json["live_class_title"],
        purchaseId: json["purchase_id"],
        coursePrice: json["course_price"],
        discountPrice: json["discount_price"],
        courseTitle: json["course_title"],
        courseImage: json["course_image"],
        bookName: json["book_name"],
        bookImage: json["book_image"],
        isFree: json["is_free"],
        bookPrice: json["book_price"],
        bookUrl: json["book_url"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "type": type,
        "user_id": userId,
        "content_id": contentId,
        "transaction_id": transactionId,
        "price": price,
        "description": description,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "package_name": packageName,
        "package_price": packagePrice,
        "package_image": packageImage,
        "package_duration": packageDuration,
        "max_courses": maxCourses,
        "metting_id": mettingId,
        "course_id": courseId,
        "chapter_id": chapterId,
        "metting_schedule_id": mettingScheduleId,
        "date": date,
        "start_time": startTime,
        "end_time": endTime,
        "details": details,
        "attachment": attachment,
        "promo_code_id": promoCodeId,
        "total_price": totalPrice,
        "live_class_title": liveClassTitle,
        "purchase_id": purchaseId,
        "course_price": coursePrice,
        "discount_price": discountPrice,
        "course_title": courseTitle,
        "course_image": courseImage,
        "book_name": bookName,
        "book_image": bookImage,
        "is_free": isFree,
        "book_price": bookPrice,
        "book_url": bookUrl,
      };
}
