// To parse this JSON data, do
//
//     final selectedTimeSloteModel = selectedTimeSloteModelFromJson(jsonString);

import 'dart:convert';

SelectedTimeSloteModel selectedTimeSloteModelFromJson(String str) =>
    SelectedTimeSloteModel.fromJson(json.decode(str));

String selectedTimeSloteModelToJson(SelectedTimeSloteModel data) =>
    json.encode(data.toJson());

class SelectedTimeSloteModel {
  int? status;
  String? message;
  List<Result>? result;

  SelectedTimeSloteModel({
    this.status,
    this.message,
    this.result,
  });

  factory SelectedTimeSloteModel.fromJson(Map<String, dynamic> json) =>
      SelectedTimeSloteModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  DateTime? date;
  List<TimeSlote>? timeSlotes;

  Result({
    this.date,
    this.timeSlotes,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        date: json["date"] == null ? null : DateTime.parse(json["date"]),
        timeSlotes: json["time_slotes"] == null
            ? []
            : List<TimeSlote>.from(
                json["time_slotes"]!.map((x) => TimeSlote.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "date":
            "${date!.year.toString().padLeft(4, '0')}-${date!.month.toString().padLeft(2, '0')}-${date!.day.toString().padLeft(2, '0')}",
        "time_slotes": timeSlotes == null
            ? []
            : List<dynamic>.from(timeSlotes!.map((x) => x.toJson())),
      };
}

class TimeSlote {
  int? id;
  int? mettingId;
  DateTime? date;
  String? startTime;
  String? endTime;
  String? timeDuration;
  int? status;
  String? createdAt;
  String? updatedAt;
  List<TimeSchedul>? timeSchedul;

  TimeSlote({
    this.id,
    this.mettingId,
    this.date,
    this.startTime,
    this.endTime,
    this.timeDuration,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.timeSchedul,
  });

  factory TimeSlote.fromJson(Map<String, dynamic> json) => TimeSlote(
        id: json["id"],
        mettingId: json["metting_id"],
        date: json["date"] == null ? null : DateTime.parse(json["date"]),
        startTime: json["start_time"],
        endTime: json["end_time"],
        timeDuration: json["time_duration"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        timeSchedul: json["time_schedul"] == null
            ? []
            : List<TimeSchedul>.from(
                json["time_schedul"]!.map((x) => TimeSchedul.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "metting_id": mettingId,
        "date":
            "${date!.year.toString().padLeft(4, '0')}-${date!.month.toString().padLeft(2, '0')}-${date!.day.toString().padLeft(2, '0')}",
        "start_time": startTime,
        "end_time": endTime,
        "time_duration": timeDuration,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "time_schedul": timeSchedul == null
            ? []
            : List<dynamic>.from(timeSchedul!.map((x) => x.toJson())),
      };
}

class TimeSchedul {
  int? id;
  int? mettingId;
  int? mettingSlotsId;
  DateTime? date;
  String? startTime;
  String? endTime;
  int? status;
  String? createdAt;
  String? updatedAt;
  int? isBook;

  TimeSchedul({
    this.id,
    this.mettingId,
    this.mettingSlotsId,
    this.date,
    this.startTime,
    this.endTime,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.isBook,
  });

  factory TimeSchedul.fromJson(Map<String, dynamic> json) => TimeSchedul(
        id: json["id"],
        mettingId: json["metting_id"],
        mettingSlotsId: json["metting_slots_id"],
        date: json["date"] == null ? null : DateTime.parse(json["date"]),
        startTime: json["start_time"],
        endTime: json["end_time"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        isBook: json["is_book"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "metting_id": mettingId,
        "metting_slots_id": mettingSlotsId,
        "date":
            "${date!.year.toString().padLeft(4, '0')}-${date!.month.toString().padLeft(2, '0')}-${date!.day.toString().padLeft(2, '0')}",
        "start_time": startTime,
        "end_time": endTime,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "is_book": isBook,
      };
}
