// To parse this JSON data, do
//
//     final searchLiveClassModel = searchLiveClassModelFromJson(jsonString);

import 'dart:convert';

SearchLiveClassModel searchLiveClassModelFromJson(String str) =>
    SearchLiveClassModel.fromJson(json.decode(str));

String searchLiveClassModelToJson(SearchLiveClassModel data) =>
    json.encode(data.toJson());

class SearchLiveClassModel {
  int? status;
  String? message;
  List<Result>? result;
  int? totalRows;
  int? totalPage;
  int? currentPage;
  bool? morePage;

  SearchLiveClassModel({
    this.status,
    this.message,
    this.result,
    this.totalRows,
    this.totalPage,
    this.currentPage,
    this.morePage,
  });

  factory SearchLiveClassModel.fromJson(Map<String, dynamic> json) =>
      SearchLiveClassModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
        totalRows: json["total_rows"],
        totalPage: json["total_page"],
        currentPage: json["current_page"],
        morePage: json["more_page"],
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
        "total_rows": totalRows,
        "total_page": totalPage,
        "current_page": currentPage,
        "more_page": morePage,
      };
}

class Result {
  int? id;
  int? type;
  int? typeId;
  int? courseId;
  String? title;
  String? description;
  String? startedDate;
  String? startTime;
  String? endTime;
  String? meetingLink;
  int? platformId;
  int? isFree;
  int? price;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? lecturerName;
  String? lecturerUserName;
  String? lecturerImage;
  String? categoryName;
  String? courseTitle;
  String? courseImage;
  String? platformName;
  int? isUserBuy;

  Result({
    this.id,
    this.type,
    this.typeId,
    this.courseId,
    this.title,
    this.description,
    this.startedDate,
    this.startTime,
    this.endTime,
    this.meetingLink,
    this.platformId,
    this.isFree,
    this.price,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.lecturerName,
    this.lecturerUserName,
    this.lecturerImage,
    this.categoryName,
    this.courseTitle,
    this.courseImage,
    this.platformName,
    this.isUserBuy,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        type: json["type"],
        typeId: json["type_id"],
        courseId: json["course_id"],
        title: json["title"],
        description: json["description"],
        startedDate: json["started_date"],
        startTime: json["start_time"],
        endTime: json["end_time"],
        meetingLink: json["meeting_link"],
        platformId: json["platform_id"],
        isFree: json["is_free"],
        price: json["price"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        lecturerName: json["lecturer_name"],
        lecturerUserName: json["lecturer_user_name"],
        lecturerImage: json["lecturer_image"],
        categoryName: json["category_name"],
        courseTitle: json["course_title"],
        courseImage: json["course_image"],
        platformName: json["platform_name"],
        isUserBuy: json["is_user_buy"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "type": type,
        "type_id": typeId,
        "course_id": courseId,
        "title": title,
        "description": description,
        "started_date": startedDate,
        "start_time": startTime,
        "end_time": endTime,
        "meeting_link": meetingLink,
        "platform_id": platformId,
        "is_free": isFree,
        "price": price,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "lecturer_name": lecturerName,
        "lecturer_user_name": lecturerUserName,
        "lecturer_image": lecturerImage,
        "category_name": categoryName,
        "course_title": courseTitle,
        "course_image": courseImage,
        "platform_name": platformName,
        "is_user_buy": isUserBuy,
      };
}
