// To parse this JSON data, do
//
//     final promocodeModel = promocodeModelFromJson(jsonString);

import 'dart:convert';

PromocodeModel promocodeModelFromJson(String str) =>
    PromocodeModel.fromJson(json.decode(str));

String promocodeModelToJson(PromocodeModel data) => json.encode(data.toJson());

class PromocodeModel {
  int? status;
  String? message;
  List<Result>? result;
  int? totalRows;
  int? totalPage;
  int? currentPage;
  bool? morePage;

  PromocodeModel({
    this.status,
    this.message,
    this.result,
    this.totalRows,
    this.totalPage,
    this.currentPage,
    this.morePage,
  });

  factory PromocodeModel.fromJson(Map<String, dynamic> json) => PromocodeModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
        totalRows: json["total_rows"],
        totalPage: json["total_page"],
        currentPage: json["current_page"],
        morePage: json["more_page"],
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
        "total_rows": totalRows,
        "total_page": totalPage,
        "current_page": currentPage,
        "more_page": morePage,
      };
}

class Result {
  int? id;
  String? name;
  String? promoCode;
  int? type;
  int? discountAmount;
  String? validFrom;
  String? validUntil;
  int? usageLimit;
  int? userLimitPerUser;
  String? image;
  int? status;
  String? createdAt;
  String? updatedAt;

  Result({
    this.id,
    this.name,
    this.promoCode,
    this.type,
    this.discountAmount,
    this.validFrom,
    this.validUntil,
    this.usageLimit,
    this.userLimitPerUser,
    this.image,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        name: json["name"],
        promoCode: json["promo_code"],
        type: json["type"],
        discountAmount: json["discount_amount"],
        validFrom: json["valid_from"],
        validUntil: json["valid_until"],
        usageLimit: json["usage_limit"],
        userLimitPerUser: json["user_limit_per_user"],
        image: json["image"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "promo_code": promoCode,
        "type": type,
        "discount_amount": discountAmount,
        "valid_from": validFrom,
        "valid_until": validUntil,
        "usage_limit": usageLimit,
        "user_limit_per_user": userLimitPerUser,
        "image": image,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
