// To parse this JSON data, do
//
//     final profileModel = profileModelFromJson(jsonString);

import 'dart:convert';

ProfileModel profileModelFromJson(String str) =>
    ProfileModel.fromJson(json.decode(str));

String profileModelToJson(ProfileModel data) => json.encode(data.toJson());

class ProfileModel {
  int? status;
  String? message;
  List<Result>? result;

  ProfileModel({
    this.status,
    this.message,
    this.result,
  });

  factory ProfileModel.fromJson(Map<String, dynamic> json) => ProfileModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  int? id;
  String? userName;
  String? fullName;
  String? email;
  String? countryCode;
  String? mobileNumber;
  String? countryName;
  String? image;
  String? description;
  int? type;
  int? deviceType;
  String? deviceToken;
  int? walletAmount;
  int? isBuy;
  int? packageId;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? tutorStatus;
  String? packageName;
  int? packagePrice;
  int? maxCoursesAllowed;

  Result({
    this.id,
    this.userName,
    this.fullName,
    this.email,
    this.countryCode,
    this.mobileNumber,
    this.countryName,
    this.image,
    this.description,
    this.type,
    this.deviceType,
    this.deviceToken,
    this.walletAmount,
    this.isBuy,
    this.packageId,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.tutorStatus,
    this.packageName,
    this.packagePrice,
    this.maxCoursesAllowed,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        userName: json["user_name"],
        fullName: json["full_name"],
        email: json["email"],
        countryCode: json["country_code"],
        mobileNumber: json["mobile_number"],
        countryName: json["country_name"],
        image: json["image"],
        description: json["description"],
        type: json["type"],
        deviceType: json["device_type"],
        deviceToken: json["device_token"],
        walletAmount: json["wallet_amount"],
        isBuy: json["is_buy"],
        packageId: json["package_id"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        tutorStatus: json["tutor_status"],
        packageName: json["package_name"],
        packagePrice: json["package_price"],
        maxCoursesAllowed: json["max_courses_allowed"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_name": userName,
        "full_name": fullName,
        "email": email,
        "country_code": countryCode,
        "mobile_number": mobileNumber,
        "country_name": countryName,
        "image": image,
        "description": description,
        "type": type,
        "device_type": deviceType,
        "device_token": deviceToken,
        "wallet_amount": walletAmount,
        "is_buy": isBuy,
        "package_id": packageId,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "tutor_status": tutorStatus,
        "package_name": packageName,
        "package_price": packagePrice,
        "max_courses_allowed": maxCoursesAllowed,
      };
}
