// To parse this JSON data, do
//
//     final notificationModel = notificationModelFromJson(jsonString);

import 'dart:convert';

NotificationModel notificationModelFromJson(String str) =>
    NotificationModel.fromJson(json.decode(str));

String notificationModelToJson(NotificationModel data) =>
    json.encode(data.toJson());

class NotificationModel {
  int? status;
  String? message;
  List<Result>? result;
  int? totalRows;
  int? totalPage;
  int? currentPage;
  bool? morePage;

  NotificationModel({
    this.status,
    this.message,
    this.result,
    this.totalRows,
    this.totalPage,
    this.currentPage,
    this.morePage,
  });

  factory NotificationModel.fromJson(Map<String, dynamic> json) =>
      NotificationModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
        totalRows: json["total_rows"],
        totalPage: json["total_page"],
        currentPage: json["current_page"],
        morePage: json["more_page"],
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
        "total_rows": totalRows,
        "total_page": totalPage,
        "current_page": currentPage,
        "more_page": morePage,
      };
}

class Result {
  int? id;
  int? type;
  int? userId;
  int? tutorId;
  int? instructorId;
  int? contentType;
  int? contentId;
  String? otherType;
  int? otherTypeId;
  String? title;
  String? message;
  String? image;
  int? status;
  String? createdAt;
  String? updatedAt;

  Result({
    this.id,
    this.type,
    this.userId,
    this.tutorId,
    this.instructorId,
    this.contentType,
    this.contentId,
    this.otherType,
    this.otherTypeId,
    this.title,
    this.message,
    this.image,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        type: json["type"],
        userId: json["user_id"],
        tutorId: json["tutor_id"],
        instructorId: json["instructor_id"],
        contentType: json["content_type"],
        contentId: json["content_id"],
        otherType: json["other_type"],
        otherTypeId: json["other_type_id"],
        title: json["title"],
        message: json["message"],
        image: json["image"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "type": type,
        "user_id": userId,
        "tutor_id": tutorId,
        "instructor_id": instructorId,
        "content_type": contentType,
        "content_id": contentId,
        "other_type": otherType,
        "other_type_id": otherTypeId,
        "title": title,
        "message": message,
        "image": image,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
